/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.toolBar;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import oracle.ewt.lwAWT.LWComponent;
import oracle.ewt.popup.ToolTipClient;
import oracle.ewt.popup.ToolTipManager;
import oracle.ewt.popup.ToolTipSite;
import oracle.ewt.toolBar.ToolBar;
import oracle.ewt.toolBar.ToolBarButton;
import oracle.ewt.toolBar.ToolBarEvent;
import oracle.ewt.toolBar.ToolBarItem;
import oracle.ewt.toolBar.ToolBarMouseListener;

public class ToolBarToolTip
implements ToolTipClient,
ToolBarMouseListener {
    private ToolBar _toolbar;
    private static final int[] _sHorizAlignments = new int[]{2, 17, 22, 1, 16, 21, 10, 5};
    private static final int[] _sVertAlignments = new int[]{10, 5, 2, 17, 22, 1, 16, 21};

    public ToolBarToolTip(ToolBar toolBar) {
        this._toolbar = toolBar;
        toolBar.addToolBarMouseListener(this);
    }

    @Override
    public ToolTipSite getToolTipSite(Component component, int n, int n2) {
        Rectangle rectangle;
        ToolBarItem toolBarItem = this._getItem(component, n, n2);
        if (toolBarItem == null) {
            return null;
        }
        String string = null;
        if (!this._toolbar.getLabelsDisplayed() && toolBarItem instanceof ToolBarButton && (string = ((ToolBarButton)toolBarItem).getLabel()) != null && string.length() == 0) {
            string = null;
        }
        if (string == null && ((string = toolBarItem.getHelpText()) == null || string.length() == 0)) {
            return null;
        }
        if (component == this._toolbar) {
            Point point = toolBarItem.getLocation();
            point = this._toolbar.convertCanvasToOuter(point.x, point.y);
            Dimension dimension = toolBarItem.getSize();
            rectangle = new Rectangle(point.x, point.y, dimension.width, dimension.height);
        } else {
            rectangle = null;
        }
        return new ToolTipSite(string, rectangle, this._toolbar.isHorizontal() ? _sHorizAlignments : _sVertAlignments, null);
    }

    @Override
    public void toolBarItemMouseEntered(ToolBarEvent toolBarEvent) {
        Component component = toolBarEvent.getItem().getComponent();
        if (component != null && !(component instanceof LWComponent)) {
            ToolTipManager.getToolTipManager().registerComponent(component, this);
            ToolTipManager.getToolTipManager().enter(component);
        }
    }

    @Override
    public void toolBarItemMouseExited(ToolBarEvent toolBarEvent) {
        Component component = toolBarEvent.getItem().getComponent();
        if (component != null && !(component instanceof LWComponent)) {
            ToolTipManager.getToolTipManager().unregisterComponent(component);
        }
    }

    private ToolBarItem _getItem(Component component, int n, int n2) {
        ToolBarItem toolBarItem = component == this._toolbar ? this._toolbar.getItemAt(n, n2) : this._toolbar.findComponent(component);
        return toolBarItem;
    }
}

