/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.toolBar;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import oracle.ewt.lwAWT.LWComponent;
import oracle.ewt.toolBar.ComponentMouseAdapter;
import oracle.ewt.toolBar.ToolBar;
import oracle.ewt.toolBar.ToolBarItem;

public class ToolBarComponentWrapper
extends ToolBarItem {
    private String _helpText;
    private Component _component;

    public ToolBarComponentWrapper(Component component) {
        this(component, -1);
    }

    public ToolBarComponentWrapper(Component component, int n) {
        this.setID(n);
        new ComponentMouseAdapter(this).attachComponent(component);
        this._component = component;
    }

    @Override
    public Component getComponent() {
        return this._component;
    }

    @Override
    public void setSize(int n, int n2) {
        this._component.setSize(n, n2);
        this._component.invalidate();
    }

    public void setSize(Dimension dimension) {
        this._component.setSize(dimension);
        this._component.invalidate();
    }

    @Override
    public void storeSize(int n, int n2) {
        this._component.setSize(n, n2);
    }

    @Override
    protected void setParent(ToolBar toolBar) {
    }

    @Override
    public ToolBar getParent() {
        return (ToolBar)this._component.getParent();
    }

    @Override
    public void setLocation(int n, int n2) {
        Point point = this.getParent().convertCanvasToOuter(n, n2);
        this._component.setLocation(point.x, point.y);
    }

    @Override
    public Point getLocation() {
        Point point = this._component.getLocation();
        return this.getParent().convertOuterToCanvas(point.x, point.y);
    }

    @Override
    public Dimension getSize() {
        return this._component.getSize();
    }

    @Override
    public Dimension getPreferredSize() {
        return this._component.getPreferredSize();
    }

    @Override
    public Dimension getMinimumSize() {
        return this._component.getMinimumSize();
    }

    @Override
    public boolean inside(int n, int n2) {
        Rectangle rectangle = this._component.getBounds();
        Point point = this.getParent().convertCanvasToOuter(n, n2);
        return point.x >= rectangle.x && point.x < rectangle.x + rectangle.width && point.y >= rectangle.y && point.y < rectangle.y + rectangle.height;
    }

    @Override
    public boolean isVisible() {
        return this._component.isVisible();
    }

    @Override
    public void setVisible(boolean bl) {
        this._component.setVisible(bl);
    }

    @Override
    public boolean isEnabled() {
        return this._component.isEnabled();
    }

    @Override
    public void setEnabled(boolean bl) {
        this._component.setEnabled(bl);
    }

    @Override
    public String getHelpText() {
        if (this._component instanceof LWComponent) {
            Object object = ((LWComponent)this._component).getToolTipValue();
            if (object instanceof String) {
                return (String)object;
            }
            return null;
        }
        return this._helpText;
    }

    @Override
    public void setHelpText(String string) {
        if (this._component instanceof LWComponent) {
            ((LWComponent)this._component).setToolTipValue(string);
        } else {
            this._helpText = string;
        }
    }
}

