/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.toolBar;

import java.awt.Dimension;
import java.awt.Image;
import java.util.ResourceBundle;
import javax.accessibility.AccessibleAction;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleState;
import javax.accessibility.AccessibleStateSet;
import oracle.ewt.UIManager;
import oracle.ewt.graphics.ImageSet;
import oracle.ewt.graphics.SynthesizingImageSet;
import oracle.ewt.painter.PaintContext;
import oracle.ewt.painter.Painter;
import oracle.ewt.plaf.ToolBarUI;
import oracle.ewt.toolBar.ToolBar;
import oracle.ewt.toolBar.ToolBarItem;
import oracle.ewt.toolBar.ToolBarPainterItem;
import oracle.ewt.util.LocaleUtils;

public class ToolBarButton
extends ToolBarPainterItem {
    static final String _RESOURCE_BUNDLE = "oracle.ewt.access.resource.AccessibilityBundle";
    private ImageSet _imageSet;
    private String _label;
    private transient Image _disabledImage;
    private Painter _painter;

    public ToolBarButton() {
        this(-1, (Image)null);
    }

    public ToolBarButton(int n, Image image) {
        this.setID(n);
        this.setIcon(image);
    }

    public ToolBarButton(int n, ImageSet imageSet) {
        this.setID(n);
        this.setImageSet(imageSet);
    }

    public ToolBarButton(int n, Image image, String string) {
        this.setID(n);
        this.setIcon(image);
        this.setLabel(string);
    }

    public ToolBarButton(int n, ImageSet imageSet, String string) {
        this.setID(n);
        this.setImageSet(imageSet);
        this.setLabel(string);
    }

    public final void setIcon(Image image) {
        SynthesizingImageSet synthesizingImageSet = null;
        if (image != null) {
            ToolBar toolBar = this.getParent();
            int n = toolBar != null ? toolBar.getToolBarUI().getBaseImageState(toolBar) : ((Integer)UIManager.get(ToolBarUI.BASE_IMAGE_STATE)).intValue();
            synthesizingImageSet = new SynthesizingImageSet(image, n, 1 | n);
        }
        this.setImageSet(synthesizingImageSet);
    }

    public void setImageSet(ImageSet imageSet) {
        if (this._imageSet != imageSet) {
            Dimension dimension = this.getPreferredSize();
            this._imageSet = imageSet;
            this._invalidateIfNecessary(dimension);
        }
    }

    public ImageSet getImageSet() {
        return this._imageSet;
    }

    public String getLabel() {
        return this._label;
    }

    public void setLabel(String string) {
        if (this._label != string) {
            String string2;
            AccessibleContext accessibleContext = this.accessAccessibleContext();
            String string3 = accessibleContext == null ? null : accessibleContext.getAccessibleName();
            Dimension dimension = this.getPreferredSize();
            this._label = string;
            if (accessibleContext != null && (string2 = accessibleContext.getAccessibleName()) != string3) {
                accessibleContext.firePropertyChange("AccessibleVisibleData", string3, string2);
            }
            this._invalidateIfNecessary(dimension);
        }
    }

    public void setPainter(Painter painter) {
        if (this._painter != painter) {
            if (this.getParent() == null) {
                this._painter = painter;
            } else {
                Dimension dimension = this.getPreferredSize();
                this._painter = painter;
                this._invalidateIfNecessary(dimension);
            }
        }
    }

    @Override
    public Painter getPainter() {
        if (this._painter != null) {
            return this._painter;
        }
        return super.getPainter();
    }

    @Override
    public Object getPaintData(Object object) {
        Object object2 = null;
        ToolBar toolBar = this.getParent();
        if (object == null || object == PaintContext.IMAGESET_KEY) {
            if (toolBar.getImagesDisplayed()) {
                object2 = this.getImageSet();
            }
        } else if (object == PaintContext.LABEL_KEY) {
            if (toolBar.getLabelsDisplayed()) {
                String string = this.getLabel();
                if (string != null && string.length() > 0) {
                    object2 = string;
                }
            } else {
                return null;
            }
        }
        if (object2 == null) {
            object2 = super.getPaintData(object);
        }
        return object2;
    }

    private void _invalidateIfNecessary(Dimension dimension) {
        ToolBar toolBar = this.getParent();
        if (toolBar != null) {
            if (this.getPreferredSize().equals(dimension)) {
                this.repaintItem();
            } else {
                toolBar.invalidateCanvas();
                toolBar.repaintCanvas();
            }
        }
    }

    @Override
    protected AccessibleContext createAccessibleContext() {
        return new ButtonAccess();
    }

    public class ButtonAccess
    extends ToolBarItem.Access
    implements AccessibleAction {
        public ButtonAccess() {
            super(ToolBarButton.this);
        }

        @Override
        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.PUSH_BUTTON;
        }

        @Override
        public AccessibleStateSet getAccessibleStateSet() {
            AccessibleStateSet accessibleStateSet = super.getAccessibleStateSet();
            if (ToolBarButton.this.isArmed()) {
                accessibleStateSet.add(AccessibleState.PRESSED);
            }
            return accessibleStateSet;
        }

        @Override
        public AccessibleAction getAccessibleAction() {
            return this;
        }

        @Override
        public int getAccessibleActionCount() {
            return 1;
        }

        @Override
        public String getAccessibleActionDescription(int n) {
            if (n == 0) {
                ResourceBundle resourceBundle = ResourceBundle.getBundle(ToolBarButton._RESOURCE_BUNDLE, LocaleUtils.getTranslationLocale(this.getLocale()));
                return resourceBundle.getString("CLICK");
            }
            return null;
        }

        @Override
        public boolean doAccessibleAction(int n) {
            if (this.isEnabled() && n == 0) {
                ToolBarButton.this.activate();
                return true;
            }
            return false;
        }
    }
}

