/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.shuttle;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;

class ShuttleLayout
implements LayoutManager {
    public static final String FROM_LIST = "FromList";
    public static final String TO_LIST = "ToList";
    public static final String FROM_HEADER = "FromHeader";
    public static final String TO_HEADER = "ToHeader";
    public static final String FROM_FOOTER = "FromFooter";
    public static final String TO_FOOTER = "ToFooter";
    public static final String SHUTTLE_CONTROL = "ShuttleControl";
    public static final String REORDER_CONTROL = "ReorderControl";
    private static final int _HEADER_GAP = 0;
    private static final int _FOOTER_GAP = 0;
    private static final int _SHUTTLE_GAP = 5;
    private static final int _INSET = 5;
    private static final int _REORDER_GAP = 5;
    private static final Dimension _ZERO_SIZE = new Dimension(0, 0);
    private Component _fromListComponent;
    private Component _toListComponent;
    private Component _fromListHeader;
    private Component _toListHeader;
    private Component _fromListFooter;
    private Component _toListFooter;
    private Component _shuttleControl;
    private Component _reorderControl;
    private boolean _reversed = false;
    private boolean _horizontal = true;

    ShuttleLayout() {
    }

    @Override
    public void addLayoutComponent(String string, Component component) {
        if (string == FROM_LIST) {
            this._fromListComponent = component;
        } else if (string == TO_LIST) {
            this._toListComponent = component;
        } else if (string == FROM_HEADER) {
            this._fromListHeader = component;
        } else if (string == TO_HEADER) {
            this._toListHeader = component;
        } else if (string == SHUTTLE_CONTROL) {
            this._shuttleControl = component;
        } else if (string == REORDER_CONTROL) {
            this._reorderControl = component;
        } else if (string == FROM_FOOTER) {
            this._fromListFooter = component;
        } else if (string == TO_FOOTER) {
            this._toListFooter = component;
        } else {
            throw new IllegalArgumentException();
        }
    }

    @Override
    public void removeLayoutComponent(Component component) {
        if (component == this._fromListComponent) {
            this._fromListComponent = null;
        } else if (component == this._toListComponent) {
            this._toListComponent = null;
        } else if (component == this._fromListHeader) {
            this._fromListHeader = null;
        } else if (component == this._toListHeader) {
            this._toListHeader = null;
        } else if (component == this._shuttleControl) {
            this._shuttleControl = null;
        } else if (component == this._reorderControl) {
            this._reorderControl = null;
        } else if (component == this._fromListFooter) {
            this._fromListFooter = null;
        } else if (component == this._toListFooter) {
            this._toListFooter = null;
        }
    }

    @Override
    public Dimension preferredLayoutSize(Container container) {
        if (this._horizontal) {
            return this._calculateHorizontalSize(this._getPreferredSize(this._fromListComponent), this._getPreferredSize(this._toListComponent), this._getPreferredSize(this._fromListHeader), this._getPreferredSize(this._toListHeader), this._getPreferredSize(this._shuttleControl), this._getPreferredSize(this._reorderControl), this._getPreferredSize(this._fromListFooter), this._getPreferredSize(this._toListFooter));
        }
        return this._calculateVerticalSize(this._getPreferredSize(this._fromListComponent), this._getPreferredSize(this._toListComponent), this._getPreferredSize(this._fromListHeader), this._getPreferredSize(this._toListHeader), this._getPreferredSize(this._shuttleControl), this._getPreferredSize(this._reorderControl), this._getPreferredSize(this._fromListFooter), this._getPreferredSize(this._toListFooter));
    }

    @Override
    public Dimension minimumLayoutSize(Container container) {
        if (this._horizontal) {
            return this._calculateHorizontalSize(this._getMinimumSize(this._fromListComponent), this._getMinimumSize(this._toListComponent), this._getMinimumSize(this._fromListHeader), this._getMinimumSize(this._toListHeader), this._getMinimumSize(this._shuttleControl), this._getMinimumSize(this._reorderControl), this._getMinimumSize(this._fromListFooter), this._getMinimumSize(this._toListFooter));
        }
        return this._calculateVerticalSize(this._getMinimumSize(this._fromListComponent), this._getMinimumSize(this._toListComponent), this._getMinimumSize(this._fromListHeader), this._getMinimumSize(this._toListHeader), this._getMinimumSize(this._shuttleControl), this._getMinimumSize(this._reorderControl), this._getMinimumSize(this._fromListFooter), this._getMinimumSize(this._toListFooter));
    }

    @Override
    public void layoutContainer(Container container) {
        if (this._horizontal) {
            this._layoutHorizontal(container);
        } else {
            this._layoutVertical(container);
        }
    }

    public Component getFromList() {
        return this._fromListComponent;
    }

    public Component getToList() {
        return this._toListComponent;
    }

    public Component getFromHeader() {
        return this._fromListHeader;
    }

    public Component getToHeader() {
        return this._toListHeader;
    }

    public Component getFromFooter() {
        return this._fromListFooter;
    }

    public Component getToFooter() {
        return this._toListFooter;
    }

    public Component getShuttleControl() {
        return this._shuttleControl;
    }

    public Component getReorderControl() {
        return this._reorderControl;
    }

    public void setHorizontalLayout(boolean bl) {
        this._horizontal = bl;
    }

    public void setReverseLayout(boolean bl) {
        this._reversed = bl;
    }

    private void _layoutHorizontal(Container container) {
        int n;
        Dimension dimension = container.getSize();
        Insets insets = container.getInsets();
        Dimension dimension2 = this._getPreferredSize(this._fromListHeader);
        Dimension dimension3 = this._getPreferredSize(this._toListHeader);
        int n2 = Math.max(dimension2.height, dimension3.height);
        Dimension dimension4 = this._getPreferredSize(this._fromListFooter);
        Dimension dimension5 = this._getPreferredSize(this._toListFooter);
        Dimension dimension6 = this._getPreferredSize(this._shuttleControl);
        Dimension dimension7 = this._getPreferredSize(this._reorderControl);
        int n3 = dimension7.width;
        if (n3 != 0) {
            n3 += 5;
        }
        int n4 = (dimension.width - insets.left - insets.right - dimension6.width - n3) / 2 - 5 - 5;
        int n5 = insets.left + 5;
        if (this._reversed) {
            n5 += n3;
        }
        int n6 = n5 + n4 + 5;
        int n7 = n6 + dimension6.width + 5;
        int n8 = !this._reversed ? n7 + n4 + 5 : insets.left + 5;
        int n9 = !this._reversed ? n5 : n7;
        int n10 = !this._reversed ? n7 : n5;
        int n11 = n = insets.top + 5;
        if (n2 > 0) {
            n11 += n2 + 0;
            if (dimension2 != _ZERO_SIZE) {
                this._fromListHeader.setBounds(n9, n, n4, n2);
            }
            if (dimension3 != _ZERO_SIZE) {
                this._toListHeader.setBounds(n10, n, n4, n2);
            }
        }
        int n12 = dimension.height - n11 - dimension4.height - 0 - 5 - insets.bottom;
        int n13 = dimension.height - n11 - dimension5.height - 0 - 5 - insets.bottom;
        if (this._fromListComponent != null && this._fromListComponent.isVisible()) {
            this._fromListComponent.setBounds(n9, n11, n4, n12);
        }
        if (this._toListComponent != null && this._toListComponent.isVisible()) {
            this._toListComponent.setBounds(n10, n11, n4, n13);
        }
        if (dimension4 != _ZERO_SIZE) {
            this._fromListFooter.setBounds(n9, n11 + n12 + 0, n4, dimension4.height);
        }
        if (dimension5 != _ZERO_SIZE) {
            this._toListFooter.setBounds(n10, n11 + n13 + 0, n4, dimension5.height);
        }
        int n14 = Math.min(n12, n13);
        if (dimension6 != _ZERO_SIZE) {
            this._shuttleControl.setBounds(n6, n11 + (n14 - dimension6.height) / 2, dimension6.width, dimension6.height);
        }
        if (dimension7 != _ZERO_SIZE) {
            this._reorderControl.setBounds(n8, n11 + (n13 - dimension7.height) / 2, dimension7.width, dimension7.height);
        }
    }

    private void _layoutVertical(Container container) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        Dimension dimension = container.getSize();
        Insets insets = container.getInsets();
        Dimension dimension2 = this._getPreferredSize(this._fromListHeader);
        Dimension dimension3 = this._getPreferredSize(this._toListHeader);
        int n8 = Math.max(dimension2.height, dimension3.height);
        if (n8 > 0) {
            n8 += 0;
        }
        Dimension dimension4 = this._getPreferredSize(this._fromListFooter);
        Dimension dimension5 = this._getPreferredSize(this._toListFooter);
        Dimension dimension6 = this._getPreferredSize(this._shuttleControl);
        Dimension dimension7 = this._getPreferredSize(this._reorderControl);
        int n9 = dimension7.width;
        if (n9 != 0) {
            n9 += 5;
        }
        int n10 = dimension.width - insets.left - insets.right - n9 - 5 - 5;
        int n11 = insets.left + 5;
        int n12 = (dimension.width - insets.left - insets.right - 5 - 5 - dimension6.width) / 2 + insets.left + 5;
        int n13 = n11 + n10 + 5;
        int n14 = (dimension.height - insets.top - 10 - 2 * n8 - 10 - dimension6.height - insets.bottom) / 2;
        int n15 = n14 - dimension4.height;
        int n16 = n14 - dimension5.height;
        int n17 = insets.top + 5;
        int n18 = n17 + n8;
        int n19 = n18 + (this._reversed ? n16 : n15);
        int n20 = n19 + 5 + (this._reversed ? dimension5.height : dimension4.height);
        int n21 = n20 + dimension6.height + 5;
        int n22 = n21 + n8;
        int n23 = n22 + (this._reversed ? n15 : n16);
        if (!this._reversed) {
            n7 = n18;
            n6 = n17;
            n5 = n19;
            n4 = n22;
            n3 = n21;
            n2 = n23;
            n = n22;
        } else {
            n7 = n22;
            n6 = n21;
            n5 = n23;
            n4 = n18;
            n3 = n17;
            n2 = n19;
            n = n18;
        }
        n += (n16 - dimension7.height) / 2;
        if (n8 > 0) {
            if (dimension2 != _ZERO_SIZE) {
                this._fromListHeader.setBounds(n11, n6, n10, n8);
            }
            if (dimension3 != _ZERO_SIZE) {
                this._toListHeader.setBounds(n11, n3, n10, n8);
            }
        }
        if (this._fromListComponent != null && this._fromListComponent.isVisible()) {
            this._fromListComponent.setBounds(n11, n7, n10, n15);
        }
        if (this._toListComponent != null && this._toListComponent.isVisible()) {
            this._toListComponent.setBounds(n11, n4, n10, n16);
        }
        if (dimension4 != _ZERO_SIZE) {
            this._fromListFooter.setBounds(n11, n5, n10, dimension4.height);
        }
        if (dimension5 != _ZERO_SIZE) {
            this._toListFooter.setBounds(n11, n2, n10, dimension5.height);
        }
        if (dimension6 != _ZERO_SIZE) {
            this._shuttleControl.setBounds(n12, n20, dimension6.width, dimension6.height);
        }
        if (dimension7 != _ZERO_SIZE) {
            this._reorderControl.setBounds(n13, n, dimension7.width, dimension7.height);
        }
    }

    private Dimension _calculateHorizontalSize(Dimension dimension, Dimension dimension2, Dimension dimension3, Dimension dimension4, Dimension dimension5, Dimension dimension6, Dimension dimension7, Dimension dimension8) {
        int n;
        int n2 = Math.max(Math.max(Math.max(dimension.height, dimension6.height), dimension2.height), dimension5.height);
        int n3 = Math.max(Math.max(dimension.width, dimension2.width), Math.max(Math.max(dimension3.width, dimension4.width), Math.max(dimension7.width, dimension8.width)));
        int n4 = Math.max(dimension3.height, dimension4.height);
        if (n4 > 0) {
            n4 += 0;
        }
        if ((n = Math.max(dimension7.height, dimension8.height)) > 0) {
            n += 0;
        }
        int n5 = 5 + n3 + 5;
        int n6 = n5 + dimension5.width + n5;
        if (dimension6 != _ZERO_SIZE) {
            n6 += 5 + dimension6.width;
        }
        return new Dimension(n6, 5 + n4 + n2 + n + 5);
    }

    private Dimension _calculateVerticalSize(Dimension dimension, Dimension dimension2, Dimension dimension3, Dimension dimension4, Dimension dimension5, Dimension dimension6, Dimension dimension7, Dimension dimension8) {
        int n = Math.max(Math.max(Math.max(dimension.height, dimension6.height), dimension2.height), dimension5.height);
        int n2 = Math.max(Math.max(dimension.width, dimension2.width), Math.max(Math.max(dimension3.width, dimension4.width), Math.max(dimension7.width, dimension8.width)));
        int n3 = Math.max(dimension3.height, dimension4.height);
        if (n3 > 0) {
            n3 += 0;
        }
        int n4 = 5 + n3 + n + 5;
        int n5 = n4 + dimension5.height + n4 + dimension7.height + dimension8.height;
        int n6 = 5 + n2 + 5;
        if (dimension6 != _ZERO_SIZE) {
            n6 += 5 + dimension6.width;
        }
        return new Dimension(n6, n5);
    }

    private Dimension _getPreferredSize(Component component) {
        return component != null && component.isVisible() ? component.getPreferredSize() : _ZERO_SIZE;
    }

    private Dimension _getMinimumSize(Component component) {
        return component != null && component.isVisible() ? component.getMinimumSize() : _ZERO_SIZE;
    }
}

