/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.shuttle;

import java.awt.Color;
import java.awt.Component;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Enumeration;
import java.util.Locale;
import java.util.ResourceBundle;
import oracle.ewt.LookAndFeel;
import oracle.ewt.UIDefaults;
import oracle.ewt.button.ContinuousButton;
import oracle.ewt.button.PulsingButtonEvent;
import oracle.ewt.button.PulsingButtonListener;
import oracle.ewt.button.PushButton;
import oracle.ewt.event.ListenerManager;
import oracle.ewt.layout.EqualColumnLayout;
import oracle.ewt.lwAWT.LWComponent;
import oracle.ewt.painter.Painter;
import oracle.ewt.plaf.ComponentUI;
import oracle.ewt.plaf.ShuttleUI;
import oracle.ewt.shuttle.ConsumableActionEvent;
import oracle.ewt.shuttle.MultiItemPicker;
import oracle.ewt.shuttle.ShuttleEvent;
import oracle.ewt.shuttle.ShuttleLayout;
import oracle.ewt.shuttle.ShuttleListener;
import oracle.ewt.shuttle.ToMultiItemPicker;
import oracle.ewt.util.LocaleUtils;

public class Shuttle
extends LWComponent {
    public static final int MOVE_MODE = 0;
    public static final int COPY_MODE = 1;
    private static final int _COMPINDEX_FROMHEADER = 0;
    private static final int _COMPINDEX_FROMCOMPONENT = 1;
    private static final int _COMPINDEX_FROMFOOTER = 2;
    private static final int _COMPINDEX_SHUTTLE = 3;
    private static final int _COMPINDEX_TOHEADER = 4;
    private static final int _COMPINDEX_TOCOMPONENT = 5;
    private static final int _COMPINDEX_TOFOOTER = 6;
    private static final int _COMPINDEX_REORDER = 7;
    private static final int _STRINGINDEX_MOVE = 0;
    private static final int _STRINGINDEX_MOVEALL = 1;
    private static final int _STRINGINDEX_REMOVE = 2;
    private static final int _STRINGINDEX_REMOVEALL = 3;
    private static final int _STRINGINDEX_COPY = 4;
    private static final int _STRINGINDEX_COPYALL = 5;
    private static final int _INTERIOR_BUTTON_GAP = 3;
    private LayoutManager _HORIZONTAL_BUTTON_LAYOUT;
    private LayoutManager _VERTICAL_BUTTON_LAYOUT;
    private static final LayoutManager _REORDER_LAYOUT = new EqualColumnLayout(3);
    private MultiItemPicker _fromPicker;
    ToMultiItemPicker _toPicker;
    private LWComponent _shuttleButtons;
    PushButton _addButton;
    PushButton _removeButton;
    PushButton _addAllButton;
    PushButton _removeAllButton;
    ContinuousButton _reorderUp;
    ContinuousButton _reorderDown;
    private boolean _useTextLabels;
    private boolean _moveAllButtonsShown = true;
    private boolean _moveButtonsShown = true;
    boolean _reorderAllowed = true;
    int _itemsUnique;
    private boolean _horizontalLayout = true;
    private boolean _reversed;
    private boolean _actualReversed;
    private String[] _buttonLabels;
    private boolean _useDefaultLabels = true;
    private static Image[] _buttonImages;
    private ShuttleHandler _handler;
    private ListenerManager _shuttleListeners;
    private static int _sInstanceCounter;
    private static final String _MOVE_KEY = "MOVE";
    private static final String _REMOVE_KEY = "REMOVE";
    private static final String _MOVE_ALL_KEY = "MOVE_ALL";
    private static final String _REMOVE_ALL_KEY = "REMOVE_ALL";
    private static final String _COPY_KEY = "COPY";
    private static final String _COPY_ALL_KEY = "COPY_ALL";

    public Shuttle() {
        ShuttleLayout shuttleLayout = this._getLayoutManager();
        super.setLayout(shuttleLayout);
        this._shuttleButtons = new LWComponent();
        this._addButton = this._createButton();
        this._removeButton = this._createButton();
        this._addAllButton = this._createButton();
        this._removeAllButton = this._createButton();
        this._updateButtonVisibility();
        this._shuttleButtons.add(this._addButton);
        this._shuttleButtons.add(this._addAllButton);
        this._shuttleButtons.add(this._removeButton);
        this._shuttleButtons.add(this._removeAllButton);
        this.add("ShuttleControl", this._shuttleButtons);
        ShuttleHandler shuttleHandler = this._getShuttleHandler();
        this._reorderUp = new ContinuousButton(shuttleHandler);
        this._reorderDown = new ContinuousButton(shuttleHandler);
        this._reorderUp.addPulsingButtonListener(shuttleHandler);
        this._reorderDown.addPulsingButtonListener(shuttleHandler);
        LWComponent lWComponent = new LWComponent();
        lWComponent.setLayout(_REORDER_LAYOUT);
        lWComponent.add(this._reorderUp);
        lWComponent.add(this._reorderDown);
        this.add("ReorderControl", lWComponent);
        this.updateUI(Shuttle.class);
    }

    public synchronized void addShuttleListener(ShuttleListener shuttleListener) {
        if (this._shuttleListeners == null) {
            this._shuttleListeners = new ListenerManager();
        }
        this._shuttleListeners.addListener(shuttleListener);
    }

    public synchronized void removeShuttleListener(ShuttleListener shuttleListener) {
        this._shuttleListeners.removeListener(shuttleListener);
    }

    public void setFromPicker(MultiItemPicker multiItemPicker) {
        this._setComponent(this._getFromComponent(), multiItemPicker.getComponent(), "FromList", 1);
        this._setFromPicker(multiItemPicker);
    }

    public final MultiItemPicker getFromPicker() {
        return this._fromPicker;
    }

    public void setToPicker(ToMultiItemPicker toMultiItemPicker) {
        if (toMultiItemPicker == null) {
            throw new IllegalArgumentException();
        }
        this._setComponent(this._getToComponent(), toMultiItemPicker.getComponent(), "ToList", 5);
        this._setToPicker(toMultiItemPicker);
        boolean bl = this._showReorder();
        this._reorderUp.setVisible(bl);
        this._reorderDown.setVisible(bl);
    }

    public final ToMultiItemPicker getToPicker() {
        return this._toPicker;
    }

    public void setFromHeader(Component component) {
        this._setComponent(this.getFromHeader(), component, "FromHeader", 0);
    }

    public Component getFromHeader() {
        return ((ShuttleLayout)this.getLayout()).getFromHeader();
    }

    public void setToHeader(Component component) {
        this._setComponent(this.getToHeader(), component, "ToHeader", 4);
    }

    public Component getToHeader() {
        return ((ShuttleLayout)this.getLayout()).getToHeader();
    }

    public void setFromFooter(Component component) {
        this._setComponent(this.getFromFooter(), component, "FromFooter", 2);
    }

    public Component getFromFooter() {
        return ((ShuttleLayout)this.getLayout()).getFromFooter();
    }

    public void setToFooter(Component component) {
        this._setComponent(this.getToFooter(), component, "ToFooter", 6);
    }

    public Component getToFooter() {
        return ((ShuttleLayout)this.getLayout()).getToFooter();
    }

    public void setUseTextButtons(boolean bl) {
        if (bl != this._useTextLabels) {
            this._useTextLabels = bl;
            this._updateButtonContents();
        }
    }

    public boolean getUseTextButtons() {
        return this._useTextLabels;
    }

    public boolean isReorderingAllowed() {
        return this._reorderAllowed;
    }

    public boolean isHorizontalLayout() {
        return this._horizontalLayout;
    }

    public boolean isLayoutReversed() {
        return this._reversed;
    }

    public int getMode() {
        return this._itemsUnique;
    }

    public void setHorizontalLayout(boolean bl) {
        if (bl != this._horizontalLayout) {
            this._horizontalLayout = bl;
            ((ShuttleLayout)this.getLayout()).setHorizontalLayout(bl);
            if (this._horizontalLayout) {
                this._shuttleButtons.setLayout(this._HORIZONTAL_BUTTON_LAYOUT);
            } else {
                this._shuttleButtons.setLayout(this._VERTICAL_BUTTON_LAYOUT);
            }
            this._updateButtonContents();
            this.invalidate();
        }
    }

    public void setLayoutReversed(boolean bl) {
        this._reversed = bl;
        int n = this.getActualReadingDirection();
        if (n == 2) {
            this._setActualLayoutReversed(!bl);
        } else {
            this._setActualLayoutReversed(bl);
        }
    }

    public void setMode(int n) {
        if (n != 0 && n != 1) {
            throw new IllegalArgumentException();
        }
        if (n != this._itemsUnique) {
            this._itemsUnique = n;
            this._updateButtonContents();
            this.invalidate();
        }
    }

    public void setReorderingAllowed(boolean bl) {
        if (bl != this._reorderAllowed) {
            this._reorderAllowed = bl;
            boolean bl2 = this._showReorder();
            this._reorderUp.setVisible(bl2);
            this._reorderDown.setVisible(bl2);
        }
    }

    public void setMoveAllAllowed(boolean bl) {
        if (bl != this._moveAllButtonsShown) {
            this._moveAllButtonsShown = bl;
            this._updateButtonVisibility();
        }
    }

    public void setMoveAllowed(boolean bl) {
        if (bl != this._moveButtonsShown) {
            this._moveButtonsShown = bl;
            this._updateButtonVisibility();
        }
    }

    public void setButtonLabels(String[] stringArray) {
        if (stringArray == null) {
            this._useDefaultLabels = true;
            this._buttonLabels = this.getLocalizedLabels(this.getLocale());
        } else {
            this._useDefaultLabels = false;
            if (stringArray.length < 6) {
                throw new IllegalArgumentException("Must provide all 6 button labels");
            }
            if (this._buttonLabels == null) {
                this._buttonLabels = new String[6];
            }
            this._buttonLabels[0] = stringArray[0];
            this._buttonLabels[1] = stringArray[2];
            this._buttonLabels[2] = stringArray[1];
            this._buttonLabels[3] = stringArray[3];
            this._buttonLabels[4] = stringArray[4];
            this._buttonLabels[5] = stringArray[5];
        }
        this._updateButtonContents();
    }

    public boolean isMoveAllAllowed() {
        return this._moveAllButtonsShown;
    }

    public boolean isMoveAllowed() {
        return this._moveButtonsShown;
    }

    public void addShuttleComponent(Component component) {
        this._shuttleButtons.add(component, this._shuttleButtons.getComponentCount() - 2);
        this.invalidate();
    }

    public void forceButtonRefresh() {
        if (this._fromPicker != null) {
            this.updateButtonsEnabled(this._fromPicker);
        }
        if (this._toPicker != null) {
            this.updateButtonsEnabled(this._toPicker);
        }
    }

    @Override
    public Object getUIClassID() {
        return "ShuttleUI";
    }

    @Override
    public void setLayout(LayoutManager layoutManager) {
        if (layoutManager instanceof ShuttleLayout) {
            super.setLayout(layoutManager);
        }
    }

    @Override
    public void setEnabled(boolean bl) {
        Component component;
        Component component2;
        Component component3;
        super.setEnabled(bl);
        this._reorderUp.setEnabled(bl);
        this._reorderDown.setEnabled(bl);
        Component[] componentArray = this._shuttleButtons.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            componentArray[i].setEnabled(bl);
        }
        if (bl) {
            this.updateReorderButtonsEnabled(this._toPicker);
            this.updateButtonsEnabled(this._fromPicker);
            this.updateButtonsEnabled(this._toPicker);
        }
        if (this._fromPicker != null && (component3 = this._fromPicker.getComponent()) != null) {
            component3.setEnabled(bl);
        }
        if (this._toPicker != null && (component2 = this._toPicker.getComponent()) != null) {
            component2.setEnabled(bl);
        }
        if ((component = this.getFromHeader()) != null) {
            component.setEnabled(bl);
        }
        if ((component = this.getToHeader()) != null) {
            component.setEnabled(bl);
        }
    }

    public void removeShuttleComponent(Component component) {
        if (component.getParent() == this._shuttleButtons) {
            this._shuttleButtons.remove(component);
        } else {
            if (component == this._getFromComponent()) {
                this._setFromPicker(null);
            } else if (component == this._getToComponent()) {
                this._setToPicker(null);
            }
            super.remove(component);
        }
    }

    @Override
    public void removeAll() {
        this._shuttleButtons.removeAll();
        this._setFromPicker(null);
        this._setToPicker(null);
        super.removeAll();
    }

    protected final ShuttleUI getShuttleUI() {
        return (ShuttleUI)this.getUI();
    }

    @Override
    protected void updateLocale(Locale locale, Locale locale2) {
        super.updateLocale(locale, locale2);
        if (this._useDefaultLabels) {
            this._buttonLabels = this.getLocalizedLabels(locale);
            this._updateButtonContents();
        }
    }

    @Override
    protected void updateReadingDirection(int n) {
        if (n == 2) {
            this._setActualLayoutReversed(!this.isLayoutReversed());
        } else if (n == 1) {
            this._setActualLayoutReversed(this.isLayoutReversed());
        }
        super.updateReadingDirection(n);
    }

    @Override
    protected int getInvalidateFlags() {
        return super.getInvalidateFlags() | 0x4000;
    }

    @Override
    protected void setUI(ComponentUI componentUI) {
        super.setUI(componentUI);
        if (componentUI != null) {
            ShuttleUI shuttleUI = this.getShuttleUI();
            this._HORIZONTAL_BUTTON_LAYOUT = shuttleUI.getHorizontalButtonLayout(this);
            this._VERTICAL_BUTTON_LAYOUT = shuttleUI.getVerticalButtonLayout(this);
            if (this._horizontalLayout) {
                this._shuttleButtons.setLayout(this._HORIZONTAL_BUTTON_LAYOUT);
            } else {
                this._shuttleButtons.setLayout(this._VERTICAL_BUTTON_LAYOUT);
            }
            this._updateButtonContents();
            this._updateReorderContents();
            UIDefaults uIDefaults = this.getUIDefaults();
            Color color = uIDefaults.getColor(LookAndFeel.CONTROL);
            this._reorderUp.setBackground(color);
            this._reorderDown.setBackground(color);
        }
    }

    @Override
    protected void updateUI(Class clazz) {
        if (clazz == Shuttle.class) {
            this.updateUI();
        }
    }

    @Override
    protected String paramString() {
        String string = super.paramString();
        string = string + ", mode=" + (this.getMode() == 0 ? _MOVE_KEY : _COPY_KEY);
        string = string + ", horizontal=" + this.isHorizontalLayout();
        string = string + ", reverseLayout=" + this.isLayoutReversed();
        string = string + ", reordering=" + this.isReorderingAllowed();
        string = string + ", moveAllAllowed=" + this.isMoveAllAllowed();
        string = string + ", textLabels=" + this.getUseTextButtons();
        return string;
    }

    private void _setFromPicker(MultiItemPicker multiItemPicker) {
        MultiItemPicker multiItemPicker2 = this._fromPicker;
        this._fromPicker = multiItemPicker;
        this._setPicker(multiItemPicker2, multiItemPicker, this._toPicker);
    }

    private void _setToPicker(ToMultiItemPicker toMultiItemPicker) {
        ToMultiItemPicker toMultiItemPicker2 = this._toPicker;
        this._toPicker = toMultiItemPicker;
        this._setPicker(toMultiItemPicker2, this._toPicker, this._fromPicker);
    }

    private void _setPicker(MultiItemPicker multiItemPicker, MultiItemPicker multiItemPicker2, MultiItemPicker multiItemPicker3) {
        ShuttleHandler shuttleHandler = this._getShuttleHandler();
        if (multiItemPicker != multiItemPicker2) {
            if (multiItemPicker != null) {
                multiItemPicker.removeItemListener(shuttleHandler);
                multiItemPicker.removeActionListener(shuttleHandler);
            }
            if (multiItemPicker2 != null) {
                multiItemPicker2.addItemListener(shuttleHandler);
                multiItemPicker2.addActionListener(shuttleHandler);
                this.updateButtonsEnabled(multiItemPicker2);
            }
            if (multiItemPicker3 != null) {
                this.updateButtonsEnabled(multiItemPicker3);
            }
        }
    }

    private void _setComponent(Component component, Component component2, String string, int n) {
        if (component != component2) {
            if (component != null) {
                this.remove(component);
            }
            this.add(component2, string, this._calculateComponentIndex(n));
        }
    }

    private Component _getFromComponent() {
        return this._fromPicker != null ? this._fromPicker.getComponent() : null;
    }

    private Component _getToComponent() {
        return this._toPicker != null ? this._toPicker.getComponent() : null;
    }

    private Component _getShuttleControl() {
        return ((ShuttleLayout)this.getLayout()).getShuttleControl();
    }

    private int _calculateComponentIndex(int n) {
        switch (n) {
            case 7: {
                if (this.getToFooter() == null) {
                    --n;
                }
            }
            case 6: {
                if (this._getToComponent() == null) {
                    --n;
                }
            }
            case 5: {
                if (this.getToHeader() == null) {
                    --n;
                }
            }
            case 4: {
                if (this._getShuttleControl() == null) {
                    --n;
                }
            }
            case 3: {
                if (this.getFromFooter() == null) {
                    --n;
                }
            }
            case 2: {
                if (this._getFromComponent() == null) {
                    --n;
                }
            }
            case 1: {
                if (this.getFromHeader() != null) break;
                --n;
            }
        }
        return n;
    }

    private ShuttleLayout _getLayoutManager() {
        ShuttleLayout shuttleLayout = new ShuttleLayout();
        if (this._isActualLayoutReversed()) {
            shuttleLayout.setReverseLayout(true);
        }
        return shuttleLayout;
    }

    private PushButton _createButton() {
        PushButton pushButton = new PushButton("");
        pushButton.addActionListener(this._getShuttleHandler());
        return pushButton;
    }

    private void _updateButtonVisibility() {
        boolean bl = this.isMoveAllAllowed();
        boolean bl2 = this.isMoveAllowed();
        this._addAllButton.setVisible(bl);
        this._removeAllButton.setVisible(bl);
        this._addButton.setVisible(bl2);
        this._removeButton.setVisible(bl2);
    }

    private boolean _showReorder() {
        ToMultiItemPicker toMultiItemPicker = this._toPicker;
        return toMultiItemPicker != null && toMultiItemPicker.isReorderable() && this.isReorderingAllowed();
    }

    private void _loadButtonImage(PushButton pushButton, int n) {
        Image[] imageArray = _buttonImages;
        if (imageArray == null) {
            imageArray = new Image[8];
        }
        if (this._isActualLayoutReversed()) {
            n = (n + 2) % 4;
        }
        if (!this.isHorizontalLayout()) {
            n += 4;
        }
        pushButton.setPainter(this.getShuttleUI().getButtonPainter(this, n));
    }

    private void _updateButtonContents() {
        String string;
        boolean bl = this.getMode() == 1;
        String[] stringArray = this._buttonLabels;
        if (this.getUseTextButtons()) {
            if (this._buttonLabels != null) {
                this._addButton.setPainter(null);
                this._addAllButton.setPainter(null);
                this._removeButton.setPainter(null);
                this._removeAllButton.setPainter(null);
                this._addButton.setLabel(bl ? stringArray[4] : stringArray[0]);
                this._addAllButton.setLabel(bl ? stringArray[5] : stringArray[1]);
                this._removeButton.setLabel(stringArray[2]);
                this._removeAllButton.setLabel(stringArray[3]);
                this._addButton.setImageSet(null);
                this._addAllButton.setImageSet(null);
                this._removeButton.setImageSet(null);
                this._removeAllButton.setImageSet(null);
            }
        } else {
            this._loadButtonImage(this._addButton, 0);
            this._loadButtonImage(this._removeButton, 2);
            this._loadButtonImage(this._addAllButton, 1);
            this._loadButtonImage(this._removeAllButton, 3);
        }
        Locale locale = LocaleUtils.getDefaultableLocale(this);
        ResourceBundle resourceBundle = ResourceBundle.getBundle("oracle.ewt.access.resource.AccessibilityBundle", LocaleUtils.getTranslationLocale(locale));
        if (this._buttonLabels != null) {
            string = bl ? stringArray[4] : stringArray[0];
            this._addButton.getAccessibleContext().setAccessibleName(string);
            string = bl ? stringArray[5] : stringArray[1];
            this._addAllButton.getAccessibleContext().setAccessibleName(string);
            string = stringArray[2];
            this._removeButton.getAccessibleContext().setAccessibleName(string);
            string = stringArray[3];
            this._removeAllButton.getAccessibleContext().setAccessibleName(string);
        }
        string = resourceBundle.getString("REORDER_UP");
        this._reorderUp.getAccessibleContext().setAccessibleName(string);
        string = resourceBundle.getString("REORDER_DOWN");
        this._reorderDown.getAccessibleContext().setAccessibleName(string);
    }

    private void _updateReorderContents() {
        ShuttleUI shuttleUI = this.getShuttleUI();
        boolean bl = this._isActualLayoutReversed();
        Painter painter = shuttleUI.getButtonPainter(this, bl ? 10 : 8);
        this._reorderUp.setPainter(painter);
        painter = shuttleUI.getButtonPainter(this, bl ? 11 : 9);
        this._reorderDown.setPainter(painter);
    }

    private boolean _isActualLayoutReversed() {
        return this._actualReversed;
    }

    private void _setActualLayoutReversed(boolean bl) {
        if (this._actualReversed != bl) {
            this._actualReversed = bl;
            LayoutManager layoutManager = this.getLayout();
            if (layoutManager != null) {
                ((ShuttleLayout)this.getLayout()).setReverseLayout(bl);
                this._updateButtonContents();
                this._updateReorderContents();
            }
            this.invalidate();
        }
    }

    void updateReorderButtonsEnabled(ToMultiItemPicker toMultiItemPicker) {
        this._reorderUp.setEnabled(toMultiItemPicker.isSelectionUpwardlyMobile());
        this._reorderDown.setEnabled(toMultiItemPicker.isSelectionDownwardlyMobile());
    }

    void updateButtonsEnabled(MultiItemPicker multiItemPicker) {
        PushButton pushButton;
        PushButton pushButton2;
        if (multiItemPicker == this._fromPicker) {
            pushButton2 = this._addButton;
            pushButton = this._addAllButton;
        } else {
            pushButton2 = this._removeButton;
            pushButton = this._removeAllButton;
            this.updateReorderButtonsEnabled((ToMultiItemPicker)multiItemPicker);
        }
        boolean bl = multiItemPicker.isSelectableItemPresent();
        boolean bl2 = multiItemPicker.isItemSelected();
        if (multiItemPicker == this._fromPicker && this._toPicker != null) {
            boolean bl3 = bl2;
            DataFlavor[] dataFlavorArray = multiItemPicker.getSupportedDataFlavors();
            if (bl2 && dataFlavorArray != null) {
                bl2 = this._toPicker.canAcceptFlavors(dataFlavorArray);
            }
            if (bl && (bl2 || !bl3)) {
                if (dataFlavorArray != null) {
                    bl = this._toPicker.canAcceptFlavors(dataFlavorArray);
                }
            } else {
                bl = false;
            }
        }
        pushButton.setEnabled(bl);
        pushButton2.setEnabled(bl2);
    }

    void addItems() {
        boolean bl;
        MultiItemPicker multiItemPicker = this._fromPicker;
        ToMultiItemPicker toMultiItemPicker = this._toPicker;
        DataFlavor[] dataFlavorArray = multiItemPicker.getSupportedDataFlavors();
        boolean bl2 = bl = dataFlavorArray == null ? true : toMultiItemPicker.canAcceptFlavors(dataFlavorArray);
        if (bl) {
            toMultiItemPicker.deselectAll();
            boolean bl3 = toMultiItemPicker.addSelectedItems(multiItemPicker.getSelectedItems());
            if (this._itemsUnique == 0 && bl3) {
                multiItemPicker.removeSelectedItems();
            }
            if (multiItemPicker.isSelectableItemPresent()) {
                multiItemPicker.getComponent().requestFocus();
            } else if (toMultiItemPicker.isSelectableItemPresent()) {
                toMultiItemPicker.getComponent().requestFocus();
            }
        }
    }

    void removeItems() {
        MultiItemPicker multiItemPicker = this._fromPicker;
        ToMultiItemPicker toMultiItemPicker = this._toPicker;
        boolean bl = true;
        if (this._itemsUnique == 0) {
            bl = multiItemPicker.addSelectedItems(toMultiItemPicker.getSelectedItems());
        }
        if (bl) {
            toMultiItemPicker.removeSelectedItems();
        }
        if (toMultiItemPicker.isSelectableItemPresent()) {
            toMultiItemPicker.getComponent().requestFocus();
        } else if (multiItemPicker.isSelectableItemPresent()) {
            multiItemPicker.getComponent().requestFocus();
        }
    }

    private ShuttleHandler _getShuttleHandler() {
        if (this._handler == null) {
            this._handler = new ShuttleHandler();
        }
        return this._handler;
    }

    protected void processShuttleEvent(ShuttleEvent shuttleEvent) {
        Enumeration enumeration;
        int n = shuttleEvent.getID();
        ListenerManager listenerManager = this._shuttleListeners;
        if (listenerManager != null && (enumeration = listenerManager.getListeners()) != null) {
            while (enumeration.hasMoreElements()) {
                ShuttleListener shuttleListener = (ShuttleListener)enumeration.nextElement();
                switch (n) {
                    case 2000: 
                    case 2001: 
                    case 2002: 
                    case 2003: {
                        shuttleListener.shuttleItemsMoved(shuttleEvent);
                        break;
                    }
                    case 2004: 
                    case 2005: {
                        shuttleListener.shuttleItemsRemoved(shuttleEvent);
                        break;
                    }
                    case 2006: 
                    case 2007: {
                        shuttleListener.shuttleItemsReordered(shuttleEvent);
                        break;
                    }
                }
            }
        }
    }

    protected String[] getLocalizedLabels(Locale locale) {
        if (locale == null) {
            locale = Locale.getDefault();
        }
        ResourceBundle resourceBundle = ResourceBundle.getBundle("oracle.ewt.shuttle.resource.ShuttleBundle", LocaleUtils.getTranslationLocale(locale));
        String[] stringArray = new String[6];
        stringArray[0] = resourceBundle.getString(_MOVE_KEY);
        stringArray[2] = resourceBundle.getString(_REMOVE_KEY);
        stringArray[1] = resourceBundle.getString(_MOVE_ALL_KEY);
        stringArray[3] = resourceBundle.getString(_REMOVE_ALL_KEY);
        stringArray[4] = resourceBundle.getString(_COPY_KEY);
        stringArray[5] = resourceBundle.getString(_COPY_ALL_KEY);
        return stringArray;
    }

    static {
        _sInstanceCounter = 0;
    }

    class ShuttleHandler
    implements ActionListener,
    ItemListener,
    PulsingButtonListener,
    Runnable {
        private ContinuousButton _pulser;

        ShuttleHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            MultiItemPicker multiItemPicker = Shuttle.this._fromPicker;
            ToMultiItemPicker toMultiItemPicker = Shuttle.this._toPicker;
            Transferable[] transferableArray = null;
            boolean bl = false;
            if (actionEvent.getSource() instanceof MultiItemPicker) {
                MultiItemPicker multiItemPicker2 = (MultiItemPicker)actionEvent.getSource();
                if (multiItemPicker2 == multiItemPicker) {
                    if (multiItemPicker.isItemSelected()) {
                        transferableArray = multiItemPicker.getSelectedItems();
                        Shuttle.this.addItems();
                        if (Shuttle.this._itemsUnique == 0) {
                            Shuttle.this.processShuttleEvent(new ShuttleEvent(Shuttle.this, 2000, transferableArray));
                        } else {
                            Shuttle.this.processShuttleEvent(new ShuttleEvent(Shuttle.this, 2002, transferableArray));
                        }
                        bl = true;
                    }
                } else if (multiItemPicker2 == toMultiItemPicker && toMultiItemPicker.isItemSelected()) {
                    transferableArray = toMultiItemPicker.getSelectedItems();
                    Shuttle.this.removeItems();
                    Shuttle.this.processShuttleEvent(new ShuttleEvent(Shuttle.this, 2004, transferableArray));
                    bl = true;
                }
            } else if (actionEvent.getSource() instanceof Component) {
                Component component = (Component)actionEvent.getSource();
                if (component == Shuttle.this._addButton) {
                    transferableArray = multiItemPicker.getSelectedItems();
                    Shuttle.this.addItems();
                    if (Shuttle.this._itemsUnique == 0) {
                        Shuttle.this.processShuttleEvent(new ShuttleEvent(Shuttle.this, 2000, transferableArray));
                    } else {
                        Shuttle.this.processShuttleEvent(new ShuttleEvent(Shuttle.this, 2002, transferableArray));
                    }
                } else if (component == Shuttle.this._addAllButton) {
                    boolean bl2;
                    DataFlavor[] dataFlavorArray = multiItemPicker.getSupportedDataFlavors();
                    boolean bl3 = bl2 = dataFlavorArray == null ? true : toMultiItemPicker.canAcceptFlavors(dataFlavorArray);
                    if (bl2) {
                        toMultiItemPicker.deselectAll();
                        boolean bl4 = false;
                        transferableArray = multiItemPicker.getAllSelectableItems();
                        bl4 = toMultiItemPicker.addSelectedItems(transferableArray);
                        if (Shuttle.this._itemsUnique == 0 && bl4) {
                            multiItemPicker.removeAllSelectableItems();
                        }
                        toMultiItemPicker.getComponent().requestFocus();
                        if (Shuttle.this._itemsUnique == 0) {
                            Shuttle.this.processShuttleEvent(new ShuttleEvent(Shuttle.this, 2001, transferableArray));
                        } else {
                            Shuttle.this.processShuttleEvent(new ShuttleEvent(Shuttle.this, 2003, transferableArray));
                        }
                    }
                } else if (component == Shuttle.this._removeButton) {
                    transferableArray = toMultiItemPicker.getSelectedItems();
                    Shuttle.this.removeItems();
                    Shuttle.this.processShuttleEvent(new ShuttleEvent(Shuttle.this, 2004, transferableArray));
                } else if (component == Shuttle.this._removeAllButton) {
                    multiItemPicker.deselectAll();
                    boolean bl5 = true;
                    transferableArray = toMultiItemPicker.getAllSelectableItems();
                    if (Shuttle.this._itemsUnique == 0) {
                        bl5 = multiItemPicker.addSelectedItems(transferableArray);
                    }
                    if (bl5) {
                        toMultiItemPicker.removeAllSelectableItems();
                    }
                    toMultiItemPicker.getComponent().requestFocus();
                    Shuttle.this.processShuttleEvent(new ShuttleEvent(Shuttle.this, 2005, transferableArray));
                }
            }
            Shuttle.this.updateButtonsEnabled(multiItemPicker);
            Shuttle.this.updateButtonsEnabled(toMultiItemPicker);
            if (bl && actionEvent instanceof ConsumableActionEvent) {
                ((ConsumableActionEvent)actionEvent).consume();
            }
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            Shuttle.this.updateButtonsEnabled((MultiItemPicker)itemEvent.getSource());
        }

        @Override
        public void run() {
            if (!Shuttle.this._reorderAllowed) {
                return;
            }
            Transferable[] transferableArray = Shuttle.this._toPicker.getSelectedItems();
            if (this._pulser == Shuttle.this._reorderUp) {
                if (Shuttle.this._toPicker.isSelectionUpwardlyMobile()) {
                    Shuttle.this._toPicker.moveSelectionUp();
                    Shuttle.this.processShuttleEvent(new ShuttleEvent(Shuttle.this, 2006, transferableArray));
                }
            } else if (this._pulser == Shuttle.this._reorderDown && Shuttle.this._toPicker.isSelectionDownwardlyMobile()) {
                Shuttle.this._toPicker.moveSelectionDown();
                Shuttle.this.processShuttleEvent(new ShuttleEvent(Shuttle.this, 2007, transferableArray));
            }
            Shuttle.this.updateReorderButtonsEnabled(Shuttle.this._toPicker);
        }

        @Override
        public void pulseStartPulsing(PulsingButtonEvent pulsingButtonEvent) {
            this._pulser = (ContinuousButton)pulsingButtonEvent.getSource();
        }

        @Override
        public void pulseEndPulsing(PulsingButtonEvent pulsingButtonEvent) {
            this._pulser = null;
        }
    }
}

