/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.pivot;

import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.MouseEvent;
import oracle.ewt.dataSource.NullOneDDataSource;
import oracle.ewt.dataSource.OneDDataSource;
import oracle.ewt.dataSource.TwoDDataSource;
import oracle.ewt.dataSource.TwoDDataSourceAdapter;
import oracle.ewt.dataSource.TwoDDataSourceEvent;
import oracle.ewt.event.Cancelable;
import oracle.ewt.grid.AppearanceManager;
import oracle.ewt.grid.Grid;
import oracle.ewt.grid.MultipleSelection;
import oracle.ewt.header.Header;
import oracle.ewt.header.MultipleItemSelection;
import oracle.ewt.painter.PaintContext;
import oracle.ewt.pivot.PivotGridLayout;
import oracle.ewt.pivot.PivotHeader;
import oracle.ewt.pivot.PivotTable;
import oracle.ewt.plaf.PivotGridUI;
import oracle.ewt.table.SpreadTable;
import oracle.ewt.table.TableEvent;

public class PivotGrid
extends SpreadTable {
    private int _dragItem;
    private boolean _horizontal;
    private boolean _resizing;

    public PivotGrid(TwoDDataSource twoDDataSource) {
        Grid grid = this.getGrid();
        this.remove(grid);
        this.setLayout(new PivotGridLayout());
        this.add("grid", grid);
        this.setDataSource(twoDDataSource);
        grid.setUpperLeft(false);
        grid.setUpperRight(false);
        grid.setLowerLeft(false);
        grid.setLowerRight(true);
        grid.setGridSelection(new MultipleSelection());
        grid.setVerticalSeparatorsVisible(true);
        grid.setHorizontalSeparatorsVisible(true);
        grid.setDrawFocusCellHighlite(true);
        Header header = this.getColumnHeader();
        header.setHeaderSelection(new MultipleItemSelection());
        header.setCanMoveItems(false);
        header = this.getRowHeader();
        header.setHeaderSelection(new MultipleItemSelection());
        header.setCanMoveItems(false);
        this._dragItem = -1;
        this.setBorderPainter(null);
    }

    @Override
    public Object getUIClassID() {
        return "PivotGridUI";
    }

    public final TwoDDataSource getDataSource() {
        return this.getGrid().getDataSource();
    }

    public void setDataSource(TwoDDataSource twoDDataSource) {
        this.setDataSources(twoDDataSource, new NullOneDDataSource(twoDDataSource.getColumnCount()), new NullOneDDataSource(twoDDataSource.getRowCount()));
        twoDDataSource.addDataSourceListener(new _DSListen());
    }

    public final AppearanceManager getAppearanceManager() {
        return this.getGrid().getAppearanceManager();
    }

    public final void setAppearanceManager(AppearanceManager appearanceManager) {
        this.getGrid().setAppearanceManager(appearanceManager);
    }

    public final PivotTable getPivotTable() {
        Container container = this.getParent();
        if (container instanceof PivotTable) {
            return (PivotTable)container;
        }
        return null;
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension dimension = this.getGrid().getPreferredSize();
        dimension.height += this.getColumnHeaderHeight();
        dimension.width += this.getRowHeaderWidth();
        return this.convertInnerToOuterSize(dimension.width, dimension.height);
    }

    @Override
    public Dimension getMinimumSize() {
        Dimension dimension = this.getGrid().getMinimumSize();
        dimension.height += this.getColumnHeaderHeight();
        dimension.width += this.getRowHeaderWidth();
        return this.convertInnerToOuterSize(dimension.width, dimension.height);
    }

    @Override
    public void setDrawRaised(boolean bl) {
        super.setDrawRaised(bl);
        this.getRowHeader().setDrawRaised(bl);
        this.getColumnHeader().setDrawRaised(bl);
        this.getGrid().setOverlayBorderVisible(bl);
    }

    @Override
    public void setCanvasOrigin(int n, int n2) {
        int n3;
        int n4;
        int n5;
        int n6;
        int n7 = this.getCanvasWidth();
        int n8 = this.getInnerWidth();
        PivotTable pivotTable = this.getPivotTable();
        this.getGrid().setCanvasOrigin(n, n2);
        this.getColumnHeader().setCanvasOrigin(n, this.getColumnHeader().getCanvasOriginY());
        this.getRowHeader().setCanvasOrigin(this.getRowHeader().getCanvasOriginX(), n2);
        if (this.getActualReadingDirection() == 1 && n8 < n7 && n8 - n7 > n) {
            if (pivotTable != null && pivotTable.getEqualSizedColumns()) {
                n = n8 - n7;
            }
            n6 = this.getGrid().getCanvasWidth();
            n5 = this.getGrid().getInnerWidth();
            this.getGrid().setCanvasOrigin(n5 - n6, n2);
            n4 = this.getColumnHeader().getCanvasWidth();
            n3 = this.getColumnHeader().getInnerWidth();
            this.getColumnHeader().setCanvasOrigin(n3 - n4, this.getColumnHeader().getCanvasOriginY());
        }
        n6 = this.getCanvasHeight();
        n5 = this.getInnerHeight();
        if (n5 < n6 && n5 - n6 > n2) {
            if (pivotTable != null && pivotTable.getEqualSizedRows()) {
                n2 = n5 - n6;
            }
            n4 = this.getGrid().getCanvasHeight();
            n3 = this.getGrid().getInnerHeight();
            this.getGrid().setCanvasOrigin(n, n3 - n4);
            int n9 = this.getRowHeader().getCanvasHeight();
            int n10 = this.getRowHeader().getInnerHeight();
            this.getRowHeader().setCanvasOrigin(this.getRowHeader().getCanvasOriginX(), n10 - n9);
        }
        super.setCanvasOrigin(n, n2);
    }

    @Override
    protected void processResizeEvent(TableEvent tableEvent) {
        super.processResizeEvent(tableEvent);
        if (tableEvent instanceof Cancelable && ((Cancelable)((Object)tableEvent)).isCancelled()) {
            return;
        }
        int n = tableEvent.getID();
        switch (n) {
            case 2013: {
                this._dragItem = tableEvent.getColumn();
                this._horizontal = true;
                break;
            }
            case 2015: {
                this._dragItem = tableEvent.getRow();
                this._horizontal = false;
                break;
            }
            case 2014: {
                this._dragItem = -1;
                break;
            }
            case 2016: {
                this._dragItem = -1;
            }
        }
        PivotTable pivotTable = this.getPivotTable();
        if (this._horizontal) {
            pivotTable.getColumnPivotHeader().setResizeItem(this._dragItem);
        } else {
            pivotTable.getRowPivotHeader().setResizeItem(this._dragItem);
        }
    }

    @Override
    protected boolean isSelectAllEnabled() {
        Grid grid = this.getGrid();
        return this.isColumnHeaderVisible() && this.isRowHeaderVisible() && grid.getColumnCount() != 0 && grid.getRowCount() != 0;
    }

    protected final PivotGridUI getPivotGridUI() {
        return (PivotGridUI)this.getUI();
    }

    @Override
    protected final Header createColumnHeader(OneDDataSource oneDDataSource) {
        return this.createPivotGridColumnHeader(oneDDataSource);
    }

    protected PivotGridHeader createPivotGridColumnHeader(OneDDataSource oneDDataSource) {
        return new PivotGridHeader(oneDDataSource, true);
    }

    @Override
    protected final Header createRowHeader(OneDDataSource oneDDataSource) {
        return this.createPivotGridRowHeader(oneDDataSource);
    }

    protected PivotGridHeader createPivotGridRowHeader(OneDDataSource oneDDataSource) {
        return new PivotGridHeader(oneDDataSource, false);
    }

    @Override
    protected final Grid createGrid(TwoDDataSource twoDDataSource) {
        return this.createPivotGridGrid(twoDDataSource);
    }

    protected PivotGridGrid createPivotGridGrid(TwoDDataSource twoDDataSource) {
        return new PivotGridGrid(twoDDataSource);
    }

    void setCurrentlyResizing(boolean bl) {
        this._resizing = bl;
    }

    boolean currentlyResizing() {
        return this._resizing;
    }

    void checkColumnHeader(int n) {
        PivotTable pivotTable = this.getPivotTable();
        PivotHeader pivotHeader = pivotTable.getColumnPivotHeader();
        int n2 = pivotHeader.getGrid().getCanvasOriginY();
        pivotHeader.getGrid().setCanvasOrigin(n, n2);
    }

    void checkRowHeader(int n) {
        PivotTable pivotTable = this.getPivotTable();
        PivotHeader pivotHeader = pivotTable.getRowPivotHeader();
        int n2 = pivotHeader.getGrid().getCanvasOriginX();
        pivotHeader.getGrid().setCanvasOrigin(n2, n);
    }

    void updateFeedback() {
        if (this._dragItem != -1) {
            PivotTable pivotTable = this.getPivotTable();
            if (this._horizontal) {
                boolean bl = this.getActualReadingDirection() == 1;
                int n = this.getColumnHeader().getItemSize(this._dragItem);
                if (bl) {
                    this.setColumnWidth(this._dragItem, n);
                }
                pivotTable.getColumnPivotHeader().updateResizeFeedback(n);
            } else {
                int n = this.getRowHeader().getItemSize(this._dragItem);
                this.setRowHeight(this._dragItem, n);
                pivotTable.getRowPivotHeader().updateResizeFeedback(n);
            }
        }
    }

    private class _DSListen
    extends TwoDDataSourceAdapter {
        private _DSListen() {
        }

        @Override
        public void rowsAdded(TwoDDataSourceEvent twoDDataSourceEvent) {
            NullOneDDataSource nullOneDDataSource = (NullOneDDataSource)PivotGrid.this.getRowHeader().getDataSource();
            nullOneDDataSource.addItems(twoDDataSourceEvent.getRowStartIndex(), twoDDataSourceEvent.getRowCount());
        }

        @Override
        public void rowsRemoved(TwoDDataSourceEvent twoDDataSourceEvent) {
            NullOneDDataSource nullOneDDataSource = (NullOneDDataSource)PivotGrid.this.getRowHeader().getDataSource();
            nullOneDDataSource.removeItems(twoDDataSourceEvent.getRowStartIndex(), twoDDataSourceEvent.getRowCount());
        }

        @Override
        public void columnsAdded(TwoDDataSourceEvent twoDDataSourceEvent) {
            NullOneDDataSource nullOneDDataSource = (NullOneDDataSource)PivotGrid.this.getColumnHeader().getDataSource();
            nullOneDDataSource.addItems(twoDDataSourceEvent.getColumnStartIndex(), twoDDataSourceEvent.getColumnCount());
        }

        @Override
        public void columnsRemoved(TwoDDataSourceEvent twoDDataSourceEvent) {
            NullOneDDataSource nullOneDDataSource = (NullOneDDataSource)PivotGrid.this.getColumnHeader().getDataSource();
            nullOneDDataSource.removeItems(twoDDataSourceEvent.getColumnStartIndex(), twoDDataSourceEvent.getColumnCount());
        }
    }

    public class PivotGridHeader
    extends Header {
        public PivotGridHeader(OneDDataSource oneDDataSource, boolean bl) {
            super(oneDDataSource, bl);
        }

        @Override
        public void setCanvasOrigin(int n, int n2) {
            if (!PivotGrid.this.currentlyResizing()) {
                super.setCanvasOrigin(n, n2);
            }
        }

        @Override
        protected void paintExtraCanvas(Graphics graphics, PaintContext paintContext, int n, int n2, int n3, int n4) {
        }

        @Override
        public Insets getAutoscrollInsets() {
            return new Insets(0, 0, 0, 0);
        }

        @Override
        protected void processMouseMotionEvent(MouseEvent mouseEvent) {
            PivotTable pivotTable = PivotGrid.this.getPivotTable();
            if (pivotTable != null) {
                pivotTable.freezeRepaints();
            }
            try {
                super.processMouseMotionEvent(mouseEvent);
                PivotGrid.this.updateFeedback();
            }
            finally {
                if (pivotTable != null) {
                    pivotTable.unfreezeRepaints();
                }
            }
        }
    }

    public class PivotGridGrid
    extends Grid {
        public PivotGridGrid(TwoDDataSource twoDDataSource) {
            super(twoDDataSource);
        }

        @Override
        public Insets getAutoscrollInsets() {
            return new Insets(0, 0, 0, 0);
        }

        @Override
        public void setCanvasOrigin(int n, int n2) {
            if (!PivotGrid.this.currentlyResizing()) {
                super.setCanvasOrigin(n, n2);
            }
        }

        @Override
        protected Dimension layoutCanvas() {
            int n = this.getCanvasOriginX();
            int n2 = this.getCanvasOriginY();
            Dimension dimension = super.layoutCanvas();
            int n3 = this.getCanvasOriginX();
            int n4 = this.getCanvasOriginY();
            if (n != n3) {
                PivotGrid.this.checkColumnHeader(n3);
            }
            if (n2 != n4) {
                PivotGrid.this.checkRowHeader(n4);
            }
            return dimension;
        }
    }
}

