/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.pivot;

import java.awt.Image;
import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.InputEvent;
import oracle.bali.share.datatransfer.TransferUtils;
import oracle.ewt.dnd.DragGestureEvent;
import oracle.ewt.dnd.DragGestureListener;
import oracle.ewt.dnd.DragSource;
import oracle.ewt.dnd.DragSourceDragEvent;
import oracle.ewt.dnd.DragSourceDropEvent;
import oracle.ewt.dnd.DragSourceEvent;
import oracle.ewt.dnd.DragSourceListener;
import oracle.ewt.dnd.DropTarget;
import oracle.ewt.dnd.DropTargetDragEvent;
import oracle.ewt.dnd.DropTargetDropEvent;
import oracle.ewt.dnd.DropTargetEvent;
import oracle.ewt.dnd.DropTargetListener;
import oracle.ewt.grid.Grid;
import oracle.ewt.grid.bigCell.AbstractBigCell;
import oracle.ewt.header.Header;
import oracle.ewt.pivot.AbstractPivotHeaderCell;
import oracle.ewt.pivot.PivotHeader;
import oracle.ewt.pivot.PivotTable;
import oracle.ewt.pivot.PivotTransfer;

class PivotDragDropAdapter
implements DropTargetListener,
DragSourceListener,
DragGestureListener {
    private static final int _PIVOT_SIZE = 6;
    PivotHeader _pivotHeader;

    public PivotDragDropAdapter(PivotHeader pivotHeader) {
        this._pivotHeader = pivotHeader;
        Header header = this._pivotHeader.isHorizontal() ? this._pivotHeader.getRowHeader() : this._pivotHeader.getColumnHeader();
        DragSource.getDefaultDragSource().createDefaultDragGestureRecognizer(header, 2, this);
        DropTarget dropTarget = new DropTarget(header, this);
        Grid grid = this._pivotHeader.getGrid();
        DragSource.getDefaultDragSource().createDefaultDragGestureRecognizer(grid, 2, this);
        dropTarget = new DropTarget(this._pivotHeader.getGrid(), this);
    }

    @Override
    public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
    }

    @Override
    public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
        if (!this._acceptDrag(dropTargetDragEvent)) {
            dropTargetDragEvent.rejectDrag();
            return;
        }
        boolean bl = this._isSwap(dropTargetDragEvent.getLocation());
        int n = this._getIndex(dropTargetDragEvent.getLocation(), bl);
        this._setDropLocation(n, bl);
    }

    public void dragScroll(DropTargetDragEvent dropTargetDragEvent) {
    }

    @Override
    public void dragExit(DropTargetEvent dropTargetEvent) {
        this._setDropLocation(-1, false);
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
    }

    @Override
    public void drop(DropTargetDropEvent dropTargetDropEvent) {
        dropTargetDropEvent.acceptDrop(1);
        this._setDropLocation(-1, false);
        Transferable transferable = dropTargetDropEvent.getTransferable();
        try {
            Object object = transferable.getTransferData(PivotTransfer.DATA_FLAVOR);
            if (object instanceof PivotTransfer) {
                PivotTransfer pivotTransfer = (PivotTransfer)object;
                Object object2 = pivotTransfer.getSource();
                int n = pivotTransfer.getIndex();
                PivotHeader pivotHeader = this._pivotHeader;
                boolean bl = this._isSwap(dropTargetDropEvent.getLocation());
                int n2 = this._getIndex(dropTargetDropEvent.getLocation(), bl);
                PivotTable pivotTable = this._pivotHeader.getPivotTable();
                boolean bl2 = true;
                if (object2 == pivotHeader) {
                    if (!bl && n < n2) {
                        --n2;
                    }
                    if (n == n2) {
                        bl2 = false;
                    }
                }
                if (bl2) {
                    if (!bl) {
                        pivotTable.firePivotEvent(object2, n, pivotHeader, n2);
                    } else {
                        pivotTable.fireSwapEvent(object2, n, pivotHeader, n2);
                    }
                    pivotTable.deselectAll();
                }
                dropTargetDropEvent.getDropTargetContext().dropComplete(true);
            } else {
                dropTargetDropEvent.getDropTargetContext().dropComplete(false);
            }
        }
        catch (Exception exception) {
            dropTargetDropEvent.getDropTargetContext().dropComplete(false);
        }
    }

    @Override
    public void dragGestureRecognized(DragGestureEvent dragGestureEvent) {
        Object object;
        int n;
        if (!this._pivotHeader.isDragEnabled() || this._pivotHeader.isDrilling() || this._pivotHeader.getResizeItem() != -1) {
            return;
        }
        boolean bl = this._pivotHeader.isHorizontal();
        Header header = bl ? this._pivotHeader.getRowHeader() : this._pivotHeader.getColumnHeader();
        Point point = dragGestureEvent.getDragOrigin();
        if (dragGestureEvent.getComponent() == header) {
            if (header.getItemCount() == 0) {
                return;
            }
            n = header.getItemAt(point.x, point.y);
            if (n == -1) {
                return;
            }
            if (bl) {
                point.x = 5;
                point.y -= header.getItemPosition(n);
                point.y = -point.y;
            } else {
                point.x -= header.getItemPosition(n);
                point.x = -point.x;
                point.y = 5;
            }
        } else {
            object = this._pivotHeader.getGrid();
            if (((Grid)object).getRowCount() == 0 || ((Grid)object).getColumnCount() == 0) {
                return;
            }
            int n2 = ((Grid)object).getColumnAt(point.x);
            int n3 = ((Grid)object).getRowAt(point.y);
            if (n2 == -1 || n3 == -1) {
                return;
            }
            AbstractBigCell abstractBigCell = AbstractBigCell.getBigCell((Grid)object, n2, n3);
            int n4 = n2;
            int n5 = n3;
            if (abstractBigCell != null) {
                if (bl) {
                    n5 = abstractBigCell.getRow();
                } else if (this._pivotHeader.isOutline() && abstractBigCell instanceof AbstractPivotHeaderCell) {
                    AbstractPivotHeaderCell abstractPivotHeaderCell = (AbstractPivotHeaderCell)abstractBigCell;
                    n4 = abstractPivotHeaderCell.getColumn() + abstractPivotHeaderCell.getIndent();
                } else {
                    n4 = abstractBigCell.getColumn();
                }
            }
            if (bl) {
                n = n5;
                point.x = 5;
                point.y -= ((Grid)object).getRowPosition(n3);
                point.y = -point.y;
            } else {
                n = n4;
                point.x -= ((Grid)object).getColumnPosition(n2);
                point.x = -point.x;
                point.y = 5;
            }
        }
        object = this._pivotHeader.getDragImage(n);
        this._pivotHeader.setDragItem(n);
        dragGestureEvent.startDrag(null, (Image)object, point, PivotTransfer.createTransferable(this._pivotHeader, n), this);
        Object[] objectArray = dragGestureEvent.toArray();
        Object object2 = objectArray[objectArray.length - 1];
        if (object2 instanceof InputEvent) {
            ((InputEvent)object2).consume();
        }
    }

    @Override
    public void dragEnter(DragSourceDragEvent dragSourceDragEvent) {
    }

    @Override
    public void dragOver(DragSourceDragEvent dragSourceDragEvent) {
    }

    @Override
    public void dropActionChanged(DragSourceDragEvent dragSourceDragEvent) {
    }

    @Override
    public void dragExit(DragSourceEvent dragSourceEvent) {
    }

    @Override
    public void dragDropEnd(DragSourceDropEvent dragSourceDropEvent) {
        this._pivotHeader.setDragItem(-1);
    }

    private boolean _acceptDrag(DropTargetDragEvent dropTargetDragEvent) {
        if (!this._pivotHeader.isEnabled()) {
            return false;
        }
        DataFlavor[] dataFlavorArray = dropTargetDragEvent.getCurrentDataFlavors();
        if (dataFlavorArray == null) {
            return false;
        }
        for (int i = 0; i < dataFlavorArray.length; ++i) {
            if (!TransferUtils.supportsDataFlavor((DataFlavor)dataFlavorArray[i], (DataFlavor)PivotTransfer.DATA_FLAVOR)) continue;
            return true;
        }
        return false;
    }

    void _setDropLocation(int n, boolean bl) {
        this._pivotHeader.setDropLocation(n, bl);
    }

    private boolean _isSwap(Point point) {
        if (!this._pivotHeader.getPivotTable().isSwapAllowed()) {
            return false;
        }
        int n = -1;
        if (this._pivotHeader.isHorizontal()) {
            Header header = this._pivotHeader.getRowHeader();
            n = header.getItemAt(point.x, point.y);
            if (n == -1) {
                return false;
            }
            int n2 = header.getItemPosition(n);
            int n3 = header.getItemSize(n);
            if (point.y < n2 + 6) {
                return false;
            }
            if (point.y > n2 + n3 - 6) {
                return false;
            }
        } else {
            Header header = this._pivotHeader.getColumnHeader();
            n = header.getItemAt(point.x, point.y);
            if (n == -1) {
                return false;
            }
            int n4 = header.getItemPosition(n);
            int n5 = header.getItemSize(n);
            if (point.x < n4 + 6) {
                return false;
            }
            if (point.x > n4 + n5 - 6) {
                return false;
            }
        }
        return true;
    }

    private int _getIndex(Point point, boolean bl) {
        int n = -1;
        if (this._pivotHeader.isHorizontal()) {
            Header header = this._pivotHeader.getRowHeader();
            n = header.getItemAt(point.x, point.y);
            if (!bl) {
                if (n == -1) {
                    n = 0;
                } else {
                    int n2;
                    int n3 = header.getItemPosition(n);
                    if (point.y > n3 + (n2 = header.getItemSize(n)) / 2) {
                        ++n;
                    }
                }
            }
        } else {
            Header header = this._pivotHeader.getColumnHeader();
            boolean bl2 = this._pivotHeader.getActualReadingDirection() == 1;
            n = header.getItemAt(point.x, point.y);
            if (!bl) {
                if (n == -1) {
                    n = 0;
                } else if (!bl) {
                    int n4 = header.getItemPosition(n);
                    int n5 = header.getItemSize(n);
                    if (bl2) {
                        if (point.x > n4 + n5 / 2) {
                            ++n;
                        }
                    } else if (point.x < n4 + n5 / 2) {
                        ++n;
                    }
                }
            }
        }
        return n;
    }
}

