/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.painter;

import oracle.ewt.painter.AbstractBorderPainter;
import oracle.ewt.painter.PaintContext;
import oracle.ewt.painter.Painter;
import oracle.ewt.util.ImmInsets;

public class DirectionalBorderPainter
extends AbstractBorderPainter {
    private ImmInsets _insets;
    private ImmInsets _rightToLeftInsets;

    public DirectionalBorderPainter(int n, int n2, int n3, int n4) {
        this._init(n, n2, n3, n4);
    }

    public DirectionalBorderPainter(Painter painter, int n, int n2, int n3, int n4) {
        super(painter);
        this._init(n, n2, n3, n4);
    }

    public DirectionalBorderPainter(Painter painter, int n, int n2, int n3, int n4, boolean bl) {
        super(painter, bl);
        this._init(n, n2, n3, n4);
    }

    @Override
    protected ImmInsets getOwnInsets(PaintContext paintContext) {
        if (paintContext.getReadingDirection() == 2) {
            return this._getRightToLeftInsets();
        }
        return this._insets;
    }

    @Override
    protected boolean isBorderTransparent(PaintContext paintContext) {
        ImmInsets immInsets = this._insets;
        return immInsets.top != 0 || immInsets.left != 0 || immInsets.bottom != 0 || immInsets.right != 0;
    }

    @Override
    public int getRepaintFlags(PaintContext paintContext) {
        return super.getRepaintFlags(paintContext) | 0x4000;
    }

    @Override
    public int getInvalidateFlags(PaintContext paintContext) {
        return super.getInvalidateFlags(paintContext) | 0x4000;
    }

    private void _init(int n, int n2, int n3, int n4) {
        this._insets = new ImmInsets(n, n2, n3, n4);
    }

    private ImmInsets _getRightToLeftInsets() {
        if (this._rightToLeftInsets == null) {
            ImmInsets immInsets = this._insets;
            this._rightToLeftInsets = new ImmInsets(immInsets.top, immInsets.right, immInsets.bottom, immInsets.left);
        }
        return this._rightToLeftInsets;
    }
}

