/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.lwAWT.lwWindow.laf;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import oracle.ewt.lwAWT.lwWindow.Desktop;
import oracle.ewt.lwAWT.lwWindow.LWWindow;
import oracle.ewt.lwAWT.lwWindow.WindowManager;
import oracle.ewt.lwAWT.lwWindow.laf.BaseWindowMover;
import oracle.ewt.lwAWT.lwWindow.laf.TitleBar;
import oracle.ewt.util.InputEventUtils;

class MouseWindowMover
extends BaseWindowMover
implements MouseListener,
MouseMotionListener {
    private Point _initialMousePos;
    private TitleBar _titleBar;

    public MouseWindowMover(LWWindow lWWindow, TitleBar titleBar) {
        super(lWWindow);
        this._titleBar = titleBar;
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        if (this.isReshaping()) {
            this.endReshaping(false);
            mouseEvent.consume();
            return;
        }
        if (!InputEventUtils.isLeftMouseButton(mouseEvent) || mouseEvent.getClickCount() > 1) {
            return;
        }
        this._initialMousePos = this._getTranslatedPoint(mouseEvent);
        this._titleBar.setArmed(true);
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (!InputEventUtils.isLeftMouseButton(mouseEvent) || mouseEvent.getClickCount() > 1) {
            return;
        }
        this.endReshaping(true);
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        if (!this.isWindowReshapable() || !InputEventUtils.isLeftMouseButton(mouseEvent) || this._initialMousePos == null) {
            return;
        }
        if (!this.isReshaping()) {
            this.beginReshaping();
        }
        Point point = this._getTranslatedPoint(mouseEvent);
        LWWindow lWWindow = this.getWindow();
        Point point2 = this.getWindowLocation();
        Desktop desktop = lWWindow.getDesktop();
        if (desktop == null) {
            return;
        }
        Component component = desktop.getDesktopComponent();
        Dimension dimension = component.getSize();
        if (point.x + point2.x < 0) {
            point.x = -point2.x;
        } else if (point.x + point2.x > dimension.width) {
            point.x = dimension.width - point2.x;
        }
        if (point.y + point2.y < 0) {
            point.y = -point2.y;
        } else if (point.y + point2.y > dimension.height) {
            point.y = dimension.height - point2.y;
        }
        int n = point.x - this._initialMousePos.x;
        int n2 = point.y - this._initialMousePos.y;
        int n3 = point2.x + n;
        int n4 = point2.y + n2;
        WindowManager windowManager = desktop.getWindowManager();
        windowManager.moveWindow(lWWindow, n3, n4);
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
    }

    @Override
    protected void endReshaping(boolean bl) {
        super.endReshaping(bl);
        this._titleBar.setArmed(false);
        this._initialMousePos = null;
    }

    @Override
    protected MouseListener getMouseGrab() {
        return this;
    }

    private Point _getTranslatedPoint(MouseEvent mouseEvent) {
        LWWindow lWWindow = this.getWindow();
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        for (Component component = (Component)mouseEvent.getSource(); component != lWWindow; component = component.getParent()) {
            Point point = component.getLocation();
            n += point.x;
            n2 += point.y;
        }
        return new Point(n, n2);
    }
}

