/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.lwAWT.lwText;

import oracle.ewt.lwAWT.lwText.TextPosition;

final class ParagraphPosition
implements Cloneable,
TextPosition {
    public int paragraph;
    public int globalIndex;
    public int index;
    public int globalRow;
    public int row;
    public int column;

    public ParagraphPosition() {
        this.paragraph = 0;
        this.globalIndex = 0;
        this.index = 0;
        this.row = 0;
        this.globalRow = 0;
        this.column = 0;
    }

    public ParagraphPosition(int n, int n2, int n3, int n4, int n5, int n6) {
        this.paragraph = n;
        this.globalIndex = n2;
        this.index = n3;
        this.row = n5;
        this.globalRow = n4;
        this.column = n6;
        if (n < 0 || n2 < 0 || n3 < 0 || n5 < 0 || n4 < 0 || n6 < 0) {
            throw new IllegalArgumentException("Invalid position " + this);
        }
    }

    public boolean equals(Object object) {
        if (!(object instanceof ParagraphPosition)) {
            return false;
        }
        ParagraphPosition paragraphPosition = (ParagraphPosition)object;
        return paragraphPosition.globalIndex == this.globalIndex && paragraphPosition.globalRow == this.globalRow && paragraphPosition.column == this.column;
    }

    @Override
    public int getIndex() {
        return this.globalIndex;
    }

    public Object clone() {
        return new ParagraphPosition(this.paragraph, this.globalIndex, this.index, this.globalRow, this.row, this.column);
    }

    public final int getParagraphStartIndex() {
        return this.globalIndex - this.index;
    }
}

