/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.lwAWT.lwText;

import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import oracle.bali.share.datatransfer.ObjectTransferable;
import oracle.bali.share.datatransfer.TransferUtils;
import oracle.ewt.dnd.DragGestureEvent;
import oracle.ewt.dnd.DragGestureListener;
import oracle.ewt.dnd.DragGestureRecognizer;
import oracle.ewt.dnd.DragSource;
import oracle.ewt.dnd.DragSourceDragEvent;
import oracle.ewt.dnd.DragSourceDropEvent;
import oracle.ewt.dnd.DragSourceEvent;
import oracle.ewt.dnd.DragSourceListener;
import oracle.ewt.dnd.DropTarget;
import oracle.ewt.dnd.DropTargetDragEvent;
import oracle.ewt.dnd.DropTargetDropEvent;
import oracle.ewt.dnd.DropTargetEvent;
import oracle.ewt.dnd.DropTargetListener;
import oracle.ewt.lwAWT.lwText.LWCommonText;
import oracle.ewt.lwAWT.lwText.TextPosition;

public class LWTextDragger {
    private DropTarget _target;
    private Adapter _adapter;
    private static final DataFlavor _sStringFlavor = TransferUtils.getDataFlavor(String.class);
    private static final DataFlavor _sArrayFlavor = TransferUtils.getDataFlavor(String[].class);

    public LWTextDragger() {
        this(null);
    }

    public LWTextDragger(LWCommonText lWCommonText) {
        this._adapter = new Adapter(lWCommonText);
        this._target = new DropTarget(lWCommonText, this._adapter);
        if (lWCommonText == null) {
            this._target.setActive(true);
        }
        this.setTargetActions(0);
    }

    public LWCommonText getTextComponent() {
        return this._adapter.getTextComponent();
    }

    public void setTextComponent(LWCommonText lWCommonText) {
        this._adapter.setTextComponent(lWCommonText);
        this._target.setComponent(lWCommonText);
    }

    public void setActive(boolean bl) {
        this._target.setActive(bl);
    }

    public boolean isActive() {
        return this._target.isActive();
    }

    public void setTargetActions(int n) {
        this._target.setDefaultActions(n);
    }

    public int getTargetActions() {
        return this._target.getDefaultActions();
    }

    public void setSourceActions(int n) {
        this._adapter.setSourceActions(n);
    }

    public int getSourceActions() {
        return this._adapter.getSourceActions();
    }

    protected Transferable createTransferable(LWCommonText lWCommonText) {
        return ObjectTransferable.createTransferable((Object)lWCommonText.getSelectedText());
    }

    protected boolean isDragAcceptable(DropTargetDragEvent dropTargetDragEvent) {
        return dropTargetDragEvent.isDataFlavorSupported(_sArrayFlavor) || dropTargetDragEvent.isDataFlavorSupported(_sStringFlavor);
    }

    protected String getStringFromDrop(DropTargetDropEvent dropTargetDropEvent) {
        Transferable transferable = dropTargetDropEvent.getTransferable();
        String string = null;
        try {
            if (transferable.isDataFlavorSupported(_sArrayFlavor)) {
                String[] stringArray = (String[])transferable.getTransferData(_sArrayFlavor);
                StringBuffer stringBuffer = new StringBuffer();
                for (int i = 0; i < stringArray.length; ++i) {
                    stringBuffer.append(stringArray[i]);
                }
                string = stringBuffer.toString();
            } else if (transferable.isDataFlavorSupported(_sStringFlavor)) {
                string = (String)transferable.getTransferData(_sStringFlavor);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string;
    }

    private class Adapter
    implements DragGestureListener,
    DragSourceListener,
    DropTargetListener {
        private LWCommonText _textComp;
        private DragGestureRecognizer _recognizer;
        private transient boolean _canDrag;
        private transient boolean _inDrag;
        private transient boolean _inDrop;

        public Adapter(LWCommonText lWCommonText) {
            DragSource dragSource = DragSource.getDefaultDragSource();
            this._recognizer = dragSource.createDefaultDragGestureRecognizer(lWCommonText, 0, this);
            this._textComp = lWCommonText;
        }

        public LWCommonText getTextComponent() {
            return this._textComp;
        }

        public void setTextComponent(LWCommonText lWCommonText) {
            this._textComp = lWCommonText;
            this._recognizer.setComponent(lWCommonText);
        }

        public void setSourceActions(int n) {
            this._recognizer.setSourceActions(n);
        }

        public int getSourceActions() {
            return this._recognizer.getSourceActions();
        }

        @Override
        public void dragGestureRecognized(DragGestureEvent dragGestureEvent) {
            LWCommonText lWCommonText = this._textComp;
            if (lWCommonText.isEditable() && lWCommonText.isEnabled()) {
                int n = lWCommonText.getSelectionStart();
                int n2 = lWCommonText.getSelectionEnd();
                Point point = dragGestureEvent.getDragOrigin();
                TextPosition textPosition = lWCommonText.canvasToPosition(point.x, point.y);
                if (n < n2 && n < textPosition.getIndex() && textPosition.getIndex() < n2 && LWTextDragger.this.isActive()) {
                    this._inDrag = true;
                    dragGestureEvent.startDrag(null, LWTextDragger.this.createTransferable(lWCommonText), this);
                }
            }
        }

        @Override
        public void dragEnter(DragSourceDragEvent dragSourceDragEvent) {
        }

        @Override
        public void dragOver(DragSourceDragEvent dragSourceDragEvent) {
        }

        @Override
        public void dropActionChanged(DragSourceDragEvent dragSourceDragEvent) {
        }

        @Override
        public void dragExit(DragSourceEvent dragSourceEvent) {
        }

        @Override
        public void dragDropEnd(DragSourceDropEvent dragSourceDropEvent) {
            if (dragSourceDropEvent.getDropSuccess() && (this.getSourceActions() & 2) != 0 && dragSourceDropEvent.getDropAction() == 2) {
                LWCommonText lWCommonText = this._textComp;
                int n = lWCommonText.getSelectionStart();
                int n2 = lWCommonText.getSelectionEnd();
                lWCommonText.replaceRange("", n, n2);
            }
            this._inDrag = false;
        }

        @Override
        public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
            this._inDrop = true;
            this.dragOver(dropTargetDragEvent);
        }

        @Override
        public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
            TextPosition textPosition;
            int n = this._getDropAction(dropTargetDragEvent.getDropAction());
            if (n != 0 && !LWTextDragger.this.isDragAcceptable(dropTargetDragEvent)) {
                n = 0;
            }
            LWCommonText lWCommonText = this._textComp;
            if (n == 0) {
                textPosition = null;
                dropTargetDragEvent.rejectDrag();
            } else {
                Point point = dropTargetDragEvent.getLocation();
                textPosition = lWCommonText.canvasToPosition(point.x, point.y);
                dropTargetDragEvent.acceptDrag(n);
            }
            lWCommonText.setDropPosition(textPosition);
        }

        @Override
        public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
        }

        @Override
        public void dragExit(DropTargetEvent dropTargetEvent) {
            this._textComp.setDropPosition(null);
            this._inDrop = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void drop(DropTargetDropEvent dropTargetDropEvent) {
            String string;
            LWCommonText lWCommonText = this._textComp;
            lWCommonText.setDropPosition(null);
            boolean bl = false;
            int n = this._getDropAction(dropTargetDropEvent.getDropAction());
            if (n != 0 && (string = LWTextDragger.this.getStringFromDrop(dropTargetDropEvent)) != null && string.length() > 0) {
                Point point = dropTargetDropEvent.getLocation();
                TextPosition textPosition = lWCommonText.canvasToPosition(point.x, point.y);
                int n2 = textPosition.getIndex();
                if (n == 2 && this._inDrag) {
                    int n3 = lWCommonText.getSelectionStart();
                    int n4 = lWCommonText.getSelectionEnd();
                    if (n2 <= n3 || n2 >= n4) {
                        bl = true;
                        dropTargetDropEvent.acceptDrop(1);
                        lWCommonText.freezeRepaints();
                        try {
                            lWCommonText.replaceRange("", n3, n4);
                            if (n2 > n4) {
                                n2 -= n4 - n3;
                            }
                            lWCommonText.replaceRange(string, n2, n2);
                        }
                        finally {
                            lWCommonText.unfreezeRepaints();
                        }
                    }
                } else if (!this._inDrag) {
                    bl = true;
                    dropTargetDropEvent.acceptDrop(n);
                    lWCommonText.freezeRepaints();
                    try {
                        lWCommonText.replaceRange(string, n2, n2);
                    }
                    finally {
                        lWCommonText.unfreezeRepaints();
                    }
                }
            }
            if (!bl) {
                dropTargetDropEvent.rejectDrop();
            }
            dropTargetDropEvent.dropComplete(bl);
            this._inDrop = false;
        }

        private int _getDropAction(int n) {
            LWCommonText lWCommonText = this._textComp;
            if (!lWCommonText.isEditable() || !lWCommonText.isEnabled()) {
                return 0;
            }
            return n;
        }
    }
}

