/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.lwAWT.lwMenu;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.Vector;
import oracle.ewt.event.tracking.MouseGrabProvider;
import oracle.ewt.event.tracking.TrackingUtils;
import oracle.ewt.lwAWT.LWComponent;
import oracle.ewt.lwAWT.lwMenu.DragRedispatcher;
import oracle.ewt.lwAWT.lwMenu.LWMenu;
import oracle.ewt.lwAWT.lwMenu.LWMenuInvoker;
import oracle.ewt.lwAWT.lwMenu.LWMenuItem;
import oracle.ewt.lwAWT.lwMenu.LWMenuItemContainer;
import oracle.ewt.lwAWT.lwMenu.MenuUtils;
import oracle.ewt.lwAWT.lwMenu.PreferredRowLayout;
import oracle.ewt.lwAWT.lwMenu.ScrollableAdapter;
import oracle.ewt.scrolling.arrowBox.ArrowBox;
import oracle.ewt.util.FocusUtils;
import oracle.ewt.util.ImmInsets;
import oracle.ewt.util.InputEventUtils;
import oracle.ewt.util.StringUtils;
import oracle.ewt.util.WindowUtils;

public abstract class BaseMIContainer
extends LWComponent
implements LWMenuItemContainer {
    private LWComponent _content = new LWComponent();
    private ArrowBox _arrowBox;
    private ScrollableAdapter _adapter;
    private LWMenuItem _selectedItem;
    private MouseListener _mouseGrab;
    private KeyGrab _keyGrab;
    private WindowListener _windowTracker;
    private MouseGrabProvider _mouseGrabProvider;
    private Window _window;
    private boolean _processingKey;
    private static final int _DEFAULT_UNIT_INCREMENT = 18;

    protected BaseMIContainer() {
        this._content.setLayout(this.createContentLayout());
        this._content.addContainerListener(new AddLsnr());
        this.setLayout(PreferredRowLayout.getInstance());
        super.addImpl(this._content, null, 0);
    }

    @Override
    public Container getContent() {
        return this._content;
    }

    public Enumeration getEnumeration() {
        return new Enum();
    }

    @Override
    public LWMenuInvoker getMenuInvoker() {
        return null;
    }

    @Override
    public LWMenuItem getSelectedItem() {
        return this._selectedItem;
    }

    @Override
    public void itemSelectionChange(LWMenuItem lWMenuItem, boolean bl) {
        if (!bl) {
            this._selectedItem = null;
        } else {
            if (lWMenuItem != this._selectedItem) {
                if (this._selectedItem != null) {
                    this._selectedItem.setSelected(false, false);
                    LWMenuItem lWMenuItem2 = this._selectedItem;
                    this._selectedItem = null;
                    lWMenuItem2.paintImmediate();
                }
                this._selectedItem = lWMenuItem;
            }
            if (lWMenuItem != null) {
                this._makeItemVisible(lWMenuItem);
            }
        }
    }

    @Override
    public void doLayout() {
        if (this._adapter != null) {
            this._adapter.setCanvasOrigin(0, 0);
            this._arrowBox.setVisibleAmount(0);
            this._arrowBox.setMaximum(0);
            this._arrowBox.setValue(0);
        } else {
            Dimension dimension = this._content.getPreferredSize();
            Dimension dimension2 = this.getSize();
            ImmInsets immInsets = this.getBorderInsets();
            if (dimension.width > dimension2.width - immInsets.left + immInsets.right && dimension2.width > 0 || dimension.height > dimension2.height - immInsets.top + immInsets.bottom && dimension2.height > 0) {
                super.remove(0);
                this.setLayout(new BorderLayout());
                int n = this.getOrientation();
                this._adapter = new ScrollableAdapter(this._content, n == 1, n == 0);
                this._arrowBox = new ArrowBox(this._adapter, this._getArrowBoxOrientation(n), 0);
                this._arrowBox.setUnitIncrement(18);
                super.addImpl(this._arrowBox, "Center", 0);
            }
        }
        super.doLayout();
    }

    @Override
    public Dimension preferredSize() {
        ImmInsets immInsets = this.getBorderInsets();
        Dimension dimension = new Dimension(this._content.getPreferredSize());
        dimension.width += immInsets.left + immInsets.right;
        dimension.height += immInsets.top + immInsets.bottom;
        return dimension;
    }

    @Override
    public void remove(Component component) {
        Container container = this.getContent();
        container.remove(component);
    }

    @Override
    public void remove(int n) {
        Container container = this.getContent();
        container.remove(n);
    }

    @Override
    public void removeAll() {
        Container container = this.getContent();
        container.removeAll();
    }

    @Override
    protected void addImpl(Component component, Object object, int n) {
        Container container = this.getContent();
        container.add(component, object, n);
    }

    protected void addMenuGrab() {
        this._addMouseGrab();
        this._addKeyGrab();
        this._addWindowListener();
    }

    protected abstract LayoutManager createContentLayout();

    protected abstract void dismissMenu();

    protected void processGrabbedKeyEvent(KeyEvent keyEvent) {
        this._processingKey = true;
        LWMenuItem lWMenuItem = this.getSelectedItem();
        if (lWMenuItem != null) {
            lWMenuItem.processMenuKeyEvent(keyEvent);
        }
        if (!keyEvent.isConsumed()) {
            this.processKeyEvent(keyEvent);
            if (!keyEvent.isConsumed()) {
                this.__handleMnemonic(keyEvent);
            }
        }
        this._processingKey = false;
    }

    protected void processGrabbedMouseEvent(MouseEvent mouseEvent) {
    }

    protected void removeMenuGrab() {
        this._removeMouseGrab();
        this._removeKeyGrab();
        this._removeWindowListener();
    }

    private int _getArrowBoxOrientation(int n) {
        if (n == 1) {
            return 0;
        }
        return 1;
    }

    private void _addKeyGrab() {
        Window window;
        Component component;
        if (this._keyGrab == null && (component = WindowUtils.getFocusOwner(window = WindowUtils.getWindow(this))) != null) {
            this._keyGrab = new KeyGrab(component);
        }
    }

    void __handleMnemonic(KeyEvent keyEvent) {
        char c = keyEvent.getKeyChar();
        if (keyEvent.getID() != 400 || c == StringUtils.CHAR_UNDEFINED) {
            return;
        }
        Container container = this.getContent();
        int n = container.getComponentCount();
        for (int i = 0; i < n; ++i) {
            Component component = container.getComponent(i);
            if (!(component instanceof LWMenuItem)) continue;
            ((LWMenuItem)component).handleMnemonic(keyEvent);
            if (keyEvent.isConsumed()) break;
        }
    }

    private void _addMouseGrab() {
        if (this._mouseGrabProvider == null) {
            this._mouseGrabProvider = TrackingUtils.getMouseGrabProvider(this);
            if (this._mouseGrabProvider != null) {
                this._mouseGrab = new MouseGrb();
                this._mouseGrabProvider.addMouseGrab(this._mouseGrab);
            }
        }
    }

    private void _addWindowListener() {
        this._window = WindowUtils.getWindow(this);
        if (this._window != null) {
            this._windowTracker = new WindowL();
            this._window.addWindowListener(this._windowTracker);
        }
    }

    private void _makeItemVisible(LWMenuItem lWMenuItem) {
        if (this._arrowBox == null) {
            return;
        }
        int n = this._arrowBox.getValue();
        Rectangle rectangle = lWMenuItem.getBounds();
        Dimension dimension = this._content.getSize();
        Dimension dimension2 = this._adapter.getViewPortSize();
        int n2 = n;
        if (this.getOrientation() == 1) {
            if (this.getActualReadingDirection() == 1) {
                if (rectangle.x < n) {
                    n2 = rectangle.x;
                } else if (rectangle.x + rectangle.width > n + dimension2.width) {
                    n2 = rectangle.x + rectangle.width - dimension2.width;
                }
            } else if (rectangle.x < dimension.width - dimension2.width - n) {
                n2 = dimension.width - (dimension2.width + rectangle.x);
            } else if (rectangle.x + rectangle.width > dimension.width - n) {
                n2 = dimension.width - (rectangle.x + rectangle.width);
            }
            if (n2 != n) {
                this._adapter.setCanvasOrigin(-n2, 0);
                this._arrowBox.setValue(n2);
            }
        } else {
            if (rectangle.y < n) {
                n2 = rectangle.y;
            } else if (rectangle.y + rectangle.height > n + dimension2.height) {
                n2 = rectangle.y + rectangle.height - dimension2.height;
            }
            if (n2 != n) {
                this._adapter.setCanvasOrigin(0, -n2);
                this._arrowBox.setValue(n2);
            }
        }
    }

    private void _removeKeyGrab() {
        if (this._keyGrab != null) {
            this._keyGrab.remove(this._processingKey);
            this._keyGrab = null;
        }
    }

    private void _removeMouseGrab() {
        if (this._mouseGrabProvider != null) {
            this._mouseGrabProvider.removeMouseGrab(this._mouseGrab);
            this._mouseGrab = null;
            this._mouseGrabProvider = null;
        }
    }

    private void _removeWindowListener() {
        if (this._window != null) {
            this._window.removeWindowListener(this._windowTracker);
            this._windowTracker = null;
            this._window = null;
        }
    }

    private class WindowL
    extends WindowAdapter {
        private WindowL() {
        }

        @Override
        public void windowIconified(WindowEvent windowEvent) {
            BaseMIContainer.this.dismissMenu();
        }

        @Override
        public void windowClosing(WindowEvent windowEvent) {
            BaseMIContainer.this.dismissMenu();
        }

        @Override
        public void windowDeactivated(WindowEvent windowEvent) {
            BaseMIContainer.this.dismissMenu();
        }
    }

    private class MouseGrb
    extends MouseAdapter {
        private MouseGrb() {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            if (!mouseEvent.isConsumed()) {
                BaseMIContainer.this.processGrabbedMouseEvent(mouseEvent);
            }
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            if (!mouseEvent.isConsumed()) {
                BaseMIContainer.this.processGrabbedMouseEvent(mouseEvent);
            }
        }
    }

    private class KeyGrab
    implements KeyListener,
    FocusListener {
        private Component _focusComp;
        private boolean _removeOnRelease;

        public KeyGrab(Component component) {
            this._focusComp = component;
            this._focusComp.addFocusListener(this);
            if (this._focusComp instanceof LWComponent) {
                ((LWComponent)this._focusComp).addPreKeyListener(this);
            } else {
                this._focusComp.addKeyListener(this);
            }
            if (this._focusComp instanceof LWComponent) {
                ((LWComponent)this._focusComp).freezeRepaints();
            }
        }

        public void remove(boolean bl) {
            if (bl) {
                this._removeOnRelease = true;
            } else {
                this._removeListeners();
            }
        }

        @Override
        public void keyTyped(KeyEvent keyEvent) {
            this._processGrabbedKeyEvent(keyEvent);
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            this._processGrabbedKeyEvent(keyEvent);
        }

        @Override
        public void keyReleased(KeyEvent keyEvent) {
            if (this._removeOnRelease) {
                this._removeListeners();
            }
            this._processGrabbedKeyEvent(keyEvent);
        }

        @Override
        public void focusLost(FocusEvent focusEvent) {
            this.remove(false);
            if (FocusUtils.areNewFocusAPIsAvailable()) {
                BaseMIContainer.this.dismissMenu();
            }
        }

        @Override
        public void focusGained(FocusEvent focusEvent) {
            this.remove(false);
        }

        private void _processGrabbedKeyEvent(KeyEvent keyEvent) {
            if (!this._removeOnRelease) {
                BaseMIContainer.this.processGrabbedKeyEvent(keyEvent);
            } else if (InputEventUtils.getMods(keyEvent) == 8 && keyEvent.getKeyCode() != 18) {
                return;
            }
            keyEvent.consume();
        }

        private void _removeListeners() {
            Component component = this._focusComp;
            if (component != null) {
                this._focusComp = null;
                if (component instanceof LWComponent) {
                    ((LWComponent)component).removePreKeyListener(this);
                } else {
                    component.removeKeyListener(this);
                }
                component.removeFocusListener(this);
                if (component instanceof LWComponent) {
                    ((LWComponent)component).unfreezeRepaints();
                }
            }
        }
    }

    private class Enum
    implements Enumeration {
        private Component _current;
        private Vector _invokerStack;

        public Enum() {
            Container container = BaseMIContainer.this.getContent();
            if (container.getComponentCount() > 0) {
                this._current = container.getComponent(0);
            }
        }

        @Override
        public boolean hasMoreElements() {
            return this._current != null;
        }

        public Object nextElement() {
            if (this._current == null) {
                throw new NoSuchElementException();
            }
            Component component = this._current;
            this._current = this._getNext(this._current);
            return component;
        }

        private Component _getNext(Component component) {
            Container container;
            LWMenuItemContainer lWMenuItemContainer;
            Component component2 = null;
            if (component instanceof LWMenu && (lWMenuItemContainer = ((LWMenu)component).getSubMenu()) != null && (container = ((BaseMIContainer)lWMenuItemContainer).getContent()).getComponentCount() > 0 && (component2 = container.getComponent(0)) != null) {
                this._pushInvoker(component);
            }
            if (component2 == null) {
                while (component != null) {
                    int n;
                    lWMenuItemContainer = MenuUtils.getMenuItemContainer(component);
                    container = lWMenuItemContainer.getContent();
                    int n2 = this._getIndex(component);
                    if (n2 < (n = container.getComponentCount()) - 1) {
                        component2 = container.getComponent(n2 + 1);
                        break;
                    }
                    if (lWMenuItemContainer == BaseMIContainer.this) break;
                    component = this._popInvoker();
                }
            }
            return component2;
        }

        private int _getIndex(Component component) {
            Container container = component.getParent();
            int n = 0;
            while (container.getComponent(n) != component) {
                ++n;
            }
            return n;
        }

        private Component _popInvoker() {
            int n;
            if (this._invokerStack != null && (n = this._invokerStack.size()) > 0) {
                Component component = (Component)this._invokerStack.elementAt(n - 1);
                this._invokerStack.removeElementAt(n - 1);
                return component;
            }
            return null;
        }

        private void _pushInvoker(Component component) {
            if (this._invokerStack == null) {
                this._invokerStack = new Vector(4);
            }
            this._invokerStack.addElement(component);
        }
    }

    private static class AddLsnr
    implements ContainerListener {
        private AddLsnr() {
        }

        @Override
        public void componentAdded(ContainerEvent containerEvent) {
            Component component = containerEvent.getChild();
            component.addMouseListener(DragRedispatcher.getInstance());
            component.addMouseMotionListener(DragRedispatcher.getInstance());
        }

        @Override
        public void componentRemoved(ContainerEvent containerEvent) {
            Component component = containerEvent.getChild();
            component.removeMouseListener(DragRedispatcher.getInstance());
            component.removeMouseMotionListener(DragRedispatcher.getInstance());
        }
    }
}

