/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.lwAWT;

import java.awt.Adjustable;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import oracle.ewt.lwAWT.LWComponent;
import oracle.ewt.lwAWT.LWScrollPaneClip;
import oracle.ewt.lwAWT.LWScrollPaneProxy;
import oracle.ewt.lwAWT.LWScrollPaneScrollbar;
import oracle.ewt.lwAWT.LWScrollbar;
import oracle.ewt.scrolling.MouseWheelScrolling;
import oracle.ewt.scrolling.MouseWheelUtils;
import oracle.ewt.util.ImmInsets;

public class LWScrollPane
extends LWComponent
implements AdjustmentListener,
MouseWheelScrolling {
    public static final int SCROLLBARS_AS_NEEDED = 0;
    public static final int SCROLLBARS_ALWAYS = 1;
    public static final int SCROLLBARS_NEVER = 2;
    private int _displayPolicy;
    private LWScrollbar _hAdjustable;
    private LWScrollbar _vAdjustable;
    private Adjustable _hProxy;
    private Adjustable _vProxy;
    private Container _clip;
    private Component _content;
    private boolean _wheelScrolling;
    private MouseWheelUtils _wheelUtils;

    public LWScrollPane() {
        this(0);
    }

    public LWScrollPane(int n) {
        if (n != 2 && n != 0 && n != 1) {
            throw new IllegalArgumentException("illegal scrollbar display policy");
        }
        this._displayPolicy = n;
        this._hAdjustable = new LWScrollPaneScrollbar(0);
        this._vAdjustable = new LWScrollPaneScrollbar(1);
        this._hProxy = new LWScrollPaneProxy(this._hAdjustable);
        this._vProxy = new LWScrollPaneProxy(this._vAdjustable);
        this._clip = this._createClipComponent();
        this._addComponents();
        this._hAdjustable.addAdjustmentListener(this);
        this._vAdjustable.addAdjustmentListener(this);
        this._hAdjustable.setVisible(false);
        this._vAdjustable.setVisible(false);
        this.setWheelScrollingEnabled(true);
    }

    public void addScrollComponent(Component component) {
        if (component != this._content) {
            this.removeScrollComponent();
            if (component != null) {
                this._content = component;
                this._clip.add(this._content);
            }
        }
    }

    @Override
    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        if (this._content != null) {
            this._content.setLocation(-this._hAdjustable.getValue(), -this._vAdjustable.getValue());
        }
    }

    public Component getScrollComponent() {
        return this._content;
    }

    public Adjustable getHAdjustable() {
        return this._hProxy;
    }

    public int getHScrollbarHeight() {
        int n = 0;
        if (this._displayPolicy != 2) {
            Dimension dimension = this._hAdjustable.getPreferredSize();
            n = dimension.height;
        }
        return n;
    }

    public int getScrollbarDisplayPolicy() {
        return this._displayPolicy;
    }

    public Point getScrollPosition() {
        if (this._content == null) {
            throw new NullPointerException("child is null");
        }
        return new Point(this._hAdjustable.getValue(), this._vAdjustable.getValue());
    }

    public Dimension getViewportSize() {
        ImmInsets immInsets = this.getBorderInsets();
        Dimension dimension = this.getSize();
        dimension.width -= immInsets.right + immInsets.left;
        dimension.height -= immInsets.top + immInsets.bottom;
        if (this._vAdjustable.isVisible()) {
            dimension.width -= this.getVScrollbarWidth();
        }
        if (this._hAdjustable.isVisible()) {
            dimension.height -= this.getHScrollbarHeight();
        }
        return dimension;
    }

    public Adjustable getVAdjustable() {
        return this._vProxy;
    }

    public int getVScrollbarWidth() {
        int n = 0;
        if (this._displayPolicy != 2) {
            Dimension dimension = this._vAdjustable.getPreferredSize();
            n = dimension.width;
        }
        return n;
    }

    public void removeScrollComponent() {
        if (this._content != null) {
            this._clip.remove(this._content);
            this._content = null;
        }
    }

    public final void setScrollPosition(Point point) {
        this.setScrollPosition(point.x, point.y);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setScrollPosition(int n, int n2) {
        Object object = this.getTreeLock();
        synchronized (object) {
            if (this._content == null) {
                throw new NullPointerException("child is null");
            }
            this._hAdjustable.setValue(n);
            this._vAdjustable.setValue(n2);
        }
    }

    public void setWheelScrollingEnabled(boolean bl) {
        if (bl != this._wheelScrolling) {
            this._wheelScrolling = bl;
            if (this._wheelUtils == null) {
                this._wheelUtils = new MouseWheelUtils();
            }
            if (bl) {
                this._wheelUtils.addMouseWheelListener(this);
            } else {
                this._wheelUtils.removeMouseWheelListener(this);
            }
        }
    }

    public boolean isWheelScrollingEnabled() {
        return MouseWheelUtils.isWheelScrollingEnabled() && this._wheelScrolling;
    }

    @Override
    public boolean handleWheelScrolling(int n, int n2, int n3) {
        if (!this.isEnabled() || !this.isWheelScrollingEnabled() || n2 == 0) {
            return false;
        }
        LWScrollbar lWScrollbar = null;
        if (this._vAdjustable.isVisible()) {
            lWScrollbar = this._vAdjustable;
        } else if (this._hAdjustable.isVisible()) {
            lWScrollbar = this._hAdjustable;
        }
        if (lWScrollbar == null) {
            return false;
        }
        int n4 = n == 1 ? lWScrollbar.getBlockIncrement() : n2 * lWScrollbar.getUnitIncrement();
        if (n3 < 0) {
            n4 = -n4;
        }
        lWScrollbar.setValue(lWScrollbar.getValue() + n4);
        return true;
    }

    @Override
    public Component getMouseWheelScrollingComponent() {
        return this;
    }

    @Override
    public void doLayout() {
        super.doLayout();
        if (!this._clip.isValid()) {
            this._clip.doLayout();
        }
        this._configureScrollbars();
        boolean bl = this._checkScrollbarVisibility(this._hAdjustable);
        boolean bl2 = this._checkScrollbarVisibility(this._vAdjustable);
        if (bl || bl2) {
            super.doLayout();
            this._configureScrollbars();
        }
    }

    @Override
    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this._hAdjustable.setEnabled(bl);
        this._vAdjustable.setEnabled(bl);
    }

    @Override
    public String paramString() {
        String string = null;
        ImmInsets immInsets = this.getBorderInsets();
        switch (this._displayPolicy) {
            case 0: {
                string = "as-needed";
                break;
            }
            case 1: {
                string = "always";
                break;
            }
            case 2: {
                string = "never";
                break;
            }
        }
        Point point = this._content == null ? new Point(0, 0) : this.getScrollPosition();
        return super.paramString() + ",ScrollPosition=(" + point.x + "," + point.y + "),Insets=(" + immInsets.top + "," + immInsets.left + "," + immInsets.bottom + "," + immInsets.right + "),ScrollbarDisplayPolicy=" + string;
    }

    @Override
    protected final void addImpl(Component component, Object object, int n) {
        throw new IllegalArgumentException("Use addScrollComponent() instead");
    }

    private void _addComponents() {
        super.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        super.addImpl(this._clip, gridBagConstraints, 0);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        super.addImpl(this._hAdjustable, gridBagConstraints, -1);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        super.addImpl(this._vAdjustable, gridBagConstraints, -1);
    }

    private boolean _checkScrollbarVisibility(LWScrollbar lWScrollbar) {
        boolean bl = false;
        if (this.getScrollComponent() != null && (this._displayPolicy == 1 || this._displayPolicy == 0 && lWScrollbar.getMaximum() - lWScrollbar.getVisibleAmount() > 0)) {
            if (!lWScrollbar.isVisible()) {
                lWScrollbar.setVisible(true);
                bl = true;
            }
        } else if (lWScrollbar.isVisible()) {
            lWScrollbar.setVisible(false);
            bl = true;
        }
        return bl;
    }

    private void _configureScrollbars() {
        if (this._content == null) {
            return;
        }
        Dimension dimension = this._content.getSize();
        Dimension dimension2 = this._clip.getSize();
        int n = this._hAdjustable.getValue();
        int n2 = this._vAdjustable.getValue();
        int n3 = dimension.width - dimension2.width;
        int n4 = dimension.height - dimension2.height;
        n = this._constrainValue(n, 0, n3);
        n2 = this._constrainValue(n2, 0, n4);
        this._hAdjustable.setMinimum(0);
        this._hAdjustable.setMaximum(dimension.width);
        this._hAdjustable.setVisibleAmount(dimension2.width);
        this._hAdjustable.setValue(n);
        this._vAdjustable.setMinimum(0);
        this._vAdjustable.setMaximum(dimension.height);
        this._vAdjustable.setVisibleAmount(dimension2.height);
        this._vAdjustable.setValue(n2);
    }

    private int _constrainValue(int n, int n2, int n3) {
        if (n < n2) {
            n = n2;
        } else if (n > n3) {
            n = n3;
        }
        return n;
    }

    private Container _createClipComponent() {
        return new LWScrollPaneClip();
    }
}

