/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.laf.oracle;

import java.awt.Font;
import oracle.ewt.UIDefaults;
import oracle.ewt.graphics.ImageStrip;
import oracle.ewt.laf.oracle.OracleButtonPainter;
import oracle.ewt.laf.oracle.OracleComponentUI;
import oracle.ewt.laf.oracle.OracleWindowCaptionTile;
import oracle.ewt.lwAWT.LWComponent;
import oracle.ewt.lwAWT.lwWindow.LWWindow;
import oracle.ewt.lwAWT.lwWindow.WindowType;
import oracle.ewt.lwAWT.lwWindow.laf.TitleBar;
import oracle.ewt.painter.AndOrStatePainterSwitcher;
import oracle.ewt.painter.BorderPainter;
import oracle.ewt.painter.FixedAlignmentPainter;
import oracle.ewt.painter.FixedBorderPainter;
import oracle.ewt.painter.ImageSetPainter;
import oracle.ewt.painter.NullPainter;
import oracle.ewt.painter.Painter;
import oracle.ewt.plaf.TitleBarUI;

public class OracleTitleBarUI
extends OracleComponentUI
implements TitleBarUI {
    private static Painter _sPaletteFill;
    private static final Painter _CAPTION_FILL;
    private static final BorderPainter _BORDER_PAINTER;

    public OracleTitleBarUI(LWComponent lWComponent) {
        super(lWComponent);
    }

    public static Object instantiate(UIDefaults uIDefaults, Object object, String string) {
        if ("Window.closePainter".equals(object)) {
            return OracleTitleBarUI._loadStrip(uIDefaults, "Window.closeStrip");
        }
        if ("Window.maximizePainter".equals(object)) {
            return OracleTitleBarUI._loadStrip(uIDefaults, "Window.maximizeStrip");
        }
        if ("Window.minimizePainter".equals(object)) {
            return OracleTitleBarUI._loadStrip(uIDefaults, "Window.minimizeStrip");
        }
        if ("Window.restorePainter".equals(object)) {
            return OracleTitleBarUI._loadStrip(uIDefaults, "Window.restoreStrip");
        }
        if ("Window.pClosePainter".equals(object)) {
            return OracleTitleBarUI._loadStrip(uIDefaults, "Window.pCloseStrip");
        }
        if ("Window.pMaximizePainter".equals(object)) {
            return OracleTitleBarUI._loadStrip(uIDefaults, "Window.pMaximizeStrip");
        }
        if ("Window.pMinimizePainter".equals(object)) {
            return OracleTitleBarUI._loadStrip(uIDefaults, "Window.pMinimizeStrip");
        }
        if ("Window.pRestorePainter".equals(object)) {
            return OracleTitleBarUI._loadStrip(uIDefaults, "Window.pRestoreStrip");
        }
        return null;
    }

    @Override
    public BorderPainter getDefaultBorderPainter(LWComponent lWComponent) {
        return _BORDER_PAINTER;
    }

    @Override
    public BorderPainter getButtonBorderPainter(LWComponent lWComponent) {
        return NullPainter.getPainter();
    }

    @Override
    public int getCloseButtonSpacing(LWComponent lWComponent) {
        return 0;
    }

    @Override
    public Painter getCloseIcon(LWComponent lWComponent) {
        return this.getUIDefaults(lWComponent).getPainter(this._isPalette(lWComponent) ? "Window.pClosePainter" : "Window.closePainter");
    }

    @Override
    public Font getDefaultFont(LWComponent lWComponent) {
        if (this._isPalette(lWComponent)) {
            UIDefaults uIDefaults = this.getUIDefaults(lWComponent);
            return uIDefaults.getFont("TitleBar.paletteFont");
        }
        return super.getDefaultFont(lWComponent);
    }

    @Override
    public Painter getMaximizeIcon(LWComponent lWComponent) {
        return this.getUIDefaults(lWComponent).getPainter(this._isPalette(lWComponent) ? "Window.pMaximizePainter" : "Window.maximizePainter");
    }

    @Override
    public Painter getMinimizeIcon(LWComponent lWComponent) {
        return this.getUIDefaults(lWComponent).getPainter(this._isPalette(lWComponent) ? "Window.pMinimizePainter" : "Window.minimizePainter");
    }

    @Override
    public Painter getRestoreIcon(LWComponent lWComponent) {
        return this.getUIDefaults(lWComponent).getPainter(this._isPalette(lWComponent) ? "Window.pRestorePainter" : "Window.restorePainter");
    }

    @Override
    public Painter getCaptionFill(LWComponent lWComponent) {
        LWWindow lWWindow = ((TitleBar)lWComponent).getLWWindow();
        if (lWWindow.getType() == WindowType.PALETTE) {
            if (_sPaletteFill == null) {
                _sPaletteFill = OracleTitleBarUI._createFill(OracleWindowCaptionTile.getPaletteInstance());
            }
            return _sPaletteFill;
        }
        return _CAPTION_FILL;
    }

    private boolean _isPalette(LWComponent lWComponent) {
        TitleBar titleBar = (TitleBar)lWComponent;
        LWWindow lWWindow = titleBar.getLWWindow();
        return lWWindow.getType() == WindowType.PALETTE;
    }

    private static Painter _createFill(Painter painter) {
        return new AndOrStatePainterSwitcher(new FixedBorderPainter(new FixedAlignmentPainter(painter, 0.0f, 0.5f), 0, 8, 0, 0), NullPainter.getPainter(), 4, 0, 0, 0);
    }

    private static Painter _loadStrip(UIDefaults uIDefaults, String string) {
        return new OracleButtonPainter(new ImageSetPainter(new ImageStrip(uIDefaults.getImage(string), 5)), true, true, false);
    }

    static {
        _CAPTION_FILL = OracleTitleBarUI._createFill(OracleWindowCaptionTile.getInstance());
        _BORDER_PAINTER = new FixedBorderPainter(null, 0, 0, 2, 0, true, true);
    }
}

