/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.laf.oracle;

import java.awt.Color;
import java.awt.Graphics;
import oracle.ewt.LookAndFeel;
import oracle.ewt.UIDefaults;
import oracle.ewt.laf.oracle.OracleColorScheme;
import oracle.ewt.painter.AbstractBorderPainter;
import oracle.ewt.painter.PaintContext;
import oracle.ewt.painter.Painter;
import oracle.ewt.util.ImmInsets;

public class OracleButtonPainter
extends AbstractBorderPainter {
    private static final int[] _sBGOffsets = new int[]{1, 2, 2, 3, 5, 8};
    private static final int _TOP = 3;
    private static final int _BOTTOM = 4;
    private static final int _LEFT = 3;
    private static final int _RIGHT = 3;
    private static final int _ARMED_SHIFT = 1;
    private static final int _EXTRA_CURVE_WIDTH = 5;
    private static final ImmInsets[] _INSETS_ARRAY = new ImmInsets[]{new ImmInsets(3, 3, 4, 3), new ImmInsets(4, 3, 3, 3), new ImmInsets(3, 3, 4, 8), new ImmInsets(4, 3, 3, 8), new ImmInsets(3, 8, 4, 3), new ImmInsets(4, 8, 3, 3), new ImmInsets(3, 8, 4, 8), new ImmInsets(4, 8, 3, 8)};
    private static final ImmInsets _THIN_INSETS = new ImmInsets(2, 2, 2, 2);
    private static final ImmInsets _THIN_ARMED_INSETS = new ImmInsets(3, 2, 1, 2);
    private boolean _hasLeftCurve;
    private boolean _hasRightCurve;
    private boolean _useThinBorder;
    private boolean _isToolBarButton;
    private boolean _hasMouseOverBorder;

    public OracleButtonPainter() {
    }

    public OracleButtonPainter(Painter painter) {
        super(painter);
    }

    public OracleButtonPainter(Painter painter, boolean bl, boolean bl2, boolean bl3) {
        super(painter);
        this._useThinBorder = bl;
        this._isToolBarButton = bl2;
        this._hasMouseOverBorder = bl3;
    }

    public OracleButtonPainter(Painter painter, boolean bl, boolean bl2) {
        super(painter);
        this._hasLeftCurve = bl;
        this._hasRightCurve = bl2;
    }

    @Override
    protected ImmInsets getOwnInsets(PaintContext paintContext) {
        boolean bl;
        boolean bl2 = bl = (paintContext.getPaintState() & 2) != 0;
        if (this._useThinBorder) {
            return bl ? _THIN_ARMED_INSETS : _THIN_INSETS;
        }
        int n = 0;
        if (this._hasLeftCurve) {
            n += 4;
        }
        if (this._hasRightCurve) {
            n += 2;
        }
        if (bl) {
            ++n;
        }
        return _INSETS_ARRAY[n];
    }

    @Override
    protected void paintBorder(PaintContext paintContext, Graphics graphics, int n, int n2, int n3, int n4) {
        Color color;
        Color color2;
        Color color3;
        Color color4;
        Color color5;
        Color color6;
        Color color7;
        Color color8;
        boolean bl;
        int n5 = paintContext.getPaintState();
        UIDefaults uIDefaults = paintContext.getPaintUIDefaults();
        Color color9 = graphics.getColor();
        int n6 = n2 + n4 - 1;
        int n7 = n + n3 - 1;
        Color color10 = uIDefaults.getColor(OracleColorScheme.CONTROL_SHADOW_DARK);
        boolean bl2 = (n5 & 1) != 0;
        boolean bl3 = (n5 & 4) != 0;
        boolean bl4 = (n5 & 2) != 0;
        boolean bl5 = bl = (n5 & 8) != 0;
        if ((n5 & 0x40) != 0 && !bl3) {
            graphics.setColor(bl3 ? color10 : uIDefaults.getColor("Button.defaultButtonBorder"));
            int n8 = bl4 ? n2 + 1 : n6 - 1;
            int n9 = n + 1;
            int n10 = n7 - 1;
            if (this._hasLeftCurve) {
                this._drawDefaultCurve(graphics, (n9 += 6) - 1, n2, n6, 1);
            } else {
                graphics.drawLine(n, n2 + 1, n, n6 - 1);
                graphics.drawLine(n + 1, n8, n + 1, n8);
            }
            if (this._hasRightCurve) {
                this._drawDefaultCurve(graphics, (n10 -= 6) + 1, n2, n6, -1);
            } else {
                graphics.drawLine(n7, n2 + 1, n7, n6 - 1);
                graphics.drawLine(n7 - 1, n8, n7 - 1, n8);
            }
            graphics.drawLine(n9, n2, n10, n2);
            graphics.drawLine(n9, n6, n10, n6);
        }
        ++n;
        ++n2;
        --n6;
        --n7;
        Color color11 = paintContext.getPaintBackground();
        if (bl3) {
            color8 = color10;
            color7 = color10;
            color6 = color10;
            color5 = color10;
            color4 = color10;
            color3 = color10;
            color2 = color10;
            color = color10;
        } else {
            Color color12;
            color8 = color12 = uIDefaults.getColor("Button.lightBorder");
            color = uIDefaults.getColor(LookAndFeel.NORMAL_INTENSITY);
            color7 = color12;
            color5 = color12;
            color6 = color12;
            color4 = color;
            color3 = uIDefaults.getColor(LookAndFeel.CONTROL_SHADOW);
            Color color13 = uIDefaults.getColor("Button.darkBorder");
            color2 = bl2 ? color : color13;
            if (bl4 || bl) {
                if (!bl2 && bl4 && this._isToolBarButton) {
                    color11 = color;
                }
                color8 = color;
                color5 = uIDefaults.getColor(OracleColorScheme.CONTROL_SHADOW_VERY_LIGHT);
                color6 = color;
                color4 = color12;
                color3 = color12;
                color7 = color13;
                color2 = color12;
            }
        }
        if (!this._isToolBarButton && !this._hasMouseOverBorder || bl4 || bl || this._hasMouseOverBorder && !bl2 && (n5 & 0x10) != 0) {
            if (this._hasLeftCurve) {
                OracleButtonPainter.drawSideCurve(graphics, color7, color6, color6, color4, color2, color11, n += 5, n2, n6, 1);
            } else {
                this._drawLeftSide(graphics, color8, color7, color5, color3, color, color11, n, n2, n6);
            }
            if (this._hasRightCurve) {
                OracleButtonPainter.drawSideCurve(graphics, color6, color4, color2, color2, color2, color11, n7 -= 5, n2, n6, -1);
            } else {
                this._drawRightSide(graphics, color2, color5, color3, color, color11, n7, n2, n6);
            }
            graphics.setColor(color7);
            graphics.drawLine(n + 2, n2, n7 - 2, n2);
            graphics.setColor(color2);
            graphics.drawLine(n + 2, n6, n7 - 2, n6);
        }
        graphics.setColor(color11);
        graphics.drawLine(n += 2, (n2 += 2) - 1, n7 -= 2, n2 - 1);
        graphics.drawLine(n, (n6 -= 2) + 1, n7, n6 + 1);
        int n11 = bl4 ? n2 : n6;
        graphics.drawLine(n, n11, n7, n11);
        if (bl4 && this._isToolBarButton) {
            graphics.fillRect(n, n2, n7 - n + 1, n6 - n2 + 1);
        }
        graphics.setColor(color9);
    }

    @Override
    public Painter getContentPainterAt(PaintContext paintContext, int n, int n2, int n3, int n4, Painter painter) {
        Painter painter2 = super.getContentPainterAt(paintContext, n, n2, n3, n4, painter);
        if (painter == this && painter2 != null || painter2 == null && n3 >= 0 && n4 >= 0 && n3 < n && n4 < n2) {
            painter2 = this;
        }
        return painter2;
    }

    @Override
    protected boolean isBorderTransparent(PaintContext paintContext) {
        return true;
    }

    @Override
    public int getRepaintFlags(PaintContext paintContext) {
        int n = super.getRepaintFlags(paintContext) | 1 | 4 | 2 | 0x40 | 0x400 | 0x80;
        if (this._hasMouseOverBorder) {
            n |= 0x10;
        }
        return n;
    }

    private void _drawDefaultCurve(Graphics graphics, int n, int n2, int n3, int n4) {
        int n5 = n - n4;
        int n6 = n5 - n4 * 3;
        int n7 = n6 - n4;
        int n8 = n7 - n4;
        graphics.drawLine(n, n2 + 1, n, n2 + 1);
        graphics.drawLine(n5, n2 + 1, n6, n2 + 4);
        graphics.drawLine(n6, n2 + 5, n7, n2 + 6);
        graphics.drawLine(n7, n2 + 7, n7, n2 + 8);
        graphics.drawLine(n8, n2 + 9, n8, n3 - 9);
        graphics.drawLine(n7, n3 - 7, n7, n3 - 8);
        graphics.drawLine(n6, n3 - 5, n7, n3 - 6);
        graphics.drawLine(n5, n3 - 1, n6, n3 - 4);
        graphics.drawLine(n, n3 - 1, n, n3 - 1);
    }

    public static void drawSideCurve(Graphics graphics, Color color, Color color2, Color color3, Color color4, Color color5, Color color6, int n, int n2, int n3, int n4) {
        int n5 = n + n4;
        int n6 = n - n4;
        int n7 = n6 - n4;
        int n8 = n7 - n4;
        int n9 = n8 - n4;
        int n10 = n9 - n4;
        graphics.setColor(color);
        graphics.drawLine(n5, n2, n5, n2);
        graphics.drawLine(n6, n2 + 1, n, n2 + 1);
        graphics.drawLine(n7, n2 + 2, n7, n2 + 2);
        graphics.drawLine(n8, n2 + 3, n8, n2 + 3);
        graphics.setColor(color2);
        graphics.drawLine(n8, n2 + 4, n8, n2 + 4);
        graphics.drawLine(n9, n2 + 5, n9, n2 + 7);
        graphics.setColor(color3);
        graphics.drawLine(n10, n2 + 8, n10, n3 - 8);
        graphics.drawLine(n9, n3 - 5, n9, n3 - 7);
        graphics.drawLine(n8, n3 - 4, n8, n3 - 4);
        graphics.setColor(color4);
        graphics.drawLine(n8, n3 - 3, n8, n3 - 3);
        graphics.drawLine(n7, n3 - 2, n7, n3 - 2);
        graphics.drawLine(n6, n3 - 1, n, n3 - 1);
        graphics.setColor(color5);
        graphics.drawLine(n5, n3, n5, n3);
        if (color6 != null) {
            graphics.setColor(color6);
            int[] nArray = _sBGOffsets;
            int n11 = _sBGOffsets.length;
            n4 = -n4;
            n -= n4;
            for (int i = 0; i < n11; ++i) {
                int n12 = nArray[i];
                graphics.drawLine(n, n2 + n12, n, n3 - n12);
                n += n4;
            }
        }
    }

    private void _drawLeftSide(Graphics graphics, Color color, Color color2, Color color3, Color color4, Color color5, Color color6, int n, int n2, int n3) {
        graphics.setColor(color);
        graphics.drawLine(n + 1, n2 + 1, n + 1, n2 + 1);
        graphics.setColor(color2);
        graphics.drawLine(n + 1, n2, n + 1, n2);
        graphics.drawLine(n, n2 + 1, n, n3 - 2);
        graphics.setColor(color3);
        graphics.drawLine(n, n3 - 1, n, n3 - 1);
        graphics.setColor(color5);
        graphics.drawLine(n + 1, n3 - 1, n + 1, n3 - 1);
        graphics.setColor(color4);
        graphics.drawLine(n + 1, n3, n + 1, n3);
        graphics.setColor(color6);
        graphics.drawLine(n + 1, n2 + 2, n + 1, n3 - 2);
    }

    private void _drawRightSide(Graphics graphics, Color color, Color color2, Color color3, Color color4, Color color5, int n, int n2, int n3) {
        graphics.setColor(color);
        graphics.drawLine(n, n2 + 2, n, n3 - 1);
        graphics.drawLine(n - 1, n3, n - 1, n3);
        graphics.setColor(color3);
        graphics.drawLine(n, n2 + 1, n, n2 + 1);
        graphics.drawLine(n - 1, n3 - 1, n - 1, n3 - 1);
        graphics.setColor(color4);
        graphics.drawLine(n - 1, n2 + 1, n - 1, n2 + 1);
        graphics.setColor(color2);
        graphics.drawLine(n - 1, n2, n - 1, n2);
        graphics.setColor(color5);
        graphics.drawLine(n - 1, n2 + 2, n - 1, n3 - 2);
    }
}

