/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.laf.oracle;

import java.awt.Color;
import java.awt.image.ImageFilter;
import oracle.ewt.LookAndFeel;
import oracle.ewt.UIDefaults;
import oracle.ewt.laf.basic.ColorizingFilter;
import oracle.ewt.laf.basic.StringInstantiator;
import oracle.ewt.laf.oracle.OracleColorScheme;
import oracle.ewt.laf.oracle.OracleLookAndFeel;

class OracleBrowserColorScheme
extends OracleColorScheme {
    public OracleBrowserColorScheme(int n) {
        this("BLAF", "Oracle Browser Color Scheme", n);
    }

    protected OracleBrowserColorScheme(String string, String string2, int n) {
        super(string, string2, null, n);
        this.__setIntRamp(this._createColorRamp());
    }

    @Override
    public void initializeCommonColors(UIDefaults uIDefaults) {
        Color color = new Color(this.getSandColor());
        Color color2 = new Color(-2959184);
        Color color3 = new Color(-6710938);
        Color color4 = new Color(-13408615);
        Color color5 = new Color(-10053172);
        Color color6 = Color.white;
        Color color7 = Color.black;
        uIDefaults.put(LookAndFeel.ACTIVE_CAPTION, color4);
        uIDefaults.put(LookAndFeel.ACTIVE_CAPTION_TEXT, color6);
        uIDefaults.put(LookAndFeel.INACTIVE_CAPTION_BORDER, color7);
        uIDefaults.put(LookAndFeel.INFO, Color.yellow);
        if (OracleLookAndFeel.__USE_HIGH_COLOR) {
            uIDefaults.put(LookAndFeel.PINSTRIPE3, new Color(14674679));
            uIDefaults.put(LookAndFeel.PINSTRIPE4, new Color(11849708));
        } else {
            uIDefaults.put(LookAndFeel.PINSTRIPE3, new Color(0x99CCFF));
            uIDefaults.put(LookAndFeel.PINSTRIPE4, new Color(0x6699FF));
        }
        uIDefaults.put(LookAndFeel.ACTIVE_CAPTION_BORDER, color3);
        uIDefaults.put(LookAndFeel.INACTIVE_CAPTION, color5);
        uIDefaults.put(LookAndFeel.INACTIVE_CAPTION_TEXT, color);
        uIDefaults.put(LookAndFeel.DIALOG, color);
        uIDefaults.put(LookAndFeel.WINDOW, color);
        uIDefaults.put(LookAndFeel.WINDOW_TEXT, color7);
        uIDefaults.put(LookAndFeel.MENU, color6);
        uIDefaults.put(LookAndFeel.MENU_TEXT, color7);
        uIDefaults.put(LookAndFeel.TEXT, color6);
        uIDefaults.put(LookAndFeel.TEXT_TEXT, color7);
        uIDefaults.put(LookAndFeel.TEXT_HIGHLIGHT, new Color(255));
        uIDefaults.put(LookAndFeel.TEXT_HIGHLIGHT_TEXT, color6);
        uIDefaults.put(LookAndFeel.TEXT_INACTIVE_TEXT, color3);
        uIDefaults.put(LookAndFeel.CONTROL, color);
        uIDefaults.put(LookAndFeel.CONTROL_TEXT, color7);
        uIDefaults.put(LookAndFeel.CONTROL_INACTIVE, color);
        uIDefaults.put(LookAndFeel.CONTROL_LT_HIGHLIGHT, color);
        uIDefaults.put(LookAndFeel.NORMAL_INTENSITY, color2);
        uIDefaults.put(LookAndFeel.CONTROL_SHADOW, color2);
        uIDefaults.put(LookAndFeel.CONTROL_DK_SHADOW, color3);
        uIDefaults.put(CONTROL_SHADOW_DARK, color2);
        Color color8 = new Color(-863993728);
        uIDefaults.put(LookAndFeel.DARK_INTENSITY, color8);
        uIDefaults.put(LookAndFeel.CONTROL_HIGHLIGHT, color2);
        uIDefaults.put(CONTROL_SHADOW_VERY_LIGHT, color);
        uIDefaults.put(CONTROL_LT_HIGHLIGHT_VERY_DARK, color7);
        uIDefaults.put(LookAndFeel.SCROLLBAR, color2);
        uIDefaults.put(LookAndFeel.INFO_TEXT, color7);
        uIDefaults.put(LookAndFeel.CONTROL_INACTIVE_TEXT, color3);
        uIDefaults.put(LookAndFeel.SECONDARY_TEXT_HIGHLIGHT, color2);
        uIDefaults.put(LookAndFeel.TEXT_INACTIVE_HIGHLIGHT, color8);
        uIDefaults.put(LookAndFeel.LIGHT_INTENSITY, color);
        uIDefaults.put(LookAndFeel.VERY_DARK_INTENSITY, color3);
        uIDefaults.put(LookAndFeel.LIGHT_LOOK, color2);
        uIDefaults.put(LookAndFeel.DARK_LOOK, color3);
        uIDefaults.put(LookAndFeel.VERY_DARK_LOOK, color3);
        uIDefaults.put(LookAndFeel.DESKTOP, color6);
        uIDefaults.put(LookAndFeel.ARROW, color2);
        uIDefaults.put(GROUP_BOX, color4);
        uIDefaults.put(GROUP_BOX_TEXT, color7);
        uIDefaults.put(GRID, color);
        uIDefaults.put(HEADER, color2);
        uIDefaults.put(HEADER_TEXT, color4);
        uIDefaults.put(THUMB_SHADOW, color3);
        uIDefaults.put(THUMB_HIGHLIGHT, color6);
    }

    @Override
    public ImageFilter createColorizingFilter() {
        return new Filter(this.getColorMappingTable());
    }

    @Override
    public void initializeLightColors(UIDefaults uIDefaults) {
        String string = "oracle.ewt.laf.oracle.OracleUIUtils#imageInst|";
        uIDefaults.put("checkboxStrip", new StringInstantiator(string + "browserCheckboxStrip.gif", false));
        uIDefaults.put("radioButtonStrip", new StringInstantiator(string + "browserRadioButtonStrip.gif", false));
    }

    @Override
    public void initializeDarkColors(UIDefaults uIDefaults) {
    }

    protected int getSandColor() {
        return -856164377;
    }

    @Override
    void __initCommonDefaults(UIDefaults uIDefaults, UIDefaults uIDefaults2) {
        Color color = new Color(-857480244);
        Color color2 = uIDefaults.getColor(LookAndFeel.ACTIVE_CAPTION);
        Color color3 = uIDefaults.getColor(LookAndFeel.INACTIVE_CAPTION);
        Color color4 = uIDefaults.getColor(LookAndFeel.DARK_INTENSITY);
        Color color5 = uIDefaults.getColor(LookAndFeel.CONTROL);
        Color color6 = Color.white;
        Color color7 = Color.black;
        uIDefaults2.put("Button.background", color);
        uIDefaults2.put("MenuBar.background", color6);
        uIDefaults2.put("StatusBar.background", color5);
        uIDefaults2.put("Button.lightBorder", color4);
        uIDefaults2.put("Button.darkBorder", color7);
        uIDefaults2.put("TabBar.selectedItemBackground", color2);
        uIDefaults2.put("TabBar.inactiveSelectedItemBackground", color3);
        uIDefaults2.put("TabBar.selectedItemForeground", color6);
        uIDefaults2.put("TabPanel.normal", color2);
        uIDefaults2.put("TabPanel.lightBorderColor", color2);
        uIDefaults2.put("TabPanel.darkBorderColor", color2);
    }

    private int[] _createColorRamp() {
        return new int[]{-1, this.getSandColor(), -1714235216, 1725094064, 0x33999966, 0, 255, 0x33CCFF, 39423};
    }

    private class Filter
    extends ColorizingFilter {
        public Filter(int[] nArray) {
            super(nArray);
        }

        @Override
        public int filterRGB(int n, int n2, int n3) {
            int n4 = n3 & 0xFF;
            if (n4 < 128) {
                return -10066330;
            }
            return super.filterRGB(n, n2, n3);
        }
    }
}

