/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.grid.hGrid;

import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import oracle.ewt.dataSource.TwoDDataSource;
import oracle.ewt.grid.CellInputHandler;
import oracle.ewt.grid.Grid;
import oracle.ewt.grid.hGrid.HArrayTwoDDataSource;
import oracle.ewt.grid.hGrid.HDataObject;
import oracle.ewt.util.InputEventUtils;

public class HGridBooleanInputHandler
extends CellInputHandler {
    private static HGridBooleanInputHandler _sInputHandler;
    private static final int SPACE = 32;

    @Override
    public void mousePressed(MouseEvent mouseEvent, Grid grid, int n, int n2) {
        if (InputEventUtils.isLeftMouseButton(mouseEvent)) {
            this.toggleValue(grid, n, n2);
        }
        super.mousePressed(mouseEvent, grid, n, n2);
    }

    @Override
    public void keyTyped(KeyEvent keyEvent, Grid grid, int n, int n2) {
        if (keyEvent.getKeyChar() == ' ') {
            this.toggleValue(grid, n, n2);
        }
    }

    private void toggleValue(Grid grid, int n, int n2) {
        if (grid == null) {
            return;
        }
        if (grid.fireCancelableCellEvent(n, n2, 2019)) {
            return;
        }
        TwoDDataSource twoDDataSource = grid.getDataSource();
        if (!(twoDDataSource instanceof HArrayTwoDDataSource)) {
            return;
        }
        HArrayTwoDDataSource hArrayTwoDDataSource = (HArrayTwoDDataSource)twoDDataSource;
        if (hArrayTwoDDataSource == null) {
            return;
        }
        HDataObject hDataObject = (HDataObject)hArrayTwoDDataSource.getExpandedData(n, n2);
        if (hDataObject == null) {
            return;
        }
        if (Boolean.TRUE.equals(hDataObject.getData())) {
            hArrayTwoDDataSource.setExpandedData(n, n2, Boolean.FALSE);
        } else {
            hArrayTwoDDataSource.setExpandedData(n, n2, Boolean.TRUE);
        }
        grid.fireCellEvent(n, n2, 2020);
    }

    public static CellInputHandler getCellInputHandler() {
        if (_sInputHandler == null) {
            _sInputHandler = new HGridBooleanInputHandler();
        }
        return _sInputHandler;
    }

    protected HGridBooleanInputHandler() {
    }
}

