/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.grid.bigCell;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.PrintGraphics;
import java.awt.Rectangle;
import java.awt.Shape;
import oracle.ewt.UIManager;
import oracle.ewt.graphics.Appearance;
import oracle.ewt.graphics.GraphicsProxy;
import oracle.ewt.grid.Cell;
import oracle.ewt.grid.Grid;
import oracle.ewt.grid.bigCell.AbstractBigCell;
import oracle.ewt.painter.AbstractPainter;
import oracle.ewt.painter.BorderPainter;
import oracle.ewt.painter.PaintContext;
import oracle.ewt.painter.PaintContextProxy;
import oracle.ewt.painter.Painter;
import oracle.ewt.util.ImmInsets;

public class BigCellPainter
extends AbstractPainter {
    public static final String BIG_CELL_KEY = "BigCell";
    private boolean _horizontalSeparatorsVisible;
    private boolean _verticalSeparatorsVisible;
    private Painter _painter;
    private boolean _keepCellsVisible = false;
    private boolean _isBorderVisible = true;

    public BigCellPainter() {
        this(null);
    }

    public BigCellPainter(Painter painter, Grid grid) {
        this(painter);
    }

    public BigCellPainter(Painter painter) {
        this._painter = painter;
        this._horizontalSeparatorsVisible = true;
        this._verticalSeparatorsVisible = true;
    }

    public void setGrid(Grid grid) {
    }

    public Grid getGrid() {
        return null;
    }

    public void setPainter(Painter painter) {
        if (this._painter != painter) {
            this._painter = painter;
        }
    }

    public Painter getPainter() {
        if (this._painter == null) {
            this._painter = UIManager.getPainter("DefaultCellPainter");
        }
        return this._painter;
    }

    public boolean getHorizontalSeparatorsVisible() {
        return this._horizontalSeparatorsVisible;
    }

    public void setHorizontalSeparatorsVisible(boolean bl) {
        this._horizontalSeparatorsVisible = bl;
    }

    public boolean getVerticalSeparatorsVisible() {
        return this._verticalSeparatorsVisible;
    }

    public void setVerticalSeparatorsVisible(boolean bl) {
        this._verticalSeparatorsVisible = bl;
    }

    public boolean isCellBorderVisible() {
        return this._isBorderVisible;
    }

    public void setCellBorderVisible(boolean bl) {
        this._isBorderVisible = bl;
    }

    @Override
    public void paint(PaintContext paintContext, Graphics graphics, int n, int n2, int n3, int n4) {
        int n5;
        int n6;
        Grid grid = (Grid)paintContext.getPaintData("Grid");
        if (grid == null) {
            return;
        }
        Appearance appearance = (Appearance)paintContext.getPaintData("Appearance");
        ImmInsets immInsets = appearance.getInsets();
        n -= immInsets.left;
        n2 -= immInsets.top;
        n3 += immInsets.left + immInsets.right;
        n4 += immInsets.top + immInsets.bottom;
        boolean bl = paintContext.getReadingDirection() == 1;
        Shape shape = graphics.getClip();
        int n7 = n;
        int n8 = n2;
        int n9 = n3;
        int n10 = n4;
        AbstractBigCell abstractBigCell = null;
        Object object = paintContext.getPaintData(null);
        BorderPainter borderPainter = null;
        boolean bl2 = graphics instanceof PrintGraphics;
        if (object instanceof AbstractBigCell) {
            Rectangle rectangle;
            int n11;
            abstractBigCell = (AbstractBigCell)object;
            int n12 = abstractBigCell.getColumn();
            int n13 = abstractBigCell.getRow();
            n7 = grid.getColumnPosition(n12);
            n8 = grid.getRowPosition(n13);
            n6 = abstractBigCell.getColumnCount();
            n5 = abstractBigCell.getRowCount();
            if (!bl) {
                n7 = grid.getColumnPosition(n12 + n6 - 1);
            }
            PaintContext paintContext2 = paintContext;
            paintContext = !bl2 ? grid.getCellPaintContext(n12, n13) : grid.getCellPrintPaintContext(graphics, n12, n13);
            paintContext = new Proxy(grid, paintContext, abstractBigCell, abstractBigCell.getData());
            n9 = 0;
            for (n11 = 0; n11 < n6; ++n11) {
                n9 += grid.getColumnWidth(n11 + n12);
            }
            n10 = 0;
            for (n11 = 0; n11 < n5; ++n11) {
                n10 += grid.getRowHeight(n11 + n13);
            }
            if (!bl2) {
                Point point = grid.convertCanvasToOuter(n7, n8);
                rectangle = new Rectangle(point.x, point.y, n9, n10);
                grid.clipToParents(rectangle);
                point = grid.convertOuterToCanvas(rectangle.x, rectangle.y);
                rectangle.x = point.x;
                rectangle.y = point.y;
                graphics.setClip(rectangle);
            } else {
                Object object2;
                rectangle = new Rectangle(n7, n8, n9, n10);
                if (graphics instanceof GraphicsProxy && (object2 = ((GraphicsProxy)graphics).get("grid.clipRect")) instanceof Rectangle) {
                    rectangle = rectangle.intersection((Rectangle)object2);
                    graphics.setClip(rectangle);
                }
            }
            if (this.isKeepCellsVisible()) {
                n7 = rectangle.x;
                n8 = rectangle.y;
                n9 = rectangle.width;
                n10 = rectangle.height;
            }
            appearance = grid.getAppearanceManager().getCellPaintingAppearance(n12, n13);
            if (this.isCellBorderVisible()) {
                borderPainter = appearance.getBorderPainter();
            }
            immInsets = appearance.getInsets();
        } else {
            Cell cell = (Cell)paintContext.getPaintData("Cell");
            appearance = grid.getAppearanceManager().getCellPaintingAppearance(cell.column, cell.row);
            borderPainter = appearance.getBorderPainter();
            immInsets = appearance.getInsets();
        }
        graphics.setColor(paintContext.getPaintBackground());
        graphics.fillRect(n7, n8, n9, n10);
        graphics.setColor(paintContext.getPaintForeground());
        graphics.setFont(paintContext.getPaintFont());
        Painter painter = this.getPainter();
        if (borderPainter != null) {
            borderPainter.paint(paintContext, graphics, n7, n8, n9 - 1, n10 - 1);
            ImmInsets immInsets2 = borderPainter.getInsets(paintContext);
            if (painter != null) {
                painter.paint(paintContext, graphics, n7 + immInsets2.left + immInsets.left, n8 + immInsets2.top + immInsets.top, n9 - (immInsets2.left + immInsets2.right) - (immInsets.left + immInsets.right), n10 - (immInsets2.top + immInsets2.bottom) - (immInsets.top + immInsets.bottom));
            }
        } else if (painter != null) {
            painter.paint(paintContext, graphics, n7 + immInsets.left, n8 + immInsets.top, n9 - (immInsets.left + immInsets.right), n10 - (immInsets.top + immInsets.bottom));
        }
        if (this.getHorizontalSeparatorsVisible()) {
            Painter painter2 = grid.getHorizontalSeparatorPainter();
            n5 = painter2.getPreferredSize((PaintContext)paintContext).height;
            n6 = n8 + n10 - n5;
            painter2.paint(paintContext, graphics, n7, n6, n7 + n9, n6);
        }
        if (this.getVerticalSeparatorsVisible()) {
            Painter painter3 = grid.getVerticalSeparatorPainter();
            n5 = painter3.getPreferredSize((PaintContext)paintContext).width;
            n6 = n7 + n9 - n5;
            painter3.paint(paintContext, graphics, n6, n8, n6, n8 + n10);
        }
        graphics.setClip(shape);
    }

    public void setVisiblePaintRect(boolean bl) {
        this.setKeepCellsVisible(bl);
    }

    public boolean isVisiblePaintRect() {
        return this.isKeepCellsVisible();
    }

    public void setKeepCellsVisible(boolean bl) {
        this._keepCellsVisible = bl;
    }

    public boolean isKeepCellsVisible() {
        return this._keepCellsVisible;
    }

    @Override
    public Dimension getMinimumSize(PaintContext paintContext) {
        if (this.getPainter() != null) {
            return this.getPainter().getMinimumSize(paintContext);
        }
        return new Dimension(0, 0);
    }

    @Override
    public int getRepaintFlags(PaintContext paintContext) {
        return 0;
    }

    private class Proxy
    extends PaintContextProxy {
        private Grid _grid;
        private PaintContext _toProxy;
        private Object _realData;
        private Object _bigCell;

        public Proxy(Grid grid, PaintContext paintContext, AbstractBigCell abstractBigCell, Object object) {
            this._grid = grid;
            this._toProxy = paintContext;
            this._bigCell = abstractBigCell;
            this._realData = object;
        }

        @Override
        public Object getPaintData(Object object) {
            Object object2;
            if (BigCellPainter.BIG_CELL_KEY.equals(object)) {
                return this._bigCell;
            }
            if ("Cell".equals(object)) {
                return super.getPaintData(object);
            }
            if ("Appearance".equals(object)) {
                return super.getPaintData(object);
            }
            if ("Grid".equals(object)) {
                return super.getPaintData(object);
            }
            if ("DataSource".equals(object)) {
                return super.getPaintData(object);
            }
            if (object != null && (object2 = super.getPaintData(object)) != this._bigCell) {
                return object2;
            }
            return this._realData;
        }

        @Override
        protected PaintContext getPaintContext() {
            return this._toProxy;
        }
    }
}

