/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.grid;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.ImageObserver;
import oracle.ewt.graphics.ImageSet;
import oracle.ewt.graphics.ImageUtils;
import oracle.ewt.graphics.SynthesizingImageSet;
import oracle.ewt.painter.AbstractPainter;
import oracle.ewt.painter.PaintContext;

public class TwoImagePainter
extends AbstractPainter {
    private Image _trueImage;
    private Image _falseImage;
    private ImageSet _trueImageSet;
    private ImageSet _falseImageSet;

    public TwoImagePainter(Image image, Image image2) {
        this.setTrueImage(image);
        this.setFalseImage(image2);
    }

    public Image getTrueImage() {
        return this._trueImage;
    }

    public void setTrueImage(Image image) {
        this._trueImage = image;
        this._trueImageSet = this._trueImage == null ? null : new SynthesizingImageSet(this._trueImage, 1);
    }

    public Image getFalseImage() {
        return this._falseImage;
    }

    public void setFalseImage(Image image) {
        this._falseImage = image;
        this._falseImageSet = this._falseImage == null ? null : new SynthesizingImageSet(this._falseImage, 1);
    }

    @Override
    public Dimension getSize(PaintContext paintContext, int n, int n2) {
        Dimension dimension = this.getMinimumSize(paintContext);
        if (dimension.width > n) {
            dimension.width = n;
        }
        if (dimension.height > n2) {
            dimension.height = n2;
        }
        return dimension;
    }

    @Override
    public Dimension getMinimumSize(PaintContext paintContext) {
        Dimension dimension = this._getSize(paintContext, this.getFalseImage());
        Dimension dimension2 = this._getSize(paintContext, this.getTrueImage());
        if (dimension.width > dimension2.width) {
            dimension2.width = dimension.width;
        }
        if (dimension.height > dimension2.height) {
            dimension2.height = dimension.height;
        }
        return dimension2;
    }

    @Override
    public void paint(PaintContext paintContext, Graphics graphics, int n, int n2, int n3, int n4) {
        ImageSet imageSet = this._getImageSet(paintContext);
        if (imageSet != null) {
            imageSet.paintImage(paintContext.getPaintState() & 0x9F, graphics, n, n2, paintContext.getImageObserver());
        }
    }

    @Override
    public int getRepaintFlags(PaintContext paintContext) {
        return 0;
    }

    private ImageSet _getImageSet(PaintContext paintContext) {
        Object object = paintContext.getPaintData(this.getDataKey());
        Boolean bl = (Boolean)object;
        if (Boolean.TRUE.equals(bl)) {
            return this._trueImageSet;
        }
        return this._falseImageSet;
    }

    private Dimension _getSize(PaintContext paintContext, Image image) {
        int n = 0;
        int n2 = 0;
        if (image != null && ImageUtils.loadImage(image)) {
            ImageObserver imageObserver = paintContext.getImageObserver();
            n = image.getWidth(imageObserver);
            n2 = image.getHeight(imageObserver);
        }
        return new Dimension(n, n2);
    }
}

