/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.grid;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeListener;
import java.util.Date;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleAction;
import javax.accessibility.AccessibleComponent;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleSelection;
import javax.accessibility.AccessibleState;
import javax.accessibility.AccessibleStateSet;
import javax.accessibility.AccessibleText;
import javax.accessibility.AccessibleValue;
import oracle.ewt.access.AccessibleLWComponent;
import oracle.ewt.graphics.Appearance;
import oracle.ewt.graphics.ImageSet;
import oracle.ewt.grid.AppearanceManager;
import oracle.ewt.grid.Cell;
import oracle.ewt.grid.Grid;
import oracle.ewt.grid.GridSelection;
import oracle.ewt.painter.FormatPainter;
import oracle.ewt.painter.Painter;
import oracle.ewt.popup.ToolTipClient;
import oracle.ewt.popup.ToolTipSite;
import oracle.ewt.util.LocaleUtils;

public class AccessibleGrid
extends AccessibleLWComponent
implements AccessibleSelection {
    private static final String _IMAGE = "GRID_IMAGE";
    private static final String _UNKNOWN = "UNKNOWN";
    private static final String _RESOURCE = "oracle.ewt.access.resource.AccessibilityBundle";
    private Grid _grid;

    public AccessibleGrid(Grid grid) {
        super(grid);
        this._grid = grid;
        this._grid.attachAccessibleGrid(this);
    }

    public Grid getGrid() {
        return this._grid;
    }

    public String getAccessibleName(int n, int n2) {
        Object object = this.getGrid().getDataSource().getData(n, n2);
        return this.getAccessibleName(n, n2, object);
    }

    @Override
    public String getAccessibleName() {
        AccessibleContext accessibleContext;
        Accessible accessible;
        String string = super.getAccessibleName();
        if (string == null && (accessible = this.getAccessibleParent()) != null && (accessibleContext = accessible.getAccessibleContext()) != null && accessibleContext.getAccessibleRole() == AccessibleRole.TABLE) {
            return accessibleContext.getAccessibleName();
        }
        return string;
    }

    public String getAccessibleDescription(int n, int n2) {
        Object object = this.getGrid().getToolTipValue();
        if (!(object instanceof ToolTipClient)) {
            return null;
        }
        ToolTipClient toolTipClient = (ToolTipClient)object;
        ToolTipSite toolTipSite = toolTipClient.getToolTipSite(this.getGrid(), this.getGrid().getColumnPosition(n) + 1, this.getGrid().getRowPosition(n2) + 1);
        if (toolTipSite != null && (object = toolTipSite.getValue()) instanceof String) {
            return (String)object;
        }
        return null;
    }

    public int getAccessibleRowAtIndex(int n) {
        return n / this.getGrid().getColumnCount();
    }

    public int getAccessibleColumnAtIndex(int n) {
        return n % this.getGrid().getColumnCount();
    }

    public int getAccessibleIndexAt(int n, int n2) {
        if (n < 0 || n2 < 0) {
            return -1;
        }
        return n2 * this.getGrid().getColumnCount() + n;
    }

    @Override
    public AccessibleRole getAccessibleRole() {
        return AccessibleRole.TABLE;
    }

    @Override
    public Accessible getAccessibleAt(Point point) {
        Point point2 = this.getGrid().convertOuterToCanvas(point.x, point.y);
        Cell cell = this.getGrid().__getCellAt(point2.x, point2.y);
        if (cell != null) {
            return this.getAccessibleChild(this.getAccessibleIndexAt(cell.column, cell.row));
        }
        return null;
    }

    @Override
    public int getAccessibleChildrenCount() {
        return this.getGrid().getColumnCount() * this.getGrid().getRowCount();
    }

    @Override
    public Accessible getAccessibleChild(int n) {
        if (n < 0 || n >= this.getAccessibleChildrenCount()) {
            return null;
        }
        return this.createAccessibleCell(n);
    }

    @Override
    public AccessibleSelection getAccessibleSelection() {
        return this;
    }

    @Override
    public int getAccessibleSelectionCount() {
        int[] nArray;
        int[] nArray2;
        GridSelection gridSelection = this.getGrid().getGridSelection();
        int n = 0;
        Cell[] cellArray = gridSelection.getSelectedCells();
        if (cellArray != null) {
            n += cellArray.length;
        }
        if ((nArray2 = gridSelection.getSelectedRows()) != null) {
            n += nArray2.length * this.getGrid().getColumnCount();
        }
        if ((nArray = gridSelection.getSelectedColumns()) != null) {
            n += nArray.length * this.getGrid().getRowCount();
        }
        return n;
    }

    @Override
    public Accessible getAccessibleSelection(int n) {
        int n2;
        int[] nArray;
        int[] nArray2;
        if (n < 0) {
            return null;
        }
        GridSelection gridSelection = this.getGrid().getGridSelection();
        Cell[] cellArray = gridSelection.getSelectedCells();
        if (cellArray != null) {
            if (n < cellArray.length) {
                Cell cell = cellArray[n];
                return this.getAccessibleChild(this.getAccessibleIndexAt(cell.column, cell.row));
            }
            n -= cellArray.length;
        }
        if ((nArray2 = gridSelection.getSelectedRows()) != null) {
            int n3 = this.getGrid().getColumnCount();
            if (n < nArray2.length * n3) {
                int n4 = n % n3;
                int n5 = nArray2[n / n3];
                return this.getAccessibleChild(this.getAccessibleIndexAt(n4, n5));
            }
            n -= nArray2.length * n3;
        }
        if ((nArray = gridSelection.getSelectedColumns()) != null && n < nArray.length * (n2 = this.getGrid().getRowCount())) {
            int n6 = n % n2;
            int n7 = nArray[n / n2];
            return this.getAccessibleChild(this.getAccessibleIndexAt(n7, n6));
        }
        return null;
    }

    @Override
    public boolean isAccessibleChildSelected(int n) {
        int n2 = this.getAccessibleColumnAtIndex(n);
        int n3 = this.getAccessibleRowAtIndex(n);
        GridSelection gridSelection = this.getGrid().getGridSelection();
        return gridSelection.isCellSelected(n2, n3) || gridSelection.isRowSelected(n3) || gridSelection.isColumnSelected(n2);
    }

    @Override
    public void addAccessibleSelection(int n) {
        int n2 = this.getAccessibleColumnAtIndex(n);
        int n3 = this.getAccessibleRowAtIndex(n);
        GridSelection gridSelection = this.getGrid().getGridSelection();
        gridSelection.addCellToSelection(n2, n3);
    }

    @Override
    public void removeAccessibleSelection(int n) {
        int n2 = this.getAccessibleColumnAtIndex(n);
        int n3 = this.getAccessibleRowAtIndex(n);
        GridSelection gridSelection = this.getGrid().getGridSelection();
        gridSelection.removeCellFromSelection(n2, n3);
    }

    @Override
    public void clearAccessibleSelection() {
        this.getGrid().getGridSelection().deselectAll();
    }

    @Override
    public void selectAllAccessibleSelection() {
        this.getGrid().getGridSelection().selectAll();
    }

    protected AccessibleCell createAccessibleCell(int n) {
        return new AccessibleCell(n);
    }

    protected String getAccessibleName(int n, int n2, Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof String) {
            return (String)object;
        }
        if (object instanceof Boolean) {
            return object.toString();
        }
        if (object instanceof Number || object instanceof Date) {
            Painter painter = this.getGrid().getColumnPainter(n);
            if (painter instanceof FormatPainter) {
                return ((FormatPainter)painter).getFormat().format(object);
            }
            return object.toString();
        }
        if (object instanceof Image || object instanceof ImageSet) {
            return this.getTranslatedString(_IMAGE);
        }
        return this.getTranslatedString(_UNKNOWN);
    }

    protected String getTranslatedString(String string) {
        ResourceBundle resourceBundle = ResourceBundle.getBundle(_RESOURCE, LocaleUtils.getTranslationLocale(this.getLocale()));
        return resourceBundle.getString(string);
    }

    public class AccessibleCell
    extends AccessibleContext
    implements Accessible,
    AccessibleComponent {
        private int _position;

        public AccessibleCell(int n) {
            this._position = n;
            this.setAccessibleParent(AccessibleGrid.this.getGrid());
        }

        @Override
        public AccessibleContext getAccessibleContext() {
            return this;
        }

        @Override
        public String getAccessibleName() {
            String string;
            AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
            if (accessibleContext != null && (string = accessibleContext.getAccessibleName()) != null && string != "") {
                return accessibleContext.getAccessibleName();
            }
            if (this.accessibleName != null && this.accessibleName != "") {
                return this.accessibleName;
            }
            int n = AccessibleGrid.this.getAccessibleRowAtIndex(this._position);
            int n2 = AccessibleGrid.this.getAccessibleColumnAtIndex(this._position);
            return AccessibleGrid.this.getAccessibleName(n2, n);
        }

        @Override
        public void setAccessibleName(String string) {
            AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
            if (accessibleContext != null) {
                accessibleContext.setAccessibleName(string);
            } else {
                super.setAccessibleName(string);
            }
        }

        @Override
        public String getAccessibleDescription() {
            AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
            if (accessibleContext != null) {
                return accessibleContext.getAccessibleDescription();
            }
            if (this.accessibleDescription != null && this.accessibleDescription != "") {
                return this.accessibleDescription;
            }
            int n = AccessibleGrid.this.getAccessibleRowAtIndex(this._position);
            int n2 = AccessibleGrid.this.getAccessibleColumnAtIndex(this._position);
            return AccessibleGrid.this.getAccessibleDescription(n2, n);
        }

        @Override
        public void setAccessibleDescription(String string) {
            AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
            if (accessibleContext != null) {
                accessibleContext.setAccessibleDescription(string);
            } else {
                super.setAccessibleDescription(string);
            }
        }

        @Override
        public AccessibleRole getAccessibleRole() {
            AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
            if (accessibleContext != null) {
                return accessibleContext.getAccessibleRole();
            }
            return AccessibleRole.LABEL;
        }

        @Override
        public AccessibleStateSet getAccessibleStateSet() {
            AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
            AccessibleStateSet accessibleStateSet = null;
            if (accessibleContext != null) {
                accessibleStateSet = accessibleContext.getAccessibleStateSet();
            }
            if (accessibleStateSet == null) {
                accessibleStateSet = new AccessibleStateSet();
            }
            int n = AccessibleGrid.this.getAccessibleRowAtIndex(this._position);
            int n2 = AccessibleGrid.this.getAccessibleColumnAtIndex(this._position);
            Rectangle rectangle = AccessibleGrid.this.getGrid().__getCellRect(n2, n);
            if (rectangle != null) {
                accessibleStateSet.add(AccessibleState.VISIBLE);
                if (this.isShowing()) {
                    accessibleStateSet.add(AccessibleState.SHOWING);
                } else {
                    accessibleStateSet.remove(AccessibleState.SHOWING);
                }
            } else {
                accessibleStateSet.remove(AccessibleState.VISIBLE);
                accessibleStateSet.remove(AccessibleState.SHOWING);
            }
            accessibleStateSet.add(AccessibleState.SELECTABLE);
            accessibleStateSet.add(AccessibleState.EDITABLE);
            if (AccessibleGrid.this.getGrid().isEnabled()) {
                accessibleStateSet.add(AccessibleState.ENABLED);
            }
            GridSelection gridSelection = AccessibleGrid.this.getGrid().getGridSelection();
            accessibleStateSet.add(AccessibleState.SELECTABLE);
            if (gridSelection.isCellSelected(n2, n) || gridSelection.isColumnSelected(n2) || gridSelection.isRowSelected(n)) {
                accessibleStateSet.add(AccessibleState.SELECTED);
            } else if (accessibleStateSet.contains(AccessibleState.SELECTED)) {
                accessibleStateSet.remove(AccessibleState.SELECTED);
            }
            accessibleStateSet.add(AccessibleState.FOCUSABLE);
            Cell cell = AccessibleGrid.this.getGrid().getFocusCell();
            if (cell != null && n == cell.row && n2 == cell.column) {
                accessibleStateSet.add(AccessibleState.ACTIVE);
                accessibleStateSet.add(AccessibleState.FOCUSED);
            }
            accessibleStateSet.add(AccessibleState.TRANSIENT);
            return accessibleStateSet;
        }

        @Override
        public Accessible getAccessibleParent() {
            return AccessibleGrid.this.getGrid();
        }

        @Override
        public int getAccessibleIndexInParent() {
            return this._position;
        }

        @Override
        public int getAccessibleChildrenCount() {
            AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
            if (accessibleContext != null) {
                return accessibleContext.getAccessibleChildrenCount();
            }
            return 0;
        }

        @Override
        public Accessible getAccessibleChild(int n) {
            AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
            if (accessibleContext != null) {
                Accessible accessible = accessibleContext.getAccessibleChild(n);
                accessibleContext.setAccessibleParent(this);
                return accessible;
            }
            return null;
        }

        @Override
        public Locale getLocale() {
            AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
            if (accessibleContext != null) {
                return accessibleContext.getLocale();
            }
            return AccessibleGrid.this.getGrid().getLocale();
        }

        @Override
        public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
            if (accessibleContext != null) {
                accessibleContext.addPropertyChangeListener(propertyChangeListener);
            } else {
                super.addPropertyChangeListener(propertyChangeListener);
            }
        }

        @Override
        public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
            if (accessibleContext != null) {
                accessibleContext.removePropertyChangeListener(propertyChangeListener);
            } else {
                super.removePropertyChangeListener(propertyChangeListener);
            }
        }

        @Override
        public AccessibleAction getAccessibleAction() {
            AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
            if (accessibleContext != null) {
                return accessibleContext.getAccessibleAction();
            }
            return null;
        }

        @Override
        public AccessibleComponent getAccessibleComponent() {
            return this;
        }

        @Override
        public AccessibleSelection getAccessibleSelection() {
            AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
            if (accessibleContext != null) {
                return accessibleContext.getAccessibleSelection();
            }
            return null;
        }

        @Override
        public AccessibleText getAccessibleText() {
            AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
            if (accessibleContext != null) {
                return accessibleContext.getAccessibleText();
            }
            return null;
        }

        @Override
        public AccessibleValue getAccessibleValue() {
            AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
            if (accessibleContext != null) {
                return accessibleContext.getAccessibleValue();
            }
            return null;
        }

        @Override
        public Color getBackground() {
            AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
            if (accessibleContext != null && accessibleContext instanceof AccessibleComponent) {
                return ((AccessibleComponent)((Object)accessibleContext)).getBackground();
            }
            Component component = this.getCurrentComponent();
            if (component != null) {
                return component.getBackground();
            }
            AppearanceManager appearanceManager = AccessibleGrid.this.getGrid().getAppearanceManager();
            if (appearanceManager != null) {
                Color color;
                int n = AccessibleGrid.this.getAccessibleRowAtIndex(this._position);
                int n2 = AccessibleGrid.this.getAccessibleColumnAtIndex(this._position);
                Appearance appearance = appearanceManager.getCellPaintingAppearance(n2, n);
                if (appearance != null && (color = appearance.getBackground()) != null) {
                    return color;
                }
            }
            return AccessibleGrid.this.getGrid().getBackground();
        }

        @Override
        public void setBackground(Color color) {
            AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
            if (accessibleContext != null && accessibleContext instanceof AccessibleComponent) {
                ((AccessibleComponent)((Object)accessibleContext)).setBackground(color);
            } else {
                Component component = this.getCurrentComponent();
                if (component != null) {
                    component.setBackground(color);
                }
            }
        }

        @Override
        public Color getForeground() {
            AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
            if (accessibleContext instanceof AccessibleComponent) {
                return ((AccessibleComponent)((Object)accessibleContext)).getForeground();
            }
            Component component = this.getCurrentComponent();
            if (component != null) {
                return component.getForeground();
            }
            AppearanceManager appearanceManager = AccessibleGrid.this.getGrid().getAppearanceManager();
            if (appearanceManager != null) {
                Color color;
                int n = AccessibleGrid.this.getAccessibleRowAtIndex(this._position);
                int n2 = AccessibleGrid.this.getAccessibleColumnAtIndex(this._position);
                Appearance appearance = appearanceManager.getCellPaintingAppearance(n2, n);
                if (appearance != null && (color = appearance.getForeground()) != null) {
                    return color;
                }
            }
            return AccessibleGrid.this.getGrid().getForeground();
        }

        @Override
        public void setForeground(Color color) {
            AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
            if (accessibleContext != null && accessibleContext instanceof AccessibleComponent) {
                ((AccessibleComponent)((Object)accessibleContext)).setForeground(color);
            } else {
                Component component = this.getCurrentComponent();
                if (component != null) {
                    component.setForeground(color);
                }
            }
        }

        @Override
        public Cursor getCursor() {
            AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
            if (accessibleContext != null && accessibleContext instanceof AccessibleComponent) {
                return ((AccessibleComponent)((Object)accessibleContext)).getCursor();
            }
            Component component = this.getCurrentComponent();
            if (component != null) {
                return component.getCursor();
            }
            Accessible accessible = this.getAccessibleParent();
            if (accessible instanceof AccessibleComponent) {
                return ((AccessibleComponent)((Object)accessible)).getCursor();
            }
            return AccessibleGrid.this.getGrid().getCursor();
        }

        @Override
        public void setCursor(Cursor cursor) {
            AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
            if (accessibleContext != null && accessibleContext instanceof AccessibleComponent) {
                ((AccessibleComponent)((Object)accessibleContext)).setCursor(cursor);
            } else {
                Component component = this.getCurrentComponent();
                if (component != null) {
                    component.setCursor(cursor);
                }
            }
        }

        @Override
        public Font getFont() {
            AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
            if (accessibleContext != null && accessibleContext instanceof AccessibleComponent) {
                return ((AccessibleComponent)((Object)accessibleContext)).getFont();
            }
            Component component = this.getCurrentComponent();
            if (component != null) {
                return component.getFont();
            }
            AppearanceManager appearanceManager = AccessibleGrid.this.getGrid().getAppearanceManager();
            if (appearanceManager != null) {
                Font font;
                int n = AccessibleGrid.this.getAccessibleRowAtIndex(this._position);
                int n2 = AccessibleGrid.this.getAccessibleColumnAtIndex(this._position);
                Appearance appearance = appearanceManager.getCellPaintingAppearance(n2, n);
                if (appearance != null && (font = appearance.getFont()) != null) {
                    return font;
                }
            }
            return AccessibleGrid.this.getGrid().getFont();
        }

        @Override
        public void setFont(Font font) {
            AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
            if (accessibleContext != null && accessibleContext instanceof AccessibleComponent) {
                ((AccessibleComponent)((Object)accessibleContext)).setFont(font);
            } else {
                Component component = this.getCurrentComponent();
                if (component != null) {
                    component.setFont(font);
                }
            }
        }

        @Override
        public FontMetrics getFontMetrics(Font font) {
            AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
            if (accessibleContext != null && accessibleContext instanceof AccessibleComponent) {
                return ((AccessibleComponent)((Object)accessibleContext)).getFontMetrics(font);
            }
            Component component = this.getCurrentComponent();
            if (component != null) {
                return component.getFontMetrics(font);
            }
            return AccessibleGrid.this.getGrid().getFontMetrics(font);
        }

        @Override
        public boolean isEnabled() {
            AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
            if (accessibleContext != null && accessibleContext instanceof AccessibleComponent) {
                return ((AccessibleComponent)((Object)accessibleContext)).isEnabled();
            }
            Component component = this.getCurrentComponent();
            if (component != null) {
                return component.isEnabled();
            }
            return AccessibleGrid.this.getGrid().isEnabled();
        }

        @Override
        public void setEnabled(boolean bl) {
            AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
            if (accessibleContext != null && accessibleContext instanceof AccessibleComponent) {
                ((AccessibleComponent)((Object)accessibleContext)).setEnabled(bl);
            } else {
                Component component = this.getCurrentComponent();
                if (component != null) {
                    component.setEnabled(bl);
                }
            }
        }

        @Override
        public boolean isVisible() {
            AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
            if (accessibleContext != null && accessibleContext instanceof AccessibleComponent) {
                return ((AccessibleComponent)((Object)accessibleContext)).isVisible();
            }
            Component component = this.getCurrentComponent();
            if (component != null) {
                return component.isVisible();
            }
            int n = AccessibleGrid.this.getAccessibleRowAtIndex(this._position);
            int n2 = AccessibleGrid.this.getAccessibleColumnAtIndex(this._position);
            Rectangle rectangle = AccessibleGrid.this.getGrid().__getCellRect(n2, n);
            return rectangle != null;
        }

        @Override
        public void setVisible(boolean bl) {
            AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
            if (accessibleContext != null && accessibleContext instanceof AccessibleComponent) {
                ((AccessibleComponent)((Object)accessibleContext)).setVisible(bl);
            } else {
                Component component = this.getCurrentComponent();
                if (component != null) {
                    component.setVisible(bl);
                }
            }
        }

        @Override
        public boolean isShowing() {
            AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
            if (accessibleContext != null && accessibleContext instanceof AccessibleComponent) {
                return ((AccessibleComponent)((Object)accessibleContext)).isShowing();
            }
            Component component = this.getCurrentComponent();
            if (component != null) {
                return component.isShowing();
            }
            return AccessibleGrid.this.getGrid().isShowing() && this.isVisible();
        }

        @Override
        public boolean contains(Point point) {
            AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
            if (accessibleContext != null && accessibleContext instanceof AccessibleComponent) {
                Rectangle rectangle = ((AccessibleComponent)((Object)accessibleContext)).getBounds();
                return rectangle.contains(point);
            }
            Component component = this.getCurrentComponent();
            if (component != null) {
                Rectangle rectangle = component.getBounds();
                return rectangle.contains(point);
            }
            Rectangle rectangle = this.getBounds();
            if (rectangle == null) {
                return false;
            }
            return rectangle.contains(point);
        }

        @Override
        public Point getLocationOnScreen() {
            if (!this.isShowing()) {
                return null;
            }
            Point point = AccessibleGrid.this.getGrid().getLocationOnScreen();
            Point point2 = this.getLocation();
            point2.translate(point.x, point.y);
            Point point3 = AccessibleGrid.this.getGrid().getCanvasOrigin();
            point2.translate(point3.x, point3.y);
            return point2;
        }

        @Override
        public Point getLocation() {
            if (AccessibleGrid.this.getGrid() != null) {
                int n = AccessibleGrid.this.getAccessibleRowAtIndex(this._position);
                int n2 = AccessibleGrid.this.getAccessibleColumnAtIndex(this._position);
                Rectangle rectangle = AccessibleGrid.this.getGrid().__getCellRect(n2, n);
                if (rectangle != null) {
                    return rectangle.getLocation();
                }
            }
            return null;
        }

        @Override
        public void setLocation(Point point) {
        }

        @Override
        public Rectangle getBounds() {
            if (!this.isShowing()) {
                return null;
            }
            int n = AccessibleGrid.this.getAccessibleRowAtIndex(this._position);
            int n2 = AccessibleGrid.this.getAccessibleColumnAtIndex(this._position);
            return AccessibleGrid.this.getGrid().__getCellRect(n2, n);
        }

        @Override
        public void setBounds(Rectangle rectangle) {
            AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
            if (accessibleContext != null && accessibleContext instanceof AccessibleComponent) {
                ((AccessibleComponent)((Object)accessibleContext)).setBounds(rectangle);
            } else {
                Component component = this.getCurrentComponent();
                if (component != null) {
                    component.setBounds(rectangle);
                }
            }
        }

        @Override
        public Dimension getSize() {
            Rectangle rectangle = this.getBounds();
            if (rectangle == null) {
                return null;
            }
            return new Dimension(rectangle.width, rectangle.height);
        }

        @Override
        public void setSize(Dimension dimension) {
            AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
            if (accessibleContext != null && accessibleContext instanceof AccessibleComponent) {
                ((AccessibleComponent)((Object)accessibleContext)).setSize(dimension);
            } else {
                Component component = this.getCurrentComponent();
                if (component != null) {
                    component.setSize(dimension);
                }
            }
        }

        @Override
        public Accessible getAccessibleAt(Point point) {
            AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
            if (accessibleContext != null && accessibleContext instanceof AccessibleComponent) {
                return ((AccessibleComponent)((Object)accessibleContext)).getAccessibleAt(point);
            }
            return null;
        }

        @Override
        public boolean isFocusTraversable() {
            AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
            if (accessibleContext != null && accessibleContext instanceof AccessibleComponent) {
                return ((AccessibleComponent)((Object)accessibleContext)).isFocusTraversable();
            }
            Component component = this.getCurrentComponent();
            if (component != null) {
                return component.isFocusTraversable();
            }
            return false;
        }

        @Override
        public void requestFocus() {
            AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
            if (accessibleContext != null && accessibleContext instanceof AccessibleComponent) {
                ((AccessibleComponent)((Object)accessibleContext)).requestFocus();
            } else {
                Component component = this.getCurrentComponent();
                if (component != null) {
                    component.requestFocus();
                }
            }
        }

        @Override
        public void addFocusListener(FocusListener focusListener) {
            AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
            if (accessibleContext != null && accessibleContext instanceof AccessibleComponent) {
                ((AccessibleComponent)((Object)accessibleContext)).addFocusListener(focusListener);
            } else {
                Component component = this.getCurrentComponent();
                if (component != null) {
                    component.addFocusListener(focusListener);
                }
            }
        }

        @Override
        public void removeFocusListener(FocusListener focusListener) {
            AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
            if (accessibleContext != null && accessibleContext instanceof AccessibleComponent) {
                ((AccessibleComponent)((Object)accessibleContext)).removeFocusListener(focusListener);
            } else {
                Component component = this.getCurrentComponent();
                if (component != null) {
                    component.removeFocusListener(focusListener);
                }
            }
        }

        protected int getPosition() {
            return this._position;
        }

        private AccessibleContext getCurrentAccessibleContext() {
            Component component = this.getCurrentComponent();
            if (component != null && component instanceof Accessible) {
                return ((Accessible)((Object)component)).getAccessibleContext();
            }
            return null;
        }

        private Component getCurrentComponent() {
            int n = AccessibleGrid.this.getAccessibleRowAtIndex(this._position);
            int n2 = AccessibleGrid.this.getAccessibleColumnAtIndex(this._position);
            Cell cell = AccessibleGrid.this.getGrid().getFocusCell();
            if (AccessibleGrid.this.getGrid().isEditing() && n == cell.row && n2 == cell.column) {
                return AccessibleGrid.this.getGrid().__getEditControl();
            }
            return null;
        }
    }
}

