/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.font;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import oracle.bali.share.sort.Sort;
import oracle.bali.share.util.IntegerUtils;
import oracle.ewt.UIManager;
import oracle.ewt.access.AccessibleLWComponent;
import oracle.ewt.access.AccessibleUtils;
import oracle.ewt.access.OracleAccessibleRole;
import oracle.ewt.button.ToggleButton;
import oracle.ewt.color.ColorChoice;
import oracle.ewt.comboBox.ComboBox;
import oracle.ewt.dataSource.ArrayOneDDataSource;
import oracle.ewt.font.FontDialog;
import oracle.ewt.font.FontPreviewArea;
import oracle.ewt.graphics.ImageUtils;
import oracle.ewt.lwAWT.LWCheckbox;
import oracle.ewt.lwAWT.LWCheckboxGroup;
import oracle.ewt.lwAWT.LWComponent;
import oracle.ewt.lwAWT.LWContainer;
import oracle.ewt.lwAWT.LWLabel;
import oracle.ewt.lwAWT.lwText.NumberTextField;
import oracle.ewt.painter.FixedBorderPainter;
import oracle.ewt.util.LocaleUtils;
import oracle.ewt.util.StringUtils;

public class FontPane
extends LWComponent {
    public static final String PROPERTY_FONT_NAME = "fontName";
    public static final String PROPERTY_FONT_SIZE = "fontSize";
    public static final String PROPERTY_FONT_STYLE = "fontStyle";
    public static final String PROPERTY_FONT_BASELINE_STYLE = "fontBaselineStyle";
    public static final String PROPERTY_FONT_WIDTH = "fontWidth";
    public static final String PROPERTY_FONT_HORIZONTAL_ALIGNMENT = "fontHorizontalAlignment";
    public static final String PROPERTY_FONT_VERTICAL_ALIGNMENT = "fontVerticalAlignment";
    public static final String PROPERTY_ACTUAL_FONT_SIZE_USED = "actualFontSizeUsed";
    public static final String PROPERTY_FONT_COLOR = "fontColor";
    public static final String PROPERTY_FONT_BACKGROUND_COLOR = "fontBackgroundColor";
    public static final String PROPERTY_BORDER_COLOR = "borderColor";
    public static final int STYLE_BOLD = 1;
    public static final int STYLE_ITALIC = 2;
    public static final int STYLE_UNDERLINE = 4;
    public static final int STYLE_STRIKETHROUGH = 8;
    public static final int BASELINE_STYLE_REGULAR = 1;
    public static final int BASELINE_STYLE_SUPERSCRIPT = 2;
    public static final int BASELINE_STYLE_SUBSCRIPT = 3;
    public static final int WIDTH_NORMAL = 2;
    public static final int WIDTH_CONDENSED = 0;
    public static final int WIDTH_SEMI_CONDENSED = 1;
    public static final int WIDTH_EXTENDED = 4;
    public static final int WIDTH_SEMI_EXTENDED = 3;
    public static final int HORIZONTAL_ALIGNMENT_FULL = 100;
    public static final int HORIZONTAL_ALIGNMENT_LEFT = 0;
    public static final int HORIZONTAL_ALIGNMENT_CENTER = 1;
    public static final int HORIZONTAL_ALIGNMENT_RIGHT = 2;
    public static final int HORIZONTAL_ALIGNMENT_START = 3;
    public static final int HORIZONTAL_ALIGNMENT_END = 4;
    public static final int VERTICAL_ALIGNMENT_TOP = 5;
    public static final int VERTICAL_ALIGNMENT_MIDDLE = 6;
    public static final int VERTICAL_ALIGNMENT_BOTTOM = 7;
    public static final int BUTTON_STYLE_BOLD = 1;
    public static final int BUTTON_STYLE_ITALIC = 2;
    public static final int BUTTON_STYLE_UNDERLINE = 4;
    public static final int BUTTON_STYLE_STRIKETHROUGH = 8;
    public static final int BUTTON_STYLE_SUPERSCRIPT = 16;
    public static final int BUTTON_STYLE_SUBSCRIPT = 32;
    public static final int BUTTON_ALIGNMENT_FULL = 1;
    public static final int BUTTON_ALIGNMENT_LEFT = 2;
    public static final int BUTTON_ALIGNMENT_CENTER = 4;
    public static final int BUTTON_ALIGNMENT_RIGHT = 8;
    public static final int BUTTON_ALIGNMENT_START = 16;
    public static final int BUTTON_ALIGNMENT_END = 32;
    public static final int BUTTON_ALIGNMENT_TOP = 64;
    public static final int BUTTON_ALIGNMENT_MIDDLE = 128;
    public static final int BUTTON_ALIGNMENT_BOTTOM = 256;
    public static final int COLOR_COMPONENT_FOREGROUND = 1;
    public static final int COLOR_COMPONENT_BACKGROUND = 2;
    public static final int COLOR_COMPONENT_BORDER = 4;
    public static final int BUTTON_OK = 1;
    public static final int BUTTON_CANCEL = 2;
    static final int _sACCESSIBLE_CHILD_COUNT = 22;
    private static final int _MIN_EXAMPLE_HEIGHT = 150;
    private static final String _RESOURCE = "oracle.ewt.font.resource.FontBundle";
    private static final String _LEFT_CONSTRAINT = "left";
    private static final String _KEY_FONT = "FONTPANE.FONT";
    private static final String _KEY_SIZE = "FONTPANE.SIZE";
    private static final String _KEY_STYLE = "FONTPANE.STYLE";
    private static final String _KEY_WIDTH = "FONTPANE.WIDTH";
    private static final String _KEY_COLOR = "FONTPANE.COLOR";
    private static final String _KEY_ALIGNMENT = "FONTPANE.ALIGNMENT";
    private static final String _KEY_SHOW_ACTUAL = "FONTPANE.SHOW_ACTUAL";
    private static final String _KEY_EXAMPLE = "FONTPANE.EXAMPLE";
    private static final String _KEY_JUSTIFY_FULL = "FONTPANE.JUSTIFY_FULL";
    private static final String _KEY_JUSTIFY_LEFT = "FONTPANE.JUSTIFY_LEFT";
    private static final String _KEY_JUSTIFY_CENTER = "FONTPANE.JUSTIFY_CENTER";
    private static final String _KEY_JUSTIFY_RIGHT = "FONTPANE.JUSTIFY_RIGHT";
    private static final String _KEY_JUSTIFY_TOP = "FONTPANE.JUSTIFY_TOP";
    private static final String _KEY_JUSTIFY_MIDDLE = "FONTPANE.JUSTIFY_MIDDLE";
    private static final String _KEY_JUSTIFY_BOTTOM = "FONTPANE.JUSTIFY_BOTTOM";
    private static final String _KEY_JUSTIFY_START = "FONTPANE.JUSTIFY_START";
    private static final String _KEY_JUSTIFY_END = "FONTPANE.JUSTIFY_END";
    private static final String _KEY_BOLD = "FONTPANE.BOLD";
    private static final String _KEY_ITALIC = "FONTPANE.ITALIC";
    private static final String _KEY_UNDERLINE = "FONTPANE.UNDERLINE";
    private static final String _KEY_STRIKETHRU = "FONTPANE.STRIKETHRU";
    private static final String _KEY_SUPERSCRIPT = "FONTPANE.SUPERSCRIPT";
    private static final String _KEY_SUBSCRIPT = "FONTPANE.SUBSCRIPT";
    private static final String _KEY_CONDENSED = "FONTPANE.CONDENSED";
    private static final String _KEY_SEMI_CONDENSED = "FONTPANE.SEMI_CONDENSED";
    private static final String _KEY_NORMAL = "FONTPANE.NORMAL";
    private static final String _KEY_SEMI_EXPANDED = "FONTPANE.SEMI_EXPANDED";
    private static final String _KEY_EXPANDED = "FONTPANE.EXPANDED";
    private static final String _KEY_TEXT_COLOR = "FONTPANE.TEXT_COLOR";
    private static final String _KEY_BACKGROUND_COLOR = "FONTPANE.BACKGROUND_COLOR";
    private static final String _KEY_BORDER_COLOR = "FONTPANE.BORDER_COLOR";
    private static final String _IMAGE_BOLD = "newbold";
    private static final String _IMAGE_ITALIC = "newitalic";
    private static final String _IMAGE_UNDERLINE = "underline";
    private static final String _IMAGE_STRIKETHROUGH = "strikethrough";
    private static final String _IMAGE_SUPERSCRIPT = "superscript";
    private static final String _IMAGE_SUBSCRIPT = "subscript";
    private static final String _IMAGE_FULL_JUSTIFY = "full";
    private static final String _IMAGE_LEFT_JUSTIFY = "left";
    private static final String _IMAGE_CENTER_JUSTIFY = "center";
    private static final String _IMAGE_RIGHT_JUSTIFY = "right";
    private static final String _IMAGE_TOP_JUSTIFY = "top";
    private static final String _IMAGE_MIDDLE_JUSTIFY = "middle";
    private static final String _IMAGE_BOTTOM_JUSTIFY = "bottom";
    private static final String _IMAGE_START_JUSTIFY = "start";
    private static final String _IMAGE_END_JUSTIFY = "end";
    private static final int _JDK_1_1_DEFAULT_STYLE_BUTTONS = 3;
    private static final int _JDK_1_2_DEFAULT_STYLE_BUTTONS = 63;
    private static final int _DEFAULT_ALIGNMENT_BUTTONS = 462;
    private static final int _DEFAULT_COLOR_BUTTONS = 3;
    private static final int[] _SIZES = new int[]{8, 9, 10, 11, 12, 14, 16, 18, 20, 22, 24, 26, 28, 36, 48, 72};
    private static final Insets _sBORDER_COLOR_INSETS = new Insets(0, 10, 6, 2);
    private static final Insets _sDEFAULT_INSETS = new Insets(0, 0, 6, 2);
    private static final Insets _sLABEL_INSETS = new Insets(0, 0, 6, 3);
    private static final Insets _sSEPARATOR_INSETS = new Insets(0, 6, 6, 3);
    private String _laggingFontName;
    private int _laggingFontSize;
    private int _laggingFontStyle;
    private int _laggingFontBaselineStyle;
    private int _laggingFontWidth;
    private int _laggingFontHorizontalAlignment;
    private int _laggingFontVerticalAlignment;
    private Color _laggingFontColor;
    private Color _laggingFontBackgroundColor;
    private Color _laggingBorderColor;
    private ComboBox _fontNames;
    private ComboBox _sizes;
    private ComboBox _widths;
    private ToggleButton _bold;
    private ToggleButton _italic;
    private ToggleButton _underline;
    private ToggleButton _strikeThrough;
    private ToggleButton _superscript;
    private ToggleButton _subscript;
    private ToggleButton _fullJustify;
    private ToggleButton _leftJustify;
    private ToggleButton _centerJustify;
    private ToggleButton _rightJustify;
    private ToggleButton _startJustify;
    private ToggleButton _endJustify;
    private ToggleButton _topJustify;
    private ToggleButton _middleJustify;
    private ToggleButton _bottomJustify;
    private LWLabel _styleLabel;
    private LWLabel _widthLabel;
    private LWLabel _fontLabel;
    private LWLabel _sizeLabel;
    private LWLabel _exampleLabel;
    private LWContainer _alignmentComponent;
    private LWContainer _colorComponent;
    private ColorChoice _textColor;
    private ColorChoice _backgroundColor;
    private ColorChoice _borderColor;
    private LWLabel _textColorLabel;
    private LWLabel _backgroundColorLabel;
    private LWLabel _borderColorLabel;
    private LWCheckbox _showFontSize;
    private LWComponent _exampleArea;
    private FontPreviewArea _exampleComponent;
    private LWComponent _clientContainer;
    private PropertyChangeSupport _propertyChangeSupport;

    public static int showDialog(Component component, FontPane fontPane) {
        return FontPane.showDialog(component, fontPane, null, false);
    }

    public static int showDialog(Component component, FontPane fontPane, String string, boolean bl) {
        if (fontPane == null) {
            throw new IllegalArgumentException("FontPane must be non-null");
        }
        FontDialog fontDialog = new FontDialog(fontPane, string, component);
        fontDialog.setResizable(bl);
        return fontDialog.runDialog() ? 1 : 2;
    }

    public FontPane() {
        UIListener uIListener = new UIListener();
        this._exampleComponent = this.createFontPreviewArea();
        this._fontNames = new ComboBox();
        this._fontNames.setEditable(false);
        this._fontNames.addItemListener(uIListener);
        this.setFontNames(Toolkit.getDefaultToolkit().getFontList());
        this._fontLabel = new LWLabel();
        this._fontLabel.setLabelFor(this._fontNames);
        this._sizes = new ComboBox();
        this._sizes.setEditable(true);
        this._sizes.addItemListener(uIListener);
        this._sizeLabel = new LWLabel();
        this._sizeLabel.setLabelFor(this._sizes);
        this._styleLabel = new LWLabel();
        this._bold = new ToggleButton();
        this._bold.setImage(FontPane._createImage(_IMAGE_BOLD));
        this._bold.addItemListener(uIListener);
        this._italic = new ToggleButton();
        this._italic.setImage(FontPane._createImage(_IMAGE_ITALIC));
        this._italic.addItemListener(uIListener);
        this._underline = new ToggleButton();
        this._underline.setImage(FontPane._createImage(_IMAGE_UNDERLINE));
        this._underline.addItemListener(uIListener);
        this._strikeThrough = new ToggleButton();
        this._strikeThrough.setImage(FontPane._createImage(_IMAGE_STRIKETHROUGH));
        this._strikeThrough.addItemListener(uIListener);
        this._superscript = new ToggleButton();
        this._superscript.setImage(FontPane._createImage(_IMAGE_SUPERSCRIPT));
        this._superscript.addItemListener(uIListener);
        this._subscript = new ToggleButton();
        this._subscript.setImage(FontPane._createImage(_IMAGE_SUBSCRIPT));
        this._subscript.addItemListener(uIListener);
        AccessibleUtils.setLabeledBy(this._bold, this._styleLabel);
        AccessibleUtils.setLabeledBy(this._italic, this._styleLabel);
        AccessibleUtils.setLabeledBy(this._underline, this._styleLabel);
        AccessibleUtils.setLabeledBy(this._superscript, this._styleLabel);
        AccessibleUtils.setLabeledBy(this._subscript, this._styleLabel);
        AccessibleUtils.setLabeledBy(this._strikeThrough, this._styleLabel);
        this._widths = new ComboBox();
        this._widths.setEditable(false);
        this._widths.addItemListener(uIListener);
        this._widthLabel = new LWLabel();
        this._widthLabel.setLabelFor(this._widths);
        this._colorComponent = new LWContainer(new BorderLayout());
        this._textColor = new ColorChoice();
        this._textColor.addPropertyChangeListener(uIListener);
        this._textColorLabel = new LWLabel();
        this._textColorLabel.setLabelFor(this._textColor);
        this._backgroundColor = new ColorChoice();
        this._backgroundColor.addPropertyChangeListener(uIListener);
        this._backgroundColorLabel = new LWLabel();
        this._backgroundColorLabel.setLabelFor(this._backgroundColor);
        this._borderColor = new ColorChoice();
        this._borderColor.addPropertyChangeListener(uIListener);
        this._borderColorLabel = new LWLabel();
        this._borderColorLabel.setLabelFor(this._borderColor);
        this._alignmentComponent = new LWContainer(new BorderLayout());
        this._fullJustify = new ToggleButton();
        this._fullJustify.setImage(FontPane._createImage(_IMAGE_FULL_JUSTIFY));
        this._fullJustify.addItemListener(uIListener);
        this._leftJustify = new ToggleButton();
        this._leftJustify.setImage(FontPane._createImage("left"));
        this._leftJustify.addItemListener(uIListener);
        this._centerJustify = new ToggleButton();
        this._centerJustify.setImage(FontPane._createImage(_IMAGE_CENTER_JUSTIFY));
        this._centerJustify.addItemListener(uIListener);
        this._rightJustify = new ToggleButton();
        this._rightJustify.setImage(FontPane._createImage(_IMAGE_RIGHT_JUSTIFY));
        this._rightJustify.addItemListener(uIListener);
        this._startJustify = new ToggleButton();
        this._startJustify.setImage(FontPane._createImage(_IMAGE_START_JUSTIFY));
        this._startJustify.addItemListener(uIListener);
        this._endJustify = new ToggleButton();
        this._endJustify.setImage(FontPane._createImage(_IMAGE_END_JUSTIFY));
        this._endJustify.addItemListener(uIListener);
        LWCheckboxGroup lWCheckboxGroup = new LWCheckboxGroup();
        this._fullJustify.setCheckboxGroup(lWCheckboxGroup);
        this._leftJustify.setCheckboxGroup(lWCheckboxGroup);
        this._centerJustify.setCheckboxGroup(lWCheckboxGroup);
        this._rightJustify.setCheckboxGroup(lWCheckboxGroup);
        this._startJustify.setCheckboxGroup(lWCheckboxGroup);
        this._endJustify.setCheckboxGroup(lWCheckboxGroup);
        this._centerJustify.setState(true);
        this._laggingFontHorizontalAlignment = 1;
        this._topJustify = new ToggleButton();
        this._topJustify.setImage(FontPane._createImage(_IMAGE_TOP_JUSTIFY));
        this._topJustify.addItemListener(uIListener);
        this._middleJustify = new ToggleButton();
        this._middleJustify.setImage(FontPane._createImage(_IMAGE_MIDDLE_JUSTIFY));
        this._middleJustify.addItemListener(uIListener);
        this._bottomJustify = new ToggleButton();
        this._bottomJustify.setImage(FontPane._createImage(_IMAGE_BOTTOM_JUSTIFY));
        this._bottomJustify.addItemListener(uIListener);
        LWCheckboxGroup lWCheckboxGroup2 = new LWCheckboxGroup();
        this._topJustify.setCheckboxGroup(lWCheckboxGroup2);
        this._middleJustify.setCheckboxGroup(lWCheckboxGroup2);
        this._bottomJustify.setCheckboxGroup(lWCheckboxGroup2);
        this._middleJustify.setState(true);
        this._laggingFontVerticalAlignment = 6;
        this._exampleLabel = new LWLabel();
        this._showFontSize = new LWCheckbox();
        this._showFontSize.setState(true);
        this._showFontSize.addItemListener(uIListener);
        LWComponent lWComponent = new LWComponent();
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        lWComponent.setLayout(gridBagLayout);
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.insets = _sLABEL_INSETS;
        gridBagConstraints.anchor = 17;
        gridBagLayout.setConstraints(this._fontLabel, gridBagConstraints);
        lWComponent.add(this._fontLabel);
        LWComponent lWComponent2 = new LWComponent();
        lWComponent2.setLayout(new BorderLayout(10, 0));
        lWComponent2.add("West", this._fontNames);
        LWComponent lWComponent3 = new LWComponent();
        lWComponent3.setLayout(new BorderLayout(3, 0));
        lWComponent3.add("West", this._sizeLabel);
        lWComponent3.add("East", this._sizes);
        lWComponent2.add("East", lWComponent3);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = _sDEFAULT_INSETS;
        gridBagLayout.setConstraints(lWComponent2, gridBagConstraints);
        lWComponent.add(lWComponent2);
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.insets = _sLABEL_INSETS;
        gridBagLayout.setConstraints(this._styleLabel, gridBagConstraints);
        lWComponent.add(this._styleLabel);
        Group group = new Group();
        GridBagLayout gridBagLayout2 = new GridBagLayout();
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.insets = _sDEFAULT_INSETS;
        gridBagConstraints2.anchor = 17;
        group.setLayout(gridBagLayout2);
        gridBagLayout2.setConstraints(this._bold, gridBagConstraints2);
        group.add(this._bold);
        gridBagLayout2.setConstraints(this._italic, gridBagConstraints2);
        group.add(this._italic);
        gridBagLayout2.setConstraints(this._underline, gridBagConstraints2);
        group.add(this._underline);
        gridBagLayout2.setConstraints(this._strikeThrough, gridBagConstraints2);
        group.add(this._strikeThrough);
        gridBagConstraints2.insets = _sSEPARATOR_INSETS;
        gridBagLayout2.setConstraints(this._superscript, gridBagConstraints2);
        group.add(this._superscript);
        gridBagConstraints2.insets = _sDEFAULT_INSETS;
        gridBagConstraints2.gridwidth = 0;
        gridBagLayout2.setConstraints(this._subscript, gridBagConstraints2);
        group.add(this._subscript);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = _sDEFAULT_INSETS;
        gridBagLayout.setConstraints(group, gridBagConstraints);
        lWComponent.add(group);
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.insets = _sLABEL_INSETS;
        gridBagLayout.setConstraints(this._widthLabel, gridBagConstraints);
        lWComponent.add(this._widthLabel);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = _sDEFAULT_INSETS;
        gridBagLayout.setConstraints(this._widths, gridBagConstraints);
        lWComponent.add(this._widths);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagLayout.setConstraints(this._colorComponent, gridBagConstraints);
        lWComponent.add(this._colorComponent);
        GridBagLayout gridBagLayout3 = new GridBagLayout();
        LWContainer lWContainer = new LWContainer(gridBagLayout3);
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.insets = _sLABEL_INSETS;
        gridBagConstraints3.anchor = 17;
        gridBagLayout3.setConstraints(this._textColorLabel, gridBagConstraints3);
        lWContainer.add(this._textColorLabel);
        gridBagConstraints3.insets = _sDEFAULT_INSETS;
        gridBagLayout3.setConstraints(this._textColor, gridBagConstraints3);
        lWContainer.add(this._textColor);
        LWContainer lWContainer2 = new LWContainer(new BorderLayout(3, 3));
        lWContainer2.add("West", this._borderColorLabel);
        lWContainer2.add("East", this._borderColor);
        gridBagConstraints3.insets = _sBORDER_COLOR_INSETS;
        gridBagConstraints3.gridwidth = 0;
        gridBagLayout3.setConstraints(lWContainer2, gridBagConstraints3);
        lWContainer.add(lWContainer2);
        gridBagConstraints3.insets = _sLABEL_INSETS;
        gridBagConstraints3.gridwidth = 1;
        gridBagLayout3.setConstraints(this._backgroundColorLabel, gridBagConstraints3);
        lWContainer.add(this._backgroundColorLabel);
        gridBagConstraints3.gridwidth = 0;
        gridBagConstraints3.insets = _sDEFAULT_INSETS;
        gridBagLayout3.setConstraints(this._backgroundColor, gridBagConstraints3);
        lWContainer.add(this._backgroundColor);
        this._colorComponent.add("West", lWContainer);
        this._clientContainer = new LWComponent();
        this._clientContainer.setLayout(new BorderLayout());
        GridBagLayout gridBagLayout4 = new GridBagLayout();
        LWContainer lWContainer3 = new LWContainer();
        lWContainer3.setLayout(gridBagLayout4);
        lWContainer3.setBorderPainter(new FixedBorderPainter(3, 0, 0, 0));
        GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
        gridBagConstraints4.insets = _sDEFAULT_INSETS;
        gridBagConstraints4.anchor = 17;
        gridBagLayout4.setConstraints(this._fullJustify, gridBagConstraints4);
        lWContainer3.add(this._fullJustify);
        gridBagLayout4.setConstraints(this._leftJustify, gridBagConstraints4);
        lWContainer3.add(this._leftJustify);
        gridBagLayout4.setConstraints(this._centerJustify, gridBagConstraints4);
        lWContainer3.add(this._centerJustify);
        gridBagLayout4.setConstraints(this._rightJustify, gridBagConstraints4);
        lWContainer3.add(this._rightJustify);
        gridBagConstraints4.insets = _sSEPARATOR_INSETS;
        gridBagLayout4.setConstraints(this._topJustify, gridBagConstraints4);
        lWContainer3.add(this._topJustify);
        gridBagConstraints4.insets = _sDEFAULT_INSETS;
        gridBagLayout4.setConstraints(this._middleJustify, gridBagConstraints4);
        lWContainer3.add(this._middleJustify);
        gridBagLayout4.setConstraints(this._bottomJustify, gridBagConstraints4);
        lWContainer3.add(this._bottomJustify);
        gridBagConstraints4.insets = _sSEPARATOR_INSETS;
        gridBagLayout4.setConstraints(this._startJustify, gridBagConstraints4);
        lWContainer3.add(this._startJustify);
        gridBagConstraints4.insets = _sDEFAULT_INSETS;
        gridBagConstraints4.gridwidth = 0;
        gridBagLayout4.setConstraints(this._endJustify, gridBagConstraints4);
        lWContainer3.add(this._endJustify);
        this._alignmentComponent.add("West", lWContainer3);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagLayout.setConstraints(this._alignmentComponent, gridBagConstraints);
        lWComponent.add(this._alignmentComponent);
        LWComponent lWComponent4 = new LWComponent();
        lWComponent4.setLayout(new BorderLayout(0, 3));
        LWComponent lWComponent5 = new LWComponent();
        lWComponent5.setLayout(new BorderLayout(0, 3));
        lWComponent5.add("West", lWComponent);
        lWComponent4.add("North", lWComponent5);
        lWComponent4.add("Center", this._clientContainer);
        this._exampleArea = new LWComponent();
        this._exampleArea.setLayout(new BorderLayout(0, 3));
        this._exampleArea.add("North", this._exampleLabel);
        this._exampleArea.add("Center", this._exampleComponent);
        this._exampleArea.add("South", this._showFontSize);
        this.setLayout(new FontPaneLayout());
        this.add("left", lWComponent4);
        this.add(this._exampleArea);
        this.setFontSizes(_SIZES);
        this.setCurrentFont(this.getFont());
        String string = System.getProperty("java.version");
        boolean bl = string == null ? false : string.startsWith("1.2");
        int n = bl ? 63 : 3;
        int n2 = 462;
        int n3 = 3;
        this.setStyleButtonMask(n);
        this.setAlignmentButtonMask(n2);
        this.setColorComponentMask(n3);
        this.setWidthVisible(bl);
        try {
            this.setFontName("Serif");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        this.setFontSize(12);
    }

    public String[] getFontNames() {
        int n = this._fontNames.getItemCount();
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = this._fontNames.getItem(i);
        }
        return stringArray;
    }

    public void setFontNames(String[] stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            stringArray = Toolkit.getDefaultToolkit().getFontList();
        }
        this._fontNames.setDataSource(new ArrayOneDDataSource(stringArray));
    }

    public String getFontName() {
        return this._fontNames.getSelectedItem();
    }

    public void setFontName(String string) {
        int n = this._fontNames.getItemCount();
        boolean bl = false;
        for (int i = 0; i < n; ++i) {
            if (!this._fontNames.getItem(i).equals(string)) continue;
            bl = true;
            break;
        }
        if (!bl) {
            throw new IllegalArgumentException("font name not found: " + string);
        }
        this._fontNames.select(string);
        this._laggingFontName = string;
    }

    public int getFontSize() {
        int n = 0;
        String string = this._sizes.getSelectedItem();
        try {
            Integer n2 = Integer.valueOf(string.toString());
            n = n2;
        }
        catch (NumberFormatException numberFormatException) {
            n = 12;
            this._sizes.select(IntegerUtils.getString((int)12));
            this._laggingFontSize = n;
        }
        return n;
    }

    public void setFontSize(int n) {
        this._sizes.select(IntegerUtils.getString((int)n));
        this._laggingFontSize = n;
        this.updateExampleFont();
    }

    public int[] getFontSizes() {
        String[] stringArray = this._sizes.getItems();
        int[] nArray = new int[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            try {
                Integer n = Integer.valueOf(stringArray[i]);
                nArray[i] = n;
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                nArray[i] = 0;
            }
        }
        return nArray;
    }

    public void setFontSizes(int[] nArray) {
        if (nArray == null || nArray.length == 0) {
            nArray = _SIZES;
        }
        Sort.qSort((int[])nArray, (int)nArray.length, (boolean)true);
        String[] stringArray = new String[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            stringArray[i] = IntegerUtils.getString((int)nArray[i]);
        }
        String string = this._sizes.getSelectedItem();
        this._sizes.setItems(stringArray);
        if (string != null) {
            this._sizes.select(string);
        }
    }

    public boolean isCustomFontSizeAllowed() {
        return this._sizes.isEditable();
    }

    public void setCustomFontSizeAllowed(boolean bl) {
        if (bl != this.isCustomFontSizeAllowed()) {
            this._sizes.setEditable(bl);
        }
    }

    public void setFontStyle(int n) {
        boolean bl = (n & 1) != 0;
        this._bold.setState(bl);
        boolean bl2 = (n & 2) != 0;
        this._italic.setState(bl2);
        boolean bl3 = (n & 4) != 0;
        this._underline.setState(bl3);
        boolean bl4 = (n & 8) != 0;
        this._strikeThrough.setState(bl4);
        this._exampleComponent.setFontStyle(n);
        this._laggingFontStyle = n;
    }

    public int getFontStyle() {
        int n = 0;
        if (this._bold.getState()) {
            n |= 1;
        }
        if (this._italic.getState()) {
            n |= 2;
        }
        if (this._underline.getState()) {
            n |= 4;
        }
        if (this._strikeThrough.getState()) {
            n |= 8;
        }
        return n;
    }

    public void setFontBaselineStyle(int n) {
        switch (n) {
            case 2: {
                this._superscript.setState(true);
                this._subscript.setState(false);
                this._exampleComponent.setBaselineVisible(true);
                break;
            }
            case 3: {
                this._subscript.setState(true);
                this._superscript.setState(false);
                this._exampleComponent.setBaselineVisible(true);
                break;
            }
            case 1: {
                this._superscript.setState(false);
                this._subscript.setState(false);
                this._exampleComponent.setBaselineVisible(this._superscript.isVisible() | this._subscript.isVisible());
                break;
            }
        }
        this._laggingFontBaselineStyle = n;
    }

    public int getFontBaselineStyle() {
        if (this._superscript.getState()) {
            return 2;
        }
        if (this._subscript.getState()) {
            return 3;
        }
        return 1;
    }

    public void setFontWidth(int n) {
        if (n < 0 || n > 4) {
            n = 2;
        }
        this._widths.select(n);
        this._laggingFontWidth = n;
    }

    public int getFontWidth() {
        return this._widths.getSelectedIndex();
    }

    public void setFontColor(Color color) {
        Color color2 = this.getFontColor();
        color = FontPane._trySetColorChoice(this._textColor, color);
        this._exampleComponent.setFontColor(color);
        this.firePropertyChange(PROPERTY_FONT_COLOR, color2, color);
        this._laggingFontColor = color;
    }

    public Color getFontColor() {
        return this._textColor.getSelectedColor();
    }

    public void setFontBackgroundColor(Color color) {
        Color color2 = this.getFontBackgroundColor();
        color = FontPane._trySetColorChoice(this._backgroundColor, color);
        this._exampleComponent.setFontBackgroundColor(color);
        this.firePropertyChange(PROPERTY_FONT_BACKGROUND_COLOR, color2, color);
        this._laggingFontBackgroundColor = color;
    }

    public Color getFontBackgroundColor() {
        return this._backgroundColor.getSelectedColor();
    }

    public void setBorderColor(Color color) {
        Color color2 = this.getBorderColor();
        color = FontPane._trySetColorChoice(this._borderColor, color);
        this._exampleComponent.setFontBorderColor(color);
        this.firePropertyChange(PROPERTY_BORDER_COLOR, color2, color);
        this._laggingBorderColor = color;
    }

    public Color getBorderColor() {
        return this._borderColor.getSelectedColor();
    }

    public void setFontHorizontalAlignment(int n) {
        switch (n) {
            case 100: {
                this._fullJustify.setState(true);
                break;
            }
            case 0: {
                this._leftJustify.setState(true);
                break;
            }
            case 1: {
                this._centerJustify.setState(true);
                break;
            }
            case 2: {
                this._rightJustify.setState(true);
                break;
            }
            case 3: {
                this._startJustify.setState(true);
                break;
            }
            case 4: {
                this._endJustify.setState(true);
                break;
            }
        }
        this._laggingFontHorizontalAlignment = n;
        this._exampleComponent.setFontHorizontalAlignment(n);
    }

    public int getFontHorizontalAlignment() {
        if (this._fullJustify.getState()) {
            return 100;
        }
        if (this._leftJustify.getState()) {
            return 0;
        }
        if (this._centerJustify.getState()) {
            return 1;
        }
        if (this._rightJustify.getState()) {
            return 2;
        }
        if (this._startJustify.getState()) {
            return 3;
        }
        if (this._endJustify.getState()) {
            return 4;
        }
        return 1;
    }

    public void setFontVerticalAlignment(int n) {
        switch (n) {
            case 5: {
                this._topJustify.setState(true);
                break;
            }
            case 6: {
                this._middleJustify.setState(true);
                break;
            }
            case 7: {
                this._bottomJustify.setState(true);
                break;
            }
        }
        this._laggingFontVerticalAlignment = n;
        this._exampleComponent.setFontVerticalAlignment(n);
    }

    public int getFontVerticalAlignment() {
        if (this._topJustify.getState()) {
            return 5;
        }
        if (this._middleJustify.getState()) {
            return 6;
        }
        if (this._bottomJustify.getState()) {
            return 7;
        }
        return 6;
    }

    public void setStyleButtonMask(int n) {
        this._bold.setVisible((n & 1) != 0);
        this._italic.setVisible((n & 2) != 0);
        this._underline.setVisible((n & 4) != 0);
        this._strikeThrough.setVisible((n & 8) != 0);
        boolean bl = (n & 0x10) != 0;
        boolean bl2 = (n & 0x20) != 0;
        this._superscript.setVisible(bl);
        this._subscript.setVisible(bl2);
        this._exampleComponent.setBaselineVisible(bl | bl2 | this._superscript.getState() | this._subscript.getState());
        this._styleLabel.setVisible(n != 0);
        this._revalidate();
    }

    public int getStyleButtonMask() {
        int n = 0;
        if (this._bold.isVisible()) {
            n |= 1;
        }
        if (this._italic.isVisible()) {
            n |= 2;
        }
        if (this._underline.isVisible()) {
            n |= 4;
        }
        if (this._strikeThrough.isVisible()) {
            n |= 8;
        }
        if (this._superscript.isVisible()) {
            n |= 0x10;
        }
        if (this._subscript.isVisible()) {
            n |= 0x20;
        }
        return n;
    }

    public void setWidthVisible(boolean bl) {
        this._widths.setVisible(bl);
        this._widthLabel.setVisible(bl);
        this._revalidate();
    }

    public boolean isWidthVisible() {
        return this._widths.isVisible();
    }

    public void setColorComponentMask(int n) {
        boolean bl = (n & 1) != 0;
        boolean bl2 = (n & 2) != 0;
        boolean bl3 = (n & 4) != 0;
        this._textColor.setVisible(bl);
        this._textColorLabel.setVisible(bl);
        this._backgroundColor.setVisible(bl2);
        this._backgroundColorLabel.setVisible(bl2);
        this._borderColor.setVisible(bl3);
        this._borderColorLabel.setVisible(bl3);
        this._exampleComponent.setFontBorderVisible(bl3);
        this._colorComponent.setVisible(bl || bl2 || bl3);
        this._revalidate();
    }

    public int getColorComponentMask() {
        int n = 0;
        if (this._textColor.isVisible()) {
            n |= 1;
        }
        if (this._backgroundColor.isVisible()) {
            n |= 2;
        }
        if (this._borderColor.isVisible()) {
            n |= 4;
        }
        return n;
    }

    public void setAlignmentButtonMask(int n) {
        this._fullJustify.setVisible((n & 1) != 0);
        this._leftJustify.setVisible((n & 2) != 0);
        this._centerJustify.setVisible((n & 4) != 0);
        this._rightJustify.setVisible((n & 8) != 0);
        this._startJustify.setVisible((n & 0x10) != 0);
        this._endJustify.setVisible((n & 0x20) != 0);
        this._topJustify.setVisible((n & 0x40) != 0);
        this._middleJustify.setVisible((n & 0x80) != 0);
        this._bottomJustify.setVisible((n & 0x100) != 0);
        this._alignmentComponent.setVisible(n != 0);
        this._revalidate();
    }

    public int getAlignmentButtonMask() {
        int n = 0;
        if (this._fullJustify.isVisible()) {
            n |= 1;
        }
        if (this._leftJustify.isVisible()) {
            n |= 2;
        }
        if (this._centerJustify.isVisible()) {
            n |= 4;
        }
        if (this._rightJustify.isVisible()) {
            n |= 8;
        }
        if (this._startJustify.isVisible()) {
            n |= 0x10;
        }
        if (this._endJustify.isVisible()) {
            n |= 0x20;
        }
        if (this._topJustify.isVisible()) {
            n |= 0x40;
        }
        if (this._middleJustify.isVisible()) {
            n |= 0x80;
        }
        if (this._bottomJustify.isVisible()) {
            n |= 0x100;
        }
        return n;
    }

    public void setExtraComponent(Component component) {
        Component component2 = this.getExtraComponent();
        if (component2 != null) {
            this._clientContainer.remove(component2);
        }
        if (component != null) {
            this._clientContainer.add("West", component);
            component.setEnabled(this.isEnabled());
        }
        this._revalidate();
    }

    public Component getExtraComponent() {
        int n = this._clientContainer.getComponentCount();
        return n < 1 ? null : this._clientContainer.getComponent(0);
    }

    public void setPreviewAreaVisible(boolean bl) {
        this._exampleArea.setVisible(bl);
        this._revalidate();
    }

    public boolean isPreviewAreaVisible() {
        return this._exampleArea.isVisible();
    }

    public Font getCurrentFont() {
        String string = this.getFontName();
        int n = this.getFontSize();
        boolean bl = this._bold.getState();
        boolean bl2 = this._italic.getState();
        int n2 = 0;
        if (bl) {
            n2 |= 1;
        }
        if (bl2) {
            n2 |= 2;
        }
        return new Font(string, n2, n);
    }

    public void setCurrentFont(Font font) {
        if (font == null) {
            font = this.getFont();
        }
        if (font != null) {
            int n;
            String string = font.getName();
            this._fontNames.select(string);
            this._laggingFontName = string;
            int n2 = font.getSize();
            this._sizes.select(IntegerUtils.getString((int)n2));
            this._laggingFontSize = n2;
            this._laggingFontStyle = n = font.getStyle();
            boolean bl = (n & 1) != 0;
            this._bold.setState(bl);
            boolean bl2 = (n & 2) != 0;
            this._italic.setState(bl2);
            this._setExampleFont(font);
        }
    }

    public void setActualFontSizeVisible(boolean bl) {
        if (bl != this._showFontSize.isVisible()) {
            this._showFontSize.setVisible(bl);
            this._revalidate();
        }
    }

    public boolean isActualFontSizeVisible() {
        return this._showFontSize == null ? false : this._showFontSize.isVisible();
    }

    public void setActualFontSizeUsed(boolean bl) {
        if (bl != this._showFontSize.getState()) {
            this._showFontSize.setState(bl);
            this.updateExampleFont();
        }
    }

    public boolean isActualFontSizeUsed() {
        return this._showFontSize == null ? true : this._showFontSize.getState();
    }

    public ColorChoice getFontColorChoice() {
        return this._textColor;
    }

    public ColorChoice getFontBackgroundColorChoice() {
        return this._backgroundColor;
    }

    public ColorChoice getBorderColorChoice() {
        return this._borderColor;
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this._propertyChangeSupport == null) {
            this._propertyChangeSupport = new PropertyChangeSupport(this);
        }
        this._propertyChangeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this._propertyChangeSupport != null) {
            this._propertyChangeSupport.removePropertyChangeListener(propertyChangeListener);
        }
    }

    @Override
    public void addNotify() {
        super.addNotify();
        FontPane._trySetColorChoice(this._textColor, this._exampleComponent.getFontColor());
        FontPane._trySetColorChoice(this._backgroundColor, this._exampleComponent.getFontBackgroundColor());
        FontPane._trySetColorChoice(this._borderColor, this._exampleComponent.getFontBorderColor());
    }

    @Override
    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this._fontNames.setEnabled(bl);
        this._sizes.setEnabled(bl);
        this._bold.setEnabled(bl);
        this._italic.setEnabled(bl);
        this._underline.setEnabled(bl);
        this._strikeThrough.setEnabled(bl);
        this._superscript.setEnabled(bl);
        this._subscript.setEnabled(bl);
        this._widths.setEnabled(bl);
        this._textColor.setEnabled(bl);
        this._backgroundColor.setEnabled(bl);
        this._borderColor.setEnabled(bl);
        this._fullJustify.setEnabled(bl);
        this._leftJustify.setEnabled(bl);
        this._centerJustify.setEnabled(bl);
        this._rightJustify.setEnabled(bl);
        this._startJustify.setEnabled(bl);
        this._endJustify.setEnabled(bl);
        this._topJustify.setEnabled(bl);
        this._middleJustify.setEnabled(bl);
        this._bottomJustify.setEnabled(bl);
        this._showFontSize.setEnabled(bl);
        if (this.getExtraComponent() != null) {
            this.getExtraComponent().setEnabled(bl);
        }
        this._styleLabel.setEnabled(bl);
        this._widthLabel.setEnabled(bl);
        this._fontLabel.setEnabled(bl);
        this._sizeLabel.setEnabled(bl);
        this._alignmentComponent.setEnabled(bl);
        this._colorComponent.setEnabled(bl);
        this._textColorLabel.setEnabled(bl);
        this._backgroundColorLabel.setEnabled(bl);
        this._borderColorLabel.setEnabled(bl);
        this._exampleComponent.setEnabled(bl);
        this._exampleLabel.setEnabled(bl);
    }

    protected FontPreviewArea createFontPreviewArea() {
        return new FontPreviewArea();
    }

    @Override
    protected void updateLocale(Locale locale, Locale locale2) {
        super.updateLocale(locale, locale2);
        this._setLabels(locale);
    }

    @Override
    protected AccessibleContext createAccessibleContext() {
        return new AccessibleFontPane();
    }

    @Override
    protected void firePropertyChange(String string, int n, int n2) {
        if (n != n2 && this._propertyChangeSupport != null) {
            this._propertyChangeSupport.firePropertyChange(string, IntegerUtils.getInteger((int)n), IntegerUtils.getInteger((int)n2));
        }
    }

    @Override
    protected void firePropertyChange(String string, Object object, Object object2) {
        if (this._propertyChangeSupport != null) {
            this._propertyChangeSupport.firePropertyChange(string, object, object2);
        }
    }

    void updateExampleFont() {
        this._setExampleFont(this.getCurrentFont());
    }

    void fireEvent(Object object, boolean bl) {
        if (object == this._fontNames) {
            if (bl) {
                this.firePropertyChange(PROPERTY_FONT_NAME, this._laggingFontName, this.getFontName());
                this._laggingFontName = this.getFontName();
            }
        } else if (object == this._sizes) {
            if (bl) {
                this.firePropertyChange(PROPERTY_FONT_SIZE, this._laggingFontSize, this.getFontSize());
                this._laggingFontSize = this.getFontSize();
            }
        } else if (object == this._bold || object == this._italic || object == this._underline || object == this._strikeThrough) {
            int n = this.getFontStyle();
            this._exampleComponent.setFontStyle(n);
            this.firePropertyChange(PROPERTY_FONT_STYLE, this._laggingFontStyle, n);
            this._laggingFontStyle = n;
        } else if (object == this._superscript || object == this._subscript) {
            if (bl) {
                if (object == this._superscript) {
                    this._subscript.setState(false);
                } else {
                    this._superscript.setState(false);
                }
            }
            int n = this.getFontBaselineStyle();
            this._exampleComponent.setFontBaselineStyle(n);
            this.firePropertyChange(PROPERTY_FONT_BASELINE_STYLE, this._laggingFontBaselineStyle, n);
            this._laggingFontBaselineStyle = n;
        } else if (object == this._widths) {
            if (bl) {
                this.firePropertyChange(PROPERTY_FONT_WIDTH, this._laggingFontWidth, this.getFontWidth());
                this._laggingFontWidth = this.getFontWidth();
            }
        } else if (object == this._fullJustify || object == this._leftJustify || object == this._rightJustify || object == this._centerJustify || object == this._startJustify || object == this._endJustify) {
            if (bl) {
                int n = this.getFontHorizontalAlignment();
                this._exampleComponent.setFontHorizontalAlignment(n);
                this.firePropertyChange(PROPERTY_FONT_HORIZONTAL_ALIGNMENT, this._laggingFontHorizontalAlignment, n);
                this._laggingFontHorizontalAlignment = n;
            }
        } else if (object == this._topJustify || object == this._bottomJustify || object == this._middleJustify) {
            if (bl) {
                int n = this.getFontVerticalAlignment();
                this._exampleComponent.setFontVerticalAlignment(n);
                this.firePropertyChange(PROPERTY_FONT_VERTICAL_ALIGNMENT, this._laggingFontVerticalAlignment, n);
                this._laggingFontVerticalAlignment = n;
            }
        } else if (object == this._showFontSize) {
            this.firePropertyChange(PROPERTY_ACTUAL_FONT_SIZE_USED, new Boolean(!this.isActualFontSizeUsed()), new Boolean(this.isActualFontSizeUsed()));
        } else if (object == this._textColor) {
            Color color = this._textColor.getSelectedColor();
            this._exampleComponent.setFontColor(color);
            this.firePropertyChange(PROPERTY_FONT_COLOR, this._laggingFontColor, color);
            this._laggingFontColor = color;
        } else if (object == this._borderColor) {
            Color color = this._borderColor.getSelectedColor();
            this._exampleComponent.setFontBorderColor(color);
            this.firePropertyChange(PROPERTY_BORDER_COLOR, this._laggingBorderColor, color);
            this._laggingBorderColor = color;
        } else if (object == this._backgroundColor) {
            Color color = this._backgroundColor.getSelectedColor();
            this._exampleComponent.setFontBackgroundColor(color);
            this.firePropertyChange(PROPERTY_FONT_BACKGROUND_COLOR, this._laggingFontBackgroundColor, color);
            this._laggingFontBackgroundColor = color;
        }
    }

    private void _revalidate() {
        this.invalidate();
        this.repaint();
    }

    private static Image _createImage(String string) {
        String string2 = "images/" + string + ".gif";
        return ImageUtils.getImageResource(FontPane.class, string2);
    }

    private void _setExampleFont(Font font) {
        if (!this.isActualFontSizeUsed() && font != null) {
            font = new Font(font.getName(), font.getStyle(), 12);
        }
        this._exampleComponent.setCurrentFont(font);
    }

    private static Color _trySetColorChoice(ColorChoice colorChoice, Color color) {
        try {
            colorChoice.setSelectedColor(color);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            color = colorChoice.getClosestColor(color);
            colorChoice.setSelectedColor(color);
        }
        return color;
    }

    private static void _setText(ToggleButton toggleButton, String string) {
        toggleButton.setToolTipValue(string);
        toggleButton.getAccessibleContext().setAccessibleName(string);
    }

    private void _setLabels(Locale locale) {
        ResourceBundle resourceBundle = ResourceBundle.getBundle(_RESOURCE, LocaleUtils.getTranslationLocale(locale));
        String string = resourceBundle.getString(_KEY_FONT);
        this._fontLabel.setText(StringUtils.stripMnemonic(string));
        this._fontLabel.setMnemonicIndex(StringUtils.getMnemonicIndex(string));
        string = resourceBundle.getString(_KEY_SIZE);
        this._sizeLabel.setText(StringUtils.stripMnemonic(string));
        this._sizeLabel.setMnemonicIndex(StringUtils.getMnemonicIndex(string));
        this._styleLabel.setText(resourceBundle.getString(_KEY_STYLE));
        FontPane._setText(this._bold, resourceBundle.getString(_KEY_BOLD));
        FontPane._setText(this._italic, resourceBundle.getString(_KEY_ITALIC));
        FontPane._setText(this._underline, resourceBundle.getString(_KEY_UNDERLINE));
        FontPane._setText(this._strikeThrough, resourceBundle.getString(_KEY_STRIKETHRU));
        FontPane._setText(this._superscript, resourceBundle.getString(_KEY_SUPERSCRIPT));
        FontPane._setText(this._subscript, resourceBundle.getString(_KEY_SUBSCRIPT));
        int n = this._widths.getSelectedIndex();
        this._widths.removeAll();
        this._widths.addItem(resourceBundle.getString(_KEY_CONDENSED));
        this._widths.addItem(resourceBundle.getString(_KEY_SEMI_CONDENSED));
        this._widths.addItem(resourceBundle.getString(_KEY_NORMAL));
        this._widths.addItem(resourceBundle.getString(_KEY_SEMI_EXPANDED));
        this._widths.addItem(resourceBundle.getString(_KEY_EXPANDED));
        if (n == -1) {
            n = 2;
        }
        this._widths.select(n);
        this._laggingFontWidth = n;
        string = resourceBundle.getString(_KEY_WIDTH);
        this._widthLabel.setText(StringUtils.stripMnemonic(string));
        this._widthLabel.setMnemonicIndex(StringUtils.getMnemonicIndex(string));
        this._colorComponent.setBorderPainter(UIManager.createGroupBoxPainter(resourceBundle.getString(_KEY_COLOR)));
        string = resourceBundle.getString(_KEY_TEXT_COLOR);
        this._textColorLabel.setText(StringUtils.stripMnemonic(string));
        this._textColorLabel.setMnemonicIndex(StringUtils.getMnemonicIndex(string));
        string = resourceBundle.getString(_KEY_BACKGROUND_COLOR);
        this._backgroundColorLabel.setText(StringUtils.stripMnemonic(string));
        this._backgroundColorLabel.setMnemonicIndex(StringUtils.getMnemonicIndex(string));
        string = resourceBundle.getString(_KEY_BORDER_COLOR);
        this._borderColorLabel.setText(StringUtils.stripMnemonic(string));
        this._borderColorLabel.setMnemonicIndex(StringUtils.getMnemonicIndex(string));
        this._alignmentComponent.setBorderPainter(UIManager.createGroupBoxPainter(resourceBundle.getString(_KEY_ALIGNMENT)));
        FontPane._setText(this._fullJustify, resourceBundle.getString(_KEY_JUSTIFY_FULL));
        FontPane._setText(this._leftJustify, resourceBundle.getString(_KEY_JUSTIFY_LEFT));
        FontPane._setText(this._centerJustify, resourceBundle.getString(_KEY_JUSTIFY_CENTER));
        FontPane._setText(this._rightJustify, resourceBundle.getString(_KEY_JUSTIFY_RIGHT));
        FontPane._setText(this._startJustify, resourceBundle.getString(_KEY_JUSTIFY_START));
        FontPane._setText(this._endJustify, resourceBundle.getString(_KEY_JUSTIFY_END));
        FontPane._setText(this._topJustify, resourceBundle.getString(_KEY_JUSTIFY_TOP));
        FontPane._setText(this._middleJustify, resourceBundle.getString(_KEY_JUSTIFY_MIDDLE));
        FontPane._setText(this._bottomJustify, resourceBundle.getString(_KEY_JUSTIFY_BOTTOM));
        this._exampleLabel.setText(resourceBundle.getString(_KEY_EXAMPLE));
        string = resourceBundle.getString(_KEY_SHOW_ACTUAL);
        this._showFontSize.setLabel(StringUtils.stripMnemonic(string));
        this._showFontSize.setMnemonicIndex(StringUtils.getMnemonicIndex(string));
    }

    private class Group
    extends LWComponent {
        private Group() {
        }

        @Override
        protected AccessibleContext createAccessibleContext() {
            return new AccessibleLWComponent(this){

                @Override
                public String getAccessibleName() {
                    return FontPane.this._styleLabel.getText();
                }

                @Override
                public AccessibleRole getAccessibleRole() {
                    return OracleAccessibleRole.GROUP_BOX;
                }
            };
        }
    }

    private static class NumberEditor
    extends NumberTextField {
        public NumberEditor() {
            this.setBorder(null);
            this.setSigned(false);
            this.setDecimal(false);
        }
    }

    private class FontPaneLayout
    implements LayoutManager {
        private final int _OFFSET = 10;
        private Component _left;

        private FontPaneLayout() {
        }

        @Override
        public void addLayoutComponent(String string, Component component) {
            if ("left".equals(string)) {
                this._left = component;
            }
        }

        @Override
        public void removeLayoutComponent(Component component) {
            if (this._left == component) {
                this._left = null;
            }
        }

        @Override
        public Dimension preferredLayoutSize(Container container) {
            Cloneable cloneable;
            Dimension dimension = this._left.getPreferredSize();
            if (FontPane.this.isPreviewAreaVisible()) {
                dimension.width += 10;
                cloneable = FontPane.this._exampleArea.getPreferredSize();
                ((Dimension)cloneable).width += 8;
                if (((Dimension)cloneable).height < 150) {
                    ((Dimension)cloneable).height = 150;
                }
                if (((Dimension)cloneable).width < dimension.height) {
                    ((Dimension)cloneable).width = dimension.height;
                }
                dimension.width += ((Dimension)cloneable).width;
                dimension.height = Math.max(dimension.height, ((Dimension)cloneable).height);
            }
            cloneable = container.getInsets();
            dimension.width += cloneable.left + cloneable.right;
            dimension.height += cloneable.top + cloneable.bottom;
            return dimension;
        }

        @Override
        public Dimension minimumLayoutSize(Container container) {
            Cloneable cloneable;
            Dimension dimension = this._left.getMinimumSize();
            if (FontPane.this.isPreviewAreaVisible()) {
                dimension.width += 10;
                cloneable = FontPane.this._exampleArea.getMinimumSize();
                if (((Dimension)cloneable).height < 150) {
                    ((Dimension)cloneable).height = 150;
                }
                if (((Dimension)cloneable).width < dimension.height) {
                    ((Dimension)cloneable).width = dimension.height;
                }
                dimension.width += ((Dimension)cloneable).width;
                dimension.height = Math.max(dimension.height, ((Dimension)cloneable).height);
            }
            cloneable = container.getInsets();
            dimension.width += cloneable.left + cloneable.right;
            dimension.height += cloneable.top + cloneable.bottom;
            return dimension;
        }

        @Override
        public void layoutContainer(Container container) {
            Dimension dimension = container.getSize();
            Insets insets = container.getInsets();
            dimension.width -= insets.left + insets.right;
            dimension.height -= insets.top + insets.bottom;
            Dimension dimension2 = this._left.getPreferredSize();
            Dimension dimension3 = null;
            Dimension dimension4 = null;
            int n = 0;
            if (FontPane.this.isPreviewAreaVisible()) {
                dimension3 = FontPane.this._exampleArea.getPreferredSize();
                dimension4 = FontPane.this._exampleArea.getMinimumSize();
                n = 10;
            } else {
                dimension3 = dimension4 = new Dimension(0, 0);
            }
            if (dimension2.width + dimension3.width + n < dimension.width) {
                dimension3.width = dimension.width - dimension2.width;
                if (dimension3.width < dimension4.width) {
                    dimension2.width -= dimension3.width - dimension4.width;
                    dimension3.width = dimension4.width;
                }
            }
            this._left.setBounds(insets.left, insets.top, dimension2.width, dimension.height);
            if (FontPane.this.isPreviewAreaVisible()) {
                int n2 = insets.left + dimension2.width + 10;
                int n3 = dimension.width - n2;
                FontPane.this._exampleArea.setBounds(n2, insets.top, n3, dimension.height);
            } else {
                FontPane.this._exampleArea.setBounds(0, 0, 0, 0);
            }
        }
    }

    private class UIListener
    implements ItemListener,
    PropertyChangeListener {
        private UIListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            FontPane.this.updateExampleFont();
            boolean bl = itemEvent.getStateChange() == 1;
            FontPane.this.fireEvent(itemEvent.getSource(), bl);
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if ("selectedColor".equals(string)) {
                FontPane.this.fireEvent(propertyChangeEvent.getSource(), true);
            }
        }
    }

    private class AccessibleFontPane
    extends AccessibleLWComponent {
        public AccessibleFontPane() {
            super(FontPane.this);
        }

        @Override
        public AccessibleRole getAccessibleRole() {
            return OracleAccessibleRole.FONT_CHOOSER;
        }
    }
}

