/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.font;

import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Locale;
import java.util.ResourceBundle;
import oracle.ewt.font.InternalFontPane;
import oracle.ewt.lwAWT.BufferedDialog;
import oracle.ewt.util.LocaleUtils;
import oracle.ewt.util.WindowUtils;

public class FontChooser
extends BufferedDialog {
    private InternalFontPane _fontPane = new InternalFontPane();
    private Component _centerOver;
    private boolean _cancelled;
    private static final String _TITLE_KEY = "TITLE";

    public FontChooser(Frame frame, boolean bl) {
        super(frame, "", bl);
        this.add("Center", this._fontPane);
        Dismisser dismisser = new Dismisser();
        this._fontPane.getOKButton().addActionListener(dismisser);
        this._fontPane.getCancelButton().addActionListener(dismisser);
        this.addWindowListener(dismisser);
        this._loadMessages(null);
    }

    public Component getCenterOver() {
        return this._centerOver;
    }

    public Font getChooserFont() {
        return this._fontPane.getFontBar().getSelectedFont();
    }

    public boolean isCancelled() {
        return this._cancelled;
    }

    public void runChooser() {
        if (this.isVisible()) {
            throw new IllegalStateException();
        }
        this._cancelled = false;
        this.pack();
        Component component = this.getCenterOver();
        if (component == null) {
            component = this.getParent();
        }
        WindowUtils.centerWindow(this, component);
        this.setVisible(true);
    }

    public void setCenterOver(Component component) {
        this._centerOver = component;
    }

    public void setChooserFont(Font font) {
        this._fontPane.getFontBar().setSelectedFont(font);
    }

    protected void dismiss(boolean bl) {
        this._cancelled = bl;
        this.setVisible(false);
    }

    @Override
    protected void updateLocale(Locale locale, Locale locale2) {
        super.updateLocale(locale, locale2);
        this._loadMessages(locale);
    }

    void __dismiss(ActionEvent actionEvent) {
        this.dismiss(actionEvent.getSource() != this._fontPane.getOKButton());
    }

    private void _loadMessages(Locale locale) {
        if (locale == null) {
            locale = Locale.getDefault();
        }
        ResourceBundle resourceBundle = ResourceBundle.getBundle("oracle.ewt.font.resource.FontBundle", LocaleUtils.getTranslationLocale(locale));
        this.setTitle(resourceBundle.getString(_TITLE_KEY));
    }

    private class Dismisser
    extends WindowAdapter
    implements ActionListener {
        private Dismisser() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            FontChooser.this.__dismiss(actionEvent);
        }

        @Override
        public void windowClosing(WindowEvent windowEvent) {
            FontChooser.this.dismiss(true);
        }
    }
}

