/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.dataSource;

import java.text.Collator;
import oracle.bali.share.sort.Comparator;
import oracle.bali.share.sort.Sort;
import oracle.bali.share.sort.StringComparator;
import oracle.ewt.dataSource.AbstractTwoDDataSource;
import oracle.ewt.dataSource.ArrayOneDDataSource;
import oracle.ewt.dataSource.RowComparator;
import oracle.ewt.dataSource.Sortable;

public class SortableTwoDDataSource
extends AbstractTwoDDataSource
implements Sortable {
    private int _columns;
    private int _rows;
    private ArrayOneDDataSource _data;
    private ArrayOneDDataSource _comparators;
    private Comparator _defaultComparator;
    private RowComparator _sorter;

    public SortableTwoDDataSource() {
        this(0, 0);
    }

    public SortableTwoDDataSource(int n, int n2) {
        this._columns = n;
        this._rows = n2;
        this._data = new ArrayOneDDataSource(this._rows);
        this._sorter = new RowComparator();
    }

    public void addColumns(int n, int n2) {
        for (int i = 0; i < this.getRowCount(); ++i) {
            ArrayOneDDataSource arrayOneDDataSource = (ArrayOneDDataSource)this._data.getData(i);
            if (arrayOneDDataSource == null) continue;
            arrayOneDDataSource.addItems(n, n2);
        }
        if (this._comparators != null) {
            this._comparators.addItems(n, n2);
        }
        this._columns += n2;
        this.fireDataSourceEvent(2001, n, n2);
    }

    public void removeColumns(int n, int n2) {
        for (int i = 0; i < this.getRowCount(); ++i) {
            ArrayOneDDataSource arrayOneDDataSource = (ArrayOneDDataSource)this._data.getData(i);
            if (arrayOneDDataSource == null) continue;
            arrayOneDDataSource.removeItems(n, n2);
        }
        if (this._comparators != null) {
            this._comparators.removeItems(n, n2);
        }
        this._columns -= n2;
        this.fireDataSourceEvent(2002, n, n2);
    }

    public void addRows(int n, int n2) {
        this._data.addItems(n, n2);
        this._rows += n2;
        this.fireDataSourceEvent(2004, n, n2);
    }

    public void removeRows(int n, int n2) {
        this._data.removeItems(n, n2);
        this._rows -= n2;
        this.fireDataSourceEvent(2005, n, n2);
    }

    @Override
    public int getColumnCount() {
        return this._columns;
    }

    @Override
    public int getRowCount() {
        return this._rows;
    }

    @Override
    public Object getData(int n, int n2) {
        ArrayOneDDataSource arrayOneDDataSource = (ArrayOneDDataSource)this._data.getData(n2);
        if (arrayOneDDataSource == null) {
            return null;
        }
        return arrayOneDDataSource.getData(n);
    }

    @Override
    public void setData(int n, int n2, Object object) {
        ArrayOneDDataSource arrayOneDDataSource = (ArrayOneDDataSource)this._data.getData(n2);
        if (arrayOneDDataSource == null) {
            arrayOneDDataSource = new ArrayOneDDataSource(this.getColumnCount());
            this._data.setData(n2, arrayOneDDataSource);
        }
        arrayOneDDataSource.setData(n, object);
        this.fireDataSourceEvent(2007, n, 1, n2, 1);
    }

    public void setColumnComparator(int n, Comparator comparator) {
        if (this._comparators == null) {
            this._comparators = new ArrayOneDDataSource(this.getColumnCount());
        }
        this._comparators.setData(n, comparator);
    }

    public Comparator getColumnComparator(int n) {
        Comparator comparator;
        if (this._comparators != null && (comparator = (Comparator)this._comparators.getData(n)) != null) {
            return comparator;
        }
        return this.getDefaultComparator();
    }

    public Comparator getDefaultComparator() {
        if (this._defaultComparator == null) {
            this._defaultComparator = new StringComparator(Collator.getInstance());
        }
        return this._defaultComparator;
    }

    public void setDefaultComparator(Comparator comparator) {
        this._defaultComparator = comparator;
    }

    @Override
    public void sort(int n, boolean bl) {
        Comparator comparator = this.getColumnComparator(n);
        this._sorter.setComparisonData(n, comparator, bl);
        int n2 = this._rows;
        Object[] objectArray = new Object[n2];
        for (int i = 0; i < n2; ++i) {
            objectArray[i] = this._data.getData(i);
        }
        Sort.qSort((Object[])objectArray, (int)objectArray.length, (Comparator)this._sorter);
        this._data.removeItems(0, n2);
        this._data.addItems(0, objectArray);
        this.fireDataSourceEvent(2007, 0, this._columns, 0, this._rows);
    }
}

