/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.dataSource;

import java.util.Enumeration;
import oracle.ewt.dataSource.TwoDDataSource;
import oracle.ewt.dataSource.TwoDDataSourceEvent;
import oracle.ewt.dataSource.TwoDDataSourceListener;
import oracle.ewt.event.ListenerManager;

public class ArrayTwoDDataSource
implements TwoDDataSource {
    private int _columns;
    private int _rows;
    private Object[][] _data;
    private ListenerManager _manager;
    private static int _ROWS_ALLOCATED_AHEAD = 20;

    public ArrayTwoDDataSource(int n, int n2) {
        this._columns = n;
        this._rows = n2;
    }

    public void addRows(int n, int n2) {
        this._addRowsToArray(n, n2);
        this._rows += n2;
        this._addRows(n, n2);
    }

    public void removeRows(int n, int n2) {
        this._removeRowsFromArray(n, n2);
        this._rows -= n2;
        this._removeRows(n, n2);
    }

    public void addColumns(int n, int n2) {
        this._addColumnsToArray(n, n2);
        this._columns += n2;
        this._addColumns(n, n2);
    }

    public void removeColumns(int n, int n2) {
        this._removeColumnsFromArray(n, n2);
        this._columns -= n2;
        this._removeColumns(n, n2);
    }

    @Override
    public int getColumnCount() {
        return this._columns;
    }

    @Override
    public int getRowCount() {
        return this._rows;
    }

    @Override
    public Object getData(int n, int n2) {
        if (n2 >= this._rows || n >= this._columns) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (this._data == null) {
            return null;
        }
        Object[] objectArray = this._data[n2];
        if (objectArray == null) {
            return null;
        }
        return objectArray[n];
    }

    @Override
    public void setData(int n, int n2, Object object) {
        Object[] objectArray;
        if (n2 >= this._rows || n >= this._columns) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (this._data == null) {
            this._data = new Object[this._rows][];
        }
        if ((objectArray = this._data[n2]) == null) {
            objectArray = new Object[this._columns];
            this._data[n2] = objectArray;
        }
        objectArray[n] = object;
        this._invalidateCell(n, n2);
    }

    @Override
    public void addDataSourceListener(TwoDDataSourceListener twoDDataSourceListener) {
        if (this._manager == null) {
            this._manager = new ListenerManager();
        }
        this._manager.addListener(twoDDataSourceListener);
    }

    @Override
    public void removeDataSourceListener(TwoDDataSourceListener twoDDataSourceListener) {
        if (this._manager != null) {
            this._manager.removeListener(twoDDataSourceListener);
        }
    }

    private void _addRows(int n, int n2) {
        if (this._manager == null) {
            return;
        }
        Enumeration enumeration = this._manager.getListeners();
        if (enumeration == null) {
            return;
        }
        TwoDDataSourceEvent twoDDataSourceEvent = new TwoDDataSourceEvent(this, 2004, n, n2);
        while (enumeration.hasMoreElements()) {
            TwoDDataSourceListener twoDDataSourceListener = (TwoDDataSourceListener)enumeration.nextElement();
            twoDDataSourceListener.rowsAdded(twoDDataSourceEvent);
        }
    }

    private void _removeRows(int n, int n2) {
        if (this._manager == null) {
            return;
        }
        Enumeration enumeration = this._manager.getListeners();
        if (enumeration == null) {
            return;
        }
        TwoDDataSourceEvent twoDDataSourceEvent = new TwoDDataSourceEvent(this, 2005, n, n2);
        while (enumeration.hasMoreElements()) {
            TwoDDataSourceListener twoDDataSourceListener = (TwoDDataSourceListener)enumeration.nextElement();
            twoDDataSourceListener.rowsRemoved(twoDDataSourceEvent);
        }
    }

    private void _invalidateCell(int n, int n2) {
        if (this._manager == null) {
            return;
        }
        Enumeration enumeration = this._manager.getListeners();
        if (enumeration == null) {
            return;
        }
        TwoDDataSourceEvent twoDDataSourceEvent = new TwoDDataSourceEvent(this, 2007, n, 1, n2, 1);
        while (enumeration.hasMoreElements()) {
            TwoDDataSourceListener twoDDataSourceListener = (TwoDDataSourceListener)enumeration.nextElement();
            twoDDataSourceListener.invalidateCells(twoDDataSourceEvent);
        }
    }

    private void _addRowsToArray(int n, int n2) {
        Object[][] objectArray;
        Object[][] objectArray2 = this._data;
        if (objectArray2 == null) {
            return;
        }
        int n3 = this._rows;
        if (objectArray2.length >= n3 + n2) {
            objectArray = objectArray2;
        } else {
            objectArray = new Object[n3 + n2 + _ROWS_ALLOCATED_AHEAD][];
            System.arraycopy(objectArray2, 0, objectArray, 0, n);
            this._data = objectArray;
        }
        System.arraycopy(objectArray2, n, objectArray, n + n2, n3 - n);
        if (objectArray == objectArray2) {
            int n4 = n;
            for (int i = 0; i < n2; ++i) {
                objectArray2[n4++] = null;
            }
        }
    }

    private void _removeRowsFromArray(int n, int n2) {
        Object[][] objectArray;
        Object[][] objectArray2 = this._data;
        if (objectArray2 == null) {
            return;
        }
        int n3 = this._rows;
        if (n3 - n2 + _ROWS_ALLOCATED_AHEAD < objectArray2.length / 2) {
            objectArray = new Object[n3 - n2 + _ROWS_ALLOCATED_AHEAD][];
            System.arraycopy(objectArray2, 0, objectArray, 0, n);
            this._data = objectArray;
        } else {
            objectArray = objectArray2;
        }
        System.arraycopy(objectArray2, n + n2, objectArray, n, n3 - n - n2);
        if (objectArray == objectArray2) {
            int n4 = n3;
            for (int i = 0; i < n2; ++i) {
                objectArray2[--n4] = null;
            }
        }
    }

    private void _addColumnsToArray(int n, int n2) {
        Object[][] objectArray = this._data;
        if (objectArray == null) {
            return;
        }
        int n3 = this._columns;
        int n4 = n3 + n2;
        int n5 = n + n2;
        int n6 = n3 - n;
        for (int i = 0; i < this._rows; ++i) {
            Object[] objectArray2 = objectArray[i];
            if (objectArray2 == null) continue;
            Object[] objectArray3 = new Object[n4];
            System.arraycopy(objectArray2, 0, objectArray3, 0, n);
            System.arraycopy(objectArray2, n, objectArray3, n5, n6);
            objectArray[i] = objectArray3;
        }
    }

    private void _removeColumnsFromArray(int n, int n2) {
        Object[][] objectArray = this._data;
        if (objectArray == null) {
            return;
        }
        int n3 = this._columns;
        int n4 = n3 - n2;
        int n5 = n + n2;
        int n6 = n3 - n - n2;
        for (int i = 0; i < this._rows; ++i) {
            Object[] objectArray2 = objectArray[i];
            if (objectArray2 == null) continue;
            Object[] objectArray3 = new Object[n4];
            System.arraycopy(objectArray2, 0, objectArray3, 0, n);
            System.arraycopy(objectArray2, n5, objectArray3, n, n6);
            objectArray[i] = objectArray3;
        }
    }

    private void _addColumns(int n, int n2) {
        if (this._manager == null) {
            return;
        }
        Enumeration enumeration = this._manager.getListeners();
        if (enumeration == null) {
            return;
        }
        TwoDDataSourceEvent twoDDataSourceEvent = new TwoDDataSourceEvent(this, 2001, n, n2);
        while (enumeration.hasMoreElements()) {
            TwoDDataSourceListener twoDDataSourceListener = (TwoDDataSourceListener)enumeration.nextElement();
            twoDDataSourceListener.columnsAdded(twoDDataSourceEvent);
        }
    }

    private void _removeColumns(int n, int n2) {
        if (this._manager == null) {
            return;
        }
        Enumeration enumeration = this._manager.getListeners();
        if (enumeration == null) {
            return;
        }
        TwoDDataSourceEvent twoDDataSourceEvent = new TwoDDataSourceEvent(this, 2002, n, n2);
        while (enumeration.hasMoreElements()) {
            TwoDDataSourceListener twoDDataSourceListener = (TwoDDataSourceListener)enumeration.nextElement();
            twoDDataSourceListener.columnsRemoved(twoDDataSourceEvent);
        }
    }
}

