/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.dTree;

import java.awt.Image;
import java.io.IOException;
import java.io.NotActiveException;
import java.io.ObjectInputStream;
import oracle.ewt.dTree.DTree;
import oracle.ewt.dTree.DTreeExplicitParent;
import oracle.ewt.dTree.DTreeItem;
import oracle.ewt.dTree.DTreeSimpleChild;

public class DTreeSimpleParent
extends DTreeSimpleChild
implements DTreeExplicitParent {
    private static final long serialVersionUID = -7133055331596216079L;
    private DTreeItem[] _children;
    private int _nchildren;
    private transient int _subheight;
    private boolean _expanded;

    public DTreeSimpleParent(String string, Image image) {
        super(string, image);
    }

    public final void addItem(DTreeItem dTreeItem) {
        this.addItem(dTreeItem, -1);
    }

    public final void addItem(DTreeItem dTreeItem, int n) {
        DTreeItem[] dTreeItemArray = new DTreeItem[]{dTreeItem};
        this.addItems(dTreeItemArray, n);
    }

    @Override
    public void addItems(DTreeItem[] dTreeItemArray, int n) {
        int n2;
        int n3 = dTreeItemArray.length;
        if (n3 <= 0) {
            return;
        }
        int n4 = this.getItemCount();
        if (n < 0 || n > n4) {
            n = n4;
        }
        if (this._children == null) {
            this._children = new DTreeItem[n3];
        } else if (this._children.length < n3 + n4) {
            DTreeItem[] dTreeItemArray2 = new DTreeItem[n3 + n4];
            System.arraycopy(this._children, 0, dTreeItemArray2, 0, n);
            System.arraycopy(this._children, n, dTreeItemArray2, n + n3, n4 - n);
            this._children = dTreeItemArray2;
        } else {
            System.arraycopy(this._children, n, this._children, n + n3, n4 - n);
        }
        System.arraycopy(dTreeItemArray, 0, this._children, n, n3);
        this._nchildren = n4 + n3;
        for (n2 = n; n2 < n + n3; ++n2) {
            this._children[n2].itemAdded(this, n2);
        }
        while (n2 < this._nchildren) {
            this._children[n2].setIndex(n2);
            ++n2;
        }
        DTree dTree = this.getTree();
        if (dTree != null) {
            dTree.itemsAdded(this, n, n3);
        }
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        DTreeSimpleParent dTreeSimpleParent = (DTreeSimpleParent)super.clone();
        dTreeSimpleParent._nchildren = 0;
        dTreeSimpleParent.itemRemoved();
        DTreeItem[] dTreeItemArray = new DTreeItem[this._nchildren];
        for (int i = 0; i < this._nchildren; ++i) {
            DTreeItem dTreeItem;
            dTreeItemArray[i] = dTreeItem = (DTreeItem)this._children[i].clone();
            dTreeItem.itemAdded(dTreeSimpleParent, dTreeItem.getIndex());
        }
        dTreeSimpleParent._children = dTreeItemArray;
        dTreeSimpleParent._nchildren = dTreeItemArray.length;
        return dTreeSimpleParent;
    }

    @Override
    public DTreeItem getItem(int n) {
        if (n >= this._nchildren) {
            return null;
        }
        return this._children[n];
    }

    @Override
    public DTreeItem getItemAt(int n, int n2) {
        int n3 = this.getSubTreeHeight();
        if (n2 > n3) {
            return null;
        }
        int n4 = this.getSize().height;
        if (n2 < n4) {
            return this;
        }
        if (this.isExpanded() && this._nchildren > 0) {
            int n5 = this.getY();
            for (int i = 0; i < this._nchildren; ++i) {
                DTreeItem dTreeItem = this.getItem(i);
                int n6 = dTreeItem.getY() - n5;
                if (n2 >= n6 && n2 < n6 + dTreeItem.getSubTreeHeight()) {
                    return dTreeItem.getItemAt(n, n2 - n6);
                }
                if (n2 >= n6) continue;
                return null;
            }
        }
        return null;
    }

    @Override
    public int getItemCount() {
        return this._nchildren;
    }

    @Override
    public DTreeItem getNextExpandedChild(DTreeItem dTreeItem) {
        int n;
        int n2 = n = dTreeItem == null ? 0 : dTreeItem.getIndex() + 1;
        while (n < this._nchildren) {
            DTreeItem dTreeItem2 = this._children[n];
            if (dTreeItem2.isExpanded()) {
                return dTreeItem2;
            }
            ++n;
        }
        return null;
    }

    @Override
    public int getSubTreeHeight() {
        return this._subheight;
    }

    @Override
    public boolean isExpandable() {
        return this.getItemCount() > 0;
    }

    @Override
    public boolean isExpanded() {
        return this._expanded;
    }

    @Override
    public void layout(int n, int n2) {
        super.layout(n, n2);
        int n3 = this.getSize().height;
        if (this._expanded && this._nchildren != 0) {
            DTreeItem dTreeItem = this.getParent();
            DTree dTree = this.getTree();
            int n4 = 0;
            int n5 = dTreeItem == null ? 0 : dTree.getIndentWidth();
            int n6 = n;
            int n7 = n2 + this.getChildrenYOffset(n3);
            if (this != dTree.getRoot()) {
                n6 += this.getChildrenXOffset(dTree.getIndentWidth());
            }
            while (n4 < this._nchildren) {
                DTreeItem dTreeItem2 = this.getItem(n4);
                dTreeItem2.layout(n6, n7);
                n7 += dTreeItem2.getSubTreeHeight();
                ++n4;
            }
            n3 = n7 - n2;
        }
        this._subheight = n3;
    }

    @Override
    public void removeItems(int n, int n2) {
        Object object;
        int n3;
        if (n2 == 0) {
            return;
        }
        for (n3 = n; n3 < n + n2; ++n3) {
            object = this._children[n3];
            object.itemRemoved();
        }
        System.arraycopy(this._children, n + n2, this._children, n, this._nchildren - (n + n2));
        this._nchildren -= n2;
        for (n3 = n; n3 < this._nchildren; ++n3) {
            this._children[n3].setIndex(n3);
        }
        object = this.getTree();
        ((DTree)object).itemsRemoved(this, n, n2);
    }

    @Override
    public void setExpanded(boolean bl) {
        if (bl == this.isExpanded()) {
            return;
        }
        DTree dTree = this.getTree();
        if (dTree == null) {
            this._expanded = bl;
        } else if (!dTree.itemExpansionChanging(this, bl)) {
            this._expanded = bl;
            dTree.itemExpansionChanged(this, bl);
        }
    }

    protected int getChildrenXOffset(int n) {
        return n;
    }

    protected int getChildrenYOffset(int n) {
        return n;
    }

    protected void setSubTreeHeight(int n) {
        this._subheight = n;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException, NotActiveException {
        objectInputStream.defaultReadObject();
        for (int i = 0; i < this._nchildren; ++i) {
            this._children[i].itemAdded(this, i);
        }
    }
}

