/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.dTree;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.datatransfer.Transferable;
import java.awt.image.FilteredImageSource;
import oracle.bali.share.datatransfer.ObjectTransferable;
import oracle.ewt.dTree.DTree;
import oracle.ewt.dTree.DTreeDragSource;
import oracle.ewt.dTree.DTreeItem;
import oracle.ewt.dTree.DTreeRangeSet;
import oracle.ewt.dTree.DTreeSelection;
import oracle.ewt.dnd.DragGestureEvent;
import oracle.ewt.dnd.DragGestureListener;
import oracle.ewt.dnd.DragGestureRecognizer;
import oracle.ewt.dnd.DragSource;
import oracle.ewt.dnd.DragSourceDragEvent;
import oracle.ewt.dnd.DragSourceDropEvent;
import oracle.ewt.dnd.DragSourceEvent;
import oracle.ewt.dnd.DragSourceListener;
import oracle.ewt.graphics.TransparencyFilter;
import oracle.ewt.plaf.TreeUI;

public class DTreeDragSupport {
    static final String __CLIENT_PROP_DRAG_ITEMS = "_ewtDTreeDragItems";
    private DTree _tree;
    private boolean _enabled;

    public DTreeDragSupport(DTree dTree) {
        this._tree = dTree;
        this._enabled = true;
        Dragger dragger = new Dragger(dTree);
    }

    public DTree getTree() {
        return this._tree;
    }

    public boolean isEnabled() {
        return this._enabled;
    }

    public void setEnabled(boolean bl) {
        this._enabled = bl;
    }

    protected Image createDragImage(DTreeRangeSet dTreeRangeSet, DTreeItem dTreeItem) {
        DTree dTree = this.getTree();
        Image image = null;
        if (dTreeRangeSet.getItemCount() > 1) {
            TreeUI treeUI = (TreeUI)dTree.getUI();
            image = treeUI.getMultiItemDragImage(dTree);
        } else {
            Dimension dimension = dTreeItem.getSize();
            Image image2 = dTree.createImage(dimension.width, dimension.height);
            Graphics graphics = image2.getGraphics();
            Color color = dTree.getBackground();
            graphics.setColor(color);
            graphics.fillRect(0, 0, dimension.width, dimension.height);
            graphics.setColor(dTree.getForeground());
            dTreeItem.paint(graphics, false, false, dimension.width, dimension.height);
            image = dTree.createImage(new FilteredImageSource(image2.getSource(), new TransparencyFilter(color)));
            graphics.dispose();
            image2.flush();
        }
        return image;
    }

    protected Transferable createTransferable(DTreeRangeSet dTreeRangeSet) {
        int n = dTreeRangeSet.getItemCount();
        if (n == 1) {
            DTreeItem dTreeItem = dTreeRangeSet.getFirstItem();
            DTreeDragSource dTreeDragSource = this.getDTreeDragSource(dTreeItem);
            if (dTreeDragSource != null) {
                return dTreeDragSource.getTransferable(dTreeItem);
            }
        } else if (n > 1) {
            DTreeItem[] dTreeItemArray = dTreeRangeSet.getItems();
            Transferable[] transferableArray = new Transferable[dTreeItemArray.length];
            int n2 = 0;
            while (n2 < dTreeItemArray.length) {
                DTreeItem dTreeItem = dTreeItemArray[n2];
                DTreeDragSource dTreeDragSource = this.getDTreeDragSource(dTreeItem);
                if (dTreeDragSource == null) {
                    return null;
                }
                Transferable transferable = dTreeDragSource.getTransferable(dTreeItem);
                if (transferable == null) {
                    return null;
                }
                transferableArray[n2++] = transferable;
            }
            return ObjectTransferable.createTransferable((Object)transferableArray);
        }
        return null;
    }

    protected void dragDropEnd(DTreeRangeSet dTreeRangeSet, int n) {
        DTreeItem[] dTreeItemArray = dTreeRangeSet.getItems();
        for (int i = 0; i < dTreeItemArray.length; ++i) {
            DTreeItem dTreeItem = dTreeItemArray[i];
            DTreeDragSource dTreeDragSource = this.getDTreeDragSource(dTreeItem);
            if (dTreeDragSource == null) continue;
            dTreeDragSource.dragDropEnd(dTreeItem, n);
        }
    }

    protected DTreeDragSource getDTreeDragSource(DTreeItem dTreeItem) {
        return dTreeItem.getDragSource();
    }

    protected int getSourceActions(DTreeRangeSet dTreeRangeSet) {
        DTreeItem[] dTreeItemArray = dTreeRangeSet.getItems();
        if (dTreeItemArray.length == 0) {
            return 0;
        }
        int n = 0x40000003;
        for (int i = 0; i < dTreeItemArray.length; ++i) {
            DTreeItem dTreeItem = dTreeItemArray[i];
            DTreeDragSource dTreeDragSource = this.getDTreeDragSource(dTreeItem);
            if (n == 0 || dTreeDragSource == null) {
                return 0;
            }
            n &= dTreeDragSource.getSourceActions(dTreeItem);
        }
        return n;
    }

    private class Dragger
    implements DragSourceListener,
    DragGestureListener {
        private DTreeRangeSet _dragItems;

        public Dragger(DTree dTree) {
            DragSource dragSource = DragSource.getDefaultDragSource();
            DragGestureRecognizer dragGestureRecognizer = dragSource.createDefaultDragGestureRecognizer(dTree, 0x40000003, this);
        }

        @Override
        public void dragGestureRecognized(DragGestureEvent dragGestureEvent) {
            if (DTreeDragSupport.this.isEnabled()) {
                DTree dTree = DTreeDragSupport.this.getTree();
                Point point = dragGestureEvent.getDragOrigin();
                Point point2 = dTree.convertOuterToCanvas(point.x, point.y);
                DTreeItem dTreeItem = dTree.getDraggableItemAt(point2.x, point2.y);
                DTreeSelection dTreeSelection = dTree.getSelection();
                if (dTreeItem != null && dTreeSelection.isSelected(dTreeItem)) {
                    Transferable transferable;
                    DTreeRangeSet dTreeRangeSet = dTreeSelection.getSelectionRanges();
                    int n = DTreeDragSupport.this.getSourceActions(dTreeRangeSet = dTreeRangeSet.getAncestorRanges());
                    if (n != 0 && (transferable = DTreeDragSupport.this.createTransferable(dTreeRangeSet)) != null) {
                        this._setDragItems(dTreeRangeSet);
                        Image image = DTreeDragSupport.this.createDragImage(dTreeRangeSet, dTreeItem);
                        Point point3 = new Point(dTreeItem.getX() - point2.x, dTreeItem.getY() - point2.y);
                        Dimension dimension = dTreeItem.getSize();
                        int n2 = image.getWidth(dTree);
                        int n3 = image.getHeight(dTree);
                        if (n2 < dimension.width || n3 < dimension.height) {
                            point3.x = -n2;
                            point3.y = -n3;
                        }
                        dragGestureEvent.startDrag(null, image, point3, transferable, this);
                    }
                }
            }
        }

        @Override
        public void dragDropEnd(DragSourceDropEvent dragSourceDropEvent) {
            int n = dragSourceDropEvent.getDropSuccess() ? dragSourceDropEvent.getDropAction() : 0;
            DTreeDragSupport.this.dragDropEnd(this._getDragItems(), n);
            this._setDragItems(null);
        }

        @Override
        public void dragEnter(DragSourceDragEvent dragSourceDragEvent) {
        }

        @Override
        public void dragOver(DragSourceDragEvent dragSourceDragEvent) {
        }

        @Override
        public void dropActionChanged(DragSourceDragEvent dragSourceDragEvent) {
        }

        @Override
        public void dragExit(DragSourceEvent dragSourceEvent) {
        }

        private DTreeRangeSet _getDragItems() {
            return this._dragItems;
        }

        private void _setDragItems(DTreeRangeSet dTreeRangeSet) {
            if (this._dragItems != dTreeRangeSet) {
                DTree dTree = DTreeDragSupport.this.getTree();
                if (this._dragItems != null) {
                    dTree.putClientProperty(DTreeDragSupport.__CLIENT_PROP_DRAG_ITEMS, null);
                    dTree.__removeRangeSet(this._dragItems);
                }
                this._dragItems = dTreeRangeSet;
                if (this._dragItems != null) {
                    dTree.__addRangeSet(this._dragItems);
                    dTree.putClientProperty(DTreeDragSupport.__CLIENT_PROP_DRAG_ITEMS, this._dragItems);
                }
            }
        }
    }
}

