/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.color;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.image.MemoryImageSource;
import java.util.Locale;
import oracle.ewt.color.BaseColorEditor;
import oracle.ewt.graphics.ColorUtils;
import oracle.ewt.imageCanvas.ImageCanvas;
import oracle.ewt.lwAWT.LWContainer;
import oracle.ewt.lwAWT.LWLabel;

class HSLImageComponent
extends BaseColorEditor {
    private static final String _KEY_LABEL = "COLORCHOOSER.COLOR_SELECTOR";
    private static final int _WIDTH = 150;
    private static final int _LUM_WIDTH = 10;
    private static final int _HEIGHT = 150;
    private static final int _IMAGE_SIZE = 22500;
    private static final int _LUM_IMAGE_SIZE = 1500;
    private LWLabel _label;
    private ImageCanvas _imageCanvas;
    private ImageCanvas _lumCanvas;
    private Gauge _lumGauge;
    private double _x = 0.0;
    private double _y = 0.0;
    private double _luminance = 0.0;

    public HSLImageComponent() {
        Listener listener = new Listener();
        this.setLayout(new BorderLayout(0, 5));
        this._label = new LWLabel("");
        this.add("North", this._label);
        LWContainer lWContainer = new LWContainer(new BorderLayout(10, 0));
        this._imageCanvas = new Canvas();
        this._imageCanvas.setImage(this._createImage());
        this._imageCanvas.addMouseListener(listener);
        this._imageCanvas.addMouseMotionListener(listener);
        lWContainer.add("Center", this._imageCanvas);
        LWContainer lWContainer2 = new LWContainer(new BorderLayout());
        this._lumGauge = new Gauge();
        this._lumGauge.addMouseListener(listener);
        this._lumGauge.addMouseMotionListener(listener);
        this._lumCanvas = new ImageCanvas();
        this._setLuminanceImage();
        this._lumCanvas.addMouseListener(listener);
        this._lumCanvas.addMouseMotionListener(listener);
        lWContainer2.add("West", this._lumCanvas);
        lWContainer2.add("Center", this._lumGauge);
        lWContainer.add("East", lWContainer2);
        this.add("Center", lWContainer);
    }

    @Override
    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this._label.setEnabled(bl);
        this._imageCanvas.setEnabled(bl);
        this._lumCanvas.setEnabled(bl);
        this._lumGauge.setEnabled(bl);
    }

    @Override
    protected void colorChanged(Color color) {
        this._updateLocation(color);
    }

    @Override
    protected void updateLabels(Locale locale) {
        String string = HSLImageComponent.__getTranslatedString(locale, _KEY_LABEL);
        this._label.setText(string);
    }

    private void _updateColor(Object object, double d, double d2) {
        if (!this.isEnabled()) {
            return;
        }
        if (d2 < 0.0) {
            d2 = 0.0;
        } else if (d2 > 150.0) {
            d2 = 150.0;
        }
        if (object == this._imageCanvas) {
            if (d < 0.0) {
                d = 0.0;
            } else if (d > 150.0) {
                d = 150.0;
            }
            this._x = d;
            this._y = d2;
        } else {
            this._luminance = d2;
        }
        double d3 = (1.0 - this._x / 150.0) * 360.0;
        double d4 = (1.0 - this._y / 150.0) * 100.0;
        double d5 = (1.0 - this._luminance / 150.0) * 100.0;
        int[] nArray = ColorUtils.hslToRGB(d3, d4, d5);
        Color color = new Color(nArray[0], nArray[1], nArray[2]);
        this.storeColor(color);
        this._imageCanvas.repaint();
        this._setLuminanceImage();
    }

    private void _updateLocation(Color color) {
        double[] dArray = ColorUtils.rgbToHSL(color.getRed(), color.getGreen(), color.getBlue());
        this._x = 150.0 * (1.0 - dArray[0] / 360.0);
        this._y = 150.0 * (1.0 - dArray[1] / 100.0);
        this._luminance = 150.0 * (1.0 - dArray[2] / 100.0);
        this._imageCanvas.repaint();
        this._setLuminanceImage();
    }

    private void _setLuminanceImage() {
        Object object;
        int[] nArray = new int[1500];
        int n = 0;
        double d = (100.0 - this._x / 150.0) * 360.0;
        double d2 = 100.0 - this._y / 150.0;
        double d3 = 100.0;
        double d4 = 0.0;
        for (int i = 0; i < 150; ++i) {
            object = ColorUtils.hslToRGB(d, d2, d3);
            int n2 = 0xFF000000 | object[0] << 16 | object[1] << 8 | object[2];
            for (int j = 0; j < 10; ++j) {
                nArray[n++] = n2;
            }
            d3 -= d4;
        }
        MemoryImageSource memoryImageSource = new MemoryImageSource(10, 150, nArray, 0, 10);
        object = this.createImage(memoryImageSource);
        this._lumCanvas.setImage((Image)object);
        this._lumGauge.repaint();
    }

    private Image _createImage() {
        int[] nArray = new int[22500];
        int n = 0;
        double d = 2.4;
        double d2 = 0.6666666666666666;
        double d3 = 100.0;
        for (int i = 0; i < 150; ++i) {
            double d4 = 360.0 - d;
            for (int j = 0; j < 150; ++j) {
                int[] nArray2 = ColorUtils.hslToRGB(d4, d3, 50.0);
                nArray[n++] = 0xFF000000 | nArray2[0] << 16 | nArray2[1] << 8 | nArray2[2];
                d4 -= d;
            }
            d3 -= d2;
        }
        MemoryImageSource memoryImageSource = new MemoryImageSource(150, 150, nArray, 0, 150);
        return this.createImage(memoryImageSource);
    }

    private class Canvas
    extends ImageCanvas {
        private Canvas() {
        }

        @Override
        public void paintOverChildren(Graphics graphics) {
            int n = (int)HSLImageComponent.this._x;
            int n2 = (int)HSLImageComponent.this._y;
            graphics.setColor(Color.black);
            graphics.drawLine(n - 5, n2 - 5, n + 5, n2 + 5);
            graphics.drawLine(n - 5, n2 + 5, n + 5, n2 - 5);
        }
    }

    private class Gauge
    extends LWContainer {
        public void paintComponent(Graphics graphics) {
            graphics.setColor(this.getBackground());
            graphics.fillRect(0, 0, this.getInnerWidth(), this.getInnerHeight());
            graphics.setColor(Color.black);
            int n = (int)HSLImageComponent.this._luminance;
            graphics.drawLine(0, n, 0, n);
            graphics.drawLine(1, n - 1, 1, n + 1);
            graphics.drawLine(2, n - 2, 2, n + 2);
            graphics.drawLine(3, n - 3, 3, n + 3);
            graphics.drawLine(4, n - 4, 4, n + 4);
        }
    }

    private class Listener
    extends MouseAdapter
    implements MouseMotionListener {
        private Listener() {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            HSLImageComponent.this._updateColor(mouseEvent.getSource(), mouseEvent.getX(), mouseEvent.getY());
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            HSLImageComponent.this._updateColor(mouseEvent.getSource(), mouseEvent.getX(), mouseEvent.getY());
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            HSLImageComponent.this._updateColor(mouseEvent.getSource(), mouseEvent.getX(), mouseEvent.getY());
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
        }
    }
}

