/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.color;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import oracle.ewt.access.AccessibleLWComponent;
import oracle.ewt.color.ColorChooserPane;
import oracle.ewt.color.ColorGrid;
import oracle.ewt.color.OLAFDialog;
import oracle.ewt.dataSource.NullTwoDDataSource;
import oracle.ewt.dataSource.TwoDDataSource;
import oracle.ewt.dataSource.TwoDDataSourceAdapter;
import oracle.ewt.dataSource.TwoDDataSourceEvent;
import oracle.ewt.layout.EqualColumnLayout;
import oracle.ewt.lwAWT.LWButton;
import oracle.ewt.lwAWT.LWComponent;
import oracle.ewt.lwAWT.LWContainer;
import oracle.ewt.lwAWT.LWLabel;
import oracle.ewt.util.LocaleUtils;
import oracle.ewt.util.StringUtils;
import oracle.ewt.util.WindowUtils;

public class ColorPalettePane
extends LWComponent
implements Accessible {
    public static final String PROPERTY_COLOR_PALETTE = "colorPalette";
    public static final String PROPERTY_SELECTED_COLOR = "selectedColor";
    public static final int BUTTON_OK = 1;
    public static final int BUTTON_CANCEL = 2;
    private static final String _RESOURCE = "oracle.ewt.color.resource.ColorBundle";
    private static final String _KEY_COLOR_NAME = "COLORPALETTE.COLOR_NAME";
    private static final String _KEY_TITLE = "COLORPALETTE.COLOR_PALETTE_TITLE";
    private static final String _KEY_LABEL = "COLORPALETTE.AVAILABLE_COLORS";
    private static final String _KEY_CUSTOM_LABEL = "COLORPALETTE.CUSTOM_COLORS";
    private static final String _KEY_EDIT = "COLORPALETTE.EDIT_COLOR";
    private Listener _listener = new Listener();
    private ColorGrid _grid = new AccessGrid(false);
    private LWLabel _label;
    private LWButton _editButton;
    private LWLabel _colorName;
    private LWLabel _colorNameLabel;
    private LWContainer _colorNameComponent;
    private PropertyChangeSupport _propertyChangeSupport;
    private LWContainer _customButtonPanel;
    private TwoDDataSource _names;
    private TwoDDataSource _customNames;
    private ColorGrid _customGrid;
    private LWLabel _customLabel;
    private ColorChooserPane _colorChooserPane;
    private boolean _ignoreEvents;

    public static int showDialog(Component component, ColorPalettePane colorPalettePane) {
        return ColorPalettePane.showDialog(component, colorPalettePane, null, false);
    }

    public static int showDialog(Component component, ColorPalettePane colorPalettePane, String string, boolean bl) {
        if (colorPalettePane == null) {
            throw new IllegalArgumentException("ColorPalettePane must be non-null");
        }
        OLAFDialog oLAFDialog = new OLAFDialog(WindowUtils.parentFrame(component));
        if (string == null) {
            Locale locale = LocaleUtils.getDefaultableLocale(colorPalettePane);
            ResourceBundle resourceBundle = ResourceBundle.getBundle(_RESOURCE, LocaleUtils.getTranslationLocale(locale));
            string = resourceBundle.getString(_KEY_TITLE);
        }
        oLAFDialog.setTitle(string);
        oLAFDialog.setContent(colorPalettePane);
        oLAFDialog.setCenterOver(component);
        oLAFDialog.setResizable(bl);
        return oLAFDialog.runDialog() ? 1 : 2;
    }

    public ColorPalettePane() {
        this(null);
    }

    public ColorPalettePane(TwoDDataSource twoDDataSource) {
        this(twoDDataSource, null, false);
    }

    public ColorPalettePane(TwoDDataSource twoDDataSource, Color color, boolean bl) {
        this(twoDDataSource, color, bl, null);
    }

    public ColorPalettePane(TwoDDataSource twoDDataSource, Color color, boolean bl, TwoDDataSource twoDDataSource2) {
        this._grid.addPropertyChangeListener(this._listener);
        this._label = new LWLabel("");
        this._label.setLabelFor(this._grid);
        this._editButton = new LWButton("");
        this._editButton.setActionCommand(_KEY_EDIT);
        this._editButton.addActionListener(this._listener);
        this._customGrid = new AccessGrid(true);
        this._customGrid.addPropertyChangeListener(this._listener);
        this._customLabel = new LWLabel("");
        this._customLabel.setLabelFor(this._customGrid);
        this._customButtonPanel = new LWContainer(new EqualColumnLayout(5));
        this._colorName = new LWLabel("");
        this._colorNameLabel = new LWLabel("");
        this._colorNameComponent = new LWContainer();
        this._colorNameComponent.setLayout(new BorderLayout(5, 5));
        this._colorNameComponent.add("West", this._colorNameLabel);
        this._colorNameComponent.add("Center", this._colorName);
        this.setLayout(new BorderLayout(5, 5));
        LWContainer lWContainer = new LWContainer();
        lWContainer.setLayout(new BorderLayout(0, 3));
        lWContainer.add("North", this._customLabel);
        LWContainer lWContainer2 = new LWContainer();
        lWContainer2.setLayout(new BorderLayout(0, 3));
        lWContainer2.add("North", this._customGrid);
        lWContainer2.add("Center", this._editButton);
        lWContainer.add("Center", lWContainer2);
        LWContainer lWContainer3 = new LWContainer();
        lWContainer3.setLayout(new BorderLayout(0, 5));
        lWContainer3.add("North", this._grid);
        lWContainer3.add("South", lWContainer);
        LWContainer lWContainer4 = new LWContainer();
        lWContainer4.setLayout(new BorderLayout(5, 5));
        lWContainer4.add("West", lWContainer3);
        LWContainer lWContainer5 = new LWContainer();
        lWContainer5.setLayout(new BorderLayout(5, 5));
        lWContainer5.add("North", this._customButtonPanel);
        lWContainer4.add("Center", lWContainer5);
        this.add("North", this._label);
        this.add("Center", lWContainer4);
        this.add("South", this._colorNameComponent);
        this.setColorNameVisible(false);
        this.setColorPalette(twoDDataSource);
        this.setCustomColorsVisible(twoDDataSource2 != null);
        this.setCustomColorPalette(twoDDataSource2);
        this.setSelectedColor(color);
        this.setEditVisible(bl);
    }

    public void setColorPalette(TwoDDataSource twoDDataSource) {
        this._grid.setColorPalette(twoDDataSource);
    }

    public TwoDDataSource getColorPalette() {
        return this._grid.getColorPalette();
    }

    public void setCustomColorPalette(TwoDDataSource twoDDataSource) {
        TwoDDataSource twoDDataSource2 = this._customGrid.getColorPalette();
        TwoDDataSource twoDDataSource3 = twoDDataSource;
        if (twoDDataSource == null) {
            twoDDataSource = NullTwoDDataSource.getTwoDDataSource();
        }
        this._customGrid.setColorPalette(twoDDataSource);
        this.firePropertyChange(PROPERTY_COLOR_PALETTE, twoDDataSource2, twoDDataSource);
    }

    public TwoDDataSource getCustomColorPalette() {
        TwoDDataSource twoDDataSource = this._customGrid.getColorPalette();
        if (twoDDataSource == NullTwoDDataSource.getTwoDDataSource()) {
            twoDDataSource = null;
        }
        return twoDDataSource;
    }

    public void setEditVisible(boolean bl) {
        this._editButton.setVisible(bl);
        this._revalidate();
    }

    public boolean isEditVisible() {
        return this._editButton.isVisible();
    }

    public void setSelectedColor(Color color) {
        this.setSelectedColor(color, false);
    }

    public Color getSelectedColor() {
        if (this.isCustomColorSelected()) {
            return this._customGrid.getSelectedColor();
        }
        return this._grid.getSelectedColor();
    }

    public boolean isCustomColorSelected() {
        return this._customGrid.isVisible() && this._customGrid.getSelectedColumn() != -1 && this._customGrid.getSelectedRow() != -1;
    }

    public void setSelectedColor(Color color, boolean bl) {
        if (bl) {
            this._customGrid.setSelectedColor(color);
        } else {
            this._grid.setSelectedColor(color);
        }
        this._updateEditButton();
    }

    public void setColorNames(TwoDDataSource twoDDataSource) {
        if (this._names != twoDDataSource) {
            if (this._names != null) {
                this._names.removeDataSourceListener(this._listener);
            }
            this._names = twoDDataSource;
            if (this._names != null) {
                this._names.addDataSourceListener(this._listener);
            }
        }
    }

    public TwoDDataSource getColorNames() {
        return this._names;
    }

    public void setCustomColorNames(TwoDDataSource twoDDataSource) {
        if (this._customNames != twoDDataSource) {
            if (this._customNames != null) {
                this._customNames.removeDataSourceListener(this._listener);
            }
            this._customNames = twoDDataSource;
            if (this._customNames != null) {
                this._customNames.addDataSourceListener(this._listener);
            }
        }
    }

    public TwoDDataSource getCustomColorNames() {
        return this._customNames;
    }

    public void setColorName(String string) {
        Color color = this.getSelectedColor();
        if (color != null) {
            this._colorName.setText(string);
            boolean bl = this.isCustomColorSelected();
            TwoDDataSource twoDDataSource = bl ? this.getCustomColorNames() : this.getColorNames();
            ColorGrid colorGrid = bl ? this._customGrid : this._grid;
            int n = colorGrid.getSelectedColumn();
            int n2 = colorGrid.getSelectedRow();
            if (n != -1 && n2 != -1 && twoDDataSource != null && n < twoDDataSource.getColumnCount() && n2 < twoDDataSource.getRowCount()) {
                twoDDataSource.setData(n, n2, string);
            }
        }
    }

    public String getColorName() {
        return this._colorName.getText();
    }

    public void setCustomColorsVisible(boolean bl) {
        this._customLabel.setVisible(bl);
        this._customGrid.setVisible(bl);
        this._revalidate();
    }

    public boolean isCustomColorsVisible() {
        return this._customGrid.isVisible();
    }

    public void setColorNameVisible(boolean bl) {
        this._colorNameComponent.setVisible(bl);
        this._revalidate();
    }

    public boolean isColorNameVisible() {
        return this._colorNameComponent.isVisible();
    }

    public void addCustomComponent(Component component) {
        this._customButtonPanel.add(component);
        this._revalidate();
    }

    public void removeCustomComponent(Component component) {
        this._customButtonPanel.remove(component);
        this._revalidate();
    }

    public int getCustomComponentCount() {
        return this._customButtonPanel.getComponentCount();
    }

    public Component getCustomComponent(int n) {
        return this._customButtonPanel.getComponent(n);
    }

    public ColorChooserPane getColorChooserPane() {
        if (this._colorChooserPane == null) {
            this._colorChooserPane = new ColorChooserPane();
        }
        return this._colorChooserPane;
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this._propertyChangeSupport == null) {
            this._propertyChangeSupport = new PropertyChangeSupport(this);
        }
        this._propertyChangeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this._propertyChangeSupport != null) {
            this._propertyChangeSupport.removePropertyChangeListener(propertyChangeListener);
        }
    }

    @Override
    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this._grid.setEnabled(bl);
        this._customGrid.setEnabled(bl);
        this._updateEditButton();
        this._label.setEnabled(bl);
        this._customLabel.setEnabled(bl);
        this._colorNameLabel.setEnabled(bl);
        this._colorName.setEnabled(bl);
    }

    @Override
    public void addNotify() {
        super.addNotify();
        Font font = this._colorNameLabel.getFont();
        if (font != null && !font.isBold()) {
            int n = font.getStyle() | 1;
            font = new Font(font.getName(), n, font.getSize());
            this._colorNameLabel.setFont(font);
        }
        this._setText(this.getLocale());
    }

    @Override
    protected void firePropertyChange(String string, Object object, Object object2) {
        if (this._propertyChangeSupport != null) {
            this._propertyChangeSupport.firePropertyChange(string, object, object2);
        }
    }

    @Override
    protected AccessibleContext createAccessibleContext() {
        return new AccessibleLWComponent(this);
    }

    @Override
    protected void updateLocale(Locale locale, Locale locale2) {
        super.updateLocale(locale, locale2);
        this._setText(locale);
    }

    private void _setText(Locale locale) {
        ResourceBundle resourceBundle = ResourceBundle.getBundle(_RESOURCE, LocaleUtils.getTranslationLocale(LocaleUtils.getDefaultableLocale(this)));
        String string = resourceBundle.getString(_KEY_LABEL);
        this._label.setText(StringUtils.stripMnemonic(string));
        this._label.setMnemonicIndex(StringUtils.getMnemonicIndex(string));
        string = resourceBundle.getString(_KEY_EDIT);
        this._editButton.setLabel(StringUtils.stripMnemonic(string));
        this._editButton.setMnemonicIndex(StringUtils.getMnemonicIndex(string));
        string = resourceBundle.getString(_KEY_CUSTOM_LABEL);
        this._customLabel.setText(StringUtils.stripMnemonic(string));
        this._customLabel.setMnemonicIndex(StringUtils.getMnemonicIndex(string));
        string = resourceBundle.getString(_KEY_COLOR_NAME);
        this._colorNameLabel.setText(StringUtils.stripMnemonic(string));
    }

    private void _updateEditButton() {
        boolean bl = this.isCustomColorSelected() && this.isEnabled();
        this._editButton.setEnabled(bl);
    }

    private void _updateColorName() {
        String string = null;
        boolean bl = this.isCustomColorSelected();
        TwoDDataSource twoDDataSource = bl ? this.getCustomColorNames() : this.getColorNames();
        ColorGrid colorGrid = bl ? this._customGrid : this._grid;
        int n = colorGrid.getSelectedColumn();
        int n2 = colorGrid.getSelectedRow();
        if (n != -1 && n2 != -1 && twoDDataSource != null && n < twoDDataSource.getColumnCount() && n2 < twoDDataSource.getRowCount()) {
            Object object = twoDDataSource.getData(n, n2);
            string = object instanceof String ? object.toString() : null;
        }
        this._colorName.setText(string);
    }

    private void _editColor() {
        ColorChooserPane colorChooserPane = this.getColorChooserPane();
        String string = this.getColorName();
        Color color = this.getSelectedColor();
        if (color == null) {
            color = Color.gray;
        }
        colorChooserPane.setOriginalColor(color);
        colorChooserPane.setColor(color);
        colorChooserPane.setColorNameVisible(this.isColorNameVisible());
        colorChooserPane.setColorName(string);
        if (ColorChooserPane.showDialog(this, colorChooserPane) == 1) {
            String string2;
            Color color2 = this._customGrid.getSelectedColor();
            Color color3 = colorChooserPane.getColor();
            this._customGrid.replaceSelectedColor(color3);
            this.firePropertyChange(PROPERTY_COLOR_PALETTE, null, this.getColorPalette());
            this.firePropertyChange(PROPERTY_SELECTED_COLOR, color2, color3);
            if (this.isColorNameVisible() && string != (string2 = colorChooserPane.getColorName())) {
                this.setColorName(string2);
            }
        }
    }

    private void _selectedColorChanged(ColorGrid colorGrid, Color color, Color color2) {
        boolean bl;
        if (this._ignoreEvents) {
            return;
        }
        this._updateEditButton();
        this._updateColorName();
        boolean bl2 = bl = colorGrid.getSelectedColumn() != -1 && colorGrid.getSelectedRow() != -1;
        if (bl) {
            this._ignoreEvents = true;
            if (colorGrid == this._grid) {
                this._customGrid.setSelectedColor(null);
            } else {
                this._grid.setSelectedColor(null);
            }
            this._ignoreEvents = false;
            this.repaint();
        }
        this.firePropertyChange(PROPERTY_SELECTED_COLOR, color, color2);
    }

    private void _revalidate() {
        this.invalidate();
        this.repaint();
    }

    private class Listener
    extends TwoDDataSourceAdapter
    implements ActionListener,
    PropertyChangeListener {
        private Listener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if (ColorPalettePane.PROPERTY_SELECTED_COLOR.equals(string)) {
                ColorPalettePane.this._selectedColorChanged((ColorGrid)propertyChangeEvent.getSource(), (Color)propertyChangeEvent.getOldValue(), (Color)propertyChangeEvent.getNewValue());
            }
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (ColorPalettePane._KEY_EDIT.equals(string)) {
                ColorPalettePane.this._editColor();
            }
        }

        @Override
        public void rowsAdded(TwoDDataSourceEvent twoDDataSourceEvent) {
            ColorPalettePane.this._updateColorName();
        }

        @Override
        public void rowsRemoved(TwoDDataSourceEvent twoDDataSourceEvent) {
            ColorPalettePane.this._updateColorName();
        }

        @Override
        public void invalidateRows(TwoDDataSourceEvent twoDDataSourceEvent) {
            ColorPalettePane.this._updateColorName();
        }

        @Override
        public void columnsAdded(TwoDDataSourceEvent twoDDataSourceEvent) {
            ColorPalettePane.this._updateColorName();
        }

        @Override
        public void columnsRemoved(TwoDDataSourceEvent twoDDataSourceEvent) {
            ColorPalettePane.this._updateColorName();
        }

        @Override
        public void invalidateColumns(TwoDDataSourceEvent twoDDataSourceEvent) {
            ColorPalettePane.this._updateColorName();
        }

        @Override
        public void invalidateCells(TwoDDataSourceEvent twoDDataSourceEvent) {
            ColorPalettePane.this._updateColorName();
        }
    }

    private class AccessGrid
    extends ColorGrid {
        private boolean _custom;

        public AccessGrid(boolean bl) {
            this._custom = bl;
        }

        @Override
        protected String getAccessibleName(int n, int n2, Color color) {
            String string = null;
            if (this._custom) {
                TwoDDataSource twoDDataSource = ColorPalettePane.this.getCustomColorNames();
                if (twoDDataSource != null) {
                    Object object = twoDDataSource.getData(n, n2);
                    string = object != null ? object.toString() : null;
                }
            } else {
                TwoDDataSource twoDDataSource = ColorPalettePane.this.getColorNames();
                if (twoDDataSource != null) {
                    Object object = twoDDataSource.getData(n, n2);
                    String string2 = string = object != null ? object.toString() : null;
                }
            }
            if (string == null) {
                string = super.getAccessibleName(n, n2, color);
            }
            return string;
        }
    }
}

