/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.color;

import java.awt.Color;
import java.awt.Component;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.accessibility.AccessibleContext;
import oracle.ewt.color.ColorEditor;
import oracle.ewt.lwAWT.LWContainer;
import oracle.ewt.util.LocaleUtils;

abstract class BaseColorEditor
extends LWContainer
implements ColorEditor {
    private static final String _RESOURCE = "oracle.ewt.color.resource.ColorBundle";
    private static final String _ACCESS_RESOURCE = "oracle.ewt.access.resource.AccessibilityBundle";
    private Color _color;
    private PropertyChangeSupport _propertyChangeSupport;

    BaseColorEditor() {
    }

    @Override
    public void setColor(Color color) {
        if (this._color != color) {
            this._color = color;
            this.colorChanged(color);
            this.repaint();
        }
    }

    @Override
    public Color getColor() {
        if (this._color == null) {
            this._color = Color.black;
        }
        return this._color;
    }

    @Override
    public Component getComponent() {
        return this;
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this._propertyChangeSupport == null) {
            this._propertyChangeSupport = new PropertyChangeSupport(this);
        }
        this._propertyChangeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this._propertyChangeSupport != null) {
            this._propertyChangeSupport.removePropertyChangeListener(propertyChangeListener);
        }
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.updateLabels(this.getLocale());
    }

    protected void storeColor(Color color) {
        Color color2 = this._color;
        this._color = color;
        this.fireColorPropertyChange(color2, this._color);
    }

    protected void colorChanged(Color color) {
    }

    protected void fireColorPropertyChange(Color color, Color color2) {
        if (this._propertyChangeSupport != null) {
            this._propertyChangeSupport.firePropertyChange("color", color, color2);
        }
    }

    protected void updateLabels(Locale locale) {
    }

    protected void updateAccessibleNames() {
    }

    @Override
    protected void updateLocale(Locale locale, Locale locale2) {
        super.updateLocale(locale, locale2);
        this.updateLabels(locale);
    }

    @Override
    protected AccessibleContext createAccessibleContext() {
        this.updateAccessibleNames();
        return super.createAccessibleContext();
    }

    static String __getTranslatedString(Locale locale, String string) {
        ResourceBundle resourceBundle = ResourceBundle.getBundle(_RESOURCE, LocaleUtils.getTranslationLocale(locale));
        return resourceBundle.getString(string);
    }

    String __getTranslatedString(String string) {
        return BaseColorEditor.__getTranslatedString(LocaleUtils.getDefaultableLocale(this), string);
    }
}

