/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.alert;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import oracle.ewt.alert.AlertPane;
import oracle.ewt.alert.BaseAlert;
import oracle.ewt.alert.BaseAlertPane;
import oracle.ewt.button.PushButton;
import oracle.ewt.event.HelpListener;

public class Alert
extends BaseAlert {
    public static final int BUTTON_YES = 1;
    public static final int BUTTON_NO = 2;
    public static final int BUTTON_CANCEL = 4;
    public static final int BUTTON_HELP = 8;
    public static final int BUTTON_USER = 0;

    public Alert(int n, int n2) {
        this((Frame)null, "", n, n2);
    }

    public Alert(String string, int n, int n2) {
        this((Frame)null, string, n, n2);
    }

    public Alert(Frame frame, int n, int n2) {
        this(frame, "", n, n2);
    }

    public Alert(Dialog dialog, String string, int n, int n2) {
        this((Frame)dialog.getParent(), string, n, n2);
    }

    public Alert(Frame frame, String string, int n, int n2) {
        super(frame, string, n);
        AlertPane alertPane = this.getAlertPane();
        alertPane.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Alert.this.dismissAlert((Component)actionEvent.getSource());
            }
        });
        alertPane.createButtons(n2);
    }

    public final AlertPane getAlertPane() {
        return (AlertPane)this.getPane();
    }

    @Override
    protected BaseAlertPane createPane(String string, int n) {
        return new AlertPane(string, n);
    }

    public int runAlert() {
        this.setVisible(true);
        return this.getAlertPane().whichButton(this.getPressed());
    }

    public String getButtonLabel(int n) {
        return this.getAlertPane().getButtonLabel(n);
    }

    public void setButtonLabel(int n, String string) {
        this.getAlertPane().setButtonLabel(n, string);
    }

    public void setButtonMnemonicIndex(int n, int n2) {
        this.getAlertPane().setButtonMnemonicIndex(n, n2);
    }

    public int getButtonMnemonicIndex(int n) {
        return this.getAlertPane().getButtonMnemonicIndex(n);
    }

    public void setButtonMnemonicChar(int n, char c) {
        this.getAlertPane().setButtonMnemonicChar(n, c);
    }

    public char getButtonMnemonicChar(int n) {
        return this.getAlertPane().getButtonMnemonicChar(n);
    }

    public int getDefaultButton() {
        return this.getAlertPane().getDefaultButton();
    }

    public void setDefaultButton(int n) {
        this.getAlertPane().setDefaultButton(n);
    }

    public synchronized void addHelpListener(HelpListener helpListener) {
        this.getAlertPane().addHelpListener(helpListener);
    }

    public synchronized void removeHelpListener(HelpListener helpListener) {
        this.getAlertPane().removeHelpListener(helpListener);
    }

    public void addDismissButton(String string, PushButton pushButton) {
        pushButton.addActionListener(this.getAlertPane());
        this.getAlertPane().addUserButton(string, pushButton);
    }

    public final void addDismissButton(PushButton pushButton) {
        pushButton.addActionListener(this.getAlertPane());
        this.getAlertPane().addUserButton(pushButton);
    }
}

