/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.access;

import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleState;
import javax.accessibility.AccessibleStateSet;
import oracle.ewt.LookAndFeel;
import oracle.ewt.access.AccessibleComponentImpl;
import oracle.ewt.access.AccessibleUtils;
import oracle.ewt.access.OracleAccessibleRole;
import oracle.ewt.lwAWT.LWComponent;
import oracle.ewt.lwAWT.LWLabel;
import oracle.ewt.painter.BorderPainter;
import oracle.ewt.painter.PaintContext;

public class AccessibleLWComponent
extends AccessibleComponentImpl {
    public AccessibleLWComponent(LWComponent lWComponent) {
        super(lWComponent);
    }

    @Override
    public String getAccessibleName() {
        Object object;
        Object object2;
        String string = this.accessibleName;
        LWComponent lWComponent = this._getLWComponent();
        if (string == null) {
            string = this.getBorderTitle(lWComponent);
        }
        if (string == null && (object2 = AccessibleUtils.getLabeledBy(lWComponent)) instanceof Accessible && (object = ((Accessible)object2).getAccessibleContext()) != null) {
            string = ((AccessibleContext)object).getAccessibleName();
        }
        if (string == null) {
            object2 = lWComponent.getPaintContext().getPaintData(PaintContext.LABEL_KEY);
            if (object2 instanceof String) {
                string = (String)object2;
            }
            if (string != null && (object = this.getMnemonicName(lWComponent)) != null) {
                string = string + (String)object;
            }
        }
        if (string != null && !(lWComponent instanceof LWLabel) && (object2 = this._findGroupBoxName()) != null) {
            string = (String)object2 + " " + string;
        }
        return string;
    }

    @Override
    public String getAccessibleDescription() {
        AccessibleContext accessibleContext;
        Object object;
        String string = this.accessibleDescription;
        LWComponent lWComponent = this._getLWComponent();
        if (string == null && (object = lWComponent.getToolTipValue()) instanceof String) {
            string = (String)object;
        }
        if (string == null && (object = AccessibleUtils.getLabeledBy(lWComponent)) instanceof Accessible && (accessibleContext = ((Accessible)object).getAccessibleContext()) != null) {
            string = accessibleContext.getAccessibleDescription();
        }
        return string;
    }

    @Override
    public AccessibleRole getAccessibleRole() {
        LWComponent lWComponent = this._getLWComponent();
        LookAndFeel lookAndFeel = lWComponent.getLookAndFeel();
        if (lookAndFeel.isGroupBoxPainter(lWComponent.getBorderPainter())) {
            return OracleAccessibleRole.GROUP_BOX;
        }
        return AccessibleRole.PANEL;
    }

    @Override
    public AccessibleStateSet getAccessibleStateSet() {
        int n;
        AccessibleStateSet accessibleStateSet = super.getAccessibleStateSet();
        LWComponent lWComponent = this._getLWComponent();
        if (lWComponent.hasFocus()) {
            accessibleStateSet.add(AccessibleState.FOCUSED);
        }
        if (!lWComponent.isTransparent()) {
            accessibleStateSet.add(AccessibleState.OPAQUE);
        }
        if (((n = lWComponent.getPaintContext().getPaintState()) & 8) != 0) {
            accessibleStateSet.add(AccessibleState.CHECKED);
        }
        if ((n & 2) != 0) {
            accessibleStateSet.add(AccessibleState.ARMED);
        }
        return accessibleStateSet;
    }

    protected String getBorderTitle(LWComponent lWComponent) {
        BorderPainter borderPainter = lWComponent.getBorderPainter();
        LookAndFeel lookAndFeel = lWComponent.getLookAndFeel();
        String string = null;
        if (lookAndFeel.isGroupBoxPainter(borderPainter)) {
            string = lookAndFeel.getGroupBoxTitle(borderPainter);
        }
        return string;
    }

    protected String getMnemonicName(LWComponent lWComponent) {
        char c = lWComponent.getMnemonicChar();
        return c != '\u0000' ? " ALT " + c : null;
    }

    private String _findGroupBoxName() {
        AccessibleContext accessibleContext = this;
        Accessible accessible = accessibleContext.getAccessibleParent();
        while (accessible != null) {
            accessibleContext = accessible.getAccessibleContext();
            if (accessibleContext.getAccessibleRole() == OracleAccessibleRole.GROUP_BOX) {
                return accessibleContext.getAccessibleName();
            }
            accessible = accessibleContext.getAccessibleParent();
        }
        return null;
    }

    private LWComponent _getLWComponent() {
        return (LWComponent)this.getComponent();
    }
}

