/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt;

import java.awt.Color;
import java.util.Locale;
import oracle.bali.share.collection.StringKey;
import oracle.ewt.ColorScheme;
import oracle.ewt.UIDefaults;
import oracle.ewt.lwAWT.LWComponent;
import oracle.ewt.painter.BorderPainter;
import oracle.ewt.painter.PaintContext;
import oracle.ewt.painter.Painter;

public abstract class LookAndFeel {
    public static final Object DESKTOP = new StringKey("desktop");
    public static final Object ACTIVE_CAPTION = new StringKey("actionCaption");
    public static final Object ACTIVE_CAPTION_TEXT = new StringKey("activeCaptionText");
    public static final Object ACTIVE_CAPTION_BORDER = new StringKey("activeCaptionBorder");
    public static final Object INACTIVE_CAPTION = new StringKey("inactiveCaption");
    public static final Object INACTIVE_CAPTION_TEXT = new StringKey("inactiveCaptionText");
    public static final Object INACTIVE_CAPTION_BORDER = new StringKey("inactiveCaptionBorder");
    public static final Object DIALOG = new StringKey("dialog");
    public static final Object WINDOW = new StringKey("window");
    public static final Object WINDOW_BORDER = new StringKey("windowBorder");
    public static final Object WINDOW_TEXT = new StringKey("windowText");
    public static final Object MENU = new StringKey("menu");
    public static final Object MENU_TEXT = new StringKey("menuText");
    public static final Object TEXT = new StringKey("text");
    public static final Object TEXT_TEXT = new StringKey("textText");
    public static final Object TEXT_HIGHLIGHT = new StringKey("textHighlight");
    public static final Object TEXT_INACTIVE_HIGHLIGHT = new StringKey("textInactiveHighlight");
    public static final Object TEXT_HIGHLIGHT_TEXT = new StringKey("textHighlightText");
    public static final Object TEXT_INACTIVE_TEXT = new StringKey("textInactiveText");
    public static final Object CONTROL = new StringKey("control");
    public static final Object CONTROL_TEXT = new StringKey("controlText");
    public static final Object CONTROL_HIGHLIGHT = new StringKey("controlHighlight");
    public static final Object CONTROL_LT_HIGHLIGHT = new StringKey("controlLtHighlight");
    public static final Object CONTROL_SHADOW = new StringKey("controlShadow");
    public static final Object CONTROL_DK_SHADOW = new StringKey("controlDkShadow");
    public static final Object SCROLLBAR = new StringKey("scrollbar");
    public static final Object ARROW = new StringKey("arrow");
    public static final Object INFO = new StringKey("info");
    public static final Object INFO_TEXT = new StringKey("infoText");
    public static final Object TOOL_TIP = new StringKey("toolTip");
    public static final Object SELECTED_FOCUS = new StringKey("selectedFocus");
    public static final Object CONTROL_INACTIVE_TEXT = new StringKey("controlInactiveText");
    public static final Object CONTROL_INACTIVE = new StringKey("controlInactive");
    public static final Object SECONDARY_TEXT_HIGHLIGHT = new StringKey("secondaryTextHighlight");
    public static final Object PINSTRIPE1 = new StringKey("pinStripe1");
    public static final Object PINSTRIPE2 = new StringKey("pinStripe2");
    public static final Object PINSTRIPE3 = new StringKey("pinStripe3");
    public static final Object PINSTRIPE4 = new StringKey("pinStripe4");
    public static final Object LIGHT_INTENSITY = new StringKey("lightIntensity");
    public static final Object NORMAL_INTENSITY = new StringKey("normalIntensity");
    public static final Object DARK_INTENSITY = new StringKey("darkIntensity");
    public static final Object VERY_DARK_INTENSITY = new StringKey("veryDarkIntensity");
    public static final Object LIGHT_LOOK = new StringKey("lightLook");
    public static final Object DARK_LOOK = new StringKey("darkLook");
    public static final Object VERY_DARK_LOOK = new StringKey("veryDarkLook");
    public static final Object IMAGE_SET_PAINTER = new StringKey("ImageSetPainter");
    public static final Object IMAGE_PAINTER = new StringKey("ImagePainter");
    public static final Object BACKGROUND_PAINTER = new StringKey("BackgroundPainter");
    public static final Object DISABLING_FILTER = new StringKey("disablingFilter");

    public abstract String getName();

    public abstract String getDisplayName(Locale var1);

    public String getDescription(Locale locale) {
        return null;
    }

    public boolean isNativeLookAndFeel() {
        return false;
    }

    public boolean isSupportedLookAndFeel() {
        return true;
    }

    public final UIDefaults getDefaults() {
        return this.getDefaults((PaintContext)null);
    }

    public final UIDefaults getDefaults(LWComponent lWComponent) {
        PaintContext paintContext = lWComponent != null ? lWComponent.getPaintContext() : null;
        return this.getDefaults(paintContext);
    }

    public abstract UIDefaults getDefaults(PaintContext var1);

    public final BorderPainter createGroupBoxPainter(String string) {
        return this.createGroupBoxPainter(null, string);
    }

    public boolean isGroupBoxPainter(BorderPainter borderPainter) {
        return false;
    }

    public String getGroupBoxTitle(BorderPainter borderPainter) {
        return null;
    }

    public final BorderPainter createGroupBoxPainter(Painter painter, String string) {
        Painter painter2 = string != null && string.length() > 0 ? this.getGroupBoxLabelPainter(string) : null;
        return this.createGroupBoxPainter(painter, painter2);
    }

    public final BorderPainter createGroupBoxPainter(Painter painter) {
        return this.createGroupBoxPainter(null, painter);
    }

    public abstract BorderPainter createGroupBoxPainter(Painter var1, Painter var2);

    protected abstract Painter getGroupBoxLabelPainter(String var1);

    public abstract void setDefaultColorScheme(ColorScheme var1);

    public abstract ColorScheme getDefaultColorScheme();

    public ColorScheme[] getColorSchemes() {
        ColorScheme[] colorSchemeArray = this.getReadOnlyColorSchemes();
        if (colorSchemeArray != null) {
            return (ColorScheme[])colorSchemeArray.clone();
        }
        return null;
    }

    public ColorScheme getColorScheme(ColorScheme colorScheme) {
        if (this.isCompatibleColorScheme(colorScheme)) {
            return colorScheme;
        }
        ColorScheme[] colorSchemeArray = this.getReadOnlyColorSchemes();
        ColorScheme colorScheme2 = LookAndFeel._getColorScheme(colorScheme.getName(), colorSchemeArray);
        if (colorScheme2 == null) {
            colorScheme2 = LookAndFeel._getColorScheme(colorScheme.getDefiningColor(), colorSchemeArray);
        }
        return colorScheme2;
    }

    public ColorScheme getColorScheme(String string) {
        return LookAndFeel._getColorScheme(string, this.getReadOnlyColorSchemes());
    }

    public ColorScheme getColorScheme(Color color) {
        return LookAndFeel._getColorScheme(color, this.getReadOnlyColorSchemes());
    }

    public String toString() {
        return super.toString() + ", name=" + this.getName();
    }

    protected boolean isCompatibleColorScheme(ColorScheme colorScheme) {
        return false;
    }

    protected abstract ColorScheme[] getReadOnlyColorSchemes();

    private static ColorScheme _getColorScheme(String string, ColorScheme[] colorSchemeArray) {
        Object var2_2 = null;
        for (int i = 0; i < colorSchemeArray.length; ++i) {
            ColorScheme colorScheme = colorSchemeArray[i];
            if (!colorScheme.getName().equals(string)) continue;
            return colorScheme;
        }
        return null;
    }

    private static ColorScheme _getColorScheme(Color color, ColorScheme[] colorSchemeArray) {
        int n = color.getRed();
        int n2 = color.getGreen();
        int n3 = color.getBlue();
        ColorScheme colorScheme = null;
        int n4 = Integer.MAX_VALUE;
        for (int i = 0; i < colorSchemeArray.length; ++i) {
            int n5;
            int n6;
            ColorScheme colorScheme2 = colorSchemeArray[i];
            Color color2 = colorScheme2.getDefiningColor();
            int n7 = n - color2.getRed();
            int n8 = n7 * n7 + (n6 = n2 - color2.getGreen()) * n6 + (n5 = n3 - color2.getBlue()) * n5;
            if (n8 == 0) {
                return colorScheme2;
            }
            if (n8 >= n4) continue;
            n4 = n8;
            colorScheme = colorScheme2;
        }
        return colorScheme;
    }
}

