/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.spnego;

import java.io.Serializable;

public class Tag
implements Serializable {
    public static final int UNIVERSAL = 0;
    public static final int APPLICATION = 64;
    public static final int CONTEXT = 128;
    public static final int PRIVATE = 192;
    public static final int BOOLEAN = 1;
    public static final int INTEGER = 2;
    public static final int BIT_STRING = 3;
    public static final int OCTET_STRING = 4;
    public static final int NULL = 5;
    public static final int OBJECT_IDENTIFIER = 6;
    public static final int REAL = 9;
    public static final int ENUMERATED = 10;
    public static final int SEQUENCE = 16;
    public static final int SEQUENCE_OF = 16;
    public static final int SET = 17;
    public static final int SET_OF = 17;
    public static final int NUMERIC_STRING = 18;
    public static final int PRINTABLE_STRING = 19;
    public static final int T61_STRING = 20;
    public static final int VIDEOTEX_STRING = 21;
    public static final int IA5_STRING = 22;
    public static final int GRAPHIC_STRING = 25;
    public static final int ISO646_STRING = 26;
    public static final int GENERAL_STRING = 27;
    public static final int UNIVERSAL_STRING = 28;
    public static final int BMP_STRING = 30;
    public static final int UTC_TIME = 23;
    public static final int GENERALIZED_TIME = 24;
    int clazz;
    int value;
    boolean explicit;
    boolean constructed;

    public Tag(int clazz, int value, boolean explicit, boolean constructed) {
        this.clazz = clazz;
        this.value = value;
        this.explicit = explicit;
        this.constructed = constructed;
    }

    public Tag(int clazz, int value, boolean explicit) {
        this(clazz, value, explicit, false);
    }

    public Tag(int clazz, int value) {
        this(clazz, value, true, false);
    }

    public Tag(int value, boolean explicit) {
        this(0, value, explicit, false);
    }

    public Tag(int value) {
        this(0, value, true, false);
    }

    private Tag(Tag that) {
        this(that.clazz, that.value, that.explicit, that.constructed);
    }

    public Object clone() {
        return new Tag(this);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Tag)) {
            return false;
        }
        Tag that = (Tag)obj;
        if (this.getClazz() != that.getClazz()) {
            return false;
        }
        return this.getValue() == that.getValue();
    }

    public int getClazz() {
        return this.clazz;
    }

    public int getValue() {
        return this.value;
    }

    public boolean isExplicit() {
        return this.explicit;
    }

    public boolean isConstructed() {
        return this.constructed;
    }

    public boolean isUniversal() {
        return this.clazz == 0;
    }

    public String toString() {
        StringBuffer result = new StringBuffer("<Tag class=\"");
        switch (this.clazz) {
            case 0: {
                result.append("UNIVERSAL");
                break;
            }
            case 64: {
                result.append("APPLICATION");
                break;
            }
            case 128: {
                result.append("CONTEXT");
                break;
            }
            case 192: {
                result.append("PRIVATE");
                break;
            }
            default: {
                result.append(this.clazz);
            }
        }
        result.append("\" value=\"");
        if (this.clazz == 128) {
            result.append(this.value);
        } else {
            switch (this.value) {
                case 1: {
                    result.append("BOOLEAN");
                    break;
                }
                case 2: {
                    result.append("INTEGER");
                    break;
                }
                case 3: {
                    result.append("BIT STRING");
                    break;
                }
                case 4: {
                    result.append("OCTET STRING");
                    break;
                }
                case 5: {
                    result.append("NULL");
                    break;
                }
                case 6: {
                    result.append("OBJECT IDENTIFIER");
                    break;
                }
                case 10: {
                    result.append("ENUMERATED");
                    break;
                }
                case 16: {
                    result.append("SEQUENCE [OF]");
                    break;
                }
                case 17: {
                    result.append("SET [OF]");
                    break;
                }
                case 18: {
                    result.append("NumericString");
                    break;
                }
                case 19: {
                    result.append("PrintableString");
                    break;
                }
                case 20: {
                    result.append("TeletexString");
                    break;
                }
                case 21: {
                    result.append("VideotexString");
                    break;
                }
                case 22: {
                    result.append("IA5String");
                    break;
                }
                case 25: {
                    result.append("GraphicString");
                    break;
                }
                case 26: {
                    result.append("VisibleString");
                    break;
                }
                case 27: {
                    result.append("GeneralString");
                    break;
                }
                case 28: {
                    result.append("UniversalString");
                    break;
                }
                case 30: {
                    result.append("BMPString");
                    break;
                }
                case 23: {
                    result.append("UTCTime");
                    break;
                }
                case 24: {
                    result.append("GeneralizedTime");
                    break;
                }
                default: {
                    result.append(this.value);
                }
            }
        }
        result.append("\" explicit=\"").append(String.valueOf(this.explicit));
        result.append("\" constructed=\"").append(String.valueOf(this.constructed)).append("\" />");
        return result.toString();
    }
}

