/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.spnego;

import java.io.EOFException;
import java.io.IOException;
import java.math.BigInteger;
import oracle.security.spnego.ASNException;
import oracle.security.spnego.ASNReader;
import oracle.security.spnego.ASNWriter;
import oracle.security.spnego.IType;
import oracle.security.spnego.Tag;
import oracle.security.spnego.Type;

public class BitString
extends Type
implements IType {
    public BitString() {
        super("", new Tag(3));
    }

    public BitString(String name) {
        super(name, new Tag(3));
    }

    public BitString(String name, Tag tag) {
        super(name, tag);
    }

    public BitString(String name, Object value) {
        this(name, new Tag(3), value);
    }

    public BitString(String name, Tag tag, Object value) {
        super(name, tag);
        if (value != null) {
            this.value = (byte[])((byte[])value).clone();
        }
        if (this.value != null) {
            this.defaultValue(this.value);
        }
    }

    public static BitString getInstance(byte[] value) {
        return new BitString("", value);
    }

    @Override
    public void decode(ASNReader is) throws IOException {
        is.mark(Integer.MAX_VALUE);
        try {
            byte[] result = is.decodeBitString(this);
            if (result == null) {
                throw new ASNException(1, "Decoding BIT STRING");
            }
            this.value(result);
        }
        catch (IOException x) {
            if (x instanceof ASNException || x instanceof EOFException) {
                is.reset();
            }
            throw x;
        }
    }

    @Override
    public void encode(ASNWriter os) throws IOException {
        String cn = this.getClass().getName();
        Object val = this.value();
        if (val != null) {
            os.encodeBitString(this, (byte[])val);
        } else {
            val = this.defaultValue();
            if (val != null) {
                os.encodeBitString(this, (byte[])val);
            } else if (!this.isOptional()) {
                throw new ASNException(0, "Encoding BIT STRING");
            }
        }
    }

    public byte[] byteArrayValue() {
        if (this.value != null) {
            if (this.value instanceof BitString) {
                return ((BitString)this.value).byteArrayValue();
            }
            return (byte[])this.value;
        }
        return null;
    }

    @Override
    protected boolean sameValue(Object obj) {
        byte[] other;
        if (obj == null) {
            return false;
        }
        try {
            other = (byte[])obj;
        }
        catch (ClassCastException x) {
            return false;
        }
        byte[] val = this.byteArrayValue();
        if (val == null) {
            return false;
        }
        if (val.length != other.length) {
            return false;
        }
        for (int i = 0; i < val.length; ++i) {
            if (val[i] == other[i]) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("-- ");
        if (this.value != null) {
            sb.append(new BigInteger(1, this.byteArrayValue()).toString(2));
        } else {
            sb.append("N/A");
        }
        return sb.toString();
    }
}

