/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.explorer;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.accessibility.Accessible;
import javax.swing.AbstractButton;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import oracle.ide.Context;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.IdeActions;
import oracle.ide.controls.ToggleAction;
import oracle.ide.controls.Toolbar;
import oracle.ide.db.model.DBObjectNode;
import oracle.ide.db.model.DBObjectNodeUtil;
import oracle.ide.db.model.DBObjectTypeNode;
import oracle.ide.model.DefaultFolder;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.model.Observer;
import oracle.ide.model.TextNode;
import oracle.ide.model.UpdateMessage;
import oracle.ide.util.AccessibleUtils;
import oracle.ide.util.IdeUtil;
import oracle.ide.view.View;
import oracle.ideimpl.db.explorer.ErrorSupport;
import oracle.ideimpl.db.explorer.model.DBObjectFolderFactory;
import oracle.ideimpl.explorer.BaseTreeExplorer;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.buffer.TextBufferListener;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectCriteria;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.SystemObject;
import oracle.javatools.db.event.DBObjectChange;
import oracle.javatools.db.event.DBObjectListener;

abstract class BaseDBObjectExplorer
extends BaseTreeExplorer {
    private Node m_node;
    private Element m_root;
    private L m_listener;
    private final Timer m_timer;
    private final Object m_listenerLock = new Object();
    private final Controller m_controller = new C();
    private AbstractButton m_refreshButton;

    public BaseDBObjectExplorer() {
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (BaseDBObjectExplorer.this.m_node != null) {
                    BaseDBObjectExplorer.this.update();
                }
                if (BaseDBObjectExplorer.this.m_timer != null) {
                    BaseDBObjectExplorer.this.m_timer.stop();
                }
            }
        };
        this.m_timer = new Timer(500, actionListener);
        this.m_timer.setRepeats(false);
    }

    public void setContext(Context context) {
        super.setContext(context);
        if (context != null && context.getNode() instanceof DBObjectNode) {
            Node node = context.getNode();
            String string = node.getShortLabel();
            if (this.tree != null) {
                AccessibleUtils.updateAccessibleName((Accessible)this.tree, (String)string, (boolean)true);
            }
        }
    }

    protected boolean supportsRefresh() {
        return DBObjectNodeUtil.isOnlineNode((Object)this.m_node);
    }

    private void addToolbarItems() {
        Toolbar toolbar;
        if (this.supportsRefresh() && (toolbar = this.owner().getToolbar()) != null) {
            if (this.m_refreshButton == null) {
                this.m_refreshButton = toolbar.add((ToggleAction)IdeActions.getViewRefreshAction().newLocalAction((View)this));
            } else {
                toolbar.add((Component)this.m_refreshButton);
            }
        }
    }

    private void removeToolbarItems() {
        Toolbar toolbar = this.owner().getToolbar();
        if (toolbar != null && this.m_refreshButton != null) {
            toolbar.remove((Component)this.m_refreshButton);
        }
    }

    private void destroyToolbarItems() {
        this.removeToolbarItems();
        if (this.m_refreshButton != null) {
            this.m_refreshButton.setAction(null);
            this.m_refreshButton = null;
        }
    }

    public void stateChanged(int n) {
        if (n == 0) {
            this.startObserving();
            this.addToolbarItems();
            this.scheduleUpdate();
        } else {
            this.stopObserving();
            if (n == 1) {
                this.removeToolbarItems();
            } else if (n == 2) {
                this.destroyToolbarItems();
            }
        }
    }

    protected Element annotate(Context context) {
        Node node;
        boolean bl = true;
        Node node2 = node = context == null ? null : context.getNode();
        if (node instanceof DBObjectNode) {
            if (this.m_node == node) {
                bl = false;
            } else {
                Element element = this.createRootElement((DBObjectNode)node, context);
                if (element != null) {
                    bl = false;
                    this.stopObserving();
                    this.m_node = node;
                    this.m_root = element;
                    this.expandTree();
                }
            }
        }
        if (bl) {
            this.stopObserving();
            this.m_root = new DefaultFolder();
            this.m_node = null;
        }
        return this.m_root;
    }

    protected Element createRootElement(DBObjectNode dBObjectNode, Context context) {
        return DBObjectFolderFactory.createRootFolder(dBObjectNode, context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopObserving() {
        Object object = this.m_listenerLock;
        synchronized (object) {
            Node node = this.m_node;
            this.m_timer.stop();
            ErrorSupport.getInstance().stopObserving((DBObjectNode)node);
            if (this.m_listener != null) {
                this.m_listener.detach();
                this.m_listener = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startObserving() {
        this.stopObserving();
        Object object = this.m_listenerLock;
        synchronized (object) {
            Node node = this.m_node;
            if (node != null) {
                this.m_listener = new L(node);
                ErrorSupport.getInstance().startObserving((DBObjectNode)node, this.m_root);
            }
        }
    }

    protected boolean updateTreeForMessage(UpdateMessage updateMessage) {
        int n = updateMessage.getMessageID();
        return n == UpdateMessage.OBJECT_OPENED || n == UpdateMessage.OBJECT_RELOADED || n == UpdateMessage.STRUCTURE_CHANGED;
    }

    private final void scheduleUpdate() {
        this.m_timer.restart();
    }

    protected void update() {
        if (this.m_root != null) {
            DBObjectFolderFactory.update(this.m_root);
            ErrorSupport.getInstance().update((DBObjectNode)this.m_node, this.m_root);
        }
    }

    protected int getAutoExpandDepth(Node node) {
        return 2;
    }

    private void expandTree() {
        int n;
        if (this.tree != null && (n = this.getAutoExpandDepth(this.m_node)) > 0) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    IdeUtil.expandTreeToDepth((JTree)BaseDBObjectExplorer.this.tree, (int)n);
                }
            });
        }
    }

    public Controller getController() {
        return this.m_controller;
    }

    private class C
    implements Controller {
        private C() {
        }

        public boolean handleEvent(IdeAction ideAction, Context context) {
            boolean bl = false;
            if (ideAction.getCommandId() == 51) {
                BaseDBObjectExplorer.this.scheduleUpdate();
                bl = true;
            }
            return bl;
        }

        public boolean update(IdeAction ideAction, Context context) {
            boolean bl = false;
            if (ideAction.getCommandId() == 51) {
                ideAction.setEnabled(BaseDBObjectExplorer.this.supportsRefresh());
                bl = true;
            }
            return bl;
        }
    }

    private class L
    extends DBObjectListener
    implements TextBufferListener,
    Observer {
        private Node m_listenerNode;
        private SystemObject m_listenerObj;
        private DBObjectProvider m_listenerPro;

        public L(Node node) {
            this.m_listenerNode = node;
            this.m_listenerNode.attach((Observer)this);
            if (this.m_listenerNode instanceof TextNode) {
                ((TextNode)this.m_listenerNode).addTextBufferListener((TextBufferListener)this);
            }
            Object var3_3 = null;
            Object var4_4 = null;
            if (this.m_listenerNode instanceof DBObjectNode) {
                if (DBObjectNodeUtil.isOnlineNode((Object)this.m_listenerNode)) {
                    String string;
                    this.m_listenerPro = DBObjectNodeUtil.findProvider((Object)this.m_listenerNode);
                    if (this.m_listenerPro != null && this.m_listenerPro.supportsObjectType(string = DBObjectNodeUtil.normalizeType((DBObjectTypeNode)((DBObjectNode)this.m_listenerNode)))) {
                        DBObjectCriteria dBObjectCriteria = DBObjectCriteria.createSingleObjectCriteria((String)string, (String)DBObjectNodeUtil.getSchemaName((DBObjectTypeNode)((DBObjectNode)this.m_listenerNode)), (String)((DBObjectNode)this.m_listenerNode).getObjectName());
                        this.m_listenerPro.addObjectListener((DBObjectListener)this, dBObjectCriteria);
                    }
                } else {
                    DBObject dBObject = ((DBObjectNode)this.m_listenerNode).getDBObject();
                    if (dBObject instanceof SystemObject) {
                        this.m_listenerObj = (SystemObject)dBObject;
                        this.m_listenerObj.addObjectListener((DBObjectListener)this);
                    }
                }
            }
        }

        public void detach() {
            this.m_listenerNode.detach((Observer)this);
            if (this.m_listenerNode instanceof TextNode) {
                ((TextNode)this.m_listenerNode).removeTextBufferListener((TextBufferListener)this);
            }
            if (this.m_listenerObj != null) {
                this.m_listenerObj.removeObjectListener((DBObjectListener)this);
            }
            if (this.m_listenerPro != null) {
                this.m_listenerPro.removeObjectListener((DBObjectListener)this);
            }
        }

        public void removeUpdate(TextBuffer textBuffer, int n, int n2, char[] cArray) {
            BaseDBObjectExplorer.this.scheduleUpdate();
        }

        public void insertUpdate(TextBuffer textBuffer, int n, int n2, char[] cArray) {
            BaseDBObjectExplorer.this.scheduleUpdate();
        }

        public void attributeUpdate(TextBuffer textBuffer, int n) {
        }

        public void update(Object object, UpdateMessage updateMessage) {
            if (BaseDBObjectExplorer.this.updateTreeForMessage(updateMessage)) {
                BaseDBObjectExplorer.this.scheduleUpdate();
            }
        }

        public void objectUpdated(DBObjectChange dBObjectChange) {
            BaseDBObjectExplorer.this.scheduleUpdate();
        }
    }
}

