/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.commands;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.sql.Connection;
import java.util.Map;
import oracle.dbtools.DataPumpResources;
import oracle.dbtools.commands.DataPumpOptions;
import oracle.dbtools.commands.SetDataPumpOptions;
import oracle.dbtools.common.DataPumpArguments;
import oracle.dbtools.common.DataPumpModel;
import oracle.dbtools.datapump.help.Messages;
import oracle.dbtools.db.ConnectionResolver;
import oracle.dbtools.exceptions.ProcessFailedException;
import oracle.dbtools.executors.DataPumpExecutor;
import oracle.dbtools.executors.DataPumpTransfer;
import oracle.dbtools.extension.SQLCLService;
import oracle.dbtools.generators.DataPumpGenerator;
import oracle.dbtools.generators.DataPumpPreprocessor;
import oracle.dbtools.raptor.newscriptrunner.CommandListener;
import oracle.dbtools.raptor.newscriptrunner.IHelp;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.ScriptUtils;
import oracle.dbtools.raptor.newscriptrunner.commands.Connected;
import oracle.dbtools.raptor.newscriptrunner.parameterparser.CommandParserConstants;
import oracle.dbtools.raptor.newscriptrunner.parameterparser.Help.CommandHelp;
import oracle.dbtools.raptor.newscriptrunner.parameterparser.exception.CommandHelpClassException;
import oracle.dbtools.raptor.newscriptrunner.parameterparser.exception.CommandOptionsClassException;
import oracle.dbtools.raptor.newscriptrunner.parameterparser.exception.ConnectionNotValidException;
import oracle.dbtools.raptor.newscriptrunner.parameterparser.exception.ExtraParameterException;
import oracle.dbtools.raptor.newscriptrunner.parameterparser.exception.InvalidCommandException;
import oracle.dbtools.raptor.newscriptrunner.parameterparser.exception.MissingRequiredParameterException;
import oracle.dbtools.raptor.newscriptrunner.parameterparser.exception.ParameterFailedValidationException;
import oracle.dbtools.raptor.newscriptrunner.parameterparser.interfaces.ICommandSyntax;
import oracle.dbtools.raptor.newscriptrunner.parameterparser.parameter.StandardParameter;
import oracle.dbtools.raptor.newscriptrunner.parameterparser.parser.CommandParser;
import oracle.dbtools.raptor.utils.ToolLogger;
import oracle.dbtools.raptor.utils.ToolLoggerResources;
import oracle.dbtools.util.Logger;

public class DataPumpCommand
extends CommandListener
implements IHelp,
SQLCLService,
Connected,
ICommandSyntax {
    private static final String NL = "\n";
    public static ScriptRunnerContext ctx;
    private CommandHelp help;
    private DataPumpModel _model;
    final long start = System.currentTimeMillis();

    public void beginEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
    }

    public void endEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
    }

    public String getCommand() {
        return "datapump";
    }

    public Class<? extends CommandListener> getCommandListener() {
        return ((Object)((Object)this)).getClass();
    }

    public String getCommandLongName() {
        return "datapump";
    }

    public Map<String, Map<String, StandardParameter>> getCommandModel() {
        return DataPumpOptions.commandModel;
    }

    public String getCommandShortName() {
        return "dp";
    }

    public String getExtensionDescription() {
        return Messages.getString("EXT_DESC");
    }

    public String getExtensionName() {
        return "datapump";
    }

    public String getExtensionVersion() {
        return Messages.getString("SQLclVersion.VERSION");
    }

    public String getHelp() {
        try {
            ScriptRunnerContext theCtx = new ScriptRunnerContext();
            this.help = new CommandHelp(theCtx, DataPumpOptions.class);
            CommandParser.loadParams((String)"datapump.parms", (String)"datapump help", (ScriptRunnerContext)theCtx, DataPumpOptions.class);
            return this.help.getCommandHelp();
        }
        catch (CommandHelpClassException | CommandOptionsClassException | ConnectionNotValidException | ExtraParameterException | InvalidCommandException | MissingRequiredParameterException | ParameterFailedValidationException e) {
            return Messages.getString("HELP_ERROR");
        }
    }

    public boolean handleEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        if (cmd.getProperty("STRIPPED_CONTINUATION") == null) {
            cmd.setSql(ScriptUtils.checkforContinuationChars((String)cmd.getSql()));
        }
        DataPumpCommand.ctx = ctx;
        ScriptRunnerContext.Parameters parameters = ctx.getParameterInstance();
        if (!cmd.getLoweredTrimmedSQL().startsWith("dp") && !cmd.getLoweredTrimmedSQL().startsWith("datapump")) {
            return false;
        }
        try {
            this.help = new CommandHelp(ctx, DataPumpOptions.class);
            DataPumpArguments args = new DataPumpArguments(ctx);
            this._model = new DataPumpModel(conn, ctx, cmd, args);
            CommandParser.loadParams((String)"datapump.parms", (String)cmd.getSql(), (ScriptRunnerContext)ctx, DataPumpOptions.class);
            String _command = parameters.getParameterAsString("datapump.parms", CommandParserConstants.COMMAND);
            boolean _help = parameters.getParameterAsBoolean("datapump.parms", CommandParserConstants.HELP);
            if (_help) {
                ctx.write(this.help.getCommandHelp());
                return true;
            }
            if (!ctx.getParameterInstance().parametersContains("setdatapump.parms")) {
                CommandParser.loadParams((String)"setdatapump.parms", (String)"set datapump -default false", (ScriptRunnerContext)ctx, SetDataPumpOptions.class);
                if (parameters.getParameterAsBoolean("setdatapump.parms", "debug").booleanValue()) {
                    ctx.write("Defaults Set");
                    ctx.getParameterInstance().printParametersAsRow("setdatapump.parms");
                }
            }
            parameters.getParameters("setdatapump.parms").forEach((key, value) -> args.put(key, value));
            CommandParser.loadParams((String)"datapump.parms", (String)cmd.getSql(), (ScriptRunnerContext)ctx, DataPumpOptions.class);
            if (parameters.getParameterAsBoolean("setdatapump.parms", "debug").booleanValue()) {
                ctx.write("Datapump Command");
                ctx.getParameterInstance().printParametersAsRow("setdatapump.parms");
            }
            parameters.getParameters("datapump.parms").forEach((key, value) -> args.put(key, value));
            args.put("jobmode", "SCHEMA");
            args.put("keepmaster", "true");
            if (!args.contains("columnencryption")) {
                args.put("columnencryption", "true");
            }
            if (!args.contains("includemetadata")) {
                args.put("includemetadata", "true");
            }
            if (!args.contains("includerows")) {
                args.put("includerows", "true");
            }
            if (!args.contains("reusefile")) {
                args.put("reusefile", "true");
            }
            if (!args.contains("tablecompression")) {
                args.put("tablecompression", "true");
            }
            if (!args.contains("wait")) {
                args.put("wait", "true");
            }
            _command = parameters.getParameterAsString("datapump.parms", CommandParserConstants.COMMAND);
            _help = parameters.getParameterAsBoolean("datapump.parms", CommandParserConstants.HELP);
            if (_help) {
                ctx.write(this.help.getCommandHelp());
                return true;
            }
            if (conn == null) {
                this._model.getToolLogger().logError(DataPumpResources.format("DPCMPD_CONN", "datapump"));
                this._model.ToolLoggerFlushLog();
                return true;
            }
            args.put("operation", _command.toUpperCase());
            switch (_command) {
                case "export": {
                    this._model.isExport(true);
                    this.process();
                    break;
                }
                case "import": {
                    this._model.isImport(true);
                    this.process();
                    break;
                }
                default: {
                    this.help.getCommandHelp();
                    break;
                }
            }
        }
        catch (CommandHelpClassException | CommandOptionsClassException | ConnectionNotValidException | ExtraParameterException | InvalidCommandException | MissingRequiredParameterException | ParameterFailedValidationException e) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            if (parameters.getParameterAsBoolean("datapump.parms", "debug").booleanValue()) {
                e.printStackTrace(pw);
                ctx.write(pw.toString());
            }
            ctx.write(e.getLocalizedMessage() + NL);
            ctx.write(Messages.getString("FAILED_REQUEST"));
            parameters.printParametersAsTable("datapump.parms");
        }
        return true;
    }

    private void process() {
        try {
            if (this._model.isVerbose() || this._model.isDebug()) {
                this._model.getToolLogger().logToolStart(DataPumpResources.getString("DP"));
            }
            if (this._model.isDebug()) {
                this._model.getToolLogger().log("debug on");
            }
            if (this._model.getConn() != null) {
                if (this._model.isDebug()) {
                    this._model.getToolLogger().log("debug on");
                }
                if (this._model.getConn() != null) {
                    String connName = ConnectionResolver.getConnectionName((Connection)this._model.getConn());
                    DataPumpPreprocessor preprocessor = new DataPumpPreprocessor(this._model);
                    if (preprocessor.check()) {
                        if (!this._model.ToolLoggerFlushLog()) {
                            return;
                        }
                        if (preprocessor.handleSupport()) {
                            if (!this._model.ToolLoggerFlushLog()) {
                                return;
                            }
                            DataPumpGenerator generator = new DataPumpGenerator(this._model);
                            generator.genSQL();
                            if (!this._model.ToolLoggerFlushLog()) {
                                return;
                            }
                            if (this._model.isNoExec()) {
                                ctx.write(DataPumpResources.getString("NO_EXEC") + NL);
                            } else {
                                if (this._model.isImport() && this._model.isArgTrue("copycloud")) {
                                    DataPumpTransfer transfer = new DataPumpTransfer(this._model);
                                    transfer.transferFromCloud();
                                    if (!this._model.ToolLoggerFlushLog()) {
                                        return;
                                    }
                                }
                                DataPumpExecutor executor = new DataPumpExecutor(this._model);
                                boolean isExec = executor.execSql();
                                if (!this._model.ToolLoggerFlushLog()) {
                                    return;
                                }
                                if (isExec & this._model.isExport() && this._model.isArgTrue("copycloud")) {
                                    DataPumpTransfer transfer = new DataPumpTransfer(this._model);
                                    transfer.transferToCloud();
                                    if (!this._model.ToolLoggerFlushLog()) {
                                        return;
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            if (e instanceof ProcessFailedException) {
                Exception e1 = ((ProcessFailedException)e).getOriginalException();
                this._model.getToolLogger().logError(e1.getLocalizedMessage());
            }
            this._model.getToolLogger().logException((Throwable)e);
            Logger.warn(((Object)((Object)this)).getClass(), (Throwable)e);
        }
        if (this._model.isVerbose() || this._model.isDebug()) {
            this._model.getToolLogger().logToolEnd();
        }
        if (ctx.getTiming()) {
            this._model.getToolLogger().log(ToolLoggerResources.format((String)"TIMINGELAPSEDTOTAL", (Object[])new Object[]{ToolLogger.getElapsedTime((long)this.start)}) + NL);
        }
        this._model.ToolLoggerFlushLog();
    }

    public boolean isSqlPlus() {
        return false;
    }

    public boolean needsConnection() {
        return true;
    }
}

