/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.jle.util;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import oracle.bali.jle.geom.Dimension2D;
import oracle.bali.jle.geom.Point2D;
import oracle.bali.jle.geom.Rectangle2D;

public class GeometryUtils {
    private GeometryUtils() {
    }

    public static Rectangle toRectangle(Rectangle2D rect) {
        return GeometryUtils.toRectangle(rect.getX(), rect.getY(), rect.getWidth(), rect.getHeight());
    }

    public static Rectangle toRectangle(double x, double y, double width, double height) {
        int x1 = (int)Math.round(x);
        int y1 = (int)Math.round(y);
        double roundedX = x - (double)x1;
        double roundedY = y - (double)y1;
        int width1 = (int)Math.round(width + roundedX);
        int height1 = (int)Math.round(height + roundedY);
        return new Rectangle(x1, y1, width1, height1);
    }

    public static Point toPoint(Point2D point) {
        return new Point((int)Math.round(point.getX()), (int)Math.round(point.getY()));
    }

    public static Dimension toDimension(Dimension2D dim) {
        return new Dimension((int)Math.round(dim.getWidth()), (int)Math.round(dim.getHeight()));
    }

    public static Rectangle2D getDrawRect(double x1, double y1, double x2, double y2) {
        double endY;
        double startY;
        double endX;
        double startX;
        if (x1 <= x2) {
            startX = x1;
            endX = x2;
        } else {
            startX = x2;
            endX = x1;
        }
        double width = endX - startX;
        if (y1 <= y2) {
            startY = y1;
            endY = y2;
        } else {
            startY = y2;
            endY = y1;
        }
        double height = endY - startY;
        return new Rectangle2D.Double(startX, startY, width, height);
    }

    public static double segmentLength(double x1, double y1, double x2, double y2) {
        return Math.sqrt((x1 - x2) * (x1 - x2) + (y1 - y2) * (y1 - y2));
    }
}

