/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.jle.tool.undo;

import oracle.bali.jle.LayoutItem;
import oracle.bali.jle.tool.SelectionTool;
import oracle.bali.jle.tool.undo.LocalizedEdit;

public class SelectionUndo
extends LocalizedEdit {
    private LayoutItem _selection;
    private boolean _select;
    private SelectionTool _tool;

    public SelectionUndo(LayoutItem selection, boolean select, SelectionTool tool) {
        if (selection == null) {
            throw new IllegalArgumentException();
        }
        this._selection = selection;
        this._select = select;
        this._tool = tool;
    }

    @Override
    public void undo() {
        super.undo();
        if (this._select) {
            this._tool.processDeselect(this._selection);
        } else {
            this._tool.processSelect(this._selection);
        }
    }

    @Override
    public void redo() {
        super.redo();
        if (!this._select) {
            this._tool.processDeselect(this._selection);
        } else {
            this._tool.processSelect(this._selection);
        }
    }

    @Override
    public void die() {
        super.die();
        this._selection = null;
        this._tool = null;
    }

    @Override
    public boolean isSignificant() {
        return false;
    }

    @Override
    public String getBaseKey() {
        return this._select ? "SELECT" : "DESELECT";
    }

    public LayoutItem getSelectedItem() {
        return this._selection;
    }

    public boolean isSelected() {
        return this._select;
    }
}

