/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.jle.tool;

import java.awt.Toolkit;
import javax.swing.KeyStroke;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoManager;
import oracle.bali.jle.JLECanvas;
import oracle.bali.jle.event.JLEEvent;
import oracle.bali.jle.event.JLEEventSource;
import oracle.bali.jle.tool.BaseTool;

public class UndoTool
extends BaseTool {
    private static final KeyStroke _sDefaultUndoStroke = KeyStroke.getKeyStroke(90, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask());
    private static final KeyStroke _sDefaultRedoStroke = KeyStroke.getKeyStroke(90, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask() | 1);
    private UndoManager _manager;
    private KeyStroke _undoStroke = _sDefaultUndoStroke;
    private KeyStroke _redoStroke = _sDefaultRedoStroke;

    @Override
    public void pickup(JLECanvas canvas, JLEEventSource eventSource) {
        super.pickup(canvas, eventSource);
        this._manager = canvas.getUndoManager();
    }

    @Override
    public void drop() {
        super.drop();
        this._manager = null;
    }

    @Override
    protected void processKeyPressed(JLEEvent e) {
        if (e.isConsumed() || this._manager == null) {
            return;
        }
        if (e.equals(this._undoStroke)) {
            this.processUndo();
            e.consume();
        } else if (e.equals(this._redoStroke)) {
            this.processRedo();
            e.consume();
        }
    }

    @Override
    public long getDefaultEnabledEvents() {
        return 8L;
    }

    public void processUndo() {
        try {
            this._manager.undo();
        }
        catch (CannotUndoException cannotUndoException) {
            // empty catch block
        }
    }

    public void processRedo() {
        try {
            this._manager.redo();
        }
        catch (CannotRedoException cannotRedoException) {
            // empty catch block
        }
    }

    public KeyStroke getUndoKeyStroke() {
        return this._undoStroke;
    }

    public void setUndoKeyStroke(KeyStroke stroke) {
        this._undoStroke = stroke;
    }

    public KeyStroke getRedoKeyStroke() {
        return this._redoStroke;
    }

    public void setRedoKeyStroke(KeyStroke stroke) {
        this._redoStroke = stroke;
    }
}

