/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.jle.tool;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.EventObject;
import java.util.Vector;
import javax.accessibility.AccessibleContext;
import javax.swing.event.UndoableEditEvent;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CompoundEdit;
import oracle.bali.jle.JLEAutoScroller;
import oracle.bali.jle.JLECanvas;
import oracle.bali.jle.LayoutItem;
import oracle.bali.jle.PropertyManager;
import oracle.bali.jle.event.Cancelable;
import oracle.bali.jle.event.JLEEvent;
import oracle.bali.jle.event.JLEEventSource;
import oracle.bali.jle.geom.Rectangle2D;
import oracle.bali.jle.item.BaseContainer;
import oracle.bali.jle.tool.ActivationEvent;
import oracle.bali.jle.tool.ActivationListener;
import oracle.bali.jle.tool.BaseTool;
import oracle.bali.jle.tool.DefaultBoundsPainter;
import oracle.bali.jle.tool.SelectedItemProvider;
import oracle.bali.jle.tool.SelectionEvent;
import oracle.bali.jle.tool.SelectionListener;
import oracle.bali.jle.tool.SelectionPainter;
import oracle.bali.jle.tool.SelectionValidateEvent;
import oracle.bali.jle.tool.undo.DeleteUndo;
import oracle.bali.jle.tool.undo.SelectionUndo;
import oracle.bali.jle.util.GeometryUtils;
import oracle.bali.jle.util.ItemUtils;
import oracle.bali.share.collection.StringKey;
import oracle.bali.share.event.ListenerManager;

public class SelectionTool
extends BaseTool
implements SelectedItemProvider,
PropertyChangeListener {
    public static final Object SELECTED_KEY = new StringKey("SELECTED_KEY");
    public static final Object REJECT_SELECTION_KEY = new StringKey("REJECT_SELECTION_KEY");
    private Vector _selectedItems = new Vector();
    private transient boolean _selecting;
    private transient boolean _gotPress;
    private transient boolean _autoscrolling;
    private double _startX;
    private double _startY;
    private double _endX;
    private double _endY;
    private SelectionPainter _painter;
    private boolean _postUndo;
    private ListenerManager _listeners;
    private ListenerManager _aListeners;
    private boolean _deleteAllowed = true;
    private boolean _multipleSelectAllowed = true;

    @Override
    public void drawHighlight(Graphics g) {
        LayoutItem[] selections;
        if (this._selecting) {
            JLECanvas canvas = this.getCanvas();
            Rectangle2D select2D = GeometryUtils.getDrawRect(this._startX, this._startY, this._endX, this._endY);
            Rectangle select = canvas.contentToDevice(select2D.getX(), select2D.getY(), select2D.getWidth(), select2D.getHeight());
            Color oldColor = g.getColor();
            g.setColor(Color.black);
            g.drawRect(select.x, select.y, select.width, select.height);
            g.setColor(oldColor);
        }
        SelectionPainter painter = this.getSelectionPainter();
        if (this.getSelectedItemCount() > 0 && (selections = this.getSelectedItems()).length > 0) {
            for (int i = 0; i < selections.length; ++i) {
                LayoutItem item = selections[i];
                Rectangle2D bounds = item.getItemBounds();
                Rectangle device = ItemUtils.parentToDevice(item, bounds);
                painter.drawSelection(g, item, device.x, device.y, device.width, device.height);
            }
        }
    }

    @Override
    public long getDefaultEnabledEvents() {
        return 56L;
    }

    @Override
    public void pickup(JLECanvas canvas, JLEEventSource eventSource) {
        super.pickup(canvas, eventSource);
        this._endY = 0.0;
        this._startY = 0.0;
        this._endX = 0.0;
        this._startX = 0.0;
        this._selecting = false;
        this._autoscrolling = false;
        this._postUndo = canvas.hasUndoableEditListeners();
    }

    @Override
    public void drop() {
        this._postUndo = false;
        this._autoscrolling = false;
        super.drop();
    }

    @Override
    protected void processMouseClicked(JLEEvent e) {
        if (e.isConsumed()) {
            return;
        }
        if (!this.isPrimaryMouseEvent(e)) {
            this.fireActivationEvent(2, e);
        } else if (e.getClickCount() > 1 && this.getSelectedItemCount() > 0) {
            this.fireActivationEvent(1, e);
        }
    }

    @Override
    protected void processMousePressed(JLEEvent e) {
        if (e.isConsumed()) {
            return;
        }
        if (this.isPrimaryMouseEvent(e)) {
            this._gotPress = true;
        }
        this._startX = this._endX = e.getX();
        this._startY = this._endY = e.getY();
        JLECanvas canvas = this.getCanvas();
        LayoutItem selected = SelectionTool.getSelectableItemAt(canvas, this._startX, this._startY);
        int modifiers = e.getModifiers();
        if ((modifiers & 3) == 0 || selected == null || !this.isMultipleSelectAllowed()) {
            int size = this._selectedItems.size();
            if (size > 0) {
                Object[] selection = new LayoutItem[size];
                this._selectedItems.copyInto(selection);
                for (int i = 0; i < size; ++i) {
                    Object curr = selection[i];
                    this.processDeselect((LayoutItem)curr, e);
                    if (!this._postUndo) continue;
                    SelectionUndo edit = new SelectionUndo((LayoutItem)curr, false, this);
                    canvas.processUndoableEditEvent(new UndoableEditEvent(this, edit));
                }
                e.consume();
            }
            if (selected != null) {
                this.processSelect(selected, e);
                if (this._postUndo) {
                    SelectionUndo edit = new SelectionUndo(selected, true, this);
                    canvas.processUndoableEditEvent(new UndoableEditEvent(this, edit));
                }
                e.consume();
            }
        } else if (selected != null) {
            boolean nowSelected = SelectionTool.isSelected(selected);
            if (nowSelected) {
                this.processDeselect(selected, e);
            } else {
                this.processSelect(selected, e);
            }
            if (this._postUndo) {
                SelectionUndo edit = new SelectionUndo(selected, !nowSelected, this);
                canvas.processUndoableEditEvent(new UndoableEditEvent(this, edit));
            }
            e.consume();
        }
        if (selected != null) {
            selected.repaintItem();
        }
    }

    @Override
    protected void processMouseReleased(JLEEvent e) {
        JLEAutoScroller.getJLEAutoScroller().cancel();
        this._autoscrolling = false;
        this._gotPress = false;
        this._selecting = false;
        this._endY = 0.0;
        this._endX = 0.0;
        this._startY = 0.0;
        this._startX = 0.0;
        this.setImmediateRect(null);
        this.updateImmediately();
    }

    @Override
    protected void processMouseDragged(JLEEvent e) {
        if (!(this._gotPress && this.isMultipleSelectAllowed() && this.isPrimaryMouseEvent(e))) {
            return;
        }
        this._autoscrolling = JLEAutoScroller.getJLEAutoScroller().checkAutoScroll(this.getCanvas(), e);
        this._selecting = true;
        this._endX = e.getX();
        this._endY = e.getY();
        Rectangle2D select = GeometryUtils.getDrawRect(this._startX, this._startY, this._endX, this._endY);
        this._rectangleSelect(select.getX(), select.getY(), select.getWidth(), select.getHeight());
        this.addImmediateRect(select);
        this.updateImmediately();
    }

    @Override
    protected void processKeyPressed(JLEEvent e) {
        if (e.isConsumed()) {
            return;
        }
        int keyCode = e.getKeyCode();
        switch (keyCode) {
            case 8: 
            case 127: {
                if (!this.isDeleteAllowed() || this.getSelectedItemCount() == 0) {
                    return;
                }
                LayoutItem[] items = this.getSelectedItems();
                JLECanvas canvas = this.getCanvas();
                AbstractUndoableEdit edit = this._postUndo && items.length > 1 ? new CompoundEdit() : null;
                for (int i = 0; i < items.length; ++i) {
                    LayoutItem doomed = items[i];
                    int index = -1;
                    LayoutItem parent = null;
                    if (this._postUndo) {
                        parent = doomed.getItemParent();
                        index = ItemUtils.getItemIndex(doomed, parent);
                    }
                    this.processDelete(doomed, e);
                    if (!this._postUndo) continue;
                    DeleteUndo temp = new DeleteUndo(doomed, parent, index);
                    if (items.length > 1) {
                        edit.addEdit(temp);
                        continue;
                    }
                    edit = temp;
                }
                if (this._postUndo) {
                    if (items.length > 1) {
                        edit.end();
                    }
                    canvas.processUndoableEditEvent(new UndoableEditEvent(this, edit));
                }
                e.consume();
                break;
            }
            case 9: {
                boolean ctrlDown = e.isControlDown();
                if (ctrlDown) {
                    this.getCanvas().transferFocus();
                    return;
                }
                boolean shiftDown = e.isShiftDown();
                LayoutItem[] oldItems = this.getSelectedItems();
                int oldCount = this.getSelectedItemCount();
                LayoutItem target = oldCount == 0 ? null : (shiftDown ? oldItems[0] : oldItems[oldCount - 1]);
                LayoutItem oldTarget = target;
                while ((target = shiftDown ? this.getCanvas().getFocusPrevious(target, true) : this.getCanvas().getFocusNext(target, true)) != null && !SelectionTool.isSelectable(target) && target != oldTarget) {
                }
                if (target == null || !SelectionTool.isSelectable(target)) {
                    return;
                }
                for (int i = 0; i < oldItems.length; ++i) {
                    this.processDeselect(oldItems[i], e);
                }
                this.processSelect(target, e);
                e.consume();
            }
        }
    }

    public boolean isDeleteAllowed() {
        return this._deleteAllowed;
    }

    public void setDeleteAllowed(boolean delete) {
        this._deleteAllowed = delete;
    }

    public void setMultipleSelectAllowed(boolean multipleSelect) {
        this._multipleSelectAllowed = multipleSelect;
    }

    public boolean isMultipleSelectAllowed() {
        return this._multipleSelectAllowed;
    }

    public final boolean toggleSelection(LayoutItem item) {
        if (SelectionTool.isSelected(item)) {
            return this.processDeselect(item);
        }
        return this.processSelect(item);
    }

    @Override
    public final boolean processSelect(LayoutItem item) {
        return this.processSelect(item, null);
    }

    public boolean processSelect(LayoutItem item, EventObject selector) {
        AccessibleContext ac;
        if (!this.fireSelectionEvent(1, item, selector)) {
            return false;
        }
        if (!SelectionTool.setSelected(item, true)) {
            return false;
        }
        if (!this._selectedItems.contains(item)) {
            this._selectedItems.addElement(item);
        }
        item.getPropertyManager().addPropertyChangeListener(this);
        this.fireSelectionEvent(2, item, selector);
        item.repaintItem();
        JLECanvas canvas = this.getCanvas();
        if (canvas != null && (ac = canvas.getAccessibleContext()) != null) {
            String newName = item.getAccessibleContext().getAccessibleName();
            canvas.getGlassComponent().getAccessibleContext().setAccessibleName(newName);
        }
        return true;
    }

    @Override
    public final boolean processDeselect(LayoutItem item) {
        return this.processDeselect(item, null);
    }

    public boolean processDeselect(LayoutItem item, EventObject deselector) {
        if (!this.fireSelectionEvent(3, item, deselector)) {
            return false;
        }
        item.getPropertyManager().removePropertyChangeListener(this);
        SelectionTool.setSelected(item, false);
        if (this._selectedItems.contains(item)) {
            this._selectedItems.removeElement(item);
        }
        this.fireSelectionEvent(4, item, deselector);
        item.repaintItem();
        JLECanvas canvas = this.getCanvas();
        AccessibleContext ac = canvas.getAccessibleContext();
        if (ac != null) {
            canvas.getGlassComponent().getAccessibleContext().setAccessibleName(null);
        }
        return true;
    }

    @Override
    public void processDeselectAll() {
        this.processDeselectAll(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processDeselectAll(EventObject deselector) {
        JLECanvas canvas = this.getCanvas();
        LayoutItem[] items = this.getSelectedItems();
        if (canvas != null) {
            canvas.freezeRepaints();
        }
        try {
            for (int i = 0; i < items.length; ++i) {
                this.processDeselect(items[i], deselector);
            }
        }
        finally {
            if (canvas != null) {
                canvas.unfreezeRepaints();
            }
        }
    }

    @Override
    public final boolean processDelete(LayoutItem item) {
        return this.processDelete(item, null);
    }

    public boolean processDelete(LayoutItem item, EventObject deletor) {
        LayoutItem parent;
        if (!this.fireSelectionEvent(5, item, deletor)) {
            return false;
        }
        if (SelectionTool.isSelected(item)) {
            this.processDeselect(item, deletor);
            if (this._postUndo) {
                JLECanvas canvas = this.getCanvas();
                SelectionUndo edit = new SelectionUndo(item, false, this);
                canvas.processUndoableEditEvent(new UndoableEditEvent(this, edit));
            }
        }
        if ((parent = item.getItemParent()) != null) {
            parent.removeItem(item);
        }
        this.fireSelectionEvent(6, item, deletor);
        if (parent != null) {
            parent.repaintItem();
        }
        return true;
    }

    public SelectionPainter getSelectionPainter() {
        if (this._painter == null) {
            this._painter = DefaultBoundsPainter.getPainter();
        }
        return this._painter;
    }

    public void setSelectionPainter(SelectionPainter painter) {
        this._painter = painter;
    }

    @Override
    public int getSelectedItemCount() {
        return this._selectedItems.size();
    }

    @Override
    public LayoutItem[] getSelectedItems() {
        Object[] items = new LayoutItem[this._selectedItems.size()];
        this._selectedItems.copyInto(items);
        return items;
    }

    @Override
    public void addSelectionListener(SelectionListener l) {
        if (this._listeners == null) {
            this._listeners = new ListenerManager();
        }
        this._listeners.addListener((EventListener)l);
    }

    public void addActivationListener(ActivationListener l) {
        if (this._aListeners == null) {
            this._aListeners = new ListenerManager();
        }
        this._aListeners.addListener((EventListener)l);
    }

    @Override
    public void removeSelectionListener(SelectionListener l) {
        if (this._listeners != null) {
            this._listeners.removeListener((EventListener)l);
        }
    }

    public void removeActivationListener(ActivationListener l) {
        if (this._aListeners != null) {
            this._aListeners.removeListener((EventListener)l);
        }
    }

    public static boolean isSelected(LayoutItem item) {
        Object result = item.getProperty(SELECTED_KEY);
        return result != PropertyManager.NOT_FOUND_OBJECT;
    }

    public static boolean setSelected(LayoutItem item, boolean select) {
        if (select) {
            Object result = item.getProperty(REJECT_SELECTION_KEY);
            if (result != PropertyManager.NOT_FOUND_OBJECT) {
                return false;
            }
            item.putProperty(SELECTED_KEY, null);
        } else {
            item.removeProperty(SELECTED_KEY);
        }
        return true;
    }

    public static boolean isSelectable(LayoutItem item) {
        Object result = item.getProperty(REJECT_SELECTION_KEY);
        return result == PropertyManager.NOT_FOUND_OBJECT;
    }

    public static void setSelectable(LayoutItem item, boolean selectable) {
        if (selectable) {
            item.removeProperty(REJECT_SELECTION_KEY);
        } else {
            item.removeProperty(SELECTED_KEY);
            item.putProperty(REJECT_SELECTION_KEY, null);
        }
    }

    public static LayoutItem getSelectableItemAt(JLECanvas canvas, double x, double y) {
        LayoutItem curr;
        for (curr = canvas.getHitItem(x, y); curr != null && !SelectionTool.isSelectable(curr); curr = curr.getItemParent()) {
        }
        return curr;
    }

    public static LayoutItem getSelectedItemAt(JLECanvas canvas, double x, double y) {
        LayoutItem curr;
        for (curr = canvas.getHitItem(x, y); curr != null && !SelectionTool.isSelected(curr); curr = curr.getItemParent()) {
        }
        return curr;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        LayoutItem item;
        String property = evt.getPropertyName();
        if (LayoutItem.DEVICE_TRANSFORM_KEY.equals(property) || LayoutItem.BOUNDS_KEY.equals(property)) {
            LayoutItem item2 = (LayoutItem)evt.getSource();
            if (item2.getCanvas() != null) {
                this.refreshSelection(item2);
            }
        } else if (LayoutItem.PARENT_KEY.equals(property) && (item = (LayoutItem)evt.getSource()).getCanvas() == null) {
            this.processDeselect(item, evt);
        }
    }

    protected boolean fireSelectionEvent(int id, LayoutItem item, EventObject selector) {
        SelectionEvent event;
        Enumeration listeners;
        Enumeration enumeration = listeners = this._listeners == null ? null : this._listeners.getListeners();
        if (listeners == null) {
            return true;
        }
        boolean cancelable = false;
        switch (id) {
            case 1: 
            case 3: 
            case 5: {
                event = new SelectionValidateEvent(this, id, item, selector);
                cancelable = true;
                break;
            }
            default: {
                event = new SelectionEvent(this, id, item, selector);
            }
        }
        while (listeners.hasMoreElements()) {
            SelectionListener listener = (SelectionListener)listeners.nextElement();
            switch (id) {
                case 1: {
                    listener.itemSelecting(event);
                    break;
                }
                case 2: {
                    listener.itemSelected(event);
                    break;
                }
                case 3: {
                    listener.itemDeselecting(event);
                    break;
                }
                case 4: {
                    listener.itemDeselected(event);
                    break;
                }
                case 5: {
                    listener.itemDeleting(event);
                    break;
                }
                case 6: {
                    listener.itemDeleted(event);
                }
            }
        }
        return cancelable ? !((Cancelable)((Object)event)).isCancelled() : true;
    }

    protected void fireActivationEvent(int id, JLEEvent activator) {
        Enumeration listeners;
        Enumeration enumeration = listeners = this._aListeners == null ? null : this._aListeners.getListeners();
        if (listeners == null) {
            return;
        }
        ActivationEvent event = new ActivationEvent(this, id, activator);
        while (listeners.hasMoreElements()) {
            ActivationListener listener = (ActivationListener)listeners.nextElement();
            switch (id) {
                case 1: {
                    listener.selectionActivated(event);
                    break;
                }
                case 2: {
                    listener.secondaryMouseClicked(event);
                }
            }
        }
    }

    protected void refreshSelection(LayoutItem item) {
    }

    private void _rectangleSelect(double x, double y, double width, double height) {
        BaseContainer content = this.getCanvas().getContentItem();
        Vector items = ItemUtils.getAllItems(content);
        Enumeration enumer = items.elements();
        while (enumer.hasMoreElements()) {
            SelectionUndo edit;
            JLECanvas canvas;
            LayoutItem child = (LayoutItem)enumer.nextElement();
            Rectangle2D bounds = ItemUtils.parentToContent(child, child.getItemBounds());
            boolean intersect = bounds.intersects(x, y, width, height);
            boolean selected = SelectionTool.isSelected(child);
            if (!SelectionTool.isSelectable(child)) continue;
            if (!selected && intersect) {
                this.processSelect(child);
                if (this._postUndo) {
                    canvas = this.getCanvas();
                    edit = new SelectionUndo(child, true, this);
                    canvas.processUndoableEditEvent(new UndoableEditEvent(this, edit));
                }
                this.addImmediateRect(bounds);
                continue;
            }
            if (!selected || intersect) continue;
            this.processDeselect(child);
            if (this._postUndo) {
                canvas = this.getCanvas();
                edit = new SelectionUndo(child, false, this);
                canvas.processUndoableEditEvent(new UndoableEditEvent(this, edit));
            }
            this.addImmediateRect(bounds);
        }
    }
}

