/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.jle.tool;

import oracle.bali.jle.LayoutItem;

public class ControlPoint {
    static final int DIR_RIGHT = 1;
    static final int DIR_DOWN = 4;
    public static final int UPPER_LEFT = 0;
    public static final int UPPER_CENTER = 1;
    public static final int UPPER_RIGHT = 2;
    public static final int CENTER_LEFT = 4;
    public static final int CENTER = 5;
    public static final int CENTER_RIGHT = 6;
    public static final int LOWER_LEFT = 8;
    public static final int LOWER_CENTER = 9;
    public static final int LOWER_RIGHT = 10;
    private double _x;
    private double _y;
    private int _type;
    private LayoutItem _source;
    ControlPoint next;

    public ControlPoint(int type, double x, double y, LayoutItem source) {
        this._x = x;
        this._y = y;
        this._type = type;
        this._source = source;
        this.next = null;
    }

    public String toString() {
        String type = null;
        switch (this._type) {
            case 5: {
                type = "Center";
                break;
            }
            case 4: {
                type = "Center Left";
                break;
            }
            case 6: {
                type = "Center Right";
                break;
            }
            case 9: {
                type = "Lower Center";
                break;
            }
            case 8: {
                type = "Lower Left";
                break;
            }
            case 10: {
                type = "Lower Right";
                break;
            }
            case 1: {
                type = "Upper Center";
                break;
            }
            case 0: {
                type = "Upper Left";
                break;
            }
            case 2: {
                type = "Upper Right";
            }
        }
        return "(" + this._x + "," + this._y + ") " + type + " " + this._source;
    }

    public final boolean isUpper() {
        return this._type / 4 == 0;
    }

    public final boolean isLower() {
        return this._type / 4 == 2;
    }

    public final boolean isLeft() {
        return this._type % 4 == 0;
    }

    public final boolean isRight() {
        return this._type % 4 == 2;
    }

    public final boolean isCenter() {
        return this._type == 5;
    }

    public final double getX() {
        return this._x;
    }

    public final double getY() {
        return this._y;
    }

    public final LayoutItem getSource() {
        return this._source;
    }

    public final int getType() {
        return this._type;
    }

    public final boolean equals(ControlPoint cp) {
        return cp.getX() == this._x && cp.getY() == this._y && cp.getType() == this._type && cp.getSource() == this._source;
    }
}

