/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.jle.item;

import java.awt.Component;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Hashtable;
import oracle.bali.jle.ComponentContainer;
import oracle.bali.jle.JLECanvas;

public class CompContainerFactory {
    private static Hashtable _sRegistry;
    private static Hashtable _sContainers;

    public static void registerCompContainerClass(Class componentClass, Class containerClass) {
        if (componentClass == null) {
            throw new IllegalArgumentException();
        }
        CompContainerFactory._initialize();
        if (!Component.class.isAssignableFrom(componentClass)) {
            throw new IllegalArgumentException();
        }
        if (containerClass != null && !ComponentContainer.class.isAssignableFrom(containerClass)) {
            throw new IllegalArgumentException();
        }
        _sRegistry.put(componentClass, containerClass);
    }

    public static Class findCompContainerClass(Class componentClass) {
        if (componentClass == null) {
            throw new IllegalArgumentException();
        }
        CompContainerFactory._initialize();
        Object cachedObject = _sRegistry.get(componentClass);
        return cachedObject != null ? (Class)cachedObject : null;
    }

    public static ComponentContainer getCompContainer(Class componentClass, JLECanvas canvas) {
        CompContainerFactory._initialize();
        if (componentClass == null || canvas == null) {
            throw new IllegalArgumentException();
        }
        if (!Component.class.isAssignableFrom(componentClass)) {
            throw new IllegalArgumentException();
        }
        Class searchClass = componentClass;
        Class foundClass = null;
        while ((foundClass = CompContainerFactory.findCompContainerClass(searchClass)) == null && (searchClass = searchClass.getSuperclass()) != Component.class && searchClass != Object.class) {
        }
        if (foundClass == null) {
            throw new IllegalArgumentException("no container registered for class: " + componentClass);
        }
        CanvasLink link = (CanvasLink)_sContainers.get(foundClass);
        if (link != null) {
            CanvasLink searchLink = link;
            CanvasLink lastLink = link;
            while (searchLink != null) {
                if (searchLink._canvas == canvas) {
                    return searchLink._container;
                }
                lastLink = searchLink;
                searchLink = searchLink._next;
            }
            lastLink._next = searchLink = CompContainerFactory._createLink(canvas, foundClass);
            return searchLink._container;
        }
        link = CompContainerFactory._createLink(canvas, foundClass);
        _sContainers.put(foundClass, link);
        return link._container;
    }

    private static CanvasLink _createLink(JLECanvas canvas, Class containerClass) {
        Class[] argTypes = new Class[]{JLECanvas.class};
        Object[] args = new Object[]{canvas};
        try {
            Constructor toInvoke = containerClass.getConstructor(argTypes);
            ComponentContainer cont = (ComponentContainer)toInvoke.newInstance(args);
            return new CanvasLink(canvas, cont);
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (InvocationTargetException invocationTargetException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InstantiationException instantiationException) {
            // empty catch block
        }
        return null;
    }

    private static synchronized void _initialize() {
        if (_sRegistry == null) {
            _sRegistry = new Hashtable();
            _sContainers = new Hashtable();
        }
    }

    private static class CanvasLink {
        JLECanvas _canvas;
        ComponentContainer _container;
        CanvasLink _next;

        CanvasLink(JLECanvas canvas, ComponentContainer container) {
            this._canvas = canvas;
            this._container = container;
            this._next = null;
        }
    }
}

