/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.jle;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.FocusEvent;
import java.awt.event.MouseMotionListener;
import java.util.Enumeration;
import java.util.EventListener;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.swing.FocusManager;
import javax.swing.JComponent;
import javax.swing.JViewport;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.undo.UndoManager;
import oracle.bali.ewt.scrolling.ScrollableComponent;
import oracle.bali.jle.ComponentContainer;
import oracle.bali.jle.ContentItem;
import oracle.bali.jle.GlassPane;
import oracle.bali.jle.LayoutItem;
import oracle.bali.jle.LayoutTool;
import oracle.bali.jle.TransformException;
import oracle.bali.jle.event.JLEEvent;
import oracle.bali.jle.event.JLEEventListener;
import oracle.bali.jle.event.JLEEventSource;
import oracle.bali.jle.geom.AffineTransform;
import oracle.bali.jle.geom.Dimension2D;
import oracle.bali.jle.geom.ImmTransform;
import oracle.bali.jle.geom.Point2D;
import oracle.bali.jle.geom.Rectangle2D;
import oracle.bali.jle.item.BaseContainer;
import oracle.bali.jle.item.CompContainerFactory;
import oracle.bali.jle.item.ComponentItem;
import oracle.bali.jle.tool.NullTool;
import oracle.bali.jle.tool.undo.ToolDropUndo;
import oracle.bali.jle.util.GeometryUtils;
import oracle.bali.jle.util.ItemUtils;
import oracle.bali.share.collection.StringKey;
import oracle.bali.share.event.ListenerManager;

public class JLECanvas
extends ScrollableComponent
implements JLEEventSource,
Accessible {
    public static final StringKey UNIT_PROPERTY_KEY = new StringKey("Unit key");
    public static final StringKey ZOOM_PROPERTY_KEY = new StringKey("Zoom key");
    public static final StringKey TOOL_PROPERTY_KEY = new StringKey("Tool key");
    public static final StringKey SECONDARY_TOOL_PROPERTY_KEY = new StringKey("Sec Tool key");
    public static final StringKey FOCUS_ITEM_PROPERTY_KEY = new StringKey("Focus item key");
    public static final StringKey CANVAS_SIZE_PROPERTY_KEY = new StringKey("JLECanvas size");
    public static final StringKey VIEWPORT_LOC_PROPERTY_KEY = new StringKey("Viewport location");
    private double _engineX;
    private double _engineY;
    private boolean _zoomed;
    private double _zoomX;
    private double _zoomY;
    private double _xFactor;
    private double _yFactor;
    private double _viewX;
    private double _viewY;
    private int _canvasWidth;
    private int _canvasHeight;
    private GlassPane _glass;
    private BaseContainer _content;
    private ListenerManager _listeners;
    private long _enabledEvents;
    private ChangeHandler _changeHandler;
    private LayoutTool _tool;
    private LayoutTool _secondaryTool;
    private ImmTransform _device;
    private LayoutItem _focused;
    private UndoManager _undo;
    private ListenerManager _undoListeners;
    private int _undoCount = 0;
    private LayoutTool _defaultTool;
    private Container[] _componentContainers;
    private static final int _GLASS_INDEX = 0;
    private static final int _FOCUS1_INDEX = 1;
    private static final int _FOCUS2_INDEX = 2;
    private static final int _COMPCONT_INDEX = 2;

    public JLECanvas() {
        this.setLayout(new CanvasLayout());
        this._yFactor = 1.0;
        this._xFactor = 1.0;
        this._zoomY = 1.0;
        this._zoomX = 1.0;
        this._engineY = 1.0;
        this._engineX = 1.0;
        this._glass = this.createGlassPane();
        this.add(this._glass, 0);
        this._device = ImmTransform.getIdentity();
        this.setTool(NullTool.getTool());
        this.setSecondaryTool(NullTool.getTool());
        long mask = 60L;
        this.enableEvents(mask);
        this._content = new ContentItem(this);
        this.updateTransform();
    }

    public boolean isHScrollable() {
        return true;
    }

    public boolean isVScrollable() {
        return true;
    }

    public void setCanvasSize(int width, int height) {
        if (width > 0 && height > 0) {
            this.getContentItem().setItemSize((double)width * this.getEngineUnitsPerPixelX(), (double)height * this.getEngineUnitsPerPixelY());
            this._canvasWidth = width;
            this._canvasHeight = height;
        }
        Dimension2D oldSize = this.getJLECanvasSize();
        super.setCanvasSize(width, height);
        this.firePropertyChange(CANVAS_SIZE_PROPERTY_KEY.getString(), oldSize, this.getJLECanvasSize());
    }

    public void setCanvasOrigin(int x, int y) {
        if (x > 0) {
            x = 0;
        }
        if (y > 0) {
            y = 0;
        }
        Dimension canvasSize = this.getCanvasSize();
        Dimension innerSize = this.getInnerSize();
        if (-x + innerSize.width > canvasSize.width) {
            x = innerSize.width - canvasSize.width;
        }
        if (-y + innerSize.height > canvasSize.height) {
            y = innerSize.height - canvasSize.height;
        }
        Point2D oldLoc = this.getJLECanvasOrigin();
        super.setCanvasOrigin(x, y);
        this.firePropertyChange(VIEWPORT_LOC_PROPERTY_KEY.getString(), oldLoc, this.getJLECanvasOrigin());
    }

    public void setJLECanvasSize(double width, double height) {
        this.setCanvasSize((int)Math.round(width / this.getEngineUnitsPerPixelX()), (int)Math.round(height / this.getEngineUnitsPerPixelY()));
    }

    public Dimension2D getJLECanvasSize() {
        Dimension canvasSize = this.getCanvasSize();
        return new Dimension2D.Double((double)canvasSize.width * this.getEngineUnitsPerPixelX(), (double)canvasSize.height * this.getEngineUnitsPerPixelY());
    }

    protected Dimension layoutCanvas() {
        if (this._canvasWidth == 0 || this._canvasHeight == 0) {
            return this.getMinimumSize();
        }
        return new Dimension(this._canvasWidth, this._canvasHeight);
    }

    public Dimension getMinimumSize() {
        return new Dimension(5, 5);
    }

    public Rectangle2D getJLEExtentBounds() {
        Point2D loc = this.getJLECanvasOrigin();
        Dimension2D size = this.getJLEExtentSize();
        return new Rectangle2D.Double(loc.getX(), loc.getY(), size.getWidth(), size.getHeight());
    }

    public void setJLECanvasOrigin(double x, double y) {
        if (x < 0.0) {
            x = 0.0;
        }
        if (y < 0.0) {
            y = 0.0;
        }
        this._viewX = x;
        this._viewY = y;
        JViewport port = this.getViewport();
        if (port != null) {
            this._actuallySetViewport();
        }
    }

    public Point2D getJLECanvasOrigin() {
        Point origin = this.getCanvasOrigin();
        return new Point2D.Double((double)(-origin.x) * this.getEngineUnitsPerPixelX(), (double)(-origin.y) * this.getEngineUnitsPerPixelY());
    }

    public Dimension2D getJLEExtentSize() {
        Dimension innerSize = this.getInnerSize();
        return new Dimension2D.Double((double)innerSize.width * this.getEngineUnitsPerPixelX(), (double)innerSize.height * this.getEngineUnitsPerPixelY());
    }

    public double getEngineUnitsPerPixelX() {
        return this._engineX;
    }

    public double getEngineUnitsPerPixelY() {
        return this._engineY;
    }

    public Dimension2D getEngineUnitsPerPixel() {
        return new Dimension2D.Double(this._engineX, this._engineY);
    }

    public void setEngineUnitsPerPixel(double xUnits, double yUnits) {
        Dimension2D.Double oldUnits = new Dimension2D.Double(this._engineX, this._engineY);
        this._engineX = xUnits;
        this._engineY = yUnits;
        this._xFactor = this._zoomX / this._engineX;
        this._yFactor = this._zoomY / this._engineY;
        this.updateTransform();
        this.firePropertyChange(UNIT_PROPERTY_KEY.getString(), oldUnits, new Dimension2D.Double(this._engineX, this._engineY));
    }

    public final void setEngineUnitsPerPixel(Dimension2D units) {
        this.setEngineUnitsPerPixel(units.getWidth(), units.getHeight());
    }

    public boolean isZoomed() {
        return this._zoomed;
    }

    public Dimension2D getZoom() {
        return new Dimension2D.Double(this._zoomX, this._zoomY);
    }

    public double getZoomX() {
        return this._zoomX;
    }

    public double getZoomY() {
        return this._zoomY;
    }

    public void setZoom(double factorX, double factorY) {
        Dimension2D.Double oldUnits = new Dimension2D.Double(this._zoomX, this._zoomY);
        this._zoomX = factorX;
        this._zoomY = factorY;
        this._zoomed = this._zoomX != 1.0 || this._zoomY != 1.0;
        this._xFactor = this._zoomX / this._engineX;
        this._yFactor = this._zoomY / this._engineY;
        this.setCanvasSize((int)Math.round((double)this._canvasWidth * factorX / ((Dimension2D)oldUnits).getWidth()), (int)Math.round((double)this._canvasHeight * factorY / ((Dimension2D)oldUnits).getHeight()));
        this.updateTransform();
        this.firePropertyChange(ZOOM_PROPERTY_KEY.getString(), oldUnits, new Dimension2D.Double(this._zoomX, this._zoomY));
        this.repaintInterior();
    }

    public Point2D deviceToContent(double x, double y) {
        return new Point2D.Double(x / this._xFactor, y / this._yFactor);
    }

    public Rectangle2D deviceToContent(double x, double y, double width, double height) {
        return new Rectangle2D.Double(x / this._xFactor, y / this._yFactor, width / this._xFactor, height / this._yFactor);
    }

    public Rectangle contentToDevice(double x, double y, double width, double height) {
        return GeometryUtils.toRectangle(x * this._xFactor, y * this._yFactor, width * this._xFactor, height * this._yFactor);
    }

    public Point contentToDevice(double x, double y) {
        return new Point((int)Math.round(x * this._xFactor), (int)Math.round(y * this._yFactor));
    }

    public Point2D contentToDeviceDouble(double x, double y) {
        return new Point2D.Double(x * this._xFactor, y * this._yFactor);
    }

    public Dimension2D contentToDevice(Dimension2D dim) {
        return new Dimension2D.Double(dim.getWidth() * this._xFactor, dim.getHeight() * this._yFactor);
    }

    public final void centerOnItem(LayoutItem centered) {
        if (centered == null) {
            throw new IllegalArgumentException();
        }
        Rectangle2D content = ItemUtils.itemToContent(centered.getItemParent(), centered.getItemBounds());
        this.centerOnRectangle(content);
    }

    public final void centerOnItems(LayoutItem[] centered) {
        if (centered == null) {
            throw new IllegalArgumentException();
        }
        if (centered.length == 0) {
            return;
        }
        Rectangle2D content = ItemUtils.itemToContent(centered[0].getItemParent(), centered[0].getItemBounds());
        for (int i = 1; i < centered.length; ++i) {
            LayoutItem curr = centered[i];
            Rectangle2D currRect = ItemUtils.itemToContent(curr.getItemParent(), curr.getItemBounds());
            Rectangle2D.union(content, currRect, content);
        }
        this.centerOnRectangle(content);
    }

    public final void centerOnRectangle(Rectangle2D centered) {
        Dimension2D canvasSize = this.getJLEExtentSize();
        double centeredX = centered.getX() - (canvasSize.getWidth() - centered.getWidth()) / 2.0;
        double centeredY = centered.getY() - (canvasSize.getHeight() - centered.getHeight()) / 2.0;
        this.setJLECanvasOrigin(centeredX, centeredY);
    }

    public final void setTool(LayoutTool tool) {
        this.setTool(tool, true);
    }

    public void setTool(LayoutTool tool, boolean allowUndoPost) {
        if (tool == null) {
            tool = this.getDefaultTool();
        }
        if (this._tool != tool) {
            LayoutTool oldTool = this._tool;
            FocusManager focus = FocusManager.getCurrentManager();
            if (this._tool != null) {
                if (this.getGlassComponent().hasFocus()) {
                    this.processJLEEvent(new JLEEvent(this._glass, 1005));
                }
                this._tool.drop();
            }
            if (allowUndoPost && this.hasUndoableEditListeners()) {
                UndoableEditEvent e = new UndoableEditEvent(this, new ToolDropUndo(oldTool, this));
                this.processUndoableEditEvent(e);
            }
            this._enabledEvents = 0L;
            this._tool = tool;
            if (this._tool != null) {
                this._tool.pickup(this, this);
                if (this.getGlassComponent().hasFocus()) {
                    this.processJLEEvent(new JLEEvent(this._glass, 1004));
                }
            }
            this.firePropertyChange(TOOL_PROPERTY_KEY.getString(), oldTool, this._tool);
        }
    }

    public LayoutTool getTool() {
        return this._tool;
    }

    public LayoutTool getSecondaryTool() {
        return this._secondaryTool;
    }

    public void setSecondaryTool(LayoutTool secondary) {
        if (this._secondaryTool != secondary) {
            LayoutTool oldTool = this._secondaryTool;
            if (this._secondaryTool != null) {
                this._secondaryTool.drop();
            }
            this._secondaryTool = secondary;
            if (this._secondaryTool != null) {
                this._secondaryTool.pickup(this, this);
            }
            this.firePropertyChange(SECONDARY_TOOL_PROPERTY_KEY.getString(), oldTool, this._secondaryTool);
        }
    }

    public LayoutTool getDefaultTool() {
        return this._defaultTool == null ? NullTool.getTool() : this._defaultTool;
    }

    public void setDefaultTool(LayoutTool defaultTool) {
        this._defaultTool = defaultTool;
    }

    public final BaseContainer getContentItem() {
        return this._content;
    }

    public final Container getComponentContainer(Component comp) {
        Container lastCont;
        ComponentContainer compContainer;
        if (this._componentContainers == null) {
            this.add(new FocusCatcher(false), 1);
            this.add(new FocusCatcher(true), 2);
            this._componentContainers = new Container[1];
        }
        if ((compContainer = CompContainerFactory.getCompContainer(comp.getClass(), this)) == null) {
            throw new IllegalArgumentException();
        }
        Container parent = compContainer.getContainer();
        if (parent.getParent() != this) {
            this.add(parent, 2);
            this.invalidateCanvas();
        }
        if ((lastCont = this._componentContainers[this._componentContainers.length - 1]) != null) {
            Container[] newConts = new Container[this._componentContainers.length + 1];
            System.arraycopy(this._componentContainers, 0, newConts, 0, this._componentContainers.length);
            this._componentContainers = newConts;
        }
        this._componentContainers[this._componentContainers.length - 1] = parent;
        return parent;
    }

    public LayoutItem getItemAt(double x, double y) {
        BaseContainer content = this.getContentItem();
        if (content == null) {
            return null;
        }
        Point2D contentPoint = ItemUtils.parentToItem(content, x, y);
        LayoutItem found = content.getItemAt(contentPoint.getX(), contentPoint.getY());
        return found;
    }

    public LayoutItem getHitItem(double x, double y) {
        BaseContainer content = this.getContentItem();
        if (content == null) {
            return null;
        }
        Point2D contentPoint = ItemUtils.parentToItem(content, x, y);
        LayoutItem found = content.getHitItem(contentPoint.getX(), contentPoint.getY());
        return found;
    }

    @Override
    public void enableJLEEvents(long eventsToEnable) {
        this._enabledEvents |= eventsToEnable;
    }

    @Override
    public void addJLEEventListener(JLEEventListener l) {
        if (this._listeners == null) {
            this._listeners = new ListenerManager();
        }
        this._listeners.addListener((EventListener)l);
    }

    @Override
    public void removeJLEEventListener(JLEEventListener l) {
        if (this._listeners != null) {
            this._listeners.removeListener((EventListener)l);
        }
    }

    public void processJLEEvent(JLEEvent evt) {
        Enumeration listeners;
        Enumeration enumeration = listeners = this._listeners == null ? null : this._listeners.getListeners();
        if (listeners == null) {
            return;
        }
        while (listeners.hasMoreElements()) {
            JLEEventListener listener = (JLEEventListener)listeners.nextElement();
            switch (evt.getID()) {
                case 500: {
                    listener.mouseClicked(evt);
                    break;
                }
                case 501: {
                    listener.mousePressed(evt);
                    break;
                }
                case 502: {
                    listener.mouseReleased(evt);
                    break;
                }
                case 504: {
                    listener.mouseEntered(evt);
                    break;
                }
                case 505: {
                    listener.mouseExited(evt);
                    break;
                }
                case 503: {
                    listener.mouseMoved(evt);
                    break;
                }
                case 506: {
                    listener.mouseDragged(evt);
                    break;
                }
                case 400: {
                    listener.keyTyped(evt);
                    break;
                }
                case 401: {
                    listener.keyPressed(evt);
                    break;
                }
                case 402: {
                    listener.keyReleased(evt);
                    break;
                }
                case 1004: {
                    listener.focusGained(evt);
                    break;
                }
                case 1005: {
                    listener.focusLost(evt);
                }
            }
            if (!evt.isConsumed()) continue;
            return;
        }
    }

    public LayoutItem getFocusedItem() {
        return this._focused;
    }

    public void setFocusedItem(LayoutItem item) {
        if (item == null) {
            return;
        }
        LayoutItem oldFocus = this.getFocusedItem();
        if (oldFocus == item) {
            return;
        }
        if (oldFocus != null) {
            JLEEvent focusLost = new JLEEvent(oldFocus, 1005);
            if (oldFocus.eventEnabled(focusLost)) {
                oldFocus.processEvent(focusLost);
                if (oldFocus instanceof ComponentItem) {
                    this._glass.requestFocus();
                }
            }
            this.processJLEEvent(focusLost);
        }
        this.setActualFocusedItem(item);
        if (this._focused != null) {
            JLEEvent focusGained = new JLEEvent(this._focused, 1004);
            if (this._focused.eventEnabled(focusGained)) {
                this._focused.processEvent(focusGained);
            }
            this.processJLEEvent(focusGained);
        }
    }

    public void setActualFocusedItem(LayoutItem item) {
        LayoutItem oldFocus = this._focused;
        this._focused = item;
        this.firePropertyChange(FOCUS_ITEM_PROPERTY_KEY.getString(), oldFocus, item);
        AccessibleContext ac = this.accessibleContext;
        if (ac != null) {
            String newName = item == null ? null : item.getAccessibleContext().getAccessibleName();
            this._glass.getAccessibleContext().setAccessibleName(newName);
        }
    }

    public final void setFocusNext() {
        LayoutItem newFocus = this.getFocusNext(this._focused);
        this.setFocusedItem(newFocus);
    }

    public final void setFocusPrevious() {
        LayoutItem newFocus = this.getFocusPrevious(this._focused);
        this.setFocusedItem(newFocus);
    }

    public final LayoutItem getFocusNext(LayoutItem base) {
        return this.getFocusNext(base, false);
    }

    public LayoutItem getFocusNext(LayoutItem base, boolean allowAll) {
        LayoutItem next;
        LayoutItem target = base;
        if (target != null && target.getItemParent() != null && !(target.getItemParent() instanceof ContentItem)) {
            LayoutItem p;
            do {
                boolean found = false;
                p = target.getItemParent();
                for (int i = 0; i < p.getItemCount(); ++i) {
                    LayoutItem c = p.getItem(i);
                    if (found) {
                        LayoutItem subItem;
                        if (c.isFocusTraversable() || allowAll) {
                            return c;
                        }
                        if (c.getItemCount() <= 0 || (subItem = this.focusForwardAndInto(c, allowAll)) == null) continue;
                        return subItem;
                    }
                    if (c != target) continue;
                    found = true;
                }
            } while ((target = p) != this._content && target.getItemParent() != null);
        }
        if ((next = this.focusForwardAndInto(this._content, allowAll)) == target && target != null) {
            return this.focusForwardAndInto(next, allowAll);
        }
        return next;
    }

    public final LayoutItem getFocusPrevious(LayoutItem base) {
        return this.getFocusPrevious(base, false);
    }

    public LayoutItem getFocusPrevious(LayoutItem base, boolean allowAll) {
        LayoutItem target = base;
        if (target != null && target.getItemParent() != null) {
            LayoutItem p;
            do {
                boolean found = false;
                p = target.getItemParent();
                for (int i = p.getItemCount() - 1; i >= 0; --i) {
                    LayoutItem c = p.getItem(i);
                    if (found) {
                        LayoutItem subItem;
                        if (c.isFocusTraversable() || allowAll) {
                            return c;
                        }
                        if (c.getItemCount() <= 0 || (subItem = this.focusBackwardAndInto(c, allowAll)) == null) continue;
                        return subItem;
                    }
                    if (c != target) continue;
                    found = true;
                }
            } while ((target = p) != this._content);
        }
        return this.focusBackwardAndInto(this._content, allowAll);
    }

    protected GlassPane createGlassPane() {
        return new GlassPane(this);
    }

    protected LayoutItem focusForwardAndInto(LayoutItem cont, boolean allowAll) {
        for (int i = 0; i < cont.getItemCount(); ++i) {
            LayoutItem subItem;
            LayoutItem c = cont.getItem(i);
            if (c.isFocusTraversable() || allowAll) {
                return c;
            }
            if (c.getItemCount() <= 0 || (subItem = this.focusForwardAndInto(c, allowAll)) == null) continue;
            return subItem;
        }
        return null;
    }

    protected LayoutItem focusBackwardAndInto(LayoutItem cont, boolean allowAll) {
        for (int i = cont.getItemCount() - 1; i >= 0; --i) {
            LayoutItem subItem;
            LayoutItem c = cont.getItem(i);
            if (c.isFocusTraversable()) {
                return c;
            }
            if (c.getItemCount() <= 0 || (subItem = this.focusBackwardAndInto(c, allowAll)) == null) continue;
            return subItem;
        }
        return null;
    }

    public ImmTransform getDeviceTransform() {
        return this._device;
    }

    protected void addImpl(Component comp, Object constraints, int index) {
        if (!(comp instanceof GlassPane || comp instanceof FocusCatcher || comp instanceof ComponentContainer)) {
            throw new IllegalArgumentException("cannot add Components to JLECanvas");
        }
        super.addImpl(comp, constraints, index);
        if (this._glass != null && this._glass.getParent() == this && this.getComponent(0) != this._glass) {
            this.add(this._glass, 0);
        }
    }

    public void addNotify() {
        super.addNotify();
        JViewport viewport = this.getViewport();
        if (viewport != null) {
            if (this._changeHandler == null) {
                this._changeHandler = new ChangeHandler();
            }
            viewport.addChangeListener(this._changeHandler);
            this._actuallySetViewport();
        }
    }

    public void removeNotify() {
        super.removeNotify();
        JViewport viewport = this.getViewport();
        if (viewport != null) {
            viewport.removeChangeListener(this._changeHandler);
        }
    }

    public void requestFocus() {
        this._glass.requestFocus();
    }

    public void paintCanvasInterior(Graphics g) {
        this.paintBackground(g.create());
        this.paintItem(g.create());
        Graphics toolGraphics = g.create();
        if (this._tool != null) {
            this.paintTool(toolGraphics, this._tool);
        }
        if (this._secondaryTool != null) {
            this.paintTool(toolGraphics, this._secondaryTool);
        }
    }

    protected void paintBackground(Graphics g) {
    }

    protected void paintItem(Graphics g) {
        if (this._content != null) {
            Rectangle2D contentBounds = this._content.getItemBounds();
            Rectangle bounds = GeometryUtils.toRectangle(contentBounds = ItemUtils.transformRect(this._device, contentBounds.getX(), contentBounds.getY(), contentBounds.getWidth(), contentBounds.getHeight(), false));
            Rectangle intersect = bounds.intersection(g.getClipBounds());
            if (!intersect.isEmpty()) {
                g.clipRect(bounds.x, bounds.y, bounds.width, bounds.height);
                AffineTransform device = this._content.getDeviceTransform();
                this._content.paintItem(g, device);
            }
        }
    }

    protected void paintTool(Graphics g, LayoutTool tool) {
        tool.drawHighlight(g);
    }

    public GlassPane getGlassComponent() {
        return this._glass;
    }

    public void addUndoableEditListener(UndoableEditListener l) {
        if (this._undoListeners == null) {
            this._undoListeners = new ListenerManager();
        }
        this._undoListeners.addListener((EventListener)l);
        ++this._undoCount;
    }

    public void removeUndoableEditListener(UndoableEditListener l) {
        if (this._undoListeners == null) {
            this._undoListeners = new ListenerManager();
        }
        this._undoListeners.removeListener((EventListener)l);
        --this._undoCount;
    }

    public void processUndoableEditEvent(UndoableEditEvent e) {
        Enumeration listeners;
        Enumeration enumeration = listeners = this._undoListeners == null ? null : this._undoListeners.getListeners();
        if (listeners == null) {
            return;
        }
        while (listeners.hasMoreElements()) {
            UndoableEditListener listener = (UndoableEditListener)listeners.nextElement();
            listener.undoableEditHappened(e);
        }
    }

    public boolean hasUndoableEditListeners() {
        return this._undoCount > 0;
    }

    public void setUndoManager(UndoManager undo) {
        if (this._undo != null) {
            this.removeUndoableEditListener(this._undo);
        }
        this._undo = undo;
        if (this._undo != null) {
            this.addUndoableEditListener(this._undo);
        }
    }

    public UndoManager getUndoManager() {
        return this._undo;
    }

    public void addMouseMotionListener(MouseMotionListener listener) {
        this.getGlassComponent().addMouseMotionListener(listener);
    }

    public void removeMouseMotionListener(MouseMotionListener listener) {
        this.getGlassComponent().removeMouseMotionListener(listener);
    }

    protected Object getPaintData(Object key) {
        if (key == UNIT_PROPERTY_KEY) {
            return this.getEngineUnitsPerPixel();
        }
        if (key == ZOOM_PROPERTY_KEY) {
            return this.getZoom();
        }
        if (key == CANVAS_SIZE_PROPERTY_KEY) {
            return this.getJLECanvasSize();
        }
        if (key == VIEWPORT_LOC_PROPERTY_KEY) {
            return this.getJLECanvasOrigin();
        }
        return super.getPaintData(key);
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new Access();
        }
        return this.accessibleContext;
    }

    boolean JLEEventEnabled(int mask) {
        switch (mask) {
            case 503: 
            case 506: {
                if ((this._enabledEvents & 0x20L) == 0L) break;
                return true;
            }
            case 500: 
            case 501: 
            case 502: 
            case 504: 
            case 505: {
                if ((this._enabledEvents & 0x10L) == 0L) break;
                return true;
            }
            case 400: 
            case 401: 
            case 402: {
                if ((this._enabledEvents & 8L) == 0L) break;
                return true;
            }
            case 1004: 
            case 1005: {
                if ((this._enabledEvents & 4L) == 0L) break;
                return true;
            }
        }
        return false;
    }

    void updateTransform() {
        ImmTransform newTrans;
        ImmTransform oldTrans = this._device;
        this._device = newTrans = new ImmTransform(this._xFactor, 0.0, 0.0, this._yFactor, 0.0, 0.0);
        if (this._content != null) {
            try {
                this._content.updateDeviceTransform(newTrans);
            }
            catch (TransformException e) {
                try {
                    this._content.updateDeviceTransform(oldTrans);
                }
                catch (TransformException e2) {
                    throw new IllegalStateException("cannot set canvas transform");
                }
            }
        }
    }

    private void _actuallySetViewport() {
        JViewport port = this.getViewport();
        if (port != null) {
            this.setCanvasSize(this._canvasWidth, this._canvasHeight);
            Dimension size = port.getExtentSize();
            int newX = this._canvasWidth <= size.width ? 0 : (int)Math.round(this._viewX / this.getEngineUnitsPerPixelX());
            int newY = this._canvasHeight <= size.height ? 0 : (int)Math.round(this._viewY / this.getEngineUnitsPerPixelY());
            this.setCanvasOrigin(-newX, -newY);
        }
    }

    void __firePropertyChange(String s, Object old, Object newValue) {
        super.firePropertyChange(s, old, newValue);
    }

    private class CanvasLayout
    implements LayoutManager {
        private CanvasLayout() {
        }

        @Override
        public void addLayoutComponent(String name, Component comp) {
        }

        @Override
        public void removeLayoutComponent(Component comp) {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return JLECanvas.this.getPreferredSize();
        }

        @Override
        public Dimension minimumLayoutSize(Container parent) {
            return JLECanvas.this.getMinimumSize();
        }

        @Override
        public void layoutContainer(Container parent) {
            Dimension size = parent.getSize();
            Component[] comps = JLECanvas.this.getComponents();
            for (int i = 0; i < comps.length; ++i) {
                Component curr = comps[i];
                Point oldLoc = curr.getLocation();
                curr.setBounds(oldLoc.x, oldLoc.y, size.width, size.height);
            }
        }
    }

    private class FocusCatcher
    extends JComponent {
        private boolean _forward;

        FocusCatcher(boolean forward) {
            this._forward = forward;
        }

        @Override
        public boolean isFocusTraversable() {
            return true;
        }

        @Override
        protected void processFocusEvent(FocusEvent e) {
            if (e.getID() == 1004) {
                JLECanvas.this.requestFocus();
                if (JLECanvas.this.getFocusedItem() == null) {
                    JLECanvas.this.processJLEEvent(new JLEEvent(JLECanvas.this, 401, 0L, 0, 9, '\t'));
                } else if (this._forward) {
                    JLECanvas.this.setFocusNext();
                } else {
                    JLECanvas.this.setFocusPrevious();
                }
            }
        }
    }

    private class ChangeHandler
    implements ChangeListener {
        private ChangeHandler() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            JLECanvas.this.__firePropertyChange(VIEWPORT_LOC_PROPERTY_KEY.getString(), null, JLECanvas.this.getJLECanvasOrigin());
        }
    }

    private class Access
    extends JComponent.AccessibleJComponent {
        public Access() {
            super((JComponent)((Object)JLECanvas.this));
        }

        @Override
        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.LAYERED_PANE;
        }

        @Override
        public int getAccessibleChildrenCount() {
            if (JLECanvas.this.getContentItem() == null) {
                return 0;
            }
            return 1;
        }

        @Override
        public Accessible getAccessibleChild(int i) {
            return i == 0 ? JLECanvas.this.getContentItem() : null;
        }
    }
}

