/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.osgi.boot.api;

import java.io.File;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.ide.osgi.boot.api.IdeBootProperties;

public class CacheUtil {
    private CacheUtil() {
    }

    public static boolean invalidateCache(Logger logger) {
        boolean invalidateFromOracleHome;
        boolean loggerPassedIn = logger != null;
        boolean invalidateFromSystem = CacheUtil.invalidateCacheFromSystemDirectory(logger);
        if (invalidateFromSystem) {
            if (loggerPassedIn) {
                logger.fine("Invalidated cache from the system directory");
            } else if (loggerPassedIn) {
                logger.fine("Failed to invalidate cache from the system directory");
            }
        }
        if (invalidateFromOracleHome = CacheUtil.invalidateCacheFromOracleHome(logger)) {
            if (loggerPassedIn) {
                logger.fine("Invalidated cache from oracle.home");
            } else if (loggerPassedIn) {
                logger.fine("Failed to invalidate cache from oracle.home");
            }
        }
        return invalidateFromSystem && invalidateFromOracleHome;
    }

    public static boolean invalidateCacheFromOracleHome(Logger logger) {
        String clusterPath;
        File lastModified;
        boolean loggerPassedIn;
        boolean bl = loggerPassedIn = logger != null;
        if (loggerPassedIn) {
            logger.fine("Trying to flushing caches from oracle home");
        }
        if ((lastModified = new File(new File(clusterPath = IdeBootProperties.getOracleHome() + File.separator + "netbeans" + File.separator + "bridge"), ".lastModified")).canWrite()) {
            long oldLastModified = lastModified.lastModified();
            Date currentDate = new Date();
            lastModified.setLastModified(currentDate.getTime());
            if (loggerPassedIn) {
                logger.log(Level.FINE, "Changed last modified time of {0} from {1} to {2}", new Object[]{lastModified, new Date(oldLastModified), new Date(lastModified.lastModified())});
            }
            return true;
        }
        return false;
    }

    public static boolean invalidateCacheFromSystemDirectory(Logger logger) {
        return CacheUtil.invalidateCacheFromSystemDirectory(logger, IdeBootProperties.getNetbeansCacheDirectory());
    }

    public static boolean invalidateCacheFromSystemDirectory(Logger logger, String cacheDirectory) {
        boolean loggerPassedIn;
        boolean bl = loggerPassedIn = logger != null;
        if (loggerPassedIn) {
            logger.fine("Trying to flush caches from the user directory");
        }
        if (cacheDirectory == null) {
            if (loggerPassedIn) {
                logger.warning("cacheDirectory is null, nothing to invalidate");
            }
            return false;
        }
        File nbCacheLocation1 = new File(cacheDirectory, "var" + File.separator + "cache");
        boolean deletedDir1 = true;
        if (nbCacheLocation1.exists()) {
            if (loggerPassedIn) {
                logger.fine("Trying to delete " + nbCacheLocation1);
            }
            deletedDir1 = CacheUtil.deleteDirectory(nbCacheLocation1);
            if (loggerPassedIn && deletedDir1) {
                logger.fine("Deleted " + nbCacheLocation1 + " successfully.");
            }
        } else if (loggerPassedIn) {
            logger.fine(nbCacheLocation1 + " didn't exist.");
        }
        File nbCacheLocation2 = new File(cacheDirectory, "config" + File.separator + "Modules");
        boolean deletedDir2 = true;
        if (nbCacheLocation2.exists()) {
            if (loggerPassedIn) {
                logger.fine("Trying to delete " + nbCacheLocation2);
            }
            deletedDir2 = CacheUtil.deleteDirectory(nbCacheLocation2);
            if (loggerPassedIn && deletedDir2) {
                logger.fine("Deleted " + nbCacheLocation2 + " successfully.");
            }
        } else if (loggerPassedIn) {
            logger.fine(nbCacheLocation2 + " didn't exist.");
        }
        return deletedDir1 && deletedDir2;
    }

    private static boolean deleteDirectory(File file) {
        if (file.isDirectory()) {
            for (File f : file.listFiles()) {
                boolean deletedFile = CacheUtil.deleteDirectory(f);
                if (deletedFile) continue;
                return false;
            }
        }
        return file.delete();
    }
}

