/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.osgi.boot;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.StringJoiner;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.logging.Filter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class IdeLogManager
extends LogManager {
    private static final String CONFIGURATION_STRING = System.getProperty("oracle.ide.boot.logging", "constrain").toLowerCase();
    private static final boolean CONSTRAIN = CONFIGURATION_STRING.contains("constrain");
    private static final boolean TRACE = CONFIGURATION_STRING.contains("trace");
    private static final boolean TRACE_PUBLISHING = CONFIGURATION_STRING.contains("publish");
    private static final boolean TEST = CONFIGURATION_STRING.contains("test");
    private static final boolean STACK_ALL = CONFIGURATION_STRING.contains("stackall");
    private static final boolean STACK_CONSTRAIN = CONFIGURATION_STRING.contains("stackconstrain");
    private static volatile boolean rootLoggerAdded;
    private static volatile boolean globalLoggerAdded;
    private static final Map<String, ConstrainingLogger> constrainingLoggers;
    private static volatile Thread constrainedThread;
    private static Map<String, Logger> retargetedLoggers;
    private static final Queue<Logger> verificationQueue;
    private static final long ZERO;
    private static final String SIXTEEN = "                ";
    private static final Matcher stackMatcher;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void runConstrained(Runnable runnable) {
        block7: {
            if (constrainedThread != null) {
                throw new IllegalStateException("IdeLogManager.runConstrained on thread \"" + Thread.currentThread().getName() + "\": thread \"" + constrainedThread.getName() + "\" already constrained");
            }
            LogManager logManager = LogManager.getLogManager();
            if (!(logManager instanceof IdeLogManager) || !CONSTRAIN) {
                runnable.run();
                return;
            }
            retargetedLoggers = new HashMap<String, Logger>();
            constrainedThread = Thread.currentThread();
            if (TRACE) {
                IdeLogManager.trace("BEGIN CONSTRAINED RUN IN THREAD \"%s\"", constrainedThread.getName());
            }
            try {
                runnable.run();
                if (!TRACE) break block7;
            }
            catch (Throwable throwable) {
                if (TRACE) {
                    IdeLogManager.trace("END CONSTRAINED RUN IN THREAD \"%s\"", constrainedThread.getName());
                }
                retargetedLoggers = null;
                constrainedThread = null;
                throw throwable;
            }
            IdeLogManager.trace("END CONSTRAINED RUN IN THREAD \"%s\"", constrainedThread.getName());
        }
        retargetedLoggers = null;
        constrainedThread = null;
        if (TEST) {
            Logger.getLogger("oracle").severe("Testing \"oracle\" logger (enabled when system property \"oracle.ide.boot.logging\" includes \"test\")");
            Logger.getLogger("oracle.database").severe("Testing \"oracle.database\" logger (enabled when system property \"oracle.ide.boot.logging\" includes \"test\")");
            Logger.getLogger("com.oracle").severe("Testing \"com.oracle\" logger (enabled when system property \"oracle.ide.boot.logging\" includes \"test\")");
            Logger.getLogger("com.oracle.database").severe("Testing \"com.oracle.database\" logger (enabled when system property \"oracle.ide.boot.logging\" includes \"test\")");
            Logger.getLogger("com.oracle.database.sql").severe("Testing \"com.oracle.database.sql\" logger (enabled when system property \"oracle.ide.boot.logging\" includes \"test\")");
        }
    }

    private static boolean isConstrained() {
        return Thread.currentThread() == constrainedThread;
    }

    public IdeLogManager() {
        if (TRACE) {
            IdeLogManager.trace("constructing IdeLogManager", new Object[0]);
        }
    }

    @Override
    public Logger getLogger(String loggerName) {
        Logger expected = verificationQueue.poll();
        while (expected != null) {
            String name;
            Logger actual;
            if (TRACE && expected != (actual = super.getLogger(name = expected.getName()))) {
                String actualKind;
                String expectedKind = expected.getClass().getSimpleName().replace("Logger", "").toLowerCase();
                if (expectedKind.isEmpty()) {
                    expectedKind = "standard";
                }
                if ((actualKind = expected.getClass().getSimpleName().replace("Logger", "").toLowerCase()).isEmpty()) {
                    actualKind = "standard";
                }
                IdeLogManager.trace("submitted logger %s unverified: expected %s logger; parent %s; use parent handlers %s; handlers %s :: actual %s logger; parent %s; use parent handlers %s; handlers %s", name, expectedKind, IdeLogManager.name(expected.getParent()), expected.getUseParentHandlers(), IdeLogManager.transitiveHandlers(expected), actualKind, IdeLogManager.name(actual.getParent()), actual.getUseParentHandlers(), IdeLogManager.transitiveHandlers(actual));
            }
            expected = verificationQueue.poll();
        }
        return super.getLogger(loggerName);
    }

    @Override
    public boolean addLogger(Logger logger) {
        String name = logger.getName();
        if (!rootLoggerAdded || !globalLoggerAdded) {
            boolean added = super.addLogger(logger);
            if (TRACE) {
                IdeLogManager.trace("%s %s logger", added ? "added" : "previously added", IdeLogManager.name(logger));
            }
            if ("".equals(name)) {
                rootLoggerAdded = true;
            }
            if ("global".equals(name)) {
                globalLoggerAdded = true;
            }
            return added;
        }
        if (CONSTRAIN && constrainingLoggers.isEmpty()) {
            for (String constrainingName : new String[]{"oracle", "com.oracle"}) {
                ConstrainingLogger constrainingLogger = new ConstrainingLogger(constrainingName);
                boolean constrainingAdded = super.addLogger(constrainingLogger);
                if (constrainingAdded) {
                    constrainingLoggers.put(constrainingName, constrainingLogger);
                    verificationQueue.add(constrainingLogger);
                }
                constrainingLogger.constructionComplete();
                if (!TRACE) continue;
                IdeLogManager.trace("constraining logger %s %s; parent %s; use parent handlers %s; handlers %s", IdeLogManager.name(constrainingLogger), constrainingAdded ? "submitted" : "failed submission", IdeLogManager.name(constrainingLogger.getParent()), constrainingLogger.getUseParentHandlers(), IdeLogManager.transitiveHandlers(constrainingLogger));
            }
        }
        if (CONSTRAIN && IdeLogManager.isConstrained() && name != null && (name.startsWith("oracle.") || name.startsWith("com.oracle.")) && !name.startsWith("oracle.jdev")) {
            String parentName = name.charAt(0) == 'o' ? "oracle" : "com.oracle";
            ConstrainingLogger constraints = constrainingLoggers.get(parentName);
            int end = name.indexOf(46, parentName.length() + 1);
            if (end < 0) {
                logger = TRACE ? new TracingLogger(name, logger.getResourceBundle(), true) : new RetargetedLogger(name, logger.getResourceBundle());
                boolean added = super.addLogger(logger);
                if (added) {
                    if (constraints != null) {
                        constraints.constrain(logger);
                    }
                    retargetedLoggers.putIfAbsent(name, logger);
                    verificationQueue.add(logger);
                }
                if (TRACE) {
                    ((TracingLogger)logger).constructionComplete();
                    IdeLogManager.trace("requested retargeted tracing logger %s %s; parent %s; use parent handlers %s; handlers %s", IdeLogManager.name(logger), added ? "submitted" : "failed submission", IdeLogManager.name(logger.getParent()), logger.getUseParentHandlers(), IdeLogManager.transitiveHandlers(logger));
                }
                return false;
            }
            String retargetedName = name.substring(0, end);
            Logger retargetedLogger = super.getLogger(retargetedName);
            if (retargetedLogger == null) {
                retargetedLogger = TRACE ? new TracingLogger(retargetedName, null, true) : new RetargetedLogger(retargetedName, null);
                boolean added = super.addLogger(retargetedLogger);
                if (added) {
                    if (constraints != null) {
                        constraints.constrain(retargetedLogger);
                    }
                    retargetedLoggers.putIfAbsent(retargetedName, retargetedLogger);
                    verificationQueue.add(retargetedLogger);
                }
                if (TRACE) {
                    ((TracingLogger)retargetedLogger).constructionComplete();
                    IdeLogManager.trace("ancestor retargeted tracing logger %s %s; parent %s; use parent handlers %s; handlers %s", IdeLogManager.name(retargetedLogger), added ? "submitted" : "failed submission", IdeLogManager.name(retargetedLogger.getParent()), retargetedLogger.getUseParentHandlers(), IdeLogManager.transitiveHandlers(retargetedLogger));
                }
            }
        }
        if (TRACE) {
            TracingLogger tracingLogger = new TracingLogger(name, logger.getResourceBundle(), false);
            boolean added = super.addLogger(tracingLogger);
            if (added) {
                verificationQueue.add(tracingLogger);
            }
            tracingLogger.constructionComplete();
            IdeLogManager.trace("tracing logger %s %s; parent %s; use parent handlers %s; handlers %s", IdeLogManager.name(tracingLogger), added ? "submitted" : "failed submission", IdeLogManager.name(tracingLogger.getParent()), tracingLogger.getUseParentHandlers(), IdeLogManager.transitiveHandlers(tracingLogger));
            return false;
        }
        return super.addLogger(logger);
    }

    private static boolean contains(Object[] array, Object object) {
        for (Object item : array) {
            if (item != object) continue;
            return true;
        }
        return false;
    }

    private static String name(Logger logger) {
        if (logger == null) {
            return "null";
        }
        if (logger.getName() == null) {
            return "anonymous";
        }
        if (logger.getName().isEmpty()) {
            return "root";
        }
        return "\"" + logger.getName() + "\"";
    }

    private static StringJoiner handlers(Handler ... handlers) {
        StringJoiner joiner = new StringJoiner(", ", "{", "}");
        for (Handler handler : handlers) {
            joiner.add(handler.getClass().getSimpleName().replace("Handler", ""));
        }
        return joiner;
    }

    private static StringJoiner transitiveHandlers(Logger logger) {
        StringJoiner handlers = new StringJoiner(", ", "{{", "}}");
        while (logger != null) {
            for (Handler handler : logger.getHandlers()) {
                handlers.add(IdeLogManager.name(logger) + ":" + handler.getClass().getSimpleName().replace("Handler", ""));
            }
            if (!logger.getUseParentHandlers()) break;
            logger = logger.getParent();
        }
        return handlers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void trace(String format, Object ... arguments) {
        if (!TRACE) {
            return;
        }
        float time = (float)(System.currentTimeMillis() - ZERO) / 1000.0f;
        String name = Thread.currentThread().getName();
        int size = name.length();
        String tail = "";
        if (size >= 16) {
            name = name.substring(0, 16);
        } else {
            tail = SIXTEEN.substring(size);
        }
        PrintStream printStream = System.out;
        synchronized (printStream) {
            boolean stack;
            System.out.printf("[LOG] %5.1f [%s]%s ", Float.valueOf(time), name, tail);
            System.out.printf(format, arguments);
            System.out.println();
            boolean bl = stack = STACK_ALL || STACK_CONSTRAIN && IdeLogManager.isConstrained();
            if (!stack) {
                return;
            }
            StackTraceElement[] trace = new Throwable().getStackTrace();
            if (trace.length <= 1) {
                return;
            }
            for (int i = 1; i < trace.length; ++i) {
                StackTraceElement element = trace[i];
                if (element.getMethodName().startsWith("access$")) continue;
                System.out.printf("[LOG] %5.1f [%s]%s ", Float.valueOf(time), name, tail);
                System.out.print("\tat ");
                System.out.println(element);
                String className = element.getClassName();
                if (!stackMatcher.reset(className).find()) break;
            }
        }
    }

    static {
        constrainingLoggers = new HashMap<String, ConstrainingLogger>();
        constrainedThread = null;
        verificationQueue = new ConcurrentLinkedQueue<Logger>();
        ZERO = System.currentTimeMillis();
        stackMatcher = Pattern.compile("^(java.util.logging.|oracle.ide.osgi.boot.|java.security.AccessController)").matcher("");
    }

    public static class ConstrainingLogger
    extends Logger {
        private Logger constrainedParent;
        private boolean constrainedUseParentHandlers;
        private final Set<Handler> constrainedHandlers = new HashSet<Handler>();
        private boolean constructed;

        ConstrainingLogger(String name) {
            super(name, null);
            this.constrainedParent = this.getParent();
            this.constrainedUseParentHandlers = this.getUseParentHandlers();
            this.constrainedHandlers.addAll(Arrays.asList(this.getHandlers()));
        }

        public void constrain(Logger logger) {
            if (logger == null) {
                return;
            }
            if (this.constrainedParent != null) {
                logger.setParent(this.constrainedParent);
            }
            logger.setUseParentHandlers(this.constrainedUseParentHandlers);
            for (Handler handler : this.getHandlers()) {
                logger.removeHandler(handler);
            }
            for (Handler handler : this.constrainedHandlers) {
                logger.addHandler(handler);
            }
        }

        void constructionComplete() {
            this.constructed = true;
        }

        private List<Logger> retargetedLoggers() {
            String thisName = this.getName();
            ArrayList<Logger> list = new ArrayList<Logger>(retargetedLoggers.size());
            for (Logger logger : retargetedLoggers.values()) {
                if (!logger.getName().startsWith(thisName)) continue;
                list.add(logger);
            }
            return list;
        }

        @Override
        public void addHandler(Handler handler) throws SecurityException {
            if (IdeLogManager.isConstrained()) {
                if (TRACE) {
                    IdeLogManager.trace("constraining logger %s blocking adding handler %s: handlers %s", IdeLogManager.name(this), IdeLogManager.handlers(handler), IdeLogManager.transitiveHandlers(this));
                }
                if (this.constrainedHandlers.add(handler)) {
                    List<Logger> targets = this.retargetedLoggers();
                    for (Logger logger : targets) {
                        logger.addHandler(handler);
                    }
                    if (TRACE) {
                        IdeLogManager.trace("constraining logger %s added handler %s to %d retargeted loggers", IdeLogManager.name(this), IdeLogManager.handlers(handler), targets.size());
                    }
                }
            } else {
                super.addHandler(handler);
                if (TRACE && this.constructed) {
                    IdeLogManager.trace("constraining logger %s added handler %s: use parent handlers %s; handlers %s", IdeLogManager.name(this), IdeLogManager.handlers(handler), this.getUseParentHandlers(), IdeLogManager.transitiveHandlers(this));
                }
            }
        }

        @Override
        public void removeHandler(Handler handler) throws SecurityException {
            if (IdeLogManager.isConstrained()) {
                if (TRACE) {
                    IdeLogManager.trace("constraining logger %s blocking removing handler %s: handlers %s", IdeLogManager.name(this), IdeLogManager.handlers(handler), IdeLogManager.transitiveHandlers(this));
                }
                if (this.constrainedHandlers.remove(handler)) {
                    List<Logger> targets = this.retargetedLoggers();
                    for (Logger logger : targets) {
                        logger.removeHandler(handler);
                    }
                    if (TRACE) {
                        IdeLogManager.trace("constraining logger %s removed handler %s from %d retargeted loggers", IdeLogManager.name(this), IdeLogManager.handlers(handler), targets.size());
                    }
                }
            } else {
                super.removeHandler(handler);
                if (TRACE) {
                    IdeLogManager.trace("constraining logger %s removed handler %s: use parent handlers %s; handlers %s", IdeLogManager.name(this), IdeLogManager.handlers(handler), this.getUseParentHandlers(), IdeLogManager.transitiveHandlers(this));
                }
            }
        }

        @Override
        public void setUseParentHandlers(boolean useParentHandlers) {
            if (IdeLogManager.isConstrained()) {
                if (TRACE) {
                    IdeLogManager.trace("constraining logger %s blocking setting use parent handlers %s; parent %s; handlers %s", IdeLogManager.name(this), useParentHandlers, IdeLogManager.name(this.getParent()), IdeLogManager.transitiveHandlers(this));
                }
                this.constrainedUseParentHandlers = useParentHandlers;
                List<Logger> targets = this.retargetedLoggers();
                for (Logger logger : targets) {
                    logger.setUseParentHandlers(useParentHandlers);
                }
                if (TRACE) {
                    IdeLogManager.trace("constraining logger %s set use parent handlers to %s on %d child loggers", IdeLogManager.name(this), useParentHandlers, targets.size());
                }
            } else {
                super.setUseParentHandlers(useParentHandlers);
                if (TRACE) {
                    IdeLogManager.trace("constraining logger %s set use parent handlers %s; parent %s; handlers %s", IdeLogManager.name(this), useParentHandlers, IdeLogManager.name(this.getParent()), IdeLogManager.transitiveHandlers(this));
                }
            }
        }

        @Override
        public void setParent(Logger parent) {
            if (IdeLogManager.isConstrained()) {
                if (TRACE) {
                    IdeLogManager.trace("constraining logger %s blocking setting parent to %s; parent %s; handlers %s", IdeLogManager.name(this), IdeLogManager.name(parent), IdeLogManager.name(this.getParent()), IdeLogManager.transitiveHandlers(this));
                }
                this.constrainedParent = parent;
                if (parent == null) {
                    return;
                }
                List<Logger> targets = this.retargetedLoggers();
                for (Logger logger : targets) {
                    logger.setParent(parent);
                }
                if (TRACE) {
                    IdeLogManager.trace("constraining logger %s set parent to %s on %d child loggers", IdeLogManager.name(this), IdeLogManager.name(parent), targets.size());
                }
            } else {
                super.setParent(parent);
                if (TRACE && this.constructed) {
                    IdeLogManager.trace("constraining logger %s set parent to %s; handlers %s", IdeLogManager.name(this), IdeLogManager.name(parent), IdeLogManager.transitiveHandlers(this));
                }
            }
        }

        @Override
        public void setLevel(Level level) {
            Level oldLevel = this.getLevel();
            if (IdeLogManager.isConstrained()) {
                if (TRACE) {
                    IdeLogManager.trace("constraining logger %s blocking setting level to %s from %s", IdeLogManager.name(this), level, oldLevel);
                }
                List<Logger> targets = this.retargetedLoggers();
                for (Logger logger : targets) {
                    logger.setLevel(level);
                }
                if (TRACE) {
                    IdeLogManager.trace("constraining logger %s set level to %s on %d child loggers", IdeLogManager.name(this), level, targets.size());
                }
            } else {
                super.setLevel(level);
                if (TRACE && this.constructed) {
                    IdeLogManager.trace("constraining logger %s set level to %s from %s; handlers %s", IdeLogManager.name(this), level, oldLevel);
                }
            }
        }

        @Override
        public void setFilter(Filter filter) {
            Filter oldFilter = this.getFilter();
            if (IdeLogManager.isConstrained()) {
                if (TRACE) {
                    IdeLogManager.trace("constraining logger %s blocking setting filter to %s from %s", IdeLogManager.name(this), filter, oldFilter);
                }
                List<Logger> targets = this.retargetedLoggers();
                for (Logger logger : targets) {
                    logger.setFilter(filter);
                }
                if (TRACE) {
                    IdeLogManager.trace("constraining logger %s set filter to %s on %d child loggers", IdeLogManager.name(this), filter, targets.size());
                }
            } else {
                super.setFilter(filter);
                if (TRACE && this.constructed) {
                    IdeLogManager.trace("constraining logger %s set filter to %s from %s; handlers %s", IdeLogManager.name(this), filter, oldFilter);
                }
            }
        }

        @Override
        public void log(LogRecord record) {
            Logger logger;
            super.log(record);
            StringJoiner handlers = new StringJoiner(", ", "{{", "}}");
            for (logger = this; logger != null; logger = logger.getParent()) {
                for (Handler handler : logger.getHandlers()) {
                    handlers.add(IdeLogManager.name(logger) + ":" + handler.getClass().getSimpleName().replace("Handler", ""));
                }
                if (!logger.getUseParentHandlers()) break;
            }
            if (TRACE_PUBLISHING) {
                IdeLogManager.trace("constraining logger %s published \"%s\" by %s%s", IdeLogManager.name(this), record.getMessage(), handlers, logger != null ? ", terminated by " + IdeLogManager.name(logger) : "");
            }
        }
    }

    public static class TracingLogger
    extends Logger {
        private final boolean retargeted;
        private boolean constructed;

        TracingLogger(String name, ResourceBundle resourceBundle, boolean retargeted) {
            super(name, null);
            this.retargeted = retargeted;
            if (resourceBundle != null) {
                super.setResourceBundle(resourceBundle);
            }
        }

        void constructionComplete() {
            this.constructed = true;
        }

        @Override
        public void addHandler(Handler handler) throws SecurityException {
            if (this.retargeted && IdeLogManager.contains(this.getHandlers(), handler)) {
                if (TRACE) {
                    IdeLogManager.trace("tracing logger %s refused duplicate handler %s; use parent handlers %s; handlers %s", IdeLogManager.name(this), IdeLogManager.handlers(handler), this.getUseParentHandlers(), IdeLogManager.transitiveHandlers(this));
                }
            } else {
                super.addHandler(handler);
                if (TRACE && this.constructed) {
                    IdeLogManager.trace("tracing logger %s added handler %s; use parent handlers %s; handlers %s", IdeLogManager.name(this), IdeLogManager.handlers(handler), this.getUseParentHandlers(), IdeLogManager.transitiveHandlers(this));
                }
            }
        }

        @Override
        public void removeHandler(Handler handler) throws SecurityException {
            super.removeHandler(handler);
            if (TRACE && this.constructed) {
                IdeLogManager.trace("tracing logger %s removed handler %s; use parent handlers %s; handlers %s", IdeLogManager.name(this), IdeLogManager.handlers(handler), this.getUseParentHandlers(), IdeLogManager.transitiveHandlers(this));
            }
        }

        @Override
        public void setUseParentHandlers(boolean useParentHandlers) {
            super.setUseParentHandlers(useParentHandlers);
            if (TRACE && this.constructed) {
                IdeLogManager.trace("tracing logger %s set use parent handlers %s; handlers %s", IdeLogManager.name(this), useParentHandlers, IdeLogManager.transitiveHandlers(this));
            }
        }

        @Override
        public void setParent(Logger parent) {
            super.setParent(parent);
            if (TRACE && this.constructed) {
                IdeLogManager.trace("tracing logger %s set parent %s; use parent handlers %s; handlers %s", IdeLogManager.name(this), IdeLogManager.name(parent), this.getUseParentHandlers(), IdeLogManager.transitiveHandlers(this));
            }
        }

        @Override
        public void setLevel(Level level) {
            Level oldLevel = this.getLevel();
            super.setLevel(level);
            if (TRACE && this.constructed) {
                IdeLogManager.trace("tracing logger %s set level to %s from %s", IdeLogManager.name(this), level, oldLevel);
            }
        }

        @Override
        public void setFilter(Filter filter) {
            Filter oldFilter = this.getFilter();
            super.setFilter(filter);
            if (TRACE && this.constructed) {
                IdeLogManager.trace("tracing logger %s set filter to %s from %s", IdeLogManager.name(this), filter, oldFilter);
            }
        }

        @Override
        public void log(LogRecord record) {
            Logger logger;
            super.log(record);
            StringJoiner handlers = new StringJoiner(", ", "{{", "}}");
            for (logger = this; logger != null; logger = logger.getParent()) {
                for (Handler handler : logger.getHandlers()) {
                    handlers.add(IdeLogManager.name(logger) + ":" + handler.getClass().getSimpleName().replace("Handler", ""));
                }
                if (!logger.getUseParentHandlers()) break;
            }
            if (TRACE_PUBLISHING) {
                IdeLogManager.trace("tracing logger %s published \"%s\" by %s%s", IdeLogManager.name(this), record.getMessage(), handlers, logger != null ? ", terminated by " + IdeLogManager.name(logger) : "");
            }
        }
    }

    private static class RetargetedLogger
    extends Logger {
        RetargetedLogger(String name, ResourceBundle resourceBundle) {
            super(name, null);
            if (resourceBundle != null) {
                super.setResourceBundle(resourceBundle);
            }
        }

        @Override
        public void addHandler(Handler handler) throws SecurityException {
            if (IdeLogManager.contains(this.getHandlers(), handler)) {
                super.addHandler(handler);
            }
        }
    }
}

