/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.cm;

import java.util.ArrayList;
import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NameClassPair;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import oracle.jdeveloper.cm.AbstractConnectionWrapper;
import oracle.jdeveloper.cm.CMException;
import oracle.jdeveloper.cm.ConnectInfoPrompter;
import oracle.jdeveloper.cm.ConnectionDescriptor;
import oracle.jdeveloper.cm.ConnectionManager;

public class JndiConnectionWrapper
extends AbstractConnectionWrapper {
    private Context _ic = null;
    private static final String OC4J_INITIAL_FACTORY = "com.evermind.server.rmi.RMIInitialContextFactory";

    JndiConnectionWrapper(ConnectionDescriptor descriptor, ConnectInfoPrompter prompter, ConnectionManager manager) throws CMException {
        super(descriptor, prompter, manager);
        this._connTypes = new ArrayList(1);
        this._connTypes.add("JNDI");
    }

    @Override
    void createConnection(ConnectionDescriptor descriptor) throws CMException {
        if (null != this._prompter) {
            this._prompter.promptUser(descriptor);
        }
        try {
            Hashtable<String, String> env = new Hashtable<String, String>();
            String s = descriptor.getProperty("JNDI_INITIAL_CONTEXT_FACTORY");
            env.put("java.naming.factory.initial", s != null ? s : OC4J_INITIAL_FACTORY);
            s = descriptor.getUsername();
            env.put("java.naming.security.principal", s != null ? s : "");
            s = descriptor.getPassword();
            env.put("java.naming.security.credentials", s != null ? s : "");
            s = descriptor.getURL();
            env.put("java.naming.provider.url", s != null ? s : "");
            env.put("dedicated.connection", "true");
            this._ic = new InitialContext(env);
        }
        catch (Exception ex) {
            throw new CMException(ex);
        }
    }

    @Override
    public Object getPresentation(String connType) throws CMException {
        try {
            if (connType.equals("JNDI")) {
                if (this._ic == null) {
                    this.createConnection(this._descriptor);
                }
                return this._ic;
            }
        }
        catch (CMException cmEx) {
            throw cmEx;
        }
        catch (NullPointerException npeEx) {
            throw new CMException(npeEx);
        }
        throw new CMException("Cannot find presentation for " + connType + " in this ConnectionWrapper instance");
    }

    public Context getContext() {
        return this._ic;
    }

    @Override
    public boolean containsPresentation(String connType) {
        return connType.equals("JNDI");
    }

    @Override
    public void closeConnection() {
        try {
            this._ic.close();
        }
        catch (NamingException namingException) {
            // empty catch block
        }
    }

    @Override
    public void testPresentation(String connType) throws CMException {
        this.getPresentation(connType);
        if (this._ic == null) {
            throw new CMException("NULL InitialContext");
        }
        try {
            NamingEnumeration<NameClassPair> ne = this._ic.list("");
            ne.close();
        }
        catch (Exception ex) {
            throw new CMException(ex);
        }
        catch (Throwable t) {
            if (t instanceof ThreadDeath) {
                throw (ThreadDeath)t;
            }
            throw new CMException(t.toString());
        }
    }
}

