/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.plugin;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Properties;
import oracle.dbtools.migration.capture.offline.OfflineCapturer;
import oracle.dbtools.migration.workbench.core.MigrationPlugin;
import oracle.dbtools.migration.workbench.core.MigrationPluginException;
import oracle.dbtools.migration.workbench.core.ThirdPartyDbProvider;
import oracle.dbtools.migration.workbench.plugin.SQLServer2005Plugin;
import oracle.dbtools.migration.workbench.sqlserver2008.SQLServer2008DbProvider;
import oracle.dbtools.migration.workbench.sqlserver2008.SQLServer2008OfflineCapturer;

public final class SQLServer2008Plugin
extends SQLServer2005Plugin {
    @Override
    protected String getSupportedMapsXMLFileName() {
        return "/oracle/dbtools/migration/workbench/sqlserver2008/SQLServer2008SupportedDataTypesMap.xml";
    }

    @Override
    public String getVersionNumber() {
        return "10.0.0";
    }

    @Override
    public ThirdPartyDbProvider getProvider(String string) throws MigrationPluginException {
        try {
            SQLServer2008Plugin.loadDriver();
            Connection connection = DriverManager.getConnection(string);
            return new SQLServer2008DbProvider(connection);
        }
        catch (SQLException sQLException) {
            throw new MigrationPluginException((Throwable)sQLException);
        }
    }

    @Override
    public ThirdPartyDbProvider getProvider(String string, Properties properties) throws MigrationPluginException {
        SQLServer2008Plugin.loadDriver();
        try {
            SQLServer2008Plugin.loadDriver();
            Connection connection = DriverManager.getConnection(string, properties);
            return new SQLServer2008DbProvider(connection);
        }
        catch (SQLException sQLException) {
            throw new MigrationPluginException((Throwable)sQLException);
        }
    }

    @Override
    public ThirdPartyDbProvider getProvider(Connection connection) throws MigrationPluginException {
        return new SQLServer2008DbProvider(connection);
    }

    @Override
    public String getPublishedVersion() {
        return "2008";
    }

    @Override
    public int getPlatformMask() {
        return 262144;
    }

    @Override
    public OfflineCapturer getOfflineCapturer() {
        return new SQLServer2008OfflineCapturer(null, null);
    }

    @Override
    public MigrationPlugin.PluginSupportLevel getPlatformSupportLevel(String string, int n, int n2, String string2) {
        if (string.equals(this.getPlatformName()) && n == 10) {
            return MigrationPlugin.PluginSupportLevel.SUPPORT_LEVEL_PREFERRED_VERSION;
        }
        return MigrationPlugin.PluginSupportLevel.SUPPORT_LEVEL_NONE;
    }
}

