/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.json.marshal;

import java.util.LinkedList;
import oracle.dbtools.json.marshal.JSONAbstractUnmarshalScopeProvider;
import oracle.dbtools.json.marshal.JSONUnmarshalEventHandler;
import oracle.dbtools.json.marshal.JSONUnmarshalScopeProvider;
import oracle.dbtools.plugin.api.json.JSONToken;

public abstract class JSONAbstractUnmarshalEventHandler
extends JSONAbstractUnmarshalScopeProvider
implements JSONUnmarshalEventHandler {
    private final boolean allowFragment;
    private final LinkedList<JSONToken> tokenStack;
    private Object result;

    private JSONAbstractUnmarshalEventHandler(JSONUnmarshalScopeProvider scopeProvider, boolean allowFragment) {
        super(scopeProvider);
        this.allowFragment = allowFragment;
        this.tokenStack = new LinkedList();
        this.result = null;
    }

    protected JSONAbstractUnmarshalEventHandler(JSONUnmarshalScopeProvider scopeProvider) {
        this(scopeProvider, false);
    }

    protected JSONAbstractUnmarshalEventHandler(boolean allowFragment) {
        this(null, allowFragment);
    }

    protected JSONAbstractUnmarshalEventHandler() {
        this(null, false);
    }

    @Override
    public JSONUnmarshalEventHandler.Acceptance accept(JSONToken event) {
        JSONUnmarshalEventHandler.Acceptance acceptance = JSONUnmarshalEventHandler.Acceptance.REJECTED;
        switch (event.type()) {
            case START_OBJECT: {
                if (this.getScopeTokenType() != null && this.getScopeTokenType() != JSONToken.Type.PROPERTY_NAME && this.getScopeTokenType() != JSONToken.Type.START_ARRAY) break;
                acceptance = JSONUnmarshalEventHandler.Acceptance.ACCEPTED;
                break;
            }
            case END_OBJECT: {
                if (this.getScopeTokenType() != JSONToken.Type.START_OBJECT) break;
                acceptance = JSONUnmarshalEventHandler.Acceptance.ACCEPTED;
                break;
            }
            case START_ARRAY: {
                if ((this.getScopeTokenType() != null || !this.allowFragment) && this.getScopeTokenType() != JSONToken.Type.PROPERTY_NAME && this.getScopeTokenType() != JSONToken.Type.START_ARRAY) break;
                acceptance = JSONUnmarshalEventHandler.Acceptance.ACCEPTED;
                break;
            }
            case END_ARRAY: {
                if (this.getScopeTokenType() != JSONToken.Type.START_ARRAY) break;
                acceptance = JSONUnmarshalEventHandler.Acceptance.ACCEPTED;
                break;
            }
            case PROPERTY_NAME: {
                if ((this.getScopeTokenType() != null || !this.allowFragment) && this.getScopeTokenType() != JSONToken.Type.START_OBJECT) break;
                acceptance = JSONUnmarshalEventHandler.Acceptance.ACCEPTED;
                break;
            }
            default: {
                if ((this.getScopeTokenType() != null || !this.allowFragment) && this.getScopeTokenType() != JSONToken.Type.PROPERTY_NAME && this.getScopeTokenType() != JSONToken.Type.START_ARRAY) break;
                acceptance = JSONUnmarshalEventHandler.Acceptance.ACCEPTED;
            }
        }
        if (acceptance == JSONUnmarshalEventHandler.Acceptance.REJECTED) {
            acceptance = this.reject(event);
        }
        acceptance = this.process(acceptance, event);
        if (this.tokenStack.isEmpty()) {
            switch (acceptance) {
                case ACCEPTED: {
                    acceptance = JSONUnmarshalEventHandler.Acceptance.FINISHED;
                }
            }
        }
        return acceptance;
    }

    protected abstract JSONUnmarshalEventHandler.Acceptance reject(JSONToken var1) throws RuntimeException;

    protected abstract JSONUnmarshalEventHandler.Acceptance process(JSONUnmarshalEventHandler.Acceptance var1, JSONToken var2);

    protected void pushToken(JSONToken token) {
        this.tokenStack.push(token);
    }

    protected JSONToken peekToken() {
        return this.tokenStack.peek();
    }

    protected JSONToken popToken() {
        return this.tokenStack.pop();
    }

    protected boolean hasToken() {
        return !this.tokenStack.isEmpty();
    }

    @Override
    public final Object getResult() {
        return this.result;
    }

    protected final void setResult(Object value) {
        this.result = value;
    }

    @Override
    public JSONToken getScopeToken() {
        return !this.tokenStack.isEmpty() ? this.tokenStack.peek() : super.getScopeToken();
    }
}

