/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.json;

import java.io.InputStream;
import java.io.Reader;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import javax.xml.namespace.QName;
import oracle.dbtools.common.util.Hex;
import oracle.dbtools.common.util.Iterables;
import oracle.dbtools.common.util.Text;
import oracle.dbtools.common.util.Transform;
import oracle.dbtools.json.FalseValue;
import oracle.dbtools.json.JSONArray;
import oracle.dbtools.json.JSONFormatter;
import oracle.dbtools.json.JSONNode;
import oracle.dbtools.json.JSONObject;
import oracle.dbtools.json.JSONOptions;
import oracle.dbtools.json.JSONParser;
import oracle.dbtools.json.JSONProperty;
import oracle.dbtools.json.JSONRenderer;
import oracle.dbtools.json.JSONValue;
import oracle.dbtools.json.NullValue;
import oracle.dbtools.json.TrueValue;
import oracle.dbtools.plugin.api.json.JSONToken;

public final class JSONBuilder {
    private JSONOptions options = JSONOptions.DEFAULT_JSON_OPTIONS;
    private final JSONNode root;
    public static final String TEXT = "$t";
    private static final String BINARY_DATA_OMITTED = "...binary data omitted...";

    private JSONBuilder(JSONOptions options, JSONNode root) {
        this.root = root;
        this.options = options;
    }

    public JSONNode build() {
        return this.root;
    }

    public JSONOptions options() {
        return this.options;
    }

    public JSONBuilder options(JSONOptions options) {
        this.options = options;
        return this;
    }

    public <T> JSONBuilder p(QName name, JSONValue<T> value) {
        this.object().add(name, value);
        return this;
    }

    public <T> JSONBuilder p(String name, CharSequence value) {
        if (value != null || this.options.includeNulls()) {
            return this.p(new QName(name), JSONBuilder.v(value.toString()));
        }
        return this;
    }

    public JSONBuilder p(String name, Object value) {
        JSONValue v = NullValue.NULL;
        if (value != null) {
            Class<?> type = value.getClass();
            if (value instanceof JSONValue) {
                v = (JSONValue)value;
            } else if (type.equals(Boolean.class)) {
                v = JSONBuilder.v((Boolean)value);
            } else if (value instanceof Number) {
                v = JSONBuilder.v((Number)value);
            } else if (type.equals(JSONBuilder.class)) {
                v = JSONBuilder.v((JSONBuilder)value);
            } else if (type.isArray()) {
                if (Byte.TYPE.equals(type.getComponentType())) {
                    v = JSONBuilder.v(JSONBuilder.encode((byte[])value));
                } else {
                    Object[] arrayValues = (Object[])value;
                    v = JSONBuilder.v(JSONBuilder.a(this.options, Iterables.transform((Iterable)Iterables.iterable((Object[])arrayValues), (Transform)new ObjectToJsonValue(this.options))));
                }
            } else {
                v = value instanceof Reader ? JSONBuilder.v((Reader)value) : (value instanceof InputStream ? JSONBuilder.v(BINARY_DATA_OMITTED) : JSONBuilder.v(value.toString()));
            }
        }
        return this.p(new QName(name), v);
    }

    public <T> JSONBuilder p(String name, Number value) {
        if (value != null || this.options.includeNulls()) {
            return this.p(new QName(name), JSONBuilder.v(value));
        }
        return this;
    }

    public <T> JSONBuilder p(String name, URI uri) {
        if (uri != null) {
            JSONBuilder hyperlink = JSONBuilder.o(this.options).p("$ref", uri.toASCIIString());
            return this.p(new QName(name), JSONBuilder.v(hyperlink));
        }
        return this;
    }

    public String toString() {
        return JSONBuilder.render(this.options, this.root);
    }

    private final JSONObject object() {
        if (this.root.getType() == JSONNode.Type.OBJECT) {
            return (JSONObject)this.root;
        }
        throw new IllegalStateException("This is an array");
    }

    private static JSONBuilder array(Iterator<JSONToken> json) {
        ArrayList values = new ArrayList();
        block9: while (json.hasNext()) {
            JSONToken value = json.next();
            switch (value.type()) {
                case STRING_VALUE: {
                    values.add(JSONBuilder.v(value.stringValue()));
                    continue block9;
                }
                case NUMERIC_VALUE: {
                    values.add(JSONBuilder.v(value.numberValue()));
                    continue block9;
                }
                case BOOLEAN_VALUE: {
                    values.add(JSONBuilder.v(value.booleanValue()));
                    continue block9;
                }
                case NULL_VALUE: {
                    values.add(JSONBuilder.v((String)null));
                }
                case START_OBJECT: {
                    values.add(JSONBuilder.v(JSONBuilder.object(json)));
                    continue block9;
                }
                case START_ARRAY: {
                    values.add(JSONBuilder.v(JSONBuilder.array(json)));
                    continue block9;
                }
                case END_ARRAY: {
                    return JSONBuilder.a(JSONOptions.DEFAULT_JSON_OPTIONS, values);
                }
            }
            throw JSONParser.error(value.toString(), "value", "]");
        }
        throw JSONParser.eof("]");
    }

    private static JSONBuilder object(Iterator<JSONToken> json) {
        JSONBuilder b = JSONBuilder.o(JSONOptions.DEFAULT_JSON_OPTIONS);
        block12: while (json.hasNext()) {
            JSONToken event = json.next();
            switch (event.type()) {
                case PROPERTY_NAME: {
                    JSONToken value = json.next();
                    switch (value.type()) {
                        case STRING_VALUE: {
                            b.p(event.propertyName(), JSONBuilder.v(value.stringValue()));
                            break;
                        }
                        case NUMERIC_VALUE: {
                            b.p(event.propertyName(), JSONBuilder.v(value.numberValue()));
                            break;
                        }
                        case BOOLEAN_VALUE: {
                            b.p(event.propertyName(), JSONBuilder.v(value.booleanValue()));
                            break;
                        }
                        case NULL_VALUE: {
                            b.p(event.propertyName(), (Object)null);
                        }
                        case START_OBJECT: {
                            b.p(event.propertyName(), JSONBuilder.v(JSONBuilder.object(json)));
                            break;
                        }
                        case START_ARRAY: {
                            b.p(event.propertyName(), JSONBuilder.v(JSONBuilder.array(json)));
                        }
                    }
                    continue block12;
                }
                case END_OBJECT: {
                    return b;
                }
            }
            throw JSONParser.error(event.toString(), "value", "}");
        }
        throw JSONParser.eof("}");
    }

    public static JSONNode build(Iterator<JSONToken> json) {
        JSONNode node = null;
        if (json.hasNext()) {
            JSONBuilder b = null;
            JSONToken event = json.next();
            if (JSONToken.Type.START_OBJECT == event.type()) {
                b = JSONBuilder.object(json);
            } else if (JSONToken.Type.START_ARRAY == event.type()) {
                b = JSONBuilder.array(json);
            } else {
                throw JSONParser.error(event.toString(), "{", "[");
            }
            node = b.build();
        }
        return node;
    }

    public static JSONBuilder a(Iterable<JSONValue<?>> values) {
        return JSONBuilder.a(JSONOptions.DEFAULT_JSON_OPTIONS, values);
    }

    public static JSONBuilder a(JSONOptions options, Iterable<JSONValue<?>> values) {
        return new JSONBuilder(options, new JSONArray(values));
    }

    public static <T> JSONBuilder a(T ... values) {
        return JSONBuilder.a(JSONOptions.DEFAULT_JSON_OPTIONS, values);
    }

    public static <T> JSONBuilder a(final JSONOptions options, T ... values) {
        return JSONBuilder.a(options, Iterables.transform(Arrays.asList(values), (Transform)new Transform<T, JSONValue<?>>(){

            public JSONValue<?> apply(T x) {
                return JSONBuilder.v(options, x);
            }
        }));
    }

    public static JSONBuilder o() {
        return JSONBuilder.o(JSONOptions.DEFAULT_JSON_OPTIONS);
    }

    public static JSONBuilder o(JSONOptions options) {
        return new JSONBuilder(options, new JSONObject());
    }

    public static void render(JSONRenderer w, JSONOptions options, Iterable<JSONProperty> properties) {
        for (JSONProperty p : properties) {
            JSONValue<?> value = p.value();
            if (!options.includeNulls() && (value.type() == JSONValue.Type.NULL || value.value() == null)) continue;
            w.name(p.name());
            JSONBuilder.render(w, options, value);
        }
    }

    public static void render(JSONRenderer w, JSONOptions options, JSONNode node) {
        if (node.getType() == JSONNode.Type.OBJECT) {
            JSONObject object = (JSONObject)node;
            w.start();
            Collection<JSONProperty> properties = object.properties();
            JSONBuilder.render(w, options, properties);
            w.end();
        } else {
            Iterable<JSONValue<?>> values = ((JSONArray)node).values();
            w.startArray();
            for (JSONValue<?> i : values) {
                JSONBuilder.render(w, options, i);
            }
            w.endArray();
        }
    }

    public static String render(JSONNode object) {
        return JSONBuilder.render(JSONOptions.DEFAULT_JSON_OPTIONS, object);
    }

    public static String render(JSONOptions options, JSONNode object) {
        StringBuilder b = new StringBuilder();
        JSONFormatter w = new JSONFormatter(b);
        JSONBuilder.render((JSONRenderer)w, options, object);
        w.flush(true);
        return b.toString();
    }

    public static byte[] toByteArray(JSONOptions options, JSONNode object) {
        String text = JSONBuilder.render(options, object);
        byte[] octets = Text.getBytes((String)text);
        return octets;
    }

    public static JSONValue<?> v(Boolean value) {
        return value != false ? TrueValue.TRUE : FalseValue.FALSE;
    }

    public static JSONValue<?> v(byte[] value) {
        return JSONBuilder.v(JSONBuilder.encode(value));
    }

    public static JSONValue<?> v(JSONBuilder value) {
        return new JSONValue(JSONValue.Type.NODE, value.build());
    }

    public static JSONValue<?> v(Number value) {
        return new JSONValue(JSONValue.Type.NUMBER, value);
    }

    private static JSONValue<?> v(JSONOptions options, Object value) {
        if (value == null) {
            return NullValue.NULL;
        }
        Class<?> type = value.getClass();
        if (type.equals(Boolean.class)) {
            return JSONBuilder.v((Boolean)value);
        }
        if (value instanceof Number) {
            return JSONBuilder.v((Number)value);
        }
        if (type.equals(JSONBuilder.class)) {
            return JSONBuilder.v((JSONBuilder)value);
        }
        if (type.isArray()) {
            if (Byte.TYPE.equals(type.getComponentType())) {
                return JSONBuilder.v(JSONBuilder.encode((byte[])value));
            }
            Object[] arrayValues = (Object[])value;
            return JSONBuilder.v(JSONBuilder.a(options, Iterables.transform((Iterable)Iterables.iterable((Object[])arrayValues), (Transform)new ObjectToJsonValue(options))));
        }
        if (value instanceof Reader) {
            return JSONBuilder.v((Reader)value);
        }
        if (value instanceof InputStream) {
            return JSONBuilder.v(BINARY_DATA_OMITTED);
        }
        return JSONBuilder.v(value.toString());
    }

    public static JSONValue<?> v(Reader value) {
        return new JSONValue(JSONValue.Type.STRING, value);
    }

    public static JSONValue<?> v(String value) {
        return new JSONValue(JSONValue.Type.STRING, value);
    }

    private static String encode(byte[] value) {
        if (value == null) {
            return null;
        }
        return Hex.encode((byte[])value);
    }

    private static void render(JSONRenderer w, JSONOptions options, JSONValue<?> value) {
        Object theValue = value.value();
        switch (value.type()) {
            case FALSE: 
            case TRUE: {
                w.value((Boolean)theValue);
                break;
            }
            case NULL: {
                w.value((CharSequence)null);
                break;
            }
            case NUMBER: {
                w.value((Number)theValue);
                break;
            }
            case NODE: {
                JSONBuilder.render(w, options, (JSONNode)theValue);
                break;
            }
            default: {
                if (theValue == null) {
                    w.value((CharSequence)null);
                    break;
                }
                if (theValue instanceof Reader) {
                    w.value((Reader)theValue);
                    break;
                }
                w.value(theValue.toString());
            }
        }
    }

    private static class ObjectToJsonValue
    implements Transform<Object, JSONValue<?>> {
        private final JSONOptions options;

        private ObjectToJsonValue(JSONOptions options) {
            this.options = options;
        }

        public JSONValue<?> apply(Object x) {
            return JSONBuilder.v(this.options, x);
        }
    }
}

