/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.ceditor.find;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.KeyStroke;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import oracle.ide.ceditor.find.AbstractFindToolbarController;
import oracle.ide.ceditor.find.Bundle;
import oracle.ide.ceditor.find.CurrentToolbarOptionsImpl;
import oracle.ide.ceditor.find.FindController;
import oracle.ide.ceditor.find.FindOptions;
import oracle.ide.ceditor.find.FindToolbar;
import oracle.ide.ceditor.find.FindToolbarController;
import oracle.ide.controller.ToolbarManager;
import oracle.ide.controls.ToolButton;
import oracle.ide.controls.Toolbar;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.TextRange;
import oracle.javatools.editor.find.FindCriteria;
import oracle.javatools.editor.find.FindResult;
import oracle.javatools.editor.find.Finder;
import oracle.javatools.editor.find.ReplaceCriteria;
import oracle.javatools.editor.find.ReplaceResult;
import oracle.javatools.editor.find.Replacement;
import oracle.javatools.editor.find.Replacer;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.search.SearchField;
import oracle.javatools.ui.search.SearchHistoryPopup;
import oracle.javatools.ui.segmented.DefaultSegment;
import oracle.javatools.ui.segmented.Segment;
import oracle.javatools.ui.segmented.SegmentButton;
import oracle.javatools.ui.segmented.SegmentedControl;

final class ReplaceToolbar {
    private final Toolbar toolbar;
    private final SearchField replaceField;
    private final BasicEditorPane editor;
    private final JLabel feedbackLabel;
    private final List<Replacement> skips = new ArrayList<Replacement>();
    private final List<Replacement> replaces = new ArrayList<Replacement>();
    private static final String SUBSTITUTE_ID = "substitute";
    private static final String PRESERVE_CASE_ID = "preserver-case";
    private int total = -1;
    private final Action toggleAction = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent e) {
            FindToolbarController findToolbarController = AbstractFindToolbarController.getFindController(ReplaceToolbar.this.editor);
            findToolbarController.setReplaceShowing(false);
            ReplaceToolbar.this.editor.requestFocus();
        }
    };
    private final Action upAction = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent e) {
            FindToolbarController findToolbarController = AbstractFindToolbarController.getFindController(ReplaceToolbar.this.editor);
            findToolbarController.getFindToolbar().findNext(false);
        }
    };
    private final Action downAction = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent e) {
            FindToolbarController findToolbarController = AbstractFindToolbarController.getFindController(ReplaceToolbar.this.editor);
            findToolbarController.getFindToolbar().findNext(true);
        }
    };
    private final Action replaceAction = new AbstractAction("REPLACE_TOOLBAR_REPLACE"){

        @Override
        public void actionPerformed(ActionEvent e) {
            ReplaceToolbar.this.replace(ReplaceCriteria.Scope.SINGLE);
        }
    };
    private final Action replaceAllAction = new AbstractAction("REPLACE_TOOLBAR_REPLACE_ALL"){

        @Override
        public void actionPerformed(ActionEvent e) {
            ReplaceToolbar.this.replace(ReplaceCriteria.Scope.GLOBAL);
        }
    };
    private final Action skipAction = new AbstractAction("REPLACE_TOOLBAR_SKIP"){

        @Override
        public void actionPerformed(ActionEvent e) {
            ReplaceToolbar.this.skip();
        }
    };
    private SegmentedControl<String> segmentedOptions;

    public ReplaceToolbar(BasicEditorPane editor) {
        this.editor = editor;
        this.toolbar = new Toolbar();
        this.replaceField = new SearchField(SearchField.Style.FILTER);
        this.replaceField.setHideCancel(true);
        this.replaceField.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 2));
        this.replaceField.setPrompt(Bundle.get("REPLACE_TOOLBAR_PROMPT"));
        this.replaceField.getTextField().getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                ReplaceToolbar.this.reset();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                ReplaceToolbar.this.reset();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                ReplaceToolbar.this.reset();
            }
        });
        new SearchHistoryPopup(this.replaceField, (SearchHistoryPopup.HistoryProvider)ReplaceHistoryProvider.INSTANCE);
        Dimension preferredSize = this.replaceField.getPreferredSize();
        this.replaceField.setMaximumSize(new Dimension(270, preferredSize.height));
        this.replaceField.setMinimumSize(new Dimension(270, preferredSize.height));
        this.replaceField.setPreferredSize(new Dimension(Math.max(preferredSize.width, 270), preferredSize.height));
        this.replaceField.getTextField().setName("replace-option-text");
        ToolButton replaceButton = new ToolButton(this.replaceAction);
        replaceButton.setIcon(null);
        replaceButton.setText(Bundle.get("REPLACE_TOOLBAR_REPLACE"));
        replaceButton.setToolTipText(Bundle.get("REPLACE_TOOLBAR_REPLACE_TIP"));
        replaceButton.setFocusable(true);
        replaceButton.setName("replace-button");
        ToolButton skipButton = new ToolButton(this.skipAction);
        skipButton.setIcon(null);
        skipButton.setText(Bundle.get("REPLACE_TOOLBAR_SKIP"));
        skipButton.setToolTipText(Bundle.get("REPLACE_TOOLBAR_SKIP_TIP"));
        skipButton.setFocusable(true);
        skipButton.setName("replace-skip-button");
        ToolButton replaceAllButton = new ToolButton(this.replaceAllAction);
        replaceAllButton.setIcon(null);
        replaceAllButton.setText(Bundle.get("REPLACE_TOOLBAR_REPLACE_ALL"));
        replaceAllButton.setToolTipText(Bundle.get("REPLACE_TOOLBAR_REPLACE_ALL_TIP"));
        replaceAllButton.setFocusable(true);
        replaceAllButton.setName("replace-all-button");
        this.bindActions((JComponent)this.replaceField.getTextField(), true);
        this.bindActions((JComponent)replaceButton, false);
        this.bindActions((JComponent)replaceAllButton, false);
        this.bindActions((JComponent)skipButton, false);
        this.segmentedOptions = new SegmentedControl(SegmentedControl.SelectionType.MULTIPLE);
        DefaultSegment caseSegment = new DefaultSegment((Object)PRESERVE_CASE_ID, OracleIcons.getIcon((String)"preservecase.png"), Bundle.get("REPLACE_TOOLBAR_PRESERVE_CASE"));
        DefaultSegment specialSegment = new DefaultSegment((Object)SUBSTITUTE_ID, OracleIcons.getIcon((String)"substitute_escape_character.png"), Bundle.get("REPLACE_TOOLBAR_SUBSTITUTE"));
        this.segmentedOptions.addSegment((Segment)caseSegment);
        this.segmentedOptions.addSegment((Segment)specialSegment);
        List buttons = this.segmentedOptions.getSegmentButtons();
        ((SegmentButton)buttons.get(0)).setName("replace-option-case");
        ((SegmentButton)buttons.get(1)).setName("replace-option-special");
        FindOptions findOptions = FindController.getFindOptions();
        if (findOptions.getPreserveCase()) {
            this.segmentedOptions.setSelected((Segment)caseSegment);
        }
        if (findOptions.getSubstituteSpecial()) {
            this.segmentedOptions.setSelected((Segment)specialSegment);
        }
        this.segmentedOptions.addItemListener(new ItemListener(){
            final /* synthetic */ Segment val$caseSegment;
            final /* synthetic */ Segment val$specialSegment;
            {
                this.val$caseSegment = segment;
                this.val$specialSegment = segment2;
            }

            @Override
            public void itemStateChanged(ItemEvent e) {
                FindOptions findOptions = FindController.getFindOptions();
                findOptions.setPreserveCase(ReplaceToolbar.this.segmentedOptions.isSelected(this.val$caseSegment));
                findOptions.setSubstituteSpecial(ReplaceToolbar.this.segmentedOptions.isSelected(this.val$specialSegment));
            }
        });
        this.feedbackLabel = new JLabel();
        this.toolbar.add((Component)this.replaceField);
        this.toolbar.add((Component)replaceButton);
        this.toolbar.add((Component)skipButton);
        this.toolbar.add((Component)replaceAllButton);
        this.toolbar.addFiller();
        this.toolbar.add(this.segmentedOptions);
        this.toolbar.addFiller();
        this.toolbar.add((Component)this.feedbackLabel);
    }

    void allowExtraButtons() {
        ToolbarManager toolbarManager = ToolbarManager.getToolbarManager();
        toolbarManager.registerOnDemandToolbar("oracle.ide.ceditor.toolbar.replace", this.toolbar, null);
        this.toolbar.addFiller();
        this.toolbar.add((Component)this.feedbackLabel);
    }

    private void bindActions(JComponent component, boolean includeEnter) {
        InputMap inputMap = component.getInputMap(0);
        ActionMap actionMap = component.getActionMap();
        String toggleOff = "ToggleOff";
        String enter = "Enter";
        String shiftEnter = "shiftEnter";
        String alterEnter = "AltEnter";
        String up = "Up";
        String down = "Down";
        inputMap.put(KeyStroke.getKeyStroke(27, 0), "ToggleOff");
        actionMap.put("ToggleOff", this.toggleAction);
        if (includeEnter) {
            inputMap.put(KeyStroke.getKeyStroke(10, 0), "Enter");
            actionMap.put("Enter", this.replaceAction);
        }
        inputMap.put(KeyStroke.getKeyStroke(10, 64), "shiftEnter");
        actionMap.put("shiftEnter", this.replaceAllAction);
        inputMap.put(KeyStroke.getKeyStroke(10, 512), "AltEnter");
        actionMap.put("AltEnter", this.skipAction);
        inputMap.put(KeyStroke.getKeyStroke(38, 0), "Up");
        actionMap.put("Up", this.upAction);
        inputMap.put(KeyStroke.getKeyStroke(40, 0), "Down");
        actionMap.put("Down", this.downAction);
    }

    Toolbar getToolbar() {
        return this.toolbar;
    }

    public static ReplaceToolbar getReplaceToolbar(BasicEditorPane editor) {
        FindToolbarController findToolbarController = AbstractFindToolbarController.getFindController(editor);
        return findToolbarController == null ? null : findToolbarController.getReplaceToolbar();
    }

    void setSearchFieldText(String text) {
        this.replaceField.setText(text, true);
    }

    SearchField getReplaceField() {
        return this.replaceField;
    }

    public void dispose() {
        this.reset();
        ToolbarManager toolbarManager = ToolbarManager.getToolbarManager();
        toolbarManager.unRegisterOnDemandToolbar("oracle.ide.ceditor.toolbar.replace", this.toolbar);
    }

    void reset() {
        Replacer.clearHighlights((BasicEditorPane)this.editor);
        for (Replacement skip : this.skips) {
            skip.dispose();
        }
        for (Replacement replace : this.replaces) {
            replace.dispose();
        }
        this.skips.clear();
        this.replaces.clear();
        this.total = -1;
        this.updateFeedback();
    }

    private void replace(ReplaceCriteria.Scope scope) {
        FindCriteria criteria;
        if (!Replacer.hasHighlights((BasicEditorPane)this.editor) && !Finder.hasHighlights((BasicEditorPane)this.editor) && (criteria = (FindCriteria)this.editor.getProperty("find-criteria")) != null) {
            FindController.find(this.editor, criteria);
        }
        ReplaceCriteria replaceCriteria = FindOptions.createReplaceCriteria();
        replaceCriteria.setScope(scope);
        replaceCriteria.setReplaceText(this.replaceField.getText());
        ArrayList<TextRange> excludes = new ArrayList<TextRange>(this.skips.size() + this.replaces.size());
        for (Replacement skip : this.skips) {
            excludes.add(skip.getReplacementRange());
        }
        for (Replacement replace : this.replaces) {
            excludes.add(replace.getReplacementRange());
        }
        replaceCriteria.setExcludes(excludes);
        ReplaceResult replaceResult = Replacer.replace((BasicEditorPane)this.editor, (ReplaceCriteria)replaceCriteria);
        FindResult findResult = replaceResult.getFindResult();
        FindController.updateFindCount(this.editor, findResult);
        FindController.getFindOptions().updateHistory(false, this.replaceField.getText());
        if (replaceResult.getState() == ReplaceResult.State.DONE) {
            if (scope == ReplaceCriteria.Scope.SINGLE) {
                if (this.total == -1) {
                    this.total = findResult == null ? 1 : findResult.getFinds().size();
                }
                Collection replaced = replaceResult.getReplacements();
                for (Replacement replace : replaced) {
                    int findOffset = replace.getReplacementRange().getStartOffset();
                    for (Replacement skip : this.skips) {
                        if (skip.getReplacementRange().getStartOffset() != findOffset) continue;
                        this.skips.remove(skip);
                        skip.dispose();
                        break;
                    }
                    for (Replacement r : this.replaces) {
                        if (r.getReplacementRange().getStartOffset() != findOffset) continue;
                        this.replaces.remove(r);
                        r.dispose();
                        break;
                    }
                    this.replaces.add(replace);
                }
                this.updateFeedback();
            } else if (scope == ReplaceCriteria.Scope.GLOBAL) {
                for (Replacement replacement : replaceResult.getReplacements()) {
                    this.replaces.add(replacement);
                }
                if (this.total == -1) {
                    this.total = replaceResult.getReplacements().size();
                }
                this.updateFeedback();
                FindToolbar.getFindToolbar(this.editor).setFindCount(-1, 0);
            }
            this.editor.ensureCaretVisible();
        }
    }

    private void skip() {
        FindController.getFindOptions().updateHistory(false, this.replaceField.getText());
        FindCriteria criteria = (FindCriteria)this.editor.getProperty("find-criteria");
        ReplaceResult result = Replacer.skip((BasicEditorPane)this.editor, (FindCriteria)criteria);
        if (result != null) {
            if (this.total == -1) {
                FindResult findResult = result.getFindResult();
                this.total = findResult == null ? 1 : findResult.getFinds().size();
            }
            Collection replacements = result.getReplacements();
            assert (replacements.size() == 1);
            Replacement replacement = (Replacement)replacements.iterator().next();
            boolean found = false;
            for (Replacement skip : this.skips) {
                if (skip.getReplacementRange().getStartOffset() != replacement.getReplacementRange().getStartOffset()) continue;
                found = true;
                break;
            }
            if (found) {
                replacement.dispose();
            } else {
                this.skips.add(replacement);
            }
            FindController.updateFindCount(this.editor, result.getFindResult());
            this.updateFeedback();
            this.editor.ensureCaretVisible();
        }
    }

    private void updateFeedback() {
        if (this.skips.isEmpty() && this.replaces.isEmpty()) {
            this.feedbackLabel.setText("");
        } else if (this.skips.size() + this.replaces.size() >= this.total) {
            this.feedbackLabel.setText(Bundle.format("REPLACE_TOOLBAR_FINISHED_FEEDBACK", this.skips.size(), this.replaces.size()));
        } else {
            this.feedbackLabel.setText(Bundle.format("REPLACE_TOOLBAR_FEEDBACK", this.skips.size(), this.replaces.size()));
        }
    }

    void populateCurrentOptions(CurrentToolbarOptionsImpl currentOptions) {
        currentOptions.setReplaceText(this.replaceField.getText());
        currentOptions.setPreserveCase(this.segmentedOptions.isSelected((Object)PRESERVE_CASE_ID));
        currentOptions.setSubstitute(this.segmentedOptions.isSelected((Object)SUBSTITUTE_ID));
    }

    private static class ReplaceHistoryProvider
    implements SearchHistoryPopup.HistoryProvider {
        private static final ReplaceHistoryProvider INSTANCE = new ReplaceHistoryProvider();

        private ReplaceHistoryProvider() {
        }

        public List<String> getHistory() {
            FindOptions findOptions = FindController.getFindOptions();
            List<String> history = findOptions.getReplaceHistory();
            return history;
        }
    }
}

